/*
 * Decompiled with CFR 0.152.
 */
package mitiv.utils;

import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Random;
import javax.imageio.ImageIO;
import org.jtransforms.fft.DoubleFFT_2D;

@Deprecated
public class MathUtils {
    public static final int COLORMAP_GRAYSCALE = 0;
    public static final int COLORMAP_JET = 1;
    public static final int GAUSSIAN = 2;
    public static final int AVERAGE = 3;
    public static final int PREWITT = 4;
    public static final int SOBEL = 5;
    public static final int KIRSH = 6;
    public static final int DISK = 7;

    public static boolean even(int n) {
        return n % 2 == 0;
    }

    public static long factorial(long l) {
        if (l == 0L) {
            return 1L;
        }
        return l * MathUtils.factorial(l - 1L);
    }

    public static double[][] cartesDist2D(int n, int n2) {
        double[][] dArray = new double[n2][n];
        double[] dArray2 = MathUtils.indgen((-n + 1) / 2, n / 2, 1.0);
        double[] dArray3 = MathUtils.indgen((-n2 + 1) / 2, n2 / 2, 1.0);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                dArray[j][i] = Math.sqrt(dArray2[j] * dArray2[j] + dArray3[i] * dArray3[i]);
            }
        }
        return dArray;
    }

    public static double[] cartesDist1D(int n, int n2) {
        double[] dArray = new double[n2 * n];
        double[] dArray2 = MathUtils.indgen((-n + 1) / 2, n / 2);
        double[] dArray3 = MathUtils.indgen((-n2 + 1) / 2, n2 / 2);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                dArray[i * n2 + j] = Math.sqrt(dArray2[j] * dArray2[j] + dArray3[i] * dArray3[i]);
            }
        }
        return dArray;
    }

    public static double[] cartesAngle1D(int n, int n2) {
        double[] dArray = new double[n2 * n];
        double[] dArray2 = MathUtils.indgen((-n + 1) / 2, n / 2);
        double[] dArray3 = MathUtils.indgen((-n2 + 1) / 2, n2 / 2);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                dArray[i * n2 + j] = Math.atan2(dArray3[j], dArray2[i]);
            }
        }
        return dArray;
    }

    public static double[][] cartesAngle2D(int n, int n2) {
        double[][] dArray = new double[n2][n];
        double[] dArray2 = MathUtils.indgen((-n + 1) / 2, n / 2);
        double[] dArray3 = MathUtils.indgen((-n2 + 1) / 2, n2 / 2);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                dArray[j][i] = Math.atan2(dArray3[j], dArray2[i]);
            }
        }
        return dArray;
    }

    public static double[] catArray(double[] dArray, double[] dArray2) {
        int n;
        int n2 = dArray.length + dArray2.length;
        double[] dArray3 = new double[n2];
        for (n = 0; n < dArray.length; ++n) {
            dArray3[n] = dArray[n];
        }
        for (n = dArray2.length; n < n2; ++n) {
            dArray3[n] = dArray2[n - dArray2.length];
        }
        return dArray3;
    }

    public static double[] create3DSquare(int n, int n2, int n3) {
        double[] dArray = new double[n * n * n2];
        for (int i = 0; i < n2; ++i) {
            for (int j = n / 2 - n3 / 2; j < n / 2 + n3 / 2; ++j) {
                for (int k = n / 2 - n3 / 2; k < n / 2 + n3 / 2; ++k) {
                    dArray[i * n * n + j * n + k] = 1.0;
                }
            }
        }
        return dArray;
    }

    public static double[][] fftAngle(int n, int n2) {
        double[][] dArray = new double[n2][n];
        double[] dArray2 = MathUtils.fftIndgen(n);
        double[] dArray3 = MathUtils.fftIndgen(n2);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                dArray[j][i] = Math.atan2(dArray3[j], dArray2[i]);
            }
        }
        return dArray;
    }

    public static double[] fftAngle1D(int n, int n2) {
        double[] dArray = new double[n * n2];
        double[] dArray2 = MathUtils.fftIndgen(n);
        double[] dArray3 = MathUtils.fftIndgen(n2);
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                dArray[j + i * n] = Math.atan2(dArray3[i], dArray2[j]);
            }
        }
        return dArray;
    }

    public static double[] fftIndgen(int n) {
        double[] dArray = new double[n];
        double[] dArray2 = MathUtils.indgen(0, n - 1);
        for (int i = 0; i < n; ++i) {
            dArray[i] = dArray2[i] > (double)(n / 2) ? dArray2[i] - (double)n : dArray2[i];
        }
        return dArray;
    }

    public static double[] fftDist(int n) {
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        dArray = MathUtils.fftIndgen(n);
        for (int i = 0; i < n; ++i) {
            dArray2[i] = Math.sqrt(dArray[i] * dArray[i] + dArray[i] * dArray[i]);
        }
        return dArray2;
    }

    public static double[][] fftDist(int n, int n2) {
        double[] dArray = new double[n];
        double[] dArray2 = new double[n2];
        double[][] dArray3 = new double[n2][n];
        dArray = MathUtils.fftIndgen(n);
        dArray2 = MathUtils.fftIndgen(n2);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                dArray3[j][i] = Math.sqrt(dArray[j] * dArray[j] + dArray2[i] * dArray2[i]);
            }
        }
        return dArray3;
    }

    public static double[] fftDist1D(int n, int n2) {
        double[] dArray = new double[n2 * n];
        double[] dArray2 = MathUtils.fftIndgen(n);
        double[] dArray3 = MathUtils.fftIndgen(n2);
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                dArray[j + i * n] = Math.sqrt(dArray2[j] * dArray2[j] + dArray3[i] * dArray3[i]);
            }
        }
        return dArray;
    }

    public static double[][][] gram_schmidt_orthonormalization(double[][][] dArray) {
        int n = dArray.length;
        int n2 = dArray[0].length;
        int n3 = dArray[0][0].length;
        double[][] dArray2 = new double[n2][n3];
        double[][] dArray3 = new double[n2][n3];
        double[][] dArray4 = new double[n2][n3];
        for (int i = 0; i < n; ++i) {
            double d;
            int n4;
            int n5;
            int n6;
            for (n6 = 0; n6 < n3; ++n6) {
                for (n5 = 0; n5 < n2; ++n5) {
                    dArray2[n5][n6] = dArray[i][n5][n6];
                }
            }
            if (i > 0) {
                for (n6 = 0; n6 < n3; ++n6) {
                    for (n5 = 0; n5 < n2; ++n5) {
                        dArray3[n5][n6] = dArray[0][n5][n6];
                    }
                }
                double d2 = MathUtils.sum(MathUtils.hadamardProd(dArray2, dArray3, 0));
                for (n4 = 0; n4 < n3; ++n4) {
                    for (int j = 0; j < n2; ++j) {
                        dArray4[j][n4] = d2 * dArray3[j][n4];
                    }
                }
                for (n4 = 1; n4 < i; ++n4) {
                    for (int j = 0; j < n3; ++j) {
                        for (int k = 0; k < n2; ++k) {
                            dArray3[k][j] = dArray[n4][k][j];
                        }
                    }
                    double d3 = MathUtils.sum(MathUtils.hadamardProd(dArray2, dArray3, 0));
                    for (int j = 0; j < n3; ++j) {
                        for (int k = 0; k < n2; ++k) {
                            double[] dArray5 = dArray4[k];
                            int n7 = j;
                            dArray5[n7] = dArray5[n7] + d3 * dArray3[k][j];
                        }
                    }
                }
                for (n4 = 0; n4 < n3; ++n4) {
                    for (int j = 0; j < n2; ++j) {
                        double[] dArray6 = dArray2[j];
                        int n8 = n4;
                        dArray6[n8] = dArray6[n8] - dArray4[j][n4];
                    }
                }
            }
            if ((d = MathUtils.sum(MathUtils.hadamardProd(dArray2, dArray2, 0))) > 0.0) {
                for (n4 = 0; n4 < n3; ++n4) {
                    for (int j = 0; j < n2; ++j) {
                        dArray[i][j][n4] = 1.0 / Math.sqrt(d) * dArray2[j][n4];
                    }
                }
                continue;
            }
            for (n4 = 0; n4 < n3; ++n4) {
                for (int j = 0; j < n2; ++j) {
                    dArray[i][j][n4] = 0.0;
                }
            }
        }
        return dArray;
    }

    public static double[] gram_schmidt_orthonormalization(double[] dArray, int n, int n2, int n3) {
        double[] dArray2 = new double[n * n2];
        double[] dArray3 = new double[n * n2];
        double[] dArray4 = new double[n * n2];
        for (int i = 0; i < n3; ++i) {
            double d;
            int n4;
            int n5;
            for (n5 = 0; n5 < n2; ++n5) {
                for (n4 = 0; n4 < n; ++n4) {
                    dArray2[n4 + n * n5] = dArray[n4 + n * n5 + i * n * n2];
                }
            }
            if (i > 0) {
                for (n5 = 0; n5 < n2; ++n5) {
                    for (n4 = 0; n4 < n; ++n4) {
                        dArray3[n4 + n * n5] = dArray[n4 + n * n5];
                    }
                }
                d = MathUtils.innerProd(dArray2, dArray3);
                for (n5 = 0; n5 < n * n2; ++n5) {
                    dArray4[n5] = d * dArray3[n5];
                }
                for (n5 = 1; n5 < i; ++n5) {
                    for (n4 = 0; n4 < n2; ++n4) {
                        for (int j = 0; j < n; ++j) {
                            dArray3[j + n * n4] = dArray[j + n * n4 + n5 * n * n2];
                        }
                    }
                    d = MathUtils.innerProd(dArray2, dArray3);
                    for (n4 = 0; n4 < n * n2; ++n4) {
                        int n6 = n4;
                        dArray4[n6] = dArray4[n6] + d * dArray3[n4];
                    }
                }
                for (n5 = 0; n5 < n * n2; ++n5) {
                    int n7 = n5;
                    dArray2[n7] = dArray2[n7] - dArray4[n5];
                }
            }
            if ((d = MathUtils.innerProd(dArray2, dArray2)) > 0.0) {
                for (n5 = 0; n5 < n2; ++n5) {
                    for (n4 = 0; n4 < n; ++n4) {
                        dArray[n4 + n * n5 + i * n * n2] = 1.0 / Math.sqrt(d) * dArray2[n4 + n * n5];
                    }
                }
                continue;
            }
            for (n5 = 0; n5 < n2; ++n5) {
                for (n4 = 0; n4 < n; ++n4) {
                    dArray[n4 + n * n5 + i * n * n2] = 0.0;
                }
            }
        }
        return dArray;
    }

    public static double[] span(double d, double d2, double d3) {
        double d4 = d;
        int n = 0;
        while (d4 <= d2) {
            d4 += d3;
            ++n;
        }
        double[] dArray = new double[n];
        d4 = d;
        int n2 = 0;
        for (double d5 = d; d5 <= d2; d5 += d3) {
            dArray[n2] = d5;
            ++n2;
        }
        return dArray;
    }

    public static double[] indgen(int n) {
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = i + 1;
        }
        return dArray;
    }

    public static double[] indgen(int n, int n2) {
        int n3 = n2 - n + 1;
        double[] dArray = new double[n3];
        for (int i = n; i <= n2; ++i) {
            dArray[i - n] = i;
        }
        return dArray;
    }

    public static double[] indgen(int n, int n2, double d) {
        double d2 = n;
        int n3 = 0;
        while (d2 <= (double)n2) {
            d2 += d;
            ++n3;
        }
        double[] dArray = new double[n3];
        d2 = n;
        int n4 = 0;
        for (double d3 = (double)n; d3 <= (double)n2; d3 += d) {
            dArray[n4] = d3;
            ++n4;
        }
        return dArray;
    }

    public static double[] span(double d, double d2, int n) {
        double[] dArray = new double[n];
        double d3 = (d2 - d) / (double)(n - 1);
        double d4 = (double)(n + 1) / 2.0;
        double d5 = (d + d2) / 2.0;
        for (int i = 0; i < n; ++i) {
            dArray[i] = d3 * ((double)(i + 1) - d4) + d5;
        }
        return dArray;
    }

    public static double[] scaleArrayTo8bit(double[] dArray) {
        int n = dArray.length;
        double[] dArray2 = new double[n];
        double d = MathUtils.min(dArray);
        double d2 = MathUtils.max(dArray);
        double d3 = d2 - d;
        for (int i = 0; i < n; ++i) {
            dArray2[i] = (dArray[i] - d) * 255.0 / d3;
        }
        return dArray2;
    }

    public static double[][] scaleArrayTo8bit(double[][] dArray) {
        int n = dArray.length;
        int n2 = dArray[0].length;
        double[][] dArray2 = new double[n][n2];
        double d = MathUtils.min(dArray);
        double d2 = MathUtils.max(dArray);
        double d3 = d2 - d;
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                dArray2[j][i] = (dArray[j][i] - d) * 255.0 / d3;
            }
        }
        return dArray2;
    }

    public static void uint8(double[][] dArray) {
        int n = dArray.length;
        int n2 = dArray[0].length;
        double d = MathUtils.min(dArray);
        double d2 = MathUtils.max(dArray);
        double d3 = d2 - d;
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                dArray[j][i] = (dArray[j][i] - d) * 255.0 / d3;
            }
        }
    }

    public static double[] uint16(double[] dArray) {
        int n = dArray.length;
        double d = MathUtils.min(dArray);
        double d2 = MathUtils.max(dArray);
        double d3 = d2 - d;
        for (int i = 0; i < n; ++i) {
            dArray[i] = (dArray[i] - d) * 65535.0 / d3;
        }
        return dArray;
    }

    public static void normalise(double[] dArray) {
        int n = dArray.length;
        double d = MathUtils.sum(MathUtils.abs2(dArray, 0));
        for (int i = 0; i < n; ++i) {
            dArray[i] = dArray[i] / d;
        }
    }

    public static void im2double(double[][] dArray) {
        int n = dArray.length;
        int n2 = dArray[0].length;
        double d = MathUtils.min(dArray);
        double d2 = MathUtils.max(dArray);
        double d3 = d2 - d;
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                dArray[j][i] = (dArray[j][i] - d) / d3;
            }
        }
    }

    public static double[][] conj1(double[][] dArray) {
        int n = dArray.length;
        int n2 = dArray[0].length;
        double[][] dArray2 = new double[n][n2];
        for (int i = 0; i < n2 / 2; ++i) {
            for (int j = 0; j < n; ++j) {
                dArray2[j][2 * i] = dArray[j][2 * i];
                dArray2[j][2 * i + 1] = -dArray[j][2 * i + 1];
            }
        }
        return dArray2;
    }

    public static void conj2(double[] dArray) {
        for (int i = 0; i < dArray.length / 2; ++i) {
            dArray[2 * i + 1] = -dArray[2 * i + 1];
        }
    }

    public static double[][] abs2(double[][] dArray) {
        int n = dArray.length;
        int n2 = dArray[0].length / 2;
        double[][] dArray2 = new double[n][n2];
        for (int i = 0; i < n; ++i) {
            dArray2[i] = MathUtils.abs2(dArray[i], 1);
        }
        return dArray2;
    }

    public static double[] abs2(double[] dArray, int n) {
        if (n == 1) {
            int n2 = dArray.length / 2;
            double[] dArray2 = new double[n2];
            for (int i = 0; i < n2; ++i) {
                dArray2[i] = dArray[2 * i] * dArray[2 * i] + dArray[2 * i + 1] * dArray[2 * i + 1];
            }
            return dArray2;
        }
        int n3 = dArray.length;
        double[] dArray3 = new double[n3];
        for (int i = 0; i < n3; ++i) {
            dArray3[i] = dArray[i] * dArray[i];
        }
        return dArray3;
    }

    public static double[] abs2(double[] dArray, int n, int n2, int n3) {
        if (n3 == 1) {
            int n4 = dArray.length / 2;
            double[] dArray2 = new double[n4];
            for (int i = n; i < n2; ++i) {
                dArray2[i] = dArray[2 * i] * dArray[2 * i] + dArray[2 * i + 1] * dArray[2 * i + 1];
            }
            return dArray2;
        }
        int n5 = n2 - n + 1;
        double[] dArray3 = new double[n5];
        for (int i = 0; i < n5; ++i) {
            dArray3[i] = dArray[i + n] * dArray[i + n];
        }
        return dArray3;
    }

    public static double min(double[] dArray) {
        double d = dArray[0];
        for (int i = 0; i < dArray.length; ++i) {
            if (!(d > dArray[i])) continue;
            d = dArray[i];
        }
        return d;
    }

    public static double min(double[][] dArray) {
        double d = dArray[0][0];
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = 0; j < dArray[i].length; ++j) {
                if (!(d > dArray[i][j])) continue;
                d = dArray[i][j];
            }
        }
        return d;
    }

    public static double max(double[] dArray) {
        double d = dArray[0];
        for (int i = 0; i < dArray.length; ++i) {
            if (!(d < dArray[i])) continue;
            d = dArray[i];
        }
        return d;
    }

    public static double max(double[][] dArray) {
        double d = dArray[0][0];
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = 0; j < dArray[i].length; ++j) {
                if (!(d < dArray[i][j])) continue;
                d = dArray[i][j];
            }
        }
        return d;
    }

    public static void printArray(int[] nArray) {
        System.out.println(Arrays.toString(nArray));
    }

    public static void printArray(double[] dArray) {
        System.out.println(Arrays.toString(dArray));
    }

    public static void printArray(double[] dArray, int n, int n2, int n3) {
        if (n3 == 0) {
            for (int i = n; i <= n2; ++i) {
                System.out.printf("%f ", dArray[i]);
            }
        } else {
            for (int i = n; i <= n2; ++i) {
                System.out.printf("%.4E ", dArray[i]);
            }
        }
    }

    public static void printArray(double[] dArray, int n, int n2, int n3, int n4) {
        if (n4 == 0) {
            for (int i = 0; i < n3; ++i) {
                System.out.println("k = " + i);
                for (int j = 0; j < n2; ++j) {
                    for (int k = 0; k < n; ++k) {
                        System.out.printf("%.2f ", dArray[k + j * n + i * n * n2]);
                    }
                    System.out.println();
                }
            }
        } else {
            for (int i = 0; i < n3; ++i) {
                System.out.println("k = " + i);
                for (int j = 0; j < n2; ++j) {
                    for (int k = 0; k < n; ++k) {
                        System.out.printf("%.4E ", dArray[k + j * n + i * n * n2]);
                    }
                    System.out.println();
                }
            }
        }
        System.out.println();
    }

    public static void printArray(double[][] dArray) {
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            System.out.println(Arrays.toString(dArray[i]));
        }
    }

    public static double[][] fftShift(double[][] dArray) {
        int n;
        int n2;
        int n3 = dArray.length;
        int n4 = dArray[0].length;
        double[][] dArray2 = new double[n3][n4];
        for (n2 = 0; n2 < n4 / 2; ++n2) {
            for (n = 0; n < n3 / 2; ++n) {
                dArray2[n3 - n3 / 2 + n][n4 - n4 / 2 + n2] = dArray[n][n2];
            }
        }
        for (n2 = 0; n2 < n4 / 2; ++n2) {
            for (n = 0; n < n3 / 2; ++n) {
                dArray2[n3 - n3 / 2 + n][n2] = dArray[n][n2 + n4 / 2];
            }
        }
        for (n2 = 0; n2 < n4 / 2; ++n2) {
            for (n = 0; n < n3 / 2; ++n) {
                dArray2[n][n4 - n4 / 2 + n2] = dArray[n + n3 / 2][n2];
            }
        }
        for (n2 = 0; n2 < n4 / 2; ++n2) {
            for (n = 0; n < n3 / 2; ++n) {
                dArray2[n][n2] = dArray[n + n3 / 2][n2 + n4 / 2];
            }
        }
        return dArray2;
    }

    public static double[] fftShift1D(double[] dArray, int n, int n2, int n3) {
        double[] dArray2 = new double[n * n2 * n3];
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n2 / 2; ++j) {
                for (int k = 0; k < n / 2; ++k) {
                    dArray2[n * (n2 - n2 / 2 + j) + n - n / 2 + k] = dArray[k + n * j];
                    dArray2[n * (n2 - n2 / 2 + j) + k] = dArray[n * j + k + n / 2];
                    dArray2[n * j + n - n / 2 + k] = dArray[n * (j + n2 / 2) + k];
                    dArray2[k + n * j] = dArray[n * (j + n2 / 2) + k + n / 2];
                }
            }
        }
        return dArray2;
    }

    public static double[] fftShift1D(double[] dArray, int n, int n2) {
        double[] dArray2 = new double[n * n2];
        for (int i = 0; i < n2 / 2; ++i) {
            for (int j = 0; j < n / 2; ++j) {
                dArray2[n * (n2 - n2 / 2 + i) + n - n / 2 + j] = dArray[j + n * i];
                dArray2[n * (n2 - n2 / 2 + i) + j] = dArray[n * i + j + n / 2];
                dArray2[n * i + n - n / 2 + j] = dArray[n * (i + n2 / 2) + j];
                dArray2[j + n * i] = dArray[n * (i + n2 / 2) + j + n / 2];
            }
        }
        return dArray2;
    }

    public static double[] fftShift3D(double[] dArray, int n, int n2, int n3) {
        double[] dArray2 = new double[n * n2 * n3];
        int n4 = n * n2;
        for (int i = 0; i < n3 / 2; ++i) {
            for (int j = 0; j < n2 / 2; ++j) {
                for (int k = 0; k < n / 2; ++k) {
                    dArray2[n - n / 2 + k + n * (n2 - n2 / 2 + j) + n4 * (n3 - n3 / 2 + i)] = dArray[k + n * j + i * n4];
                    dArray2[k + n * (n2 - n2 / 2 + j) + n4 * (n3 - n3 / 2 + i)] = dArray[k + n / 2 + n * j + i * n4];
                    dArray2[n - n / 2 + k + n * j + n4 * (n3 - n3 / 2 + i)] = dArray[k + n * (j + n2 / 2) + i * n4];
                    dArray2[k + n * j + n4 * (n3 - n3 / 2 + i)] = dArray[k + n / 2 + n * (j + n2 / 2) + i * n4];
                    dArray2[n - n / 2 + k + n * (n2 - n2 / 2 + j) + i * n4] = dArray[k + n * j + n4 * (n3 - n3 / 2 + i)];
                    dArray2[k + n * (n2 - n2 / 2 + j) + i * n4] = dArray[k + n / 2 + n * j + n4 * (n3 - n3 / 2 + i)];
                    dArray2[n - n / 2 + k + n * j + i * n4] = dArray[k + n * (j + n2 / 2) + n4 * (n3 - n3 / 2 + i)];
                    dArray2[k + n * j + i * n4] = dArray[k + n / 2 + n * (j + n2 / 2) + n4 * (n3 - n3 / 2 + i)];
                }
            }
        }
        return dArray2;
    }

    public static double[][] fftConv(double[][] dArray, double[][] dArray2) {
        int n = dArray.length;
        int n2 = dArray[0].length;
        DoubleFFT_2D doubleFFT_2D = new DoubleFFT_2D(n, n2);
        double[][] dArray3 = new double[n][n2];
        double[][] dArray4 = MathUtils.real2complex(dArray2);
        double[][] dArray5 = MathUtils.real2complex(dArray);
        doubleFFT_2D.complexForward(dArray4);
        doubleFFT_2D.complexForward(dArray5);
        double[][] dArray6 = MathUtils.hadamardProd(dArray4, dArray5, 1);
        doubleFFT_2D.complexInverse(dArray6, true);
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                dArray3[j][i] = dArray6[j][2 * i];
            }
        }
        return dArray3;
    }

    public static double[][] real2complex(double[][] dArray) {
        int n = dArray.length;
        int n2 = dArray[0].length;
        double[][] dArray2 = new double[n][2 * n2];
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                dArray2[j][2 * i] = dArray[j][i];
            }
        }
        return dArray2;
    }

    public static double avg(double[] dArray) {
        return MathUtils.sum(dArray) / (double)dArray.length;
    }

    public static double avg(long[] lArray) {
        return MathUtils.sum(lArray) / (long)lArray.length;
    }

    public static double avg(double[][] dArray) {
        int n = dArray.length;
        int n2 = dArray[0].length;
        return MathUtils.sum(dArray) / (double)(n * n2);
    }

    public static double avg(double[][][] dArray) {
        int n = dArray.length;
        int n2 = dArray[0].length;
        int n3 = dArray[0][0].length;
        return MathUtils.sum(dArray) / (double)(n3 * n2 * n);
    }

    public static double sum(double[] dArray) {
        int n = dArray.length;
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            d += dArray[i];
        }
        return d;
    }

    public static double sum(double[] dArray, int n, int n2) {
        double d = 0.0;
        for (int i = n; i <= n2; ++i) {
            d += dArray[i];
        }
        return d;
    }

    public static long sum(long[] lArray) {
        int n = lArray.length;
        long l = 0L;
        for (int i = 0; i < n; ++i) {
            l += lArray[i];
        }
        return l;
    }

    public static double sum(double[][] dArray) {
        int n = dArray.length;
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            d += MathUtils.sum(dArray[i]);
        }
        return d;
    }

    public static double sum(double[][][] dArray) {
        int n = dArray.length;
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            d += MathUtils.sum(dArray[i]);
        }
        return d;
    }

    public static double innerProd(double[] dArray, double[] dArray2) {
        int n = dArray.length;
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            d += dArray[i] * dArray2[i];
        }
        return d;
    }

    public static double[] im2array(String string) {
        File file = new File(string);
        BufferedImage bufferedImage = null;
        try {
            bufferedImage = ImageIO.read(file);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        int n = bufferedImage.getHeight();
        int n2 = bufferedImage.getWidth();
        double[] dArray = new double[n * n2];
        WritableRaster writableRaster = bufferedImage.getRaster();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                int[] nArray = writableRaster.getPixel(i, j, (int[])null);
                dArray[j + i * n2] = nArray[0];
            }
        }
        return dArray;
    }

    public static double[][] img_pad(double[][] dArray, int n, int n2, int n3) {
        int n4 = dArray.length;
        int n5 = dArray[0].length;
        double[][] dArray2 = new double[n2][n];
        switch (n3) {
            case 0: {
                for (int i = 0; i < n4; ++i) {
                    for (int j = 0; j < n5; ++j) {
                        dArray2[i][j] = dArray[i][j];
                    }
                }
                break;
            }
            case 1: {
                int n6 = (n - n5) / 2;
                int n7 = (n2 - n4) / 2;
                for (int i = 0; i < n4; ++i) {
                    for (int j = 0; j < n5; ++j) {
                        dArray2[n7 + i][j + n6] = dArray[i][j];
                    }
                }
                break;
            }
            case -1: {
                int n8;
                int n9;
                int n10 = n5 / 2;
                int n11 = n4 / 2;
                if (n10 != 0 || n11 != 0) {
                    for (n9 = 0; n9 < n11; ++n9) {
                        for (n8 = 0; n8 < n10; ++n8) {
                            dArray2[n2 - n11 + n9][n - n10 + n8] = dArray[n9][n8];
                        }
                    }
                }
                if (n10 != 0) {
                    for (n9 = 0; n9 < n11; ++n9) {
                        for (n8 = 0; n8 < n5 - n10; ++n8) {
                            dArray2[n2 - n11 + n9][n8] = dArray[n9][n8 + n10];
                        }
                    }
                }
                if (n11 != 0) {
                    for (n9 = 0; n9 < n4 - n11; ++n9) {
                        for (n8 = 0; n8 < n10; ++n8) {
                            dArray2[n9][n - n10 + n8] = dArray[n9 + n11][n8];
                        }
                    }
                }
                for (n9 = 0; n9 < n4 - n11; ++n9) {
                    for (n8 = 0; n8 < n5 - n10; ++n8) {
                        dArray2[n9][n8] = dArray[n9 + n11][n8 + n10];
                    }
                }
                break;
            }
            default: {
                System.out.println("bad value for keyword JUST");
            }
        }
        return dArray2;
    }

    public static double[] img_pad1d(double[] dArray, int n, int n2, int n3, int n4, int n5) {
        double[] dArray2 = new double[n4 * n3];
        switch (n5) {
            case 0: {
                for (int i = 0; i < n2; ++i) {
                    for (int j = 0; j < n; ++j) {
                        dArray2[j + i * n3] = dArray[j + i * n];
                    }
                }
                break;
            }
            case 1: {
                int n6 = (n3 - n) / 2;
                int n7 = (n4 - n2) / 2;
                for (int i = 0; i < n2; ++i) {
                    for (int j = 0; j < n; ++j) {
                        dArray2[n7 + i + (j + n6) * n3] = dArray[j * n + i];
                    }
                }
                break;
            }
            case -1: {
                int n8;
                int n9;
                int n10 = n / 2;
                int n11 = n2 / 2;
                if (n10 != 0 || n11 != 0) {
                    for (n9 = 0; n9 < n11; ++n9) {
                        for (n8 = 0; n8 < n10; ++n8) {
                            dArray2[n4 - n11 + n9 + (n3 - n10 + n8) * n3] = dArray[n8 * n + n9];
                        }
                    }
                }
                if (n10 != 0) {
                    for (n9 = 0; n9 < n11; ++n9) {
                        for (n8 = 0; n8 < n - n10; ++n8) {
                            dArray2[(n4 - n11 + n9) * n3 + n8] = dArray[n9 * n + n8 + n10];
                        }
                    }
                }
                if (n11 != 0) {
                    for (n9 = 0; n9 < n2 - n11; ++n9) {
                        for (n8 = 0; n8 < n10; ++n8) {
                            dArray2[n9 * n3 + n3 - n10 + n8] = dArray[(n9 + n11) * n + n8];
                        }
                    }
                }
                for (n9 = 0; n9 < n2 - n11; ++n9) {
                    for (n8 = 0; n8 < n - n10; ++n8) {
                        dArray2[n8 + n9 * n3] = dArray[(n9 + n11) * n + n8 + n10];
                    }
                }
                break;
            }
            default: {
                System.out.println("bad value for keyword JUST");
            }
        }
        return dArray2;
    }

    public static double[] img_pad(double[] dArray, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        double[] dArray2 = new double[n5 * n4 * n6];
        int n8 = n4 * n5;
        int n9 = n * n2;
        switch (n7) {
            case 0: {
                for (int i = 0; i < n3; ++i) {
                    for (int j = 0; j < n2; ++j) {
                        for (int k = 0; k < n; ++k) {
                            dArray2[k + j * n4] = dArray[k + j * n];
                        }
                    }
                }
                break;
            }
            case 1: {
                int n10 = (n4 - n) / 2;
                int n11 = (n5 - n2) / 2;
                int n12 = (n6 - n3) / 2;
                for (int i = 0; i < n3; ++i) {
                    for (int j = 0; j < n2; ++j) {
                        for (int k = 0; k < n; ++k) {
                            dArray2[n10 + k + (j + n11) * n4 + (i + n12) * n8] = dArray[k + j * n + i * n9];
                        }
                    }
                }
                break;
            }
            case -1: {
                int n13;
                int n14;
                int n15 = n / 2;
                int n16 = n2 / 2;
                if (n15 != 0 || n16 != 0) {
                    for (n14 = 0; n14 < n16; ++n14) {
                        for (n13 = 0; n13 < n15; ++n13) {
                            dArray2[n5 - n16 + n14 + (n4 - n15 + n13) * n4] = dArray[n13 * n + n14];
                        }
                    }
                }
                if (n15 != 0) {
                    for (n14 = 0; n14 < n16; ++n14) {
                        for (n13 = 0; n13 < n - n15; ++n13) {
                            dArray2[(n5 - n16 + n14) * n4 + n13] = dArray[n14 * n + n13 + n15];
                        }
                    }
                }
                if (n16 != 0) {
                    for (n14 = 0; n14 < n2 - n16; ++n14) {
                        for (n13 = 0; n13 < n15; ++n13) {
                            dArray2[n14 * n4 + n4 - n15 + n13] = dArray[(n14 + n16) * n + n13];
                        }
                    }
                }
                for (n14 = 0; n14 < n2 - n16; ++n14) {
                    for (n13 = 0; n13 < n - n15; ++n13) {
                        dArray2[n13 + n14 * n4] = dArray[(n14 + n16) * n + n13 + n15];
                    }
                }
                break;
            }
            default: {
                System.out.println("bad value for keyword JUST");
            }
        }
        return dArray2;
    }

    public static double[][] hadamardProd(double[][] dArray, double[][] dArray2, int n) {
        int n2 = dArray.length;
        int n3 = dArray[0].length;
        double[][] dArray3 = new double[n2][n3];
        if (n == 0) {
            for (int i = 0; i < n3; ++i) {
                for (int j = 0; j < n2; ++j) {
                    dArray3[j][i] = dArray[j][i] * dArray2[j][i];
                }
            }
        } else {
            for (int i = 0; i < n3; ++i) {
                for (int j = 0; j < n2; ++j) {
                    dArray3[j][2 * i] = dArray[j][2 * i] * dArray2[j][2 * i] - dArray[j][2 * i + 1] * dArray2[j][2 * i + 1];
                    dArray3[j][2 * i + 1] = dArray[j][2 * i] * dArray2[j][2 * i + 1] + dArray[j][2 * i + 1] * dArray2[j][2 * i];
                }
            }
        }
        return dArray3;
    }

    public static double[][] sumArrays(double[][] dArray, double[][] dArray2, String string) {
        int n = dArray.length;
        int n2 = dArray[0].length;
        double[][] dArray3 = new double[n][n2];
        if (string == "+") {
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n; ++j) {
                    dArray3[j][i] = dArray[j][i] + dArray2[j][i];
                }
            }
        } else {
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n; ++j) {
                    dArray3[j][i] = dArray[j][i] - dArray2[j][i];
                }
            }
        }
        return dArray3;
    }

    public static double std(double[] dArray) {
        double d = MathUtils.var(dArray);
        return Math.sqrt(d);
    }

    public static double std(double[][] dArray) {
        double d = MathUtils.var(dArray);
        return Math.sqrt(d);
    }

    public static double std(double[][][] dArray) {
        double d = MathUtils.var(dArray);
        return Math.sqrt(d);
    }

    public static double var(double[] dArray) {
        double d = MathUtils.avg(dArray);
        double d2 = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            d2 += dArray[i] * dArray[i];
        }
        return d2 / (double)dArray.length - d * d;
    }

    public static double var(double[][] dArray) {
        double d = MathUtils.avg(dArray);
        double d2 = MathUtils.avg(MathUtils.hadamardProd(dArray, dArray, 0)) - d * d;
        return d2;
    }

    public static double var(double[][][] dArray) {
        double d = 0.0;
        double d2 = MathUtils.avg(dArray);
        double d3 = 0.0;
        double d4 = 0.0;
        for (int i = 0; i < dArray[0][0].length; ++i) {
            for (int j = 0; j < dArray[0].length; ++j) {
                for (int k = 0; k < dArray.length; ++k) {
                    d4 = dArray[k][j][i] - d2;
                    d += d4 * d4;
                    d3 += 1.0;
                }
            }
        }
        return d / d3;
    }

    public static void stat(double[][] dArray) {
        System.out.println("H " + dArray.length + " W " + dArray[0].length);
        System.out.println("min " + MathUtils.min(dArray) + " max " + MathUtils.max(dArray));
        System.out.println("avg " + MathUtils.avg(dArray) + " var " + MathUtils.var(dArray) + " std " + MathUtils.std(dArray));
    }

    public static void stat(double[] dArray) {
        System.out.println("size " + dArray.length);
        System.out.println("min " + MathUtils.min(dArray) + " max " + MathUtils.max(dArray));
        System.out.println("avg " + MathUtils.avg(dArray) + " var " + MathUtils.var(dArray) + " std " + MathUtils.std(dArray));
    }

    public static void statC(double[] dArray) {
        int n = dArray.length;
        System.out.println("size " + dArray.length);
        double[] dArray2 = new double[n / 2];
        double[] dArray3 = new double[n / 2];
        for (int i = 0; i < n / 2; ++i) {
            dArray2[i] = dArray[2 * i];
            dArray3[i] = dArray[2 * i + 1];
        }
        System.out.println("Real part");
        System.out.println("min " + MathUtils.min(dArray2) + " max " + MathUtils.max(dArray2));
        System.out.println("avg " + MathUtils.avg(dArray2) + " var " + MathUtils.var(dArray2) + " std " + MathUtils.std(dArray2));
        System.out.println("Imaginary part");
        System.out.println("min " + MathUtils.min(dArray3) + " max " + MathUtils.max(dArray3));
        System.out.println("avg " + MathUtils.avg(dArray3) + " var " + MathUtils.var(dArray3) + " std " + MathUtils.std(dArray3));
    }

    public static void stat(double[] dArray, int n, int n2) {
        double[] dArray2 = new double[n2 - n + 1];
        for (int i = n; i <= n2; ++i) {
            dArray2[i - n] = dArray[i];
        }
        System.out.println("size " + dArray2.length);
        System.out.println("min " + MathUtils.min(dArray2) + " max " + MathUtils.max(dArray2));
        System.out.println("avg " + MathUtils.avg(dArray2) + " var " + MathUtils.var(dArray2) + " std " + MathUtils.std(dArray2));
    }

    public static double[][] imnoise(double[][] dArray, int n, double d, double d2) {
        int n2 = dArray.length;
        int n3 = dArray[0].length;
        double[][] dArray2 = new double[n2][n3];
        switch (n) {
            case 2: {
                Random random = new Random();
                double d3 = Math.sqrt(d);
                double d4 = d2;
                MathUtils.im2double(dArray);
                for (int i = 0; i < n3; ++i) {
                    for (int j = 0; j < n2; ++j) {
                        dArray2[j][i] = dArray[j][i] + d3 * random.nextGaussian() + d4;
                    }
                }
                MathUtils.uint8(dArray2);
                break;
            }
            default: {
                throw new IllegalArgumentException("The type does not exist");
            }
        }
        return dArray2;
    }

    public static double[][] fspecialAverage(int[] nArray) {
        double[][] dArray = new double[nArray[0]][nArray[1]];
        double d = 1.0 / (double)(nArray[0] * nArray[1]);
        int n = nArray[0];
        int n2 = nArray[1];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                dArray[i][j] = d;
            }
        }
        return dArray;
    }

    public static double[][] fspecial(int n, int n2) {
        switch (n) {
            case 7: {
                int n3;
                int n4;
                int n5 = n2;
                int n6 = 2 * n5;
                double[][] dArray = MathUtils.cartesDist2D(n6, n6);
                double[][] dArray2 = new double[n6][n6];
                double[][] dArray3 = new double[n6][n6];
                for (n4 = 0; n4 < dArray.length; ++n4) {
                    for (n3 = 0; n3 < dArray.length; ++n3) {
                        if (!(dArray[n3][n4] <= (double)n5)) continue;
                        dArray2[n3][n4] = 1.0;
                    }
                }
                double d = MathUtils.sum(dArray2);
                for (n4 = 0; n4 < dArray.length; ++n4) {
                    for (n3 = 0; n3 < dArray.length; ++n3) {
                        if (dArray2[n3][n4] != 1.0) continue;
                        dArray3[n3][n4] = 1.0 / d;
                    }
                }
                return dArray3;
            }
        }
        throw new IllegalArgumentException("The type does not exist");
    }

    public static double[][] fspecial(int n, int[] nArray, double d) {
        switch (n) {
            case 3: {
                double[][] dArray = new double[nArray[0]][nArray[1]];
                double d2 = 1.0 / (double)(nArray[0] * nArray[1]);
                int n2 = nArray[0];
                int n3 = nArray[1];
                for (int i = 0; i < n2; ++i) {
                    for (int j = 0; j < n3; ++j) {
                        dArray[i][j] = d2;
                    }
                }
                return dArray;
            }
            case 2: {
                double[][] dArray = new double[nArray[0]][nArray[1]];
                double d3 = 2.0 * d * d;
                double d4 = 1.0 / Math.sqrt(Math.PI * d3);
                int n4 = (-nArray[1] + 1) / 2;
                int n5 = nArray[1] / 2;
                int n6 = (-nArray[0] + 1) / 2;
                int n7 = nArray[0] / 2;
                for (int i = n6; i <= n7; ++i) {
                    for (int j = n4; j <= n5; ++j) {
                        dArray[i - n6][j - n4] = d4 * Math.exp((double)(-(j * j + i * i)) / d3);
                    }
                }
                return dArray;
            }
        }
        throw new IllegalArgumentException("The type does not exist");
    }

    public static double[] fspecial1D(int n, int[] nArray, double d) {
        int n2 = nArray[0] * nArray[1];
        switch (n) {
            case 3: {
                double[] dArray = new double[n2];
                double d2 = 1.0 / (double)n2;
                for (int i = 0; i < n2; ++i) {
                    dArray[i] = d2;
                }
                return dArray;
            }
            case 2: {
                double[] dArray = new double[n2];
                int n3 = (-nArray[1] + 1) / 2;
                int n4 = nArray[1] / 2;
                int n5 = (-nArray[0] + 1) / 2;
                int n6 = nArray[0] / 2;
                for (int i = n5; i <= n6; ++i) {
                    for (int j = n3; j <= n4; ++j) {
                    }
                }
                return dArray;
            }
        }
        throw new IllegalArgumentException("The type does not exist");
    }

    public static double[] fspecial1D(int n) {
        switch (n) {
            case 3: {
                double d = 0.1111111111111111;
                double[] dArray = new double[]{d, d, d, d, d, d, d, d, d};
                return dArray;
            }
            case 7: {
                int n2;
                int n3 = 5;
                int n4 = 2 * n3;
                double[] dArray = MathUtils.cartesDist1D(n4, n4);
                double[] dArray2 = new double[n4 * n4];
                double[] dArray3 = new double[n4 * n4];
                for (n2 = 0; n2 < dArray.length; ++n2) {
                    if (!(dArray[n2] <= (double)n3)) continue;
                    dArray2[n2] = 1.0;
                }
                double d = MathUtils.sum(dArray2);
                for (n2 = 0; n2 < dArray.length; ++n2) {
                    if (dArray2[n2] != 1.0) continue;
                    dArray3[n2] = 1.0 / d;
                }
                return dArray3;
            }
            case 5: {
                double[] dArray = new double[]{1.0, 2.0, 1.0, 0.0, 0.0, 0.0, -1.0, -2.0, -1.0};
                return dArray;
            }
            case 4: {
                double[] dArray = new double[]{1.0, 1.0, 1.0, 0.0, 0.0, 0.0, -1.0, -1.0, -1.0};
                return dArray;
            }
            case 6: {
                double[] dArray = new double[]{3.0, 3.0, 3.0, 3.0, 0.0, 3.0, -5.0, -5.0, -5.0};
                return dArray;
            }
        }
        throw new IllegalArgumentException("The type does not exist");
    }

    public static double[][] fspecial(int n) {
        switch (n) {
            case 3: {
                double d = 0.1111111111111111;
                double[][] dArrayArray = new double[][]{{d, d, d}, {d, d, d}, {d, d, d}};
                return dArrayArray;
            }
            case 7: {
                int n2;
                int n3;
                int n4 = 5;
                int n5 = 2 * n4;
                double[][] dArray = MathUtils.cartesDist2D(n5, n5);
                double[][] dArray2 = new double[n5][n5];
                double[][] dArray3 = new double[n5][n5];
                for (n3 = 0; n3 < dArray.length; ++n3) {
                    for (n2 = 0; n2 < dArray.length; ++n2) {
                        if (!(dArray[n2][n3] <= (double)n4)) continue;
                        dArray2[n2][n3] = 1.0;
                    }
                }
                double d = MathUtils.sum(dArray2);
                for (n3 = 0; n3 < dArray.length; ++n3) {
                    for (n2 = 0; n2 < dArray.length; ++n2) {
                        if (dArray2[n2][n3] != 1.0) continue;
                        dArray3[n2][n3] = 1.0 / d;
                    }
                }
                return dArray3;
            }
            case 5: {
                double[][] dArrayArray = new double[][]{{1.0, 2.0, 1.0}, {0.0, 0.0, 0.0}, {-1.0, -2.0, -1.0}};
                return dArrayArray;
            }
            case 4: {
                double[][] dArrayArray = new double[][]{{1.0, 1.0, 1.0}, {0.0, 0.0, 0.0}, {-1.0, -1.0, -1.0}};
                return dArrayArray;
            }
            case 6: {
                double[][] dArrayArray = new double[][]{{3.0, 3.0, 3.0}, {3.0, 0.0, 3.0}, {-5.0, -5.0, -5.0}};
                return dArrayArray;
            }
        }
        throw new IllegalArgumentException("The type does not exist");
    }

    public static double[] getArray(double[] dArray, int n, int n2, int n3) {
        int n4 = n * n2;
        double[] dArray2 = new double[n4];
        for (int i = 0; i < n4; ++i) {
            dArray2[i] = dArray[n3 * n4 + i];
        }
        return dArray2;
    }

    public static double[] transpose(double[] dArray, int n, int n2, int n3) {
        int n4 = dArray.length;
        double[] dArray2 = new double[n4];
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n2; ++j) {
                for (int k = 0; k < n; ++k) {
                    dArray2[j + n2 * k + i * n * n2] = dArray[k + n * j + i * n * n2];
                }
            }
        }
        return dArray2;
    }

    public static void writeStat(double[][] dArray, String string) {
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(new File("temp"), true));
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i <= 5; ++i) {
                stringBuffer.append(string);
            }
            stringBuffer.append("H " + dArray.length + " W " + dArray[0].length + "\n min " + MathUtils.min(dArray) + " max " + MathUtils.max(dArray) + "\n avg " + MathUtils.avg(dArray) + " var " + MathUtils.var(dArray) + " std " + MathUtils.std(dArray));
            bufferedWriter.write(stringBuffer.toString());
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static double[][][] XY2XZ(double[][][] dArray) {
        int n = dArray.length;
        int n2 = dArray[0].length;
        int n3 = dArray[0][0].length;
        double[][][] dArray2 = new double[n2][n][n3];
        for (int i = 0; i < n3; ++i) {
            for (int j = n - 1; j >= 0; --j) {
                for (int k = 0; k < n3; ++k) {
                    dArray2[i][Math.abs((int)(j - 1))][k] = dArray[j][k][i];
                }
            }
        }
        return dArray2;
    }

    public static double[] cumSum(double[] dArray) {
        int n = dArray.length;
        double[] dArray2 = new double[n];
        dArray2[0] = dArray[0];
        for (int i = 1; i < n; ++i) {
            dArray2[i] = dArray2[i - 1] + dArray[i];
        }
        return dArray2;
    }

    public static double mse(double[] dArray, double[] dArray2) {
        int n = dArray2.length;
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < n; ++i) {
            d = dArray2[i] - dArray[i];
            d2 += d * d;
        }
        return d2 / (double)n;
    }
}

