/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.tools;

import loci.formats.IFormatReader;
import loci.formats.IFormatWriter;
import loci.formats.ImageReader;
import loci.formats.ImageWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrintFormatTable {
    private static final Logger LOGGER = LoggerFactory.getLogger(PrintFormatTable.class);

    public static String getTextHeader() {
        return "";
    }

    public static String getTextFooter() {
        return "";
    }

    public static String getTextFormatLine(String name, boolean read, boolean write, boolean wmp, String ext) {
        StringBuffer s = new StringBuffer(name);
        if (read) {
            s.append(": can read");
        }
        if (write) {
            s.append(", can write");
        }
        if (wmp) {
            s.append(", can write multiple");
        }
        s.append(" (");
        s.append(ext);
        s.append(")");
        return s.toString();
    }

    public static String getXmlHeader() {
        return "<response>\n";
    }

    public static String getXmlFooter() {
        return "</response>\n";
    }

    public static String getXmlFormatLine(String name, boolean read, boolean write, boolean wmp, String ext) {
        StringBuffer s = new StringBuffer("<format name='");
        s.append(name);
        s.append("'>\n");
        if (read) {
            s.append("  <tag name='support' value='reading' />\n");
        }
        if (write) {
            s.append("  <tag name='support' value='writing' />\n");
        }
        if (wmp) {
            s.append("  <tag name='support' value='writing multiple pages' />\n");
        }
        s.append("  <tag name='extensions' value='");
        s.append(ext.replace(", ", "|"));
        s.append("' />\n</format>\n");
        return s.toString();
    }

    public static String getHtmlHeader() {
        return "<table><tr><th>Name</th><th>Reading</th><th>Writing</th><th>Extensions</th></tr>";
    }

    public static String getHtmlFooter() {
        return "</table>";
    }

    public static String getHtmlFormatLine(String name, boolean read, boolean write, String ext) {
        StringBuffer s = new StringBuffer("  <tr><td>");
        s.append(name);
        s.append("</td><td>");
        s.append(read ? "yes" : "no");
        s.append("</td><td>");
        s.append(write ? "yes" : "no");
        s.append("</td><td>");
        s.append(ext);
        s.append("</td></tr>");
        return s.toString();
    }

    public static String getHeader(PrintStyles style) {
        if (style == PrintStyles.XML) {
            return PrintFormatTable.getXmlHeader();
        }
        if (style == PrintStyles.HTML) {
            return PrintFormatTable.getHtmlHeader();
        }
        if (style == PrintStyles.TXT) {
            return PrintFormatTable.getTextHeader();
        }
        return "";
    }

    public static String getFooter(PrintStyles style) {
        if (style == PrintStyles.XML) {
            return PrintFormatTable.getXmlFooter();
        }
        if (style == PrintStyles.HTML) {
            return PrintFormatTable.getHtmlFooter();
        }
        if (style == PrintStyles.TXT) {
            return PrintFormatTable.getTextFooter();
        }
        return "";
    }

    public static String getFormatLine(PrintStyles style, String name, boolean read, boolean write, boolean wmp, String ext) {
        if (style == PrintStyles.XML) {
            return PrintFormatTable.getXmlFormatLine(name, read, write, wmp, ext);
        }
        if (style == PrintStyles.HTML) {
            return PrintFormatTable.getHtmlFormatLine(name, read, write, ext);
        }
        if (style == PrintStyles.TXT) {
            return PrintFormatTable.getTextFormatLine(name, read, write, wmp, ext);
        }
        return "";
    }

    public static void printSupportedFormats(String[] args) {
        PrintStyles printStyle = PrintStyles.TXT;
        boolean usage = false;
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equals("-help")) {
                    usage = true;
                    continue;
                }
                if (args[i].equals("-xml")) {
                    printStyle = PrintStyles.XML;
                    continue;
                }
                if (args[i].equals("-html")) {
                    printStyle = PrintStyles.HTML;
                    continue;
                }
                if (args[i].equals("-txt")) {
                    printStyle = PrintStyles.TXT;
                    continue;
                }
                LOGGER.warn("unknown flag: {}; try -help for options", (Object)args[i]);
            }
        }
        if (usage) {
            LOGGER.info("Usage: formatlist [-html] [-txt] [-xml]");
            LOGGER.info("  -html: show formats in an HTML table");
            LOGGER.info("   -txt: show formats in plaintext (default)");
            LOGGER.info("   -xml: show formats as XML data");
            return;
        }
        LOGGER.info(PrintFormatTable.getHeader(printStyle));
        ImageReader baseReader = new ImageReader();
        IFormatReader[] readers = baseReader.getReaders();
        ImageWriter baseWriter = new ImageWriter();
        IFormatWriter[] writers = baseWriter.getWriters();
        for (int i = 0; i < readers.length; ++i) {
            String readerFormatName = readers[i].getFormat();
            String ext = "";
            boolean read = true;
            boolean write = false;
            boolean wmp = false;
            IFormatWriter writer = null;
            for (int j = 0; j < writers.length; ++j) {
                if (!writers[j].getFormat().equals(readerFormatName)) continue;
                writer = writers[j];
            }
            if (writer != null) {
                write = true;
                if (writer.canDoStacks()) {
                    wmp = true;
                }
            }
            String[] extensions = readers[i].getSuffixes();
            for (int j = 0; j < extensions.length; ++j) {
                ext = ext + extensions[j];
                if (j >= extensions.length - 1) continue;
                ext = ext + ", ";
            }
            LOGGER.info(PrintFormatTable.getFormatLine(printStyle, readerFormatName, read, write, wmp, ext));
        }
        LOGGER.info(PrintFormatTable.getFooter(printStyle));
    }

    public static void main(String[] args) {
        PrintFormatTable.printSupportedFormats(args);
    }

    public static enum PrintStyles {
        TXT,
        XML,
        HTML;

    }
}

