/*
 * Decompiled with CFR 0.152.
 */
package mitiv.optim;

import mitiv.exception.IncorrectSpaceException;
import mitiv.linalg.Vector;
import mitiv.linalg.VectorSpace;
import mitiv.linalg.shaped.DoubleShapedVectorSpace;
import mitiv.linalg.shaped.FloatShapedVectorSpace;
import mitiv.optim.DoubleBoxedSet;
import mitiv.optim.FloatBoxedSet;

public abstract class BoxedSet {
    protected VectorSpace space;
    static final int ASCENT = -1;
    static final int DESCENT = 1;

    protected BoxedSet(VectorSpace vectorSpace) {
        this.space = vectorSpace;
    }

    public static BoxedSet create(VectorSpace vectorSpace) {
        if (vectorSpace instanceof FloatShapedVectorSpace) {
            return new FloatBoxedSet((FloatShapedVectorSpace)vectorSpace);
        }
        if (vectorSpace instanceof DoubleShapedVectorSpace) {
            return new DoubleBoxedSet((DoubleShapedVectorSpace)vectorSpace);
        }
        throw new IncorrectSpaceException();
    }

    public abstract void projectVariables(Vector var1, Vector var2);

    public abstract void projectDirection(Vector var1, Vector var2, Vector var3, int var4);

    public abstract void findFreeVariables(Vector var1, Vector var2, Vector var3, int var4);

    public abstract double[] findStepLimits(Vector var1, Vector var2, int var3);
}

