/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import loci.common.DataTools;
import loci.common.Location;
import loci.formats.ClassList;
import loci.formats.CoreMetadata;
import loci.formats.FileStitcher;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.IFormatReader;
import loci.formats.ImageReader;
import loci.formats.Modulo;
import loci.formats.meta.MetadataStore;

public class FilePatternReader
extends FormatReader {
    private FileStitcher helper;

    public FilePatternReader() {
        super("File pattern", new String[]{"pattern"});
        ClassList<IFormatReader> classes = ImageReader.getDefaultReaderClasses();
        Class<IFormatReader>[] classArray = classes.getClasses();
        ClassList<IFormatReader> newClasses = new ClassList<IFormatReader>(IFormatReader.class);
        for (Class<IFormatReader> c : classArray) {
            if (c.equals(FilePatternReader.class)) continue;
            newClasses.addClass(c);
        }
        this.helper = new FileStitcher(new ImageReader(newClasses));
        this.suffixSufficient = true;
    }

    @Override
    public int getImageCount() {
        return this.helper.getImageCount();
    }

    @Override
    public boolean isRGB() {
        return this.helper.isRGB();
    }

    @Override
    public int getSizeX() {
        return this.helper.getSizeX();
    }

    @Override
    public int getSizeY() {
        return this.helper.getSizeY();
    }

    @Override
    public int getSizeZ() {
        return this.helper.getSizeZ();
    }

    @Override
    public int getSizeC() {
        return this.helper.getSizeC();
    }

    @Override
    public int getSizeT() {
        return this.helper.getSizeT();
    }

    @Override
    public int getPixelType() {
        return this.helper.getPixelType();
    }

    @Override
    public int getBitsPerPixel() {
        return this.helper.getBitsPerPixel();
    }

    @Override
    public int getEffectiveSizeC() {
        return this.helper.getEffectiveSizeC();
    }

    @Override
    public int getRGBChannelCount() {
        return this.helper.getRGBChannelCount();
    }

    @Override
    public boolean isIndexed() {
        return this.helper.isIndexed();
    }

    @Override
    public boolean isFalseColor() {
        return this.helper.isFalseColor();
    }

    @Override
    public byte[][] get8BitLookupTable() throws FormatException, IOException {
        if (this.getCurrentFile() == null) {
            return null;
        }
        return this.helper.get8BitLookupTable();
    }

    @Override
    public short[][] get16BitLookupTable() throws FormatException, IOException {
        if (this.getCurrentFile() == null) {
            return null;
        }
        return this.helper.get16BitLookupTable();
    }

    @Override
    public Modulo getModuloZ() {
        return this.helper.getModuloZ();
    }

    @Override
    public Modulo getModuloC() {
        return this.helper.getModuloC();
    }

    @Override
    public Modulo getModuloT() {
        return this.helper.getModuloT();
    }

    @Override
    public int getThumbSizeX() {
        return this.helper.getThumbSizeX();
    }

    @Override
    public int getThumbSizeY() {
        return this.helper.getThumbSizeY();
    }

    @Override
    public boolean isLittleEndian() {
        return this.helper.isLittleEndian();
    }

    @Override
    public String getDimensionOrder() {
        return this.helper.getDimensionOrder();
    }

    @Override
    public boolean isOrderCertain() {
        return this.helper.isOrderCertain();
    }

    @Override
    public boolean isThumbnailSeries() {
        return this.helper.isThumbnailSeries();
    }

    @Override
    public boolean isInterleaved() {
        return this.helper.isInterleaved();
    }

    @Override
    public boolean isInterleaved(int subC) {
        return this.helper.isInterleaved(subC);
    }

    @Override
    public byte[] openBytes(int no) throws FormatException, IOException {
        return this.helper.openBytes(no);
    }

    @Override
    public byte[] openBytes(int no, int x, int y, int w, int h) throws FormatException, IOException {
        return this.helper.openBytes(no, x, y, w, h);
    }

    @Override
    public byte[] openBytes(int no, byte[] buf) throws FormatException, IOException {
        return this.helper.openBytes(no, buf);
    }

    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        return this.helper.openBytes(no, buf, x, y, w, h);
    }

    @Override
    public Object openPlane(int no, int x, int y, int w, int h) throws FormatException, IOException {
        return this.helper.openPlane(no, x, y, w, h);
    }

    @Override
    public byte[] openThumbBytes(int no) throws FormatException, IOException {
        return this.helper.openThumbBytes(no);
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        this.helper.close(fileOnly);
    }

    @Override
    public int getSeriesCount() {
        return this.helper.getSeriesCount();
    }

    @Override
    public void setSeries(int no) {
        this.helper.setSeries(no);
    }

    @Override
    public int getSeries() {
        return this.helper.getSeries();
    }

    @Override
    public void setGroupFiles(boolean group) {
        this.helper.setGroupFiles(group);
    }

    @Override
    public boolean isGroupFiles() {
        return this.helper.isGroupFiles();
    }

    @Override
    public boolean isMetadataComplete() {
        return this.helper.isMetadataComplete();
    }

    @Override
    public void setNormalized(boolean normalize) {
        this.helper.setNormalized(normalize);
    }

    @Override
    public boolean isNormalized() {
        return this.helper.isNormalized();
    }

    @Override
    public void setOriginalMetadataPopulated(boolean populate) {
        this.helper.setOriginalMetadataPopulated(populate);
    }

    @Override
    public boolean isOriginalMetadataPopulated() {
        return this.helper.isOriginalMetadataPopulated();
    }

    @Override
    public String[] getSeriesUsedFiles(boolean noPixels) {
        if (noPixels) {
            return new String[]{this.currentId};
        }
        String[] helperFiles = this.helper.getSeriesUsedFiles(noPixels);
        String[] allFiles = new String[helperFiles.length + 1];
        allFiles[0] = this.currentId;
        System.arraycopy(helperFiles, 0, allFiles, 1, helperFiles.length);
        return allFiles;
    }

    @Override
    public String[] getUsedFiles(boolean noPixels) {
        if (noPixels) {
            return new String[]{this.currentId};
        }
        String[] helperFiles = this.helper.getUsedFiles(noPixels);
        String[] allFiles = new String[helperFiles.length + 1];
        allFiles[0] = this.currentId;
        System.arraycopy(helperFiles, 0, allFiles, 1, helperFiles.length);
        return allFiles;
    }

    @Override
    public int getIndex(int z, int c, int t) {
        return this.helper.getIndex(z, c, t);
    }

    @Override
    public int[] getZCTCoords(int index) {
        return this.helper.getZCTCoords(index);
    }

    @Override
    public Object getMetadataValue(String field) {
        return this.helper.getMetadataValue(field);
    }

    @Override
    public Object getSeriesMetadataValue(String field) {
        return this.helper.getSeriesMetadataValue(field);
    }

    @Override
    public Hashtable<String, Object> getGlobalMetadata() {
        return this.helper.getGlobalMetadata();
    }

    @Override
    public Hashtable<String, Object> getSeriesMetadata() {
        return this.helper.getSeriesMetadata();
    }

    @Override
    public List<CoreMetadata> getCoreMetadataList() {
        List<CoreMetadata> oldcore = this.helper.getCoreMetadataList();
        ArrayList<CoreMetadata> newcore = new ArrayList<CoreMetadata>();
        for (int s = 0; s < oldcore.size(); ++s) {
            CoreMetadata newMeta = oldcore.get(s).clone(this, s);
            newMeta.resolutionCount = oldcore.get((int)s).resolutionCount;
            newcore.add(newMeta);
        }
        return newcore;
    }

    @Override
    public void setMetadataFiltered(boolean filter) {
        this.helper.setMetadataFiltered(filter);
    }

    @Override
    public boolean isMetadataFiltered() {
        return this.helper.isMetadataFiltered();
    }

    @Override
    public void setMetadataStore(MetadataStore store) {
        this.helper.setMetadataStore(store);
    }

    @Override
    public MetadataStore getMetadataStore() {
        return this.helper.getMetadataStore();
    }

    @Override
    public Object getMetadataStoreRoot() {
        return this.helper.getMetadataStoreRoot();
    }

    @Override
    public IFormatReader[] getUnderlyingReaders() {
        return new IFormatReader[]{this.helper};
    }

    @Override
    public boolean isSingleFile(String id) throws FormatException, IOException {
        return false;
    }

    @Override
    public String getDatasetStructureDescription() {
        return this.helper.getDatasetStructureDescription();
    }

    @Override
    public boolean hasCompanionFiles() {
        return true;
    }

    @Override
    public String[] getPossibleDomains(String id) throws FormatException, IOException {
        return this.helper.getPossibleDomains(id);
    }

    @Override
    public String[] getDomains() {
        return this.helper.getDomains();
    }

    @Override
    public int getOptimalTileWidth() {
        return this.helper.getOptimalTileWidth();
    }

    @Override
    public int getOptimalTileHeight() {
        return this.helper.getOptimalTileHeight();
    }

    @Override
    public int getCoreIndex() {
        return this.helper.getCoreIndex();
    }

    @Override
    public void setCoreIndex(int no) {
        this.helper.setCoreIndex(no);
    }

    @Override
    public int seriesToCoreIndex(int series) {
        return this.helper.seriesToCoreIndex(series);
    }

    @Override
    public int coreIndexToSeries(int index) {
        return this.helper.coreIndexToSeries(index);
    }

    @Override
    public int getResolutionCount() {
        return this.helper.getResolutionCount();
    }

    @Override
    public void setResolution(int no) {
        this.helper.setResolution(no);
    }

    @Override
    public int getResolution() {
        return this.helper.getResolution();
    }

    @Override
    public boolean hasFlattenedResolutions() {
        return this.helper.hasFlattenedResolutions();
    }

    @Override
    public void setFlattenedResolutions(boolean flattened) {
        this.helper.setFlattenedResolutions(flattened);
    }

    @Override
    public Class<?> getNativeDataType() {
        return this.helper.getNativeDataType();
    }

    @Override
    public void close() throws IOException {
        if (this.helper != null) {
            this.helper.close();
        }
    }

    @Override
    protected void initFile(String id) throws FormatException, IOException {
        this.currentId = new Location(id).getAbsolutePath();
        String pattern = DataTools.readFile(id).trim();
        String dir = new Location(id).getAbsoluteFile().getParent();
        if (new Location(pattern).getParent() == null) {
            pattern = dir + File.separator + pattern;
        }
        this.helper.setUsingPatternIds(true);
        this.helper.setCanChangePattern(false);
        this.helper.setId(pattern);
        this.core = this.helper.getCoreMetadataList();
    }
}

