/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.dense.decomposition.hessenberg;

import org.ejml.alg.dense.decomposition.DecompositionInterface;
import org.ejml.alg.dense.decomposition.qr.QrHelperFunctions;
import org.ejml.data.DenseMatrix64F;
import org.ejml.ops.CommonOps;

public class HessenbergSimilarDecomposition
implements DecompositionInterface<DenseMatrix64F> {
    private DenseMatrix64F QH;
    private int N;
    private double[] gammas;
    private double[] b;
    private double[] u;

    public HessenbergSimilarDecomposition(int n) {
        this.gammas = new double[n];
        this.b = new double[n];
        this.u = new double[n];
    }

    public HessenbergSimilarDecomposition() {
        this(5);
    }

    @Override
    public boolean decompose(DenseMatrix64F denseMatrix64F) {
        if (denseMatrix64F.numRows != denseMatrix64F.numCols) {
            throw new IllegalArgumentException("A must be square.");
        }
        this.QH = denseMatrix64F;
        this.N = denseMatrix64F.numCols;
        if (this.b.length < this.N) {
            this.b = new double[this.N];
            this.gammas = new double[this.N];
            this.u = new double[this.N];
        }
        return this._decompose();
    }

    @Override
    public boolean inputModified() {
        return true;
    }

    public DenseMatrix64F getQH() {
        return this.QH;
    }

    public DenseMatrix64F getH(DenseMatrix64F denseMatrix64F) {
        if (denseMatrix64F == null) {
            denseMatrix64F = new DenseMatrix64F(this.N, this.N);
        } else {
            if (this.N != denseMatrix64F.numRows || this.N != denseMatrix64F.numCols) {
                throw new IllegalArgumentException("The provided H must have the same dimensions as the decomposed matrix.");
            }
            denseMatrix64F.zero();
        }
        System.arraycopy(this.QH.data, 0, denseMatrix64F.data, 0, this.N);
        for (int i = 1; i < this.N; ++i) {
            for (int j = i - 1; j < this.N; ++j) {
                denseMatrix64F.set(i, j, this.QH.get(i, j));
            }
        }
        return denseMatrix64F;
    }

    public DenseMatrix64F getQ(DenseMatrix64F denseMatrix64F) {
        int n;
        if (denseMatrix64F == null) {
            denseMatrix64F = new DenseMatrix64F(this.N, this.N);
            for (n = 0; n < this.N; ++n) {
                denseMatrix64F.data[n * this.N + n] = 1.0;
            }
        } else {
            if (this.N != denseMatrix64F.numRows || this.N != denseMatrix64F.numCols) {
                throw new IllegalArgumentException("The provided H must have the same dimensions as the decomposed matrix.");
            }
            CommonOps.setIdentity(denseMatrix64F);
        }
        for (n = this.N - 2; n >= 0; --n) {
            this.u[n + 1] = 1.0;
            for (int i = n + 2; i < this.N; ++i) {
                this.u[i] = this.QH.get(i, n);
            }
            QrHelperFunctions.rank1UpdateMultR(denseMatrix64F, this.u, this.gammas[n], n + 1, n + 1, this.N, this.b);
        }
        return denseMatrix64F;
    }

    private boolean _decompose() {
        double[] dArray = this.QH.data;
        for (int i = 0; i < this.N - 2; ++i) {
            double d = 0.0;
            for (int j = i + 1; j < this.N; ++j) {
                double d2 = this.u[j] = dArray[j * this.N + i];
                if (!((d2 = Math.abs(d2)) > d)) continue;
                d = d2;
            }
            if (d > 0.0) {
                double d3;
                double d4 = 0.0;
                int n = i + 1;
                while (n < this.N) {
                    int n2 = n++;
                    double d5 = this.u[n2] / d;
                    this.u[n2] = d5;
                    double d6 = d5;
                    d4 += d6 * d6;
                }
                d4 = Math.sqrt(d4);
                if (this.u[i + 1] < 0.0) {
                    d4 = -d4;
                }
                double d7 = this.u[i + 1] + d4;
                this.u[i + 1] = 1.0;
                for (int j = i + 2; j < this.N; ++j) {
                    int n3 = j;
                    double d8 = this.u[n3] / d7;
                    this.u[n3] = d8;
                    dArray[j * this.N + i] = d8;
                }
                this.gammas[i] = d3 = d7 / d4;
                QrHelperFunctions.rank1UpdateMultR(this.QH, this.u, d3, i + 1, i + 1, this.N, this.b);
                QrHelperFunctions.rank1UpdateMultL(this.QH, this.u, d3, 0, i + 1, this.N);
                dArray[(i + 1) * this.N + i] = -d4 * d;
                continue;
            }
            this.gammas[i] = 0.0;
        }
        return true;
    }

    public double[] getGammas() {
        return this.gammas;
    }
}

