/*
 * Decompiled with CFR 0.152.
 */
package mitiv.linalg;

import mitiv.exception.IncorrectSpaceException;
import mitiv.linalg.LinearOperator;
import mitiv.linalg.Vector;
import mitiv.linalg.VectorSpace;

public class LinearConjugateGradient {
    public static final int IN_PROGRESS = 0;
    public static final int CONVERGED = 1;
    public static final int TOO_MANY_ITERATIONS = 2;
    public static final int A_IS_NOT_POSITIVE_DEFINITE = 3;
    public static final int P_IS_NOT_POSITIVE_DEFINITE = 4;
    public static final int BAD_ATOL = 5;
    public static final int BAD_RTOL = 6;
    public static final int BUG = 7;
    public static final double DEFAULT_ATOL = 0.0;
    public static final double DEFAULT_RTOL = 1.0E-5;
    private double atol = 0.0;
    private double rtol = 1.0E-5;
    private LinearOperator A;
    private LinearOperator P;
    private Vector b;
    private Vector p;
    private Vector q;
    private Vector r;
    private Vector z;

    public LinearConjugateGradient(LinearOperator linearOperator, Vector vector) {
        this(linearOperator, vector, null);
    }

    public LinearConjugateGradient(LinearOperator linearOperator, Vector vector, LinearOperator linearOperator2) {
        if (!vector.belongsTo(linearOperator.getOutputSpace())) {
            throw new IncorrectSpaceException();
        }
        if (linearOperator.getInputSpace() != linearOperator.getOutputSpace()) {
            throw new IllegalArgumentException("LHS matrix must be an endomorphism.");
        }
        if (linearOperator2 != null && (linearOperator2.getInputSpace() != linearOperator.getOutputSpace() || linearOperator2.getOutputSpace() != linearOperator.getInputSpace())) {
            throw new IncorrectSpaceException();
        }
        this.A = linearOperator;
        this.b = vector;
        this.P = linearOperator2;
    }

    public double getAtol() {
        return this.atol;
    }

    public void setAtol(double d) {
        this.atol = Math.max(0.0, d);
    }

    public double getRtol() {
        return this.rtol;
    }

    public void setRtol(double d) {
        this.rtol = Math.max(0.0, d);
    }

    public int solve(Vector vector, int n, boolean bl) {
        if (!vector.belongsTo(this.A.getInputSpace())) {
            throw new IncorrectSpaceException();
        }
        VectorSpace vectorSpace = this.b.getSpace();
        if (this.p == null) {
            this.p = vectorSpace.create();
        }
        if (this.q == null) {
            this.q = vectorSpace.create();
        }
        if (this.r == null) {
            this.r = vectorSpace.create();
        }
        if (this.z == null) {
            Vector vector2 = this.z = this.P == null ? this.r : vectorSpace.create();
        }
        if (bl) {
            vector.zero();
            this.r.copy(this.b);
        } else {
            this.A.apply(this.r, vector);
            this.r.combine(1.0, this.b, -1.0, this.r);
        }
        if (this.P != null) {
            this.P.apply(this.z, this.r);
        }
        double d = this.z.dot(this.r);
        double d2 = 0.0;
        double d3 = Math.max(0.0, Math.max(this.atol, this.rtol * d));
        int n2 = 0;
        while (true) {
            double d4;
            if (d <= d3) {
                if (d < 0.0) {
                    if (this.P != null) {
                        return 4;
                    }
                    return 7;
                }
                return 1;
            }
            if (n >= 0 && n2 >= n) {
                return 2;
            }
            if (n2 == 0) {
                this.p.copy(this.p);
            } else {
                d4 = d / d2;
                this.p.combine(1.0, this.z, d4, this.p);
            }
            this.A.apply(this.q, this.p);
            d4 = this.p.dot(this.q);
            if (d4 <= 0.0) {
                return 3;
            }
            double d5 = d / d4;
            vector.add(d5, this.p);
            this.r.add(-d5, this.q);
            if (this.P != null) {
                this.P.apply(this.z, this.r);
            }
            d2 = d;
            d = this.z.dot(this.r);
            ++n2;
        }
    }

    public static int solve(LinearOperator linearOperator, Vector vector, Vector vector2, double d, double d2, int n, boolean bl) {
        return LinearConjugateGradient.solve(linearOperator, vector, vector2, null, d, d2, n, bl);
    }

    public static int solve(LinearOperator linearOperator, Vector vector, Vector vector2, LinearOperator linearOperator2, double d, double d2, int n, boolean bl) {
        if (d < 0.0) {
            return 5;
        }
        if (d2 < 0.0) {
            return 6;
        }
        LinearConjugateGradient linearConjugateGradient = new LinearConjugateGradient(linearOperator, vector, linearOperator2);
        return linearConjugateGradient.solve(vector2, n, bl);
    }
}

