/*
 * Decompiled with CFR 0.152.
 */
package com.ochafik.util;

import com.ochafik.util.Adapter;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;

public class CollectionAdapter<U, V>
extends AbstractCollection<V> {
    protected Collection<U> collection;
    protected Adapter<U, V> adapter;

    public CollectionAdapter(Collection<U> collection, Adapter<U, V> adapter) {
        this.collection = collection;
        this.adapter = adapter;
    }

    @Override
    public Iterator<V> iterator() {
        return new IteratorAdapter(this.collection.iterator());
    }

    @Override
    public int size() {
        return this.collection.size();
    }

    @Override
    public boolean isEmpty() {
        return this.collection.isEmpty();
    }

    @Override
    public void clear() {
        this.collection.clear();
    }

    @Override
    public boolean add(V o) {
        return this.collection.add(this.adapter.reAdapt(o));
    }

    @Override
    public boolean contains(Object o) {
        for (U element : this.collection) {
            if (!this.adapter.adapt(element).equals(o)) continue;
            return true;
        }
        return false;
    }

    protected class IteratorAdapter
    implements Iterator<V> {
        Iterator<U> iterator;

        public IteratorAdapter(Iterator<U> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public V next() {
            return CollectionAdapter.this.adapter.adapt(this.iterator.next());
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }
}

