/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array.impl;

import mitiv.array.Double1D;
import mitiv.array.Double5D;
import mitiv.array.Double6D;
import mitiv.array.impl.FlatDouble1D;
import mitiv.array.impl.FlatDouble5D;
import mitiv.array.impl.Helper;
import mitiv.array.impl.SelectedDouble6D;
import mitiv.array.impl.StriddenDouble5D;
import mitiv.array.impl.StriddenDouble6D;
import mitiv.base.Shape;
import mitiv.base.indexing.CompiledRange;
import mitiv.base.indexing.Range;
import mitiv.base.mapping.DoubleFunction;
import mitiv.base.mapping.DoubleScanner;
import mitiv.exception.NonConformableArrayException;
import mitiv.random.DoubleGenerator;

public class FlatDouble6D
extends Double6D {
    static final int order = 1;
    final double[] data;
    final int dim1dim2;
    final int dim1dim2dim3;
    final int dim1dim2dim3dim4;
    final int dim1dim2dim3dim4dim5;

    public FlatDouble6D(int n, int n2, int n3, int n4, int n5, int n6) {
        super(n, n2, n3, n4, n5, n6);
        this.data = new double[this.number];
        this.dim1dim2 = n * n2;
        this.dim1dim2dim3 = this.dim1dim2 * n3;
        this.dim1dim2dim3dim4 = this.dim1dim2dim3 * n4;
        this.dim1dim2dim3dim4dim5 = this.dim1dim2dim3dim4 * n5;
    }

    public FlatDouble6D(int[] nArray) {
        super(nArray);
        this.data = new double[this.number];
        this.dim1dim2 = this.dim1 * this.dim2;
        this.dim1dim2dim3 = this.dim1dim2 * this.dim3;
        this.dim1dim2dim3dim4 = this.dim1dim2dim3 * this.dim4;
        this.dim1dim2dim3dim4dim5 = this.dim1dim2dim3dim4 * this.dim5;
    }

    public FlatDouble6D(Shape shape) {
        super(shape);
        this.data = new double[this.number];
        this.dim1dim2 = this.dim1 * this.dim2;
        this.dim1dim2dim3 = this.dim1dim2 * this.dim3;
        this.dim1dim2dim3dim4 = this.dim1dim2dim3 * this.dim4;
        this.dim1dim2dim3dim4dim5 = this.dim1dim2dim3dim4 * this.dim5;
    }

    public FlatDouble6D(double[] dArray, int n, int n2, int n3, int n4, int n5, int n6) {
        super(n, n2, n3, n4, n5, n6);
        this.checkSize(dArray);
        this.data = dArray;
        this.dim1dim2 = n * n2;
        this.dim1dim2dim3 = this.dim1dim2 * n3;
        this.dim1dim2dim3dim4 = this.dim1dim2dim3 * n4;
        this.dim1dim2dim3dim4dim5 = this.dim1dim2dim3dim4 * n5;
    }

    public FlatDouble6D(double[] dArray, int[] nArray) {
        super(nArray);
        this.checkSize(dArray);
        this.data = dArray;
        this.dim1dim2 = this.dim1 * this.dim2;
        this.dim1dim2dim3 = this.dim1dim2 * this.dim3;
        this.dim1dim2dim3dim4 = this.dim1dim2dim3 * this.dim4;
        this.dim1dim2dim3dim4dim5 = this.dim1dim2dim3dim4 * this.dim5;
    }

    public FlatDouble6D(double[] dArray, Shape shape) {
        super(shape);
        this.checkSize(dArray);
        this.data = dArray;
        this.dim1dim2 = this.dim1 * this.dim2;
        this.dim1dim2dim3 = this.dim1dim2 * this.dim3;
        this.dim1dim2dim3dim4 = this.dim1dim2dim3 * this.dim4;
        this.dim1dim2dim3dim4dim5 = this.dim1dim2dim3dim4 * this.dim5;
    }

    @Override
    public void checkSanity() {
        if (this.data == null) {
            throw new NonConformableArrayException("Wrapped array is null");
        }
        if (this.data.length < this.number) {
            throw new NonConformableArrayException("Wrapped array is too small");
        }
    }

    private void checkSize(double[] dArray) {
        if (dArray == null || dArray.length < this.number) {
            throw new NonConformableArrayException("Wrapped array is too small");
        }
    }

    final int index(int n, int n2, int n3, int n4, int n5, int n6) {
        return this.dim1dim2dim3dim4dim5 * n6 + this.dim1dim2dim3dim4 * n5 + this.dim1dim2dim3 * n4 + this.dim1dim2 * n3 + this.dim1 * n2 + n;
    }

    @Override
    public final double get(int n, int n2, int n3, int n4, int n5, int n6) {
        return this.data[this.dim1dim2dim3dim4dim5 * n6 + this.dim1dim2dim3dim4 * n5 + this.dim1dim2dim3 * n4 + this.dim1dim2 * n3 + this.dim1 * n2 + n];
    }

    @Override
    public final void set(int n, int n2, int n3, int n4, int n5, int n6, double d) {
        this.data[this.dim1dim2dim3dim4dim5 * n6 + this.dim1dim2dim3dim4 * n5 + this.dim1dim2dim3 * n4 + this.dim1dim2 * n3 + this.dim1 * n2 + n] = d;
    }

    @Override
    public final int getOrder() {
        return 1;
    }

    @Override
    public void fill(double d) {
        for (int i = 0; i < this.number; ++i) {
            this.data[i] = d;
        }
    }

    @Override
    public void fill(DoubleGenerator doubleGenerator) {
        for (int i = 0; i < this.number; ++i) {
            this.data[i] = doubleGenerator.nextDouble();
        }
    }

    @Override
    public void increment(double d) {
        int n = 0;
        while (n < this.number) {
            int n2 = n++;
            this.data[n2] = this.data[n2] + d;
        }
    }

    @Override
    public void decrement(double d) {
        int n = 0;
        while (n < this.number) {
            int n2 = n++;
            this.data[n2] = this.data[n2] - d;
        }
    }

    @Override
    public void scale(double d) {
        int n = 0;
        while (n < this.number) {
            int n2 = n++;
            this.data[n2] = this.data[n2] * d;
        }
    }

    @Override
    public void map(DoubleFunction doubleFunction) {
        for (int i = 0; i < this.number; ++i) {
            this.data[i] = doubleFunction.apply(this.data[i]);
        }
    }

    @Override
    public void scan(DoubleScanner doubleScanner) {
        doubleScanner.initialize(this.data[0]);
        for (int i = 1; i < this.number; ++i) {
            doubleScanner.update(this.data[i]);
        }
    }

    @Override
    public final boolean isFlat() {
        return true;
    }

    @Override
    public double[] flatten(boolean bl) {
        if (bl) {
            double[] dArray = new double[this.number];
            System.arraycopy(this.data, 0, dArray, 0, this.number);
            return dArray;
        }
        return this.data;
    }

    @Override
    public double[] getData() {
        return this.data;
    }

    @Override
    public Double5D slice(int n) {
        if ((n = Helper.fixIndex(n, this.dim6)) == 0) {
            return new FlatDouble5D(this.data, this.dim1, this.dim2, this.dim3, this.dim4, this.dim5);
        }
        return new StriddenDouble5D(this.data, this.dim1dim2dim3dim4dim5 * n, 1, this.dim1, this.dim1dim2, this.dim1dim2dim3, this.dim1dim2dim3dim4, this.dim1, this.dim2, this.dim3, this.dim4, this.dim5);
    }

    @Override
    public Double5D slice(int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        int n13;
        if ((n2 = Helper.fixSliceIndex(n2, 6)) == 0) {
            n13 = Helper.fixIndex(n, this.dim1);
            n12 = this.dim1;
            n11 = this.dim1dim2;
            n10 = this.dim1dim2dim3;
            n9 = this.dim1dim2dim3dim4;
            n8 = this.dim1dim2dim3dim4dim5;
            n7 = this.dim2;
            n6 = this.dim3;
            n5 = this.dim4;
            n4 = this.dim5;
            n3 = this.dim6;
        } else if (n2 == 1) {
            n13 = this.dim1 * Helper.fixIndex(n, this.dim2);
            n12 = 1;
            n11 = this.dim1dim2;
            n10 = this.dim1dim2dim3;
            n9 = this.dim1dim2dim3dim4;
            n8 = this.dim1dim2dim3dim4dim5;
            n7 = this.dim1;
            n6 = this.dim3;
            n5 = this.dim4;
            n4 = this.dim5;
            n3 = this.dim6;
        } else if (n2 == 2) {
            n13 = this.dim1dim2 * Helper.fixIndex(n, this.dim3);
            n12 = 1;
            n11 = this.dim1;
            n10 = this.dim1dim2dim3;
            n9 = this.dim1dim2dim3dim4;
            n8 = this.dim1dim2dim3dim4dim5;
            n7 = this.dim1;
            n6 = this.dim2;
            n5 = this.dim4;
            n4 = this.dim5;
            n3 = this.dim6;
        } else if (n2 == 3) {
            n13 = this.dim1dim2dim3 * Helper.fixIndex(n, this.dim4);
            n12 = 1;
            n11 = this.dim1;
            n10 = this.dim1dim2;
            n9 = this.dim1dim2dim3dim4;
            n8 = this.dim1dim2dim3dim4dim5;
            n7 = this.dim1;
            n6 = this.dim2;
            n5 = this.dim3;
            n4 = this.dim5;
            n3 = this.dim6;
        } else if (n2 == 4) {
            n13 = this.dim1dim2dim3dim4 * Helper.fixIndex(n, this.dim5);
            n12 = 1;
            n11 = this.dim1;
            n10 = this.dim1dim2;
            n9 = this.dim1dim2dim3;
            n8 = this.dim1dim2dim3dim4dim5;
            n7 = this.dim1;
            n6 = this.dim2;
            n5 = this.dim3;
            n4 = this.dim4;
            n3 = this.dim6;
        } else {
            n13 = this.dim1dim2dim3dim4dim5 * Helper.fixIndex(n, this.dim6);
            n12 = 1;
            n11 = this.dim1;
            n10 = this.dim1dim2;
            n9 = this.dim1dim2dim3;
            n8 = this.dim1dim2dim3dim4;
            n7 = this.dim1;
            n6 = this.dim2;
            n5 = this.dim3;
            n4 = this.dim4;
            n3 = this.dim5;
        }
        return new StriddenDouble5D(this.data, n13, n12, n11, n10, n9, n8, n7, n6, n5, n4, n3);
    }

    @Override
    public Double6D view(Range range, Range range2, Range range3, Range range4, Range range5, Range range6) {
        CompiledRange compiledRange = new CompiledRange(range, this.dim1, 0, 1);
        CompiledRange compiledRange2 = new CompiledRange(range2, this.dim2, 0, this.dim1);
        CompiledRange compiledRange3 = new CompiledRange(range3, this.dim3, 0, this.dim1dim2);
        CompiledRange compiledRange4 = new CompiledRange(range4, this.dim4, 0, this.dim1dim2dim3);
        CompiledRange compiledRange5 = new CompiledRange(range5, this.dim5, 0, this.dim1dim2dim3dim4);
        CompiledRange compiledRange6 = new CompiledRange(range6, this.dim6, 0, this.dim1dim2dim3dim4dim5);
        if (compiledRange.doesNothing() && compiledRange2.doesNothing() && compiledRange3.doesNothing() && compiledRange4.doesNothing() && compiledRange5.doesNothing() && compiledRange6.doesNothing()) {
            return this;
        }
        return new StriddenDouble6D(this.data, compiledRange.getOffset() + compiledRange2.getOffset() + compiledRange3.getOffset() + compiledRange4.getOffset() + compiledRange5.getOffset() + compiledRange6.getOffset(), compiledRange.getStride(), compiledRange2.getStride(), compiledRange3.getStride(), compiledRange4.getStride(), compiledRange5.getStride(), compiledRange6.getStride(), compiledRange.getNumber(), compiledRange2.getNumber(), compiledRange3.getNumber(), compiledRange4.getNumber(), compiledRange5.getNumber(), compiledRange6.getNumber());
    }

    @Override
    public Double6D view(int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, int[] nArray5, int[] nArray6) {
        int[] nArray7 = Helper.select(0, 1, this.dim1, nArray);
        int[] nArray8 = Helper.select(0, this.dim1, this.dim2, nArray2);
        int[] nArray9 = Helper.select(0, this.dim1dim2, this.dim3, nArray3);
        int[] nArray10 = Helper.select(0, this.dim1dim2dim3, this.dim4, nArray4);
        int[] nArray11 = Helper.select(0, this.dim1dim2dim3dim4, this.dim5, nArray5);
        int[] nArray12 = Helper.select(0, this.dim1dim2dim3dim4dim5, this.dim6, nArray6);
        return new SelectedDouble6D(this.data, nArray7, nArray8, nArray9, nArray10, nArray11, nArray12);
    }

    @Override
    public Double1D as1D() {
        return new FlatDouble1D(this.data, this.number);
    }
}

