/*******************************************************************************
 * Copyright (c) 2012-2013 Biomedical Image Group (BIG), EPFL, Switzerland.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Public License v3.0
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/gpl.html
 * 
 * Contributors:
 *     Ricard Delgado-Gonzalo (ricard.delgado@gmail.com)
 *     Nicolas Chenouard (nicolas.chenouard@gmail.com)
 *     Philippe Th&#233;venaz (philippe.thevenaz@epfl.ch)
 *     Emrah Bostan (emrah.bostan@gmail.com)
 *     Ulugbek S. Kamilov (kamilov@gmail.com)
 *     Ramtin Madani (ramtin_madani@yahoo.com)
 *     Masih Nilchian (masih_n85@yahoo.com)
 *     C&#233;dric Vonesch (cedric.vonesch@epfl.ch)
 *     Virginie Uhlmann (virginie.uhlmann@epfl.ch)
 *     Cl&#233;ment Marti (clement.marti@epfl.ch)
 *     Julien Jacquemot (julien.jacquemot@epfl.ch)
 ******************************************************************************/
package plugins.big.bigsnakeutils.process.process3D;

/**
 * Class that encapsulates the accessing to some image values.
 * 
 * @version May 3, 2014
 * 
 * @author Ricard Delgado-Gonzalo (ricard.delgado@gmail.com)
 */
public class ImageArrayUtils {

	// ============================================================================
	// PUBLIC METHODS

	/**
	 * Puts in a one dimensional array the information of one column along the
	 * 1st dimension of an image stack.
	 */
	public static void getX(double[][] data, int width, int height, int depth,
			int x, int y, int z, double[] buffer) {
		int offset = x + y * width;
		double[] tmp = data[z];
		for (int i = 0; i < buffer.length; i++) {
			buffer[i] = tmp[offset];
			offset++;
		}
	}

	// ----------------------------------------------------------------------------

	/**
	 * Puts in a one dimensional array the information of one column along the
	 * 2nd dimension of an image stack.
	 */
	public static void getY(double[][] data, int width, int height, int depth,
			int x, int y, int z, double[] buffer) {
		int offset = x + y * width;
		double[] tmp = data[z];
		for (int i = 0; i < buffer.length; i++) {
			buffer[i] = tmp[offset];
			offset += width;
		}
	}

	// ----------------------------------------------------------------------------

	/**
	 * Puts in a one dimensional array the information of one column along the
	 * 3rd dimension of an image stack.
	 */
	public static void getZ(double[][] data, int width, int height, int depth,
			int x, int y, int z, double[] buffer) {
		int offset = x + y * width;
		for (int i = 0; i < buffer.length; i++) {
			buffer[i] = data[z][offset];
			z++;
		}
	}

	// ----------------------------------------------------------------------------

	/** Puts in an image stack the information a buffer along the 1st dimension. */
	public static void putX(double[][] data, int width, int height, int depth,
			int x, int y, int z, double[] buffer) {
		System.arraycopy(buffer, 0, data[z], x + y * width, buffer.length);
	}

	// ----------------------------------------------------------------------------

	/** Puts in an image stack the information a buffer along the 2nd dimension. */
	public static void putY(double[][] data, int width, int height, int depth,
			int x, int y, int z, double[] buffer) {
		int offset = x + y * width;
		double[] tmp = data[z];
		for (double element : buffer) {
			tmp[offset] = element;
			offset += width;
		}
	}

	// ----------------------------------------------------------------------------

	/** Puts in an image stack the information a buffer along the 3rd dimension. */
	public static void putZ(double[][] data, int width, int height, int depth,
			int x, int y, int z, double[] buffer) {
		int offset = x + y * width;
		for (double element : buffer) {
			data[z][offset] = element;
			z++;
		}
	}
}
