/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array.impl;

import mitiv.array.Float1D;
import mitiv.array.Float6D;
import mitiv.array.Float7D;
import mitiv.array.impl.FlatFloat1D;
import mitiv.array.impl.Helper;
import mitiv.array.impl.SelectedFloat7D;
import mitiv.array.impl.StriddenFloat6D;
import mitiv.base.indexing.CompiledRange;
import mitiv.base.indexing.Range;
import mitiv.base.mapping.FloatFunction;
import mitiv.base.mapping.FloatScanner;
import mitiv.random.FloatGenerator;

public class StriddenFloat7D
extends Float7D {
    final int order;
    final float[] data;
    final int offset;
    final int stride1;
    final int stride2;
    final int stride3;
    final int stride4;
    final int stride5;
    final int stride6;
    final int stride7;
    final boolean flat;

    public StriddenFloat7D(float[] fArray, int n, int[] nArray, int[] nArray2) {
        super(nArray2);
        if (nArray.length != 7) {
            throw new IllegalArgumentException("There must be as many strides as the rank");
        }
        this.data = fArray;
        this.offset = n;
        this.stride1 = nArray[0];
        this.stride2 = nArray[1];
        this.stride3 = nArray[2];
        this.stride4 = nArray[3];
        this.stride5 = nArray[4];
        this.stride6 = nArray[5];
        this.stride7 = nArray[6];
        this.order = Float7D.checkViewStrides(this.data.length, n, this.stride1, this.stride2, this.stride3, this.stride4, this.stride5, this.stride6, this.stride7, this.dim1, this.dim2, this.dim3, this.dim4, this.dim5, this.dim6, this.dim7);
        this.flat = n == 0 && this.stride1 == 1 && this.stride2 == this.dim1 && this.stride3 == this.dim2 * this.stride2 && this.stride4 == this.dim3 * this.stride3 && this.stride5 == this.dim4 * this.stride4 && this.stride6 == this.dim5 * this.stride5 && this.stride7 == this.dim6 * this.stride6;
    }

    public StriddenFloat7D(float[] fArray, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13, int n14, int n15) {
        super(n9, n10, n11, n12, n13, n14, n15);
        this.data = fArray;
        this.offset = n;
        this.stride1 = n2;
        this.stride2 = n3;
        this.stride3 = n4;
        this.stride4 = n5;
        this.stride5 = n6;
        this.stride6 = n7;
        this.stride7 = n8;
        this.order = Float7D.checkViewStrides(this.data.length, n, n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, n12, n13, n14, n15);
        this.flat = n == 0 && n2 == 1 && n3 == n9 && n4 == n10 * n3 && n5 == n11 * n4 && n6 == n12 * n5 && n7 == n13 * n6 && n8 == n14 * n7;
    }

    @Override
    public void checkSanity() {
        Float7D.checkViewStrides(this.data.length, this.offset, this.stride1, this.stride2, this.stride3, this.stride4, this.stride5, this.stride6, this.stride7, this.dim1, this.dim2, this.dim3, this.dim4, this.dim5, this.dim6, this.dim7);
    }

    final int index(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        return this.offset + this.stride7 * n7 + this.stride6 * n6 + this.stride5 * n5 + this.stride4 * n4 + this.stride3 * n3 + this.stride2 * n2 + this.stride1 * n;
    }

    @Override
    public final float get(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        return this.data[this.offset + this.stride7 * n7 + this.stride6 * n6 + this.stride5 * n5 + this.stride4 * n4 + this.stride3 * n3 + this.stride2 * n2 + this.stride1 * n];
    }

    @Override
    public final void set(int n, int n2, int n3, int n4, int n5, int n6, int n7, float f) {
        this.data[this.offset + this.stride7 * n7 + this.stride6 * n6 + this.stride5 * n5 + this.stride4 * n4 + this.stride3 * n3 + this.stride2 * n2 + this.stride1 * n] = f;
    }

    @Override
    public final int getOrder() {
        return this.order;
    }

    @Override
    public void fill(float f) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                int n = this.stride1 * i + this.offset;
                for (int j = 0; j < this.dim2; ++j) {
                    int n2 = this.stride2 * j + n;
                    for (int k = 0; k < this.dim3; ++k) {
                        int n3 = this.stride3 * k + n2;
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            int n4 = this.stride4 * i2 + n3;
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                int n5 = this.stride5 * i3 + n4;
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    int n6 = this.stride6 * i4 + n5;
                                    for (int i5 = 0; i5 < this.dim7; ++i5) {
                                        int n7 = this.stride7 * i5 + n6;
                                        this.data[n7] = f;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim7; ++i) {
                int n = this.stride7 * i + this.offset;
                for (int j = 0; j < this.dim6; ++j) {
                    int n8 = this.stride6 * j + n;
                    for (int k = 0; k < this.dim5; ++k) {
                        int n9 = this.stride5 * k + n8;
                        for (int i6 = 0; i6 < this.dim4; ++i6) {
                            int n10 = this.stride4 * i6 + n9;
                            for (int i7 = 0; i7 < this.dim3; ++i7) {
                                int n11 = this.stride3 * i7 + n10;
                                for (int i8 = 0; i8 < this.dim2; ++i8) {
                                    int n12 = this.stride2 * i8 + n11;
                                    for (int i9 = 0; i9 < this.dim1; ++i9) {
                                        int n13 = this.stride1 * i9 + n12;
                                        this.data[n13] = f;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void fill(FloatGenerator floatGenerator) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                int n = this.stride1 * i + this.offset;
                for (int j = 0; j < this.dim2; ++j) {
                    int n2 = this.stride2 * j + n;
                    for (int k = 0; k < this.dim3; ++k) {
                        int n3 = this.stride3 * k + n2;
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            int n4 = this.stride4 * i2 + n3;
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                int n5 = this.stride5 * i3 + n4;
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    int n6 = this.stride6 * i4 + n5;
                                    for (int i5 = 0; i5 < this.dim7; ++i5) {
                                        int n7 = this.stride7 * i5 + n6;
                                        this.data[n7] = floatGenerator.nextFloat();
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim7; ++i) {
                int n = this.stride7 * i + this.offset;
                for (int j = 0; j < this.dim6; ++j) {
                    int n8 = this.stride6 * j + n;
                    for (int k = 0; k < this.dim5; ++k) {
                        int n9 = this.stride5 * k + n8;
                        for (int i6 = 0; i6 < this.dim4; ++i6) {
                            int n10 = this.stride4 * i6 + n9;
                            for (int i7 = 0; i7 < this.dim3; ++i7) {
                                int n11 = this.stride3 * i7 + n10;
                                for (int i8 = 0; i8 < this.dim2; ++i8) {
                                    int n12 = this.stride2 * i8 + n11;
                                    for (int i9 = 0; i9 < this.dim1; ++i9) {
                                        int n13 = this.stride1 * i9 + n12;
                                        this.data[n13] = floatGenerator.nextFloat();
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void increment(float f) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                int n = this.stride1 * i + this.offset;
                for (int j = 0; j < this.dim2; ++j) {
                    int n2 = this.stride2 * j + n;
                    for (int k = 0; k < this.dim3; ++k) {
                        int n3 = this.stride3 * k + n2;
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            int n4 = this.stride4 * i2 + n3;
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                int n5 = this.stride5 * i3 + n4;
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    int n6 = this.stride6 * i4 + n5;
                                    for (int i5 = 0; i5 < this.dim7; ++i5) {
                                        int n7;
                                        int n8 = n7 = this.stride7 * i5 + n6;
                                        this.data[n8] = this.data[n8] + f;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim7; ++i) {
                int n = this.stride7 * i + this.offset;
                for (int j = 0; j < this.dim6; ++j) {
                    int n9 = this.stride6 * j + n;
                    for (int k = 0; k < this.dim5; ++k) {
                        int n10 = this.stride5 * k + n9;
                        for (int i6 = 0; i6 < this.dim4; ++i6) {
                            int n11 = this.stride4 * i6 + n10;
                            for (int i7 = 0; i7 < this.dim3; ++i7) {
                                int n12 = this.stride3 * i7 + n11;
                                for (int i8 = 0; i8 < this.dim2; ++i8) {
                                    int n13 = this.stride2 * i8 + n12;
                                    for (int i9 = 0; i9 < this.dim1; ++i9) {
                                        int n14;
                                        int n15 = n14 = this.stride1 * i9 + n13;
                                        this.data[n15] = this.data[n15] + f;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void decrement(float f) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                int n = this.stride1 * i + this.offset;
                for (int j = 0; j < this.dim2; ++j) {
                    int n2 = this.stride2 * j + n;
                    for (int k = 0; k < this.dim3; ++k) {
                        int n3 = this.stride3 * k + n2;
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            int n4 = this.stride4 * i2 + n3;
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                int n5 = this.stride5 * i3 + n4;
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    int n6 = this.stride6 * i4 + n5;
                                    for (int i5 = 0; i5 < this.dim7; ++i5) {
                                        int n7;
                                        int n8 = n7 = this.stride7 * i5 + n6;
                                        this.data[n8] = this.data[n8] - f;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim7; ++i) {
                int n = this.stride7 * i + this.offset;
                for (int j = 0; j < this.dim6; ++j) {
                    int n9 = this.stride6 * j + n;
                    for (int k = 0; k < this.dim5; ++k) {
                        int n10 = this.stride5 * k + n9;
                        for (int i6 = 0; i6 < this.dim4; ++i6) {
                            int n11 = this.stride4 * i6 + n10;
                            for (int i7 = 0; i7 < this.dim3; ++i7) {
                                int n12 = this.stride3 * i7 + n11;
                                for (int i8 = 0; i8 < this.dim2; ++i8) {
                                    int n13 = this.stride2 * i8 + n12;
                                    for (int i9 = 0; i9 < this.dim1; ++i9) {
                                        int n14;
                                        int n15 = n14 = this.stride1 * i9 + n13;
                                        this.data[n15] = this.data[n15] - f;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void scale(float f) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                int n = this.stride1 * i + this.offset;
                for (int j = 0; j < this.dim2; ++j) {
                    int n2 = this.stride2 * j + n;
                    for (int k = 0; k < this.dim3; ++k) {
                        int n3 = this.stride3 * k + n2;
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            int n4 = this.stride4 * i2 + n3;
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                int n5 = this.stride5 * i3 + n4;
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    int n6 = this.stride6 * i4 + n5;
                                    for (int i5 = 0; i5 < this.dim7; ++i5) {
                                        int n7;
                                        int n8 = n7 = this.stride7 * i5 + n6;
                                        this.data[n8] = this.data[n8] * f;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim7; ++i) {
                int n = this.stride7 * i + this.offset;
                for (int j = 0; j < this.dim6; ++j) {
                    int n9 = this.stride6 * j + n;
                    for (int k = 0; k < this.dim5; ++k) {
                        int n10 = this.stride5 * k + n9;
                        for (int i6 = 0; i6 < this.dim4; ++i6) {
                            int n11 = this.stride4 * i6 + n10;
                            for (int i7 = 0; i7 < this.dim3; ++i7) {
                                int n12 = this.stride3 * i7 + n11;
                                for (int i8 = 0; i8 < this.dim2; ++i8) {
                                    int n13 = this.stride2 * i8 + n12;
                                    for (int i9 = 0; i9 < this.dim1; ++i9) {
                                        int n14;
                                        int n15 = n14 = this.stride1 * i9 + n13;
                                        this.data[n15] = this.data[n15] * f;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void map(FloatFunction floatFunction) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                int n = this.stride1 * i + this.offset;
                for (int j = 0; j < this.dim2; ++j) {
                    int n2 = this.stride2 * j + n;
                    for (int k = 0; k < this.dim3; ++k) {
                        int n3 = this.stride3 * k + n2;
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            int n4 = this.stride4 * i2 + n3;
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                int n5 = this.stride5 * i3 + n4;
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    int n6 = this.stride6 * i4 + n5;
                                    for (int i5 = 0; i5 < this.dim7; ++i5) {
                                        int n7 = this.stride7 * i5 + n6;
                                        this.data[n7] = floatFunction.apply(this.data[n7]);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim7; ++i) {
                int n = this.stride7 * i + this.offset;
                for (int j = 0; j < this.dim6; ++j) {
                    int n8 = this.stride6 * j + n;
                    for (int k = 0; k < this.dim5; ++k) {
                        int n9 = this.stride5 * k + n8;
                        for (int i6 = 0; i6 < this.dim4; ++i6) {
                            int n10 = this.stride4 * i6 + n9;
                            for (int i7 = 0; i7 < this.dim3; ++i7) {
                                int n11 = this.stride3 * i7 + n10;
                                for (int i8 = 0; i8 < this.dim2; ++i8) {
                                    int n12 = this.stride2 * i8 + n11;
                                    for (int i9 = 0; i9 < this.dim1; ++i9) {
                                        int n13 = this.stride1 * i9 + n12;
                                        this.data[n13] = floatFunction.apply(this.data[n13]);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void scan(FloatScanner floatScanner) {
        boolean bl = false;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                int n = this.stride1 * i + this.offset;
                for (int j = 0; j < this.dim2; ++j) {
                    int n2 = this.stride2 * j + n;
                    for (int k = 0; k < this.dim3; ++k) {
                        int n3 = this.stride3 * k + n2;
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            int n4 = this.stride4 * i2 + n3;
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                int n5 = this.stride5 * i3 + n4;
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    int n6 = this.stride6 * i4 + n5;
                                    for (int i5 = 0; i5 < this.dim7; ++i5) {
                                        int n7 = this.stride7 * i5 + n6;
                                        if (bl) {
                                            floatScanner.update(this.data[n7]);
                                            continue;
                                        }
                                        floatScanner.initialize(this.data[n7]);
                                        bl = true;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim7; ++i) {
                int n = this.stride7 * i + this.offset;
                for (int j = 0; j < this.dim6; ++j) {
                    int n8 = this.stride6 * j + n;
                    for (int k = 0; k < this.dim5; ++k) {
                        int n9 = this.stride5 * k + n8;
                        for (int i6 = 0; i6 < this.dim4; ++i6) {
                            int n10 = this.stride4 * i6 + n9;
                            for (int i7 = 0; i7 < this.dim3; ++i7) {
                                int n11 = this.stride3 * i7 + n10;
                                for (int i8 = 0; i8 < this.dim2; ++i8) {
                                    int n12 = this.stride2 * i8 + n11;
                                    for (int i9 = 0; i9 < this.dim1; ++i9) {
                                        int n13 = this.stride1 * i9 + n12;
                                        if (bl) {
                                            floatScanner.update(this.data[n13]);
                                            continue;
                                        }
                                        floatScanner.initialize(this.data[n13]);
                                        bl = true;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public final boolean isFlat() {
        return this.flat;
    }

    @Override
    public float[] flatten(boolean bl) {
        if (!bl && this.flat) {
            return this.data;
        }
        float[] fArray = new float[this.number];
        if (this.flat) {
            System.arraycopy(this.data, 0, fArray, 0, this.number);
        } else {
            int n = -1;
            for (int i = 0; i < this.dim7; ++i) {
                int n2 = this.stride7 * i + this.offset;
                for (int j = 0; j < this.dim6; ++j) {
                    int n3 = this.stride6 * j + n2;
                    for (int k = 0; k < this.dim5; ++k) {
                        int n4 = this.stride5 * k + n3;
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            int n5 = this.stride4 * i2 + n4;
                            for (int i3 = 0; i3 < this.dim3; ++i3) {
                                int n6 = this.stride3 * i3 + n5;
                                for (int i4 = 0; i4 < this.dim2; ++i4) {
                                    int n7 = this.stride2 * i4 + n6;
                                    for (int i5 = 0; i5 < this.dim1; ++i5) {
                                        int n8 = this.stride1 * i5 + n7;
                                        fArray[++n] = this.data[n8];
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return fArray;
    }

    @Override
    public float[] getData() {
        return this.flat ? this.data : null;
    }

    @Override
    public Float6D slice(int n) {
        return new StriddenFloat6D(this.data, this.offset + this.stride7 * n, this.stride1, this.stride2, this.stride3, this.stride4, this.stride5, this.stride6, this.dim1, this.dim2, this.dim3, this.dim4, this.dim5, this.dim6);
    }

    @Override
    public Float6D slice(int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        int n13;
        int n14;
        int n15;
        if (n2 < 0) {
            n2 += 7;
        }
        if (n2 == 0) {
            n15 = this.offset + this.stride1 * n;
            n14 = this.stride2;
            n13 = this.stride3;
            n12 = this.stride4;
            n11 = this.stride5;
            n10 = this.stride6;
            n9 = this.stride7;
            n8 = this.dim2;
            n7 = this.dim3;
            n6 = this.dim4;
            n5 = this.dim5;
            n4 = this.dim6;
            n3 = this.dim7;
        } else if (n2 == 1) {
            n15 = this.offset + this.stride2 * n;
            n14 = this.stride1;
            n13 = this.stride3;
            n12 = this.stride4;
            n11 = this.stride5;
            n10 = this.stride6;
            n9 = this.stride7;
            n8 = this.dim1;
            n7 = this.dim3;
            n6 = this.dim4;
            n5 = this.dim5;
            n4 = this.dim6;
            n3 = this.dim7;
        } else if (n2 == 2) {
            n15 = this.offset + this.stride3 * n;
            n14 = this.stride1;
            n13 = this.stride2;
            n12 = this.stride4;
            n11 = this.stride5;
            n10 = this.stride6;
            n9 = this.stride7;
            n8 = this.dim1;
            n7 = this.dim2;
            n6 = this.dim4;
            n5 = this.dim5;
            n4 = this.dim6;
            n3 = this.dim7;
        } else if (n2 == 3) {
            n15 = this.offset + this.stride4 * n;
            n14 = this.stride1;
            n13 = this.stride2;
            n12 = this.stride3;
            n11 = this.stride5;
            n10 = this.stride6;
            n9 = this.stride7;
            n8 = this.dim1;
            n7 = this.dim2;
            n6 = this.dim3;
            n5 = this.dim5;
            n4 = this.dim6;
            n3 = this.dim7;
        } else if (n2 == 4) {
            n15 = this.offset + this.stride5 * n;
            n14 = this.stride1;
            n13 = this.stride2;
            n12 = this.stride3;
            n11 = this.stride4;
            n10 = this.stride6;
            n9 = this.stride7;
            n8 = this.dim1;
            n7 = this.dim2;
            n6 = this.dim3;
            n5 = this.dim4;
            n4 = this.dim6;
            n3 = this.dim7;
        } else if (n2 == 5) {
            n15 = this.offset + this.stride6 * n;
            n14 = this.stride1;
            n13 = this.stride2;
            n12 = this.stride3;
            n11 = this.stride4;
            n10 = this.stride5;
            n9 = this.stride7;
            n8 = this.dim1;
            n7 = this.dim2;
            n6 = this.dim3;
            n5 = this.dim4;
            n4 = this.dim5;
            n3 = this.dim7;
        } else if (n2 == 6) {
            n15 = this.offset + this.stride7 * n;
            n14 = this.stride1;
            n13 = this.stride2;
            n12 = this.stride3;
            n11 = this.stride4;
            n10 = this.stride5;
            n9 = this.stride6;
            n8 = this.dim1;
            n7 = this.dim2;
            n6 = this.dim3;
            n5 = this.dim4;
            n4 = this.dim5;
            n3 = this.dim6;
        } else {
            throw new IndexOutOfBoundsException("Dimension index out of bounds");
        }
        return new StriddenFloat6D(this.data, n15, n14, n13, n12, n11, n10, n9, n8, n7, n6, n5, n4, n3);
    }

    @Override
    public Float7D view(Range range, Range range2, Range range3, Range range4, Range range5, Range range6, Range range7) {
        CompiledRange compiledRange = new CompiledRange(range, this.dim1, this.offset, this.stride1);
        CompiledRange compiledRange2 = new CompiledRange(range2, this.dim2, 0, this.stride2);
        CompiledRange compiledRange3 = new CompiledRange(range3, this.dim3, 0, this.stride3);
        CompiledRange compiledRange4 = new CompiledRange(range4, this.dim4, 0, this.stride4);
        CompiledRange compiledRange5 = new CompiledRange(range5, this.dim5, 0, this.stride5);
        CompiledRange compiledRange6 = new CompiledRange(range6, this.dim6, 0, this.stride6);
        CompiledRange compiledRange7 = new CompiledRange(range7, this.dim7, 0, this.stride7);
        if (compiledRange.doesNothing() && compiledRange2.doesNothing() && compiledRange3.doesNothing() && compiledRange4.doesNothing() && compiledRange5.doesNothing() && compiledRange6.doesNothing() && compiledRange7.doesNothing()) {
            return this;
        }
        return new StriddenFloat7D(this.data, compiledRange.getOffset() + compiledRange2.getOffset() + compiledRange3.getOffset() + compiledRange4.getOffset() + compiledRange5.getOffset() + compiledRange6.getOffset() + compiledRange7.getOffset(), compiledRange.getStride(), compiledRange2.getStride(), compiledRange3.getStride(), compiledRange4.getStride(), compiledRange5.getStride(), compiledRange6.getStride(), compiledRange7.getStride(), compiledRange.getNumber(), compiledRange2.getNumber(), compiledRange3.getNumber(), compiledRange4.getNumber(), compiledRange5.getNumber(), compiledRange6.getNumber(), compiledRange7.getNumber());
    }

    @Override
    public Float7D view(int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, int[] nArray5, int[] nArray6, int[] nArray7) {
        int[] nArray8 = Helper.select(this.offset, this.stride1, this.dim1, nArray);
        int[] nArray9 = Helper.select(0, this.stride2, this.dim2, nArray2);
        int[] nArray10 = Helper.select(0, this.stride3, this.dim3, nArray3);
        int[] nArray11 = Helper.select(0, this.stride4, this.dim4, nArray4);
        int[] nArray12 = Helper.select(0, this.stride5, this.dim5, nArray5);
        int[] nArray13 = Helper.select(0, this.stride6, this.dim6, nArray6);
        int[] nArray14 = Helper.select(0, this.stride7, this.dim7, nArray7);
        return new SelectedFloat7D(this.data, nArray8, nArray9, nArray10, nArray11, nArray12, nArray13, nArray14);
    }

    @Override
    public Float1D as1D() {
        return new FlatFloat1D(this.flatten(), this.number);
    }
}

