/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array;

import mitiv.array.Array1D;
import mitiv.array.Byte1D;
import mitiv.array.Double1D;
import mitiv.array.Float1D;
import mitiv.array.IntArray;
import mitiv.array.IntScalar;
import mitiv.array.Long1D;
import mitiv.array.ShapedArray;
import mitiv.array.Short1D;
import mitiv.array.impl.FlatInt1D;
import mitiv.array.impl.StriddenInt1D;
import mitiv.base.Shape;
import mitiv.base.indexing.Range;
import mitiv.base.mapping.IntFunction;
import mitiv.base.mapping.IntScanner;
import mitiv.exception.IllegalTypeException;
import mitiv.exception.NonConformableArrayException;
import mitiv.linalg.shaped.DoubleShapedVector;
import mitiv.linalg.shaped.FloatShapedVector;
import mitiv.linalg.shaped.ShapedVector;
import mitiv.random.IntGenerator;

public abstract class Int1D
extends Array1D
implements IntArray {
    protected Int1D(int n) {
        super(n);
    }

    protected Int1D(int[] nArray) {
        super(nArray);
    }

    protected Int1D(Shape shape) {
        super(shape);
    }

    @Override
    public final int getType() {
        return 2;
    }

    public abstract int get(int var1);

    public abstract void set(int var1, int var2);

    @Override
    public void fill(int n) {
        for (int i = 0; i < this.dim1; ++i) {
            this.set(i, n);
        }
    }

    @Override
    public void increment(int n) {
        for (int i = 0; i < this.dim1; ++i) {
            this.set(i, this.get(i) + n);
        }
    }

    @Override
    public void decrement(int n) {
        for (int i = 0; i < this.dim1; ++i) {
            this.set(i, this.get(i) - n);
        }
    }

    @Override
    public void scale(int n) {
        for (int i = 0; i < this.dim1; ++i) {
            this.set(i, this.get(i) * n);
        }
    }

    @Override
    public void map(IntFunction intFunction) {
        for (int i = 0; i < this.dim1; ++i) {
            this.set(i, intFunction.apply(this.get(i)));
        }
    }

    @Override
    public void fill(IntGenerator intGenerator) {
        for (int i = 0; i < this.dim1; ++i) {
            this.set(i, intGenerator.nextInt());
        }
    }

    @Override
    public void scan(IntScanner intScanner) {
        intScanner.initialize(this.get(0));
        for (int i = 1; i < this.dim1; ++i) {
            intScanner.update(this.get(i));
        }
    }

    @Override
    public final int[] flatten() {
        return this.flatten(false);
    }

    @Override
    public int min() {
        int n = this.get(0);
        for (int i = 1; i < this.dim1; ++i) {
            int n2 = this.get(i);
            if (n2 >= n) continue;
            n = n2;
        }
        return n;
    }

    @Override
    public int max() {
        int n = this.get(0);
        for (int i = 1; i < this.dim1; ++i) {
            int n2 = this.get(i);
            if (n2 <= n) continue;
            n = n2;
        }
        return n;
    }

    @Override
    public int[] getMinAndMax() {
        int[] nArray = new int[2];
        this.getMinAndMax(nArray);
        return nArray;
    }

    @Override
    public void getMinAndMax(int[] nArray) {
        int n;
        int n2 = n = this.get(0);
        for (int i = 1; i < this.dim1; ++i) {
            int n3 = this.get(i);
            if (n3 < n) {
                n = n3;
            }
            if (n3 <= n2) continue;
            n2 = n3;
        }
        nArray[0] = n;
        nArray[1] = n2;
    }

    @Override
    public int sum() {
        int n = this.get(0);
        for (int i = 1; i < this.dim1; ++i) {
            n += this.get(i);
        }
        return n;
    }

    @Override
    public double average() {
        return (double)this.sum() / (double)this.number;
    }

    @Override
    public Byte1D toByte() {
        byte[] byArray = new byte[this.number];
        if (this.isFlat()) {
            int[] nArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                byArray[i] = (byte)nArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim1; ++i) {
                byArray[++n] = (byte)this.get(i);
            }
        }
        return Byte1D.wrap(byArray, this.getShape());
    }

    @Override
    public Short1D toShort() {
        short[] sArray = new short[this.number];
        if (this.isFlat()) {
            int[] nArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                sArray[i] = (short)nArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim1; ++i) {
                sArray[++n] = (short)this.get(i);
            }
        }
        return Short1D.wrap(sArray, this.getShape());
    }

    @Override
    public Int1D toInt() {
        return this;
    }

    @Override
    public Long1D toLong() {
        long[] lArray = new long[this.number];
        if (this.isFlat()) {
            int[] nArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                lArray[i] = nArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim1; ++i) {
                lArray[++n] = this.get(i);
            }
        }
        return Long1D.wrap(lArray, this.getShape());
    }

    @Override
    public Float1D toFloat() {
        float[] fArray = new float[this.number];
        if (this.isFlat()) {
            int[] nArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                fArray[i] = nArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim1; ++i) {
                fArray[++n] = this.get(i);
            }
        }
        return Float1D.wrap(fArray, this.getShape());
    }

    @Override
    public Double1D toDouble() {
        double[] dArray = new double[this.number];
        if (this.isFlat()) {
            int[] nArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                dArray[i] = nArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim1; ++i) {
                dArray[++n] = this.get(i);
            }
        }
        return Double1D.wrap(dArray, this.getShape());
    }

    @Override
    public Int1D copy() {
        return new FlatInt1D(this.flatten(true), this.shape);
    }

    @Override
    public void assign(ShapedArray shapedArray) {
        if (!this.getShape().equals(shapedArray.getShape())) {
            throw new NonConformableArrayException("Source and destination must have the same shape");
        }
        Int1D int1D = shapedArray.getType() == 2 ? (Int1D)shapedArray : (Int1D)shapedArray.toInt();
        for (int i = 0; i < this.dim1; ++i) {
            this.set(i, int1D.get(i));
        }
    }

    @Override
    public void assign(ShapedVector shapedVector) {
        if (!this.getShape().equals(shapedVector.getShape())) {
            throw new NonConformableArrayException("Source and destination must have the same shape");
        }
        if (shapedVector.getType() == 5) {
            DoubleShapedVector doubleShapedVector = (DoubleShapedVector)shapedVector;
            for (int i = 0; i < this.dim1; ++i) {
                this.set(i, (int)doubleShapedVector.get(i));
            }
        } else if (shapedVector.getType() == 4) {
            FloatShapedVector floatShapedVector = (FloatShapedVector)shapedVector;
            for (int i = 0; i < this.dim1; ++i) {
                this.set(i, (int)floatShapedVector.get(i));
            }
        } else {
            throw new IllegalTypeException();
        }
    }

    @Override
    public Int1D create() {
        return new FlatInt1D(this.getShape());
    }

    public static Int1D create(int n) {
        return new FlatInt1D(n);
    }

    public static Int1D create(int[] nArray) {
        return new FlatInt1D(nArray);
    }

    public static Int1D create(Shape shape) {
        return new FlatInt1D(shape);
    }

    public static Int1D wrap(int[] nArray, int n) {
        return new FlatInt1D(nArray, n);
    }

    public static Int1D wrap(int[] nArray, int[] nArray2) {
        return new FlatInt1D(nArray, nArray2);
    }

    public static Int1D wrap(int[] nArray, Shape shape) {
        return new FlatInt1D(nArray, shape);
    }

    public static Int1D wrap(int[] nArray, int n, int n2, int n3) {
        return new StriddenInt1D(nArray, n, n2, n3);
    }

    @Override
    public abstract IntScalar slice(int var1);

    @Override
    public abstract IntScalar slice(int var1, int var2);

    @Override
    public abstract Int1D view(Range var1);

    @Override
    public abstract Int1D view(int[] var1);

    @Override
    public abstract Int1D as1D();
}

