/*
 * Decompiled with CFR 0.152.
 */
package mitiv.random;

import mitiv.random.DoubleGenerator;
import mitiv.random.FloatGenerator;
import mitiv.random.RandomEngine;

public class PressTeukolskyGenerator
extends RandomEngine
implements DoubleGenerator,
FloatGenerator {
    private static final int IM1 = 2147483563;
    private static final int IA1 = 40014;
    private static final int IQ1 = 53668;
    private static final int IR1 = 12211;
    private static final int IM2 = 0x7FFFFF07;
    private static final int IA2 = 40692;
    private static final int IQ2 = 52774;
    private static final int IR2 = 3791;
    private static final int NTAB = 32;
    private static final int IMM1 = 0x7FFFFFAA;
    private static final int NDIV = 0x3FFFFFE;
    private int idum1 = 0;
    private int idum2 = 0;
    private final int[] iv = new int[32];
    private int iy;
    public static final int DEFAULT_SEED = 1327217730;
    private static final int MIN_VALUE = 1;
    private static final int MAX_VALUE = 0x7FFFFFAA;
    public static final double DBL_SCALE = PressTeukolskyGenerator.standardScale(1.0, 2.147483562E9);
    public static final double DBL_BIAS = PressTeukolskyGenerator.standardBias(1.0, 2.147483562E9);
    public static final float FLT_SCALE = (float)DBL_SCALE;
    public static final float FLT_BIAS = (float)DBL_BIAS;

    public PressTeukolskyGenerator(int n) {
        this.reset(n);
    }

    public PressTeukolskyGenerator() {
        this.reset(1327217730);
    }

    @Override
    public void reset(int n) {
        if (n <= 0) {
            n = 1327217730;
        }
        this.idum1 = this.idum2 = 1 + n % 2147483398;
        for (int i = 39; i >= 0; --i) {
            this.idum1 = 40014 * (this.idum1 % 53668) - 12211 * (this.idum1 / 53668);
            if (this.idum1 < 0) {
                this.idum1 += 2147483563;
            }
            if (i >= 32) continue;
            this.iv[i] = this.idum1;
        }
        this.iy = this.iv[0];
    }

    @Override
    public int next() {
        this.idum1 = 40014 * (this.idum1 % 53668) - 12211 * (this.idum1 / 53668);
        if (this.idum1 < 0) {
            this.idum1 += 2147483563;
        }
        this.idum2 = 40692 * (this.idum2 % 52774) - 3791 * (this.idum2 / 52774);
        if (this.idum2 < 0) {
            this.idum2 += 0x7FFFFF07;
        }
        int n = this.iy / 0x3FFFFFE;
        this.iy = this.iv[n] - this.idum2;
        this.iv[n] = this.idum1;
        if (this.iy < 1) {
            this.iy += 0x7FFFFFAA;
        }
        return this.iy;
    }

    public double generate(double d, double d2) {
        return d + (d2 - d) * (double)this.next();
    }

    void generate(double[] dArray) {
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            dArray[i] = this.next();
        }
    }

    void generate(double[] dArray, double d, double d2) {
        double d3 = (d2 - d) * DBL_SCALE;
        double d4 = (d2 - d) * DBL_BIAS - d;
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            dArray[i] = d3 * (double)this.next() - d4;
        }
    }

    @Override
    public int min() {
        return 1;
    }

    @Override
    public int max() {
        return 0x7FFFFFAA;
    }

    @Override
    public double nextDouble() {
        return DBL_SCALE * (double)this.next() - DBL_BIAS;
    }

    @Override
    public float nextFloat() {
        return FLT_SCALE * (float)this.next() - FLT_BIAS;
    }

    public static void main(String[] stringArray) {
        double d;
        System.out.printf("MIN_VALUE = 0x%08x\n", 1);
        System.out.printf("MAX_VALUE = 0x%08x\n", 0x7FFFFFAA);
        System.out.printf("DBL_SCALE = %g\n", DBL_SCALE);
        System.out.printf("DBL_BIAS = %g\n", DBL_BIAS);
        System.out.printf("DBL_BIAS/DBL_SCALE = %g\n", DBL_BIAS / DBL_SCALE);
        PressTeukolskyGenerator pressTeukolskyGenerator = new PressTeukolskyGenerator();
        System.out.printf("Sample:", new Object[0]);
        for (int i = 1; i < 10; ++i) {
            System.out.printf("  %8.6f", pressTeukolskyGenerator.nextDouble());
        }
        System.out.printf("\n", new Object[0]);
        int n = 10000000;
        double d2 = d = pressTeukolskyGenerator.nextDouble();
        double d3 = d;
        for (int i = 1; i < n; ++i) {
            double d4 = pressTeukolskyGenerator.nextDouble();
            d3 += d4;
            if (d4 < d2) {
                d2 = d4;
            }
            if (!(d4 > d)) continue;
            d = d4;
        }
        System.out.printf("Test of %d draws: avg = %g; min = %g; 1 - max = %g;\n", n, d3 / (double)n, d2, 1.0 - d);
    }
}

