/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.util.pngj.chunks;

import jogamp.opengl.util.pngj.ImageInfo;
import jogamp.opengl.util.pngj.PngHelperInternal;
import jogamp.opengl.util.pngj.PngjException;
import jogamp.opengl.util.pngj.chunks.ChunkRaw;
import jogamp.opengl.util.pngj.chunks.PngChunk;
import jogamp.opengl.util.pngj.chunks.PngChunkSingle;

public class PngChunkHIST
extends PngChunkSingle {
    public static final String ID = "hIST";
    private int[] hist = new int[0];

    public PngChunkHIST(ImageInfo imageInfo) {
        super(ID, imageInfo);
    }

    @Override
    public PngChunk.ChunkOrderingConstraint getOrderingConstraint() {
        return PngChunk.ChunkOrderingConstraint.AFTER_PLTE_BEFORE_IDAT;
    }

    @Override
    public void parseFromRaw(ChunkRaw chunkRaw) {
        if (!this.imgInfo.indexed) {
            throw new PngjException("only indexed images accept a HIST chunk");
        }
        int n = chunkRaw.data.length / 2;
        this.hist = new int[n];
        for (int i = 0; i < this.hist.length; ++i) {
            this.hist[i] = PngHelperInternal.readInt2fromBytes(chunkRaw.data, i * 2);
        }
    }

    @Override
    public ChunkRaw createRawChunk() {
        if (!this.imgInfo.indexed) {
            throw new PngjException("only indexed images accept a HIST chunk");
        }
        ChunkRaw chunkRaw = null;
        chunkRaw = this.createEmptyChunk(this.hist.length * 2, true);
        for (int i = 0; i < this.hist.length; ++i) {
            PngHelperInternal.writeInt2tobytes(this.hist[i], chunkRaw.data, i * 2);
        }
        return chunkRaw;
    }

    @Override
    public void cloneDataFromRead(PngChunk pngChunk) {
        PngChunkHIST pngChunkHIST = (PngChunkHIST)pngChunk;
        this.hist = new int[pngChunkHIST.hist.length];
        System.arraycopy(pngChunkHIST.hist, 0, this.hist, 0, pngChunkHIST.hist.length);
    }

    public int[] getHist() {
        return this.hist;
    }

    public void setHist(int[] nArray) {
        this.hist = nArray;
    }
}

