/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array;

import mitiv.array.Array2D;
import mitiv.array.Byte2D;
import mitiv.array.Double2D;
import mitiv.array.Float1D;
import mitiv.array.FloatArray;
import mitiv.array.Int2D;
import mitiv.array.Long2D;
import mitiv.array.ShapedArray;
import mitiv.array.Short2D;
import mitiv.array.impl.FlatFloat2D;
import mitiv.array.impl.StriddenFloat2D;
import mitiv.base.Shape;
import mitiv.base.indexing.Range;
import mitiv.base.mapping.FloatFunction;
import mitiv.base.mapping.FloatScanner;
import mitiv.exception.IllegalTypeException;
import mitiv.exception.NonConformableArrayException;
import mitiv.linalg.shaped.DoubleShapedVector;
import mitiv.linalg.shaped.FloatShapedVector;
import mitiv.linalg.shaped.ShapedVector;
import mitiv.random.FloatGenerator;

public abstract class Float2D
extends Array2D
implements FloatArray {
    protected Float2D(int n, int n2) {
        super(n, n2);
    }

    protected Float2D(int[] nArray) {
        super(nArray);
    }

    protected Float2D(Shape shape) {
        super(shape);
    }

    @Override
    public final int getType() {
        return 4;
    }

    public abstract float get(int var1, int var2);

    public abstract void set(int var1, int var2, float var3);

    @Override
    public void fill(float f) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    this.set(i, j, f);
                }
            }
        } else {
            for (int i = 0; i < this.dim2; ++i) {
                for (int j = 0; j < this.dim1; ++j) {
                    this.set(j, i, f);
                }
            }
        }
    }

    @Override
    public void increment(float f) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    this.set(i, j, this.get(i, j) + f);
                }
            }
        } else {
            for (int i = 0; i < this.dim2; ++i) {
                for (int j = 0; j < this.dim1; ++j) {
                    this.set(j, i, this.get(j, i) + f);
                }
            }
        }
    }

    @Override
    public void decrement(float f) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    this.set(i, j, this.get(i, j) - f);
                }
            }
        } else {
            for (int i = 0; i < this.dim2; ++i) {
                for (int j = 0; j < this.dim1; ++j) {
                    this.set(j, i, this.get(j, i) - f);
                }
            }
        }
    }

    @Override
    public void scale(float f) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    this.set(i, j, this.get(i, j) * f);
                }
            }
        } else {
            for (int i = 0; i < this.dim2; ++i) {
                for (int j = 0; j < this.dim1; ++j) {
                    this.set(j, i, this.get(j, i) * f);
                }
            }
        }
    }

    @Override
    public void map(FloatFunction floatFunction) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    this.set(i, j, floatFunction.apply(this.get(i, j)));
                }
            }
        } else {
            for (int i = 0; i < this.dim2; ++i) {
                for (int j = 0; j < this.dim1; ++j) {
                    this.set(j, i, floatFunction.apply(this.get(j, i)));
                }
            }
        }
    }

    @Override
    public void fill(FloatGenerator floatGenerator) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    this.set(i, j, floatGenerator.nextFloat());
                }
            }
        } else {
            for (int i = 0; i < this.dim2; ++i) {
                for (int j = 0; j < this.dim1; ++j) {
                    this.set(j, i, floatGenerator.nextFloat());
                }
            }
        }
    }

    @Override
    public void scan(FloatScanner floatScanner) {
        boolean bl = false;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    if (bl) {
                        floatScanner.update(this.get(i, j));
                        continue;
                    }
                    floatScanner.initialize(this.get(i, j));
                    bl = true;
                }
            }
        } else {
            for (int i = 0; i < this.dim2; ++i) {
                for (int j = 0; j < this.dim1; ++j) {
                    if (bl) {
                        floatScanner.update(this.get(j, i));
                        continue;
                    }
                    floatScanner.initialize(this.get(j, i));
                    bl = true;
                }
            }
        }
    }

    @Override
    public final float[] flatten() {
        return this.flatten(false);
    }

    @Override
    public float min() {
        float f = this.get(0, 0);
        boolean bl = true;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    if (bl) {
                        bl = false;
                        continue;
                    }
                    float f2 = this.get(i, j);
                    if (!(f2 < f)) continue;
                    f = f2;
                }
            }
        } else {
            for (int i = 0; i < this.dim2; ++i) {
                for (int j = 0; j < this.dim1; ++j) {
                    if (bl) {
                        bl = false;
                        continue;
                    }
                    float f3 = this.get(j, i);
                    if (!(f3 < f)) continue;
                    f = f3;
                }
            }
        }
        return f;
    }

    @Override
    public float max() {
        float f = this.get(0, 0);
        boolean bl = true;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    if (bl) {
                        bl = false;
                        continue;
                    }
                    float f2 = this.get(i, j);
                    if (!(f2 > f)) continue;
                    f = f2;
                }
            }
        } else {
            for (int i = 0; i < this.dim2; ++i) {
                for (int j = 0; j < this.dim1; ++j) {
                    if (bl) {
                        bl = false;
                        continue;
                    }
                    float f3 = this.get(j, i);
                    if (!(f3 > f)) continue;
                    f = f3;
                }
            }
        }
        return f;
    }

    @Override
    public float[] getMinAndMax() {
        float[] fArray = new float[2];
        this.getMinAndMax(fArray);
        return fArray;
    }

    @Override
    public void getMinAndMax(float[] fArray) {
        float f;
        float f2 = f = this.get(0, 0);
        boolean bl = true;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    if (bl) {
                        bl = false;
                        continue;
                    }
                    float f3 = this.get(i, j);
                    if (f3 < f) {
                        f = f3;
                    }
                    if (!(f3 > f2)) continue;
                    f2 = f3;
                }
            }
        } else {
            for (int i = 0; i < this.dim2; ++i) {
                for (int j = 0; j < this.dim1; ++j) {
                    if (bl) {
                        bl = false;
                        continue;
                    }
                    float f4 = this.get(j, i);
                    if (f4 < f) {
                        f = f4;
                    }
                    if (!(f4 > f2)) continue;
                    f2 = f4;
                }
            }
        }
        fArray[0] = f;
        fArray[1] = f2;
    }

    @Override
    public float sum() {
        float f = 0.0f;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    f += this.get(i, j);
                }
            }
        } else {
            for (int i = 0; i < this.dim2; ++i) {
                for (int j = 0; j < this.dim1; ++j) {
                    f += this.get(j, i);
                }
            }
        }
        return f;
    }

    @Override
    public double average() {
        return (double)this.sum() / (double)this.number;
    }

    @Override
    public Byte2D toByte() {
        byte[] byArray = new byte[this.number];
        if (this.isFlat()) {
            float[] fArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                byArray[i] = (byte)fArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim2; ++i) {
                for (int j = 0; j < this.dim1; ++j) {
                    byArray[++n] = (byte)this.get(j, i);
                }
            }
        }
        return Byte2D.wrap(byArray, this.getShape());
    }

    @Override
    public Short2D toShort() {
        short[] sArray = new short[this.number];
        if (this.isFlat()) {
            float[] fArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                sArray[i] = (short)fArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim2; ++i) {
                for (int j = 0; j < this.dim1; ++j) {
                    sArray[++n] = (short)this.get(j, i);
                }
            }
        }
        return Short2D.wrap(sArray, this.getShape());
    }

    @Override
    public Int2D toInt() {
        int[] nArray = new int[this.number];
        if (this.isFlat()) {
            float[] fArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                nArray[i] = (int)fArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim2; ++i) {
                for (int j = 0; j < this.dim1; ++j) {
                    nArray[++n] = (int)this.get(j, i);
                }
            }
        }
        return Int2D.wrap(nArray, this.getShape());
    }

    @Override
    public Long2D toLong() {
        long[] lArray = new long[this.number];
        if (this.isFlat()) {
            float[] fArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                lArray[i] = (long)fArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim2; ++i) {
                for (int j = 0; j < this.dim1; ++j) {
                    lArray[++n] = (long)this.get(j, i);
                }
            }
        }
        return Long2D.wrap(lArray, this.getShape());
    }

    @Override
    public Float2D toFloat() {
        return this;
    }

    @Override
    public Double2D toDouble() {
        double[] dArray = new double[this.number];
        if (this.isFlat()) {
            float[] fArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                dArray[i] = fArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim2; ++i) {
                for (int j = 0; j < this.dim1; ++j) {
                    dArray[++n] = this.get(j, i);
                }
            }
        }
        return Double2D.wrap(dArray, this.getShape());
    }

    @Override
    public Float2D copy() {
        return new FlatFloat2D(this.flatten(true), this.shape);
    }

    @Override
    public void assign(ShapedArray shapedArray) {
        if (!this.getShape().equals(shapedArray.getShape())) {
            throw new NonConformableArrayException("Source and destination must have the same shape");
        }
        Float2D float2D = shapedArray.getType() == 4 ? (Float2D)shapedArray : (Float2D)shapedArray.toFloat();
        if (this.getOrder() == 2 && float2D.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    this.set(i, j, float2D.get(i, j));
                }
            }
        } else {
            for (int i = 0; i < this.dim2; ++i) {
                for (int j = 0; j < this.dim1; ++j) {
                    this.set(j, i, float2D.get(j, i));
                }
            }
        }
    }

    @Override
    public void assign(ShapedVector shapedVector) {
        if (!this.getShape().equals(shapedVector.getShape())) {
            throw new NonConformableArrayException("Source and destination must have the same shape");
        }
        int n = -1;
        if (shapedVector.getType() == 5) {
            DoubleShapedVector doubleShapedVector = (DoubleShapedVector)shapedVector;
            for (int i = 0; i < this.dim2; ++i) {
                for (int j = 0; j < this.dim1; ++j) {
                    this.set(j, i, (float)doubleShapedVector.get(++n));
                }
            }
        } else if (shapedVector.getType() == 4) {
            FloatShapedVector floatShapedVector = (FloatShapedVector)shapedVector;
            for (int i = 0; i < this.dim2; ++i) {
                for (int j = 0; j < this.dim1; ++j) {
                    this.set(j, i, (float)floatShapedVector.get(++n));
                }
            }
        } else {
            throw new IllegalTypeException();
        }
    }

    @Override
    public Float2D create() {
        return new FlatFloat2D(this.getShape());
    }

    public static Float2D create(int n, int n2) {
        return new FlatFloat2D(n, n2);
    }

    public static Float2D create(int[] nArray) {
        return new FlatFloat2D(nArray);
    }

    public static Float2D create(Shape shape) {
        return new FlatFloat2D(shape);
    }

    public static Float2D wrap(float[] fArray, int n, int n2) {
        return new FlatFloat2D(fArray, n, n2);
    }

    public static Float2D wrap(float[] fArray, int[] nArray) {
        return new FlatFloat2D(fArray, nArray);
    }

    public static Float2D wrap(float[] fArray, Shape shape) {
        return new FlatFloat2D(fArray, shape);
    }

    public static Float2D wrap(float[] fArray, int n, int n2, int n3, int n4, int n5) {
        return new StriddenFloat2D(fArray, n, n2, n3, n4, n5);
    }

    @Override
    public abstract Float1D slice(int var1);

    @Override
    public abstract Float1D slice(int var1, int var2);

    @Override
    public abstract Float2D view(Range var1, Range var2);

    @Override
    public abstract Float2D view(int[] var1, int[] var2);

    @Override
    public abstract Float1D as1D();
}

