/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.alg.dense.decomposition.eig;

import org.ejml.alg.dense.decomposition.EigenDecomposition;
import org.ejml.alg.dense.decomposition.eig.watched.WatchedDoubleStepQREigenvalue;
import org.ejml.alg.dense.decomposition.eig.watched.WatchedDoubleStepQREigenvector;
import org.ejml.alg.dense.decomposition.hessenberg.HessenbergSimilarDecomposition;
import org.ejml.data.Complex64F;
import org.ejml.data.DenseMatrix64F;

public class WatchedDoubleStepQRDecomposition
implements EigenDecomposition<DenseMatrix64F> {
    HessenbergSimilarDecomposition hessenberg = new HessenbergSimilarDecomposition(10);
    WatchedDoubleStepQREigenvalue algValue = new WatchedDoubleStepQREigenvalue();
    WatchedDoubleStepQREigenvector algVector = new WatchedDoubleStepQREigenvector();
    DenseMatrix64F H;
    boolean computeVectors;

    public WatchedDoubleStepQRDecomposition(boolean bl) {
        this.computeVectors = bl;
    }

    @Override
    public boolean decompose(DenseMatrix64F denseMatrix64F) {
        this.hessenberg.decompose(denseMatrix64F);
        this.H = this.hessenberg.getH(null);
        this.algValue.getImplicitQR().createR = false;
        if (!this.algValue.process(this.H)) {
            return false;
        }
        this.algValue.getImplicitQR().createR = true;
        if (this.computeVectors) {
            return this.algVector.process(this.algValue.getImplicitQR(), this.H, this.hessenberg.getQ(null));
        }
        return true;
    }

    @Override
    public boolean inputModified() {
        return this.hessenberg.inputModified();
    }

    @Override
    public int getNumberOfEigenvalues() {
        return this.algValue.getEigenvalues().length;
    }

    @Override
    public Complex64F getEigenvalue(int n) {
        return this.algValue.getEigenvalues()[n];
    }

    @Override
    public DenseMatrix64F getEigenVector(int n) {
        return this.algVector.getEigenvectors()[n];
    }
}

