/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.jtransforms.fft;

import edu.emory.mathcs.jtransforms.fft.FloatFFT_1D;
import edu.emory.mathcs.jtransforms.fft.FloatFFT_2D;
import edu.emory.mathcs.jtransforms.fft.FloatFFT_3D;
import edu.emory.mathcs.utils.IOUtils;

public class AccuracyCheckFloatFFT {
    private static int[] sizes1D = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 16, 32, 64, 100, 120, 128, 256, 310, 512, 1024, 1056, 2048, 8192, 10158, 16384, 32768, 65530, 65536, 131072};
    private static int[] sizes2D = new int[]{2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 16, 32, 64, 100, 120, 128, 256, 310, 511, 512, 1024};
    private static int[] sizes3D = new int[]{2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 16, 32, 64, 100, 128};
    private static int[] sizes2D2 = new int[]{2, 4, 8, 16, 32, 64, 128, 256, 512, 1024};
    private static int[] sizes3D2 = new int[]{2, 4, 8, 16, 32, 64, 128};
    private static double eps = Math.pow(2.0, -23.0);

    private AccuracyCheckFloatFFT() {
    }

    public static void checkAccuracyComplexFFT_1D() {
        System.out.println("Checking accuracy of 1D complex FFT...");
        int i = 0;
        while (i < sizes1D.length) {
            FloatFFT_1D fft = new FloatFFT_1D(sizes1D[i]);
            double err = 0.0;
            float[] a = new float[2 * sizes1D[i]];
            IOUtils.fillMatrix_1D(2 * sizes1D[i], a);
            float[] b = new float[2 * sizes1D[i]];
            IOUtils.fillMatrix_1D(2 * sizes1D[i], b);
            fft.complexForward(a);
            fft.complexInverse(a, true);
            err = AccuracyCheckFloatFFT.computeRMSE(a, b);
            if (err > eps) {
                System.err.println("\tsize = " + sizes1D[i] + ";\terror = " + err);
            } else {
                System.out.println("\tsize = " + sizes1D[i] + ";\terror = " + err);
            }
            a = null;
            b = null;
            fft = null;
            System.gc();
            ++i;
        }
    }

    public static void checkAccuracyComplexFFT_2D() {
        Object b;
        Object a;
        double err;
        FloatFFT_2D fft2;
        System.out.println("Checking accuracy of 2D complex FFT (float[] input)...");
        int i = 0;
        while (i < sizes2D.length) {
            fft2 = new FloatFFT_2D(sizes2D[i], sizes2D[i]);
            err = 0.0;
            a = new float[2 * sizes2D[i] * sizes2D[i]];
            IOUtils.fillMatrix_2D(sizes2D[i], 2 * sizes2D[i], a);
            b = new float[2 * sizes2D[i] * sizes2D[i]];
            IOUtils.fillMatrix_2D(sizes2D[i], 2 * sizes2D[i], b);
            fft2.complexForward((float[])a);
            fft2.complexInverse((float[])a, true);
            err = AccuracyCheckFloatFFT.computeRMSE(a, b);
            if (err > eps) {
                System.err.println("\tsize = " + sizes2D[i] + " x " + sizes2D[i] + ";\terror = " + err);
            } else {
                System.out.println("\tsize = " + sizes2D[i] + " x " + sizes2D[i] + ";\terror = " + err);
            }
            a = null;
            b = null;
            fft2 = null;
            System.gc();
            ++i;
        }
        System.out.println("Checking accuracy of 2D complex FFT (float[][] input)...");
        i = 0;
        while (i < sizes2D.length) {
            fft2 = new FloatFFT_2D(sizes2D[i], sizes2D[i]);
            err = 0.0;
            a = new float[sizes2D[i]][2 * sizes2D[i]];
            IOUtils.fillMatrix_2D(sizes2D[i], 2 * sizes2D[i], (float[][])a);
            b = new float[sizes2D[i]][2 * sizes2D[i]];
            IOUtils.fillMatrix_2D(sizes2D[i], 2 * sizes2D[i], (float[][])b);
            fft2.complexForward((float[][])a);
            fft2.complexInverse((float[][])a, true);
            err = AccuracyCheckFloatFFT.computeRMSE((float[][])a, (float[][])b);
            if (err > eps) {
                System.err.println("\tsize = " + sizes2D[i] + " x " + sizes2D[i] + ";\terror = " + err);
            } else {
                System.out.println("\tsize = " + sizes2D[i] + " x " + sizes2D[i] + ";\terror = " + err);
            }
            a = null;
            b = null;
            fft2 = null;
            System.gc();
            ++i;
        }
    }

    public static void checkAccuracyComplexFFT_3D() {
        Object b;
        Object a;
        double err;
        FloatFFT_3D fft3;
        System.out.println("Checking accuracy of 3D complex FFT (float[] input)...");
        int i = 0;
        while (i < sizes3D.length) {
            fft3 = new FloatFFT_3D(sizes3D[i], sizes3D[i], sizes3D[i]);
            err = 0.0;
            a = new float[2 * sizes3D[i] * sizes3D[i] * sizes3D[i]];
            IOUtils.fillMatrix_3D(sizes3D[i], sizes3D[i], 2 * sizes3D[i], a);
            b = new float[2 * sizes3D[i] * sizes3D[i] * sizes3D[i]];
            IOUtils.fillMatrix_3D(sizes3D[i], sizes3D[i], 2 * sizes3D[i], b);
            fft3.complexForward((float[])a);
            fft3.complexInverse((float[])a, true);
            err = AccuracyCheckFloatFFT.computeRMSE(a, b);
            if (err > eps) {
                System.err.println("\tsize = " + sizes3D[i] + " x " + sizes3D[i] + " x " + sizes3D[i] + ";\t\terror = " + err);
            } else {
                System.out.println("\tsize = " + sizes3D[i] + " x " + sizes3D[i] + " x " + sizes3D[i] + ";\t\terror = " + err);
            }
            a = null;
            b = null;
            fft3 = null;
            System.gc();
            ++i;
        }
        System.out.println("Checking accuracy of 3D complex FFT (float[][][] input)...");
        i = 0;
        while (i < sizes3D.length) {
            fft3 = new FloatFFT_3D(sizes3D[i], sizes3D[i], sizes3D[i]);
            err = 0.0;
            a = new float[sizes3D[i]][sizes3D[i]][2 * sizes3D[i]];
            IOUtils.fillMatrix_3D(sizes3D[i], sizes3D[i], 2 * sizes3D[i], (float[][][])a);
            b = new float[sizes3D[i]][sizes3D[i]][2 * sizes3D[i]];
            IOUtils.fillMatrix_3D(sizes3D[i], sizes3D[i], 2 * sizes3D[i], (float[][][])b);
            fft3.complexForward((float[][][])a);
            fft3.complexInverse((float[][][])a, true);
            err = AccuracyCheckFloatFFT.computeRMSE((float[][][])a, (float[][][])b);
            if (err > eps) {
                System.err.println("\tsize = " + sizes3D[i] + " x " + sizes3D[i] + " x " + sizes3D[i] + ";\t\terror = " + err);
            } else {
                System.out.println("\tsize = " + sizes3D[i] + " x " + sizes3D[i] + " x " + sizes3D[i] + ";\t\terror = " + err);
            }
            a = null;
            b = null;
            fft3 = null;
            System.gc();
            ++i;
        }
    }

    public static void checkAccuracyRealFFT_1D() {
        int j;
        float[] b;
        float[] a;
        double err;
        FloatFFT_1D fft;
        System.out.println("Checking accuracy of 1D real FFT...");
        int i = 0;
        while (i < sizes1D.length) {
            fft = new FloatFFT_1D(sizes1D[i]);
            err = 0.0;
            a = new float[sizes1D[i]];
            IOUtils.fillMatrix_1D(sizes1D[i], a);
            b = new float[sizes1D[i]];
            IOUtils.fillMatrix_1D(sizes1D[i], b);
            fft.realForward(a);
            fft.realInverse(a, true);
            err = AccuracyCheckFloatFFT.computeRMSE(a, b);
            if (err > eps) {
                System.err.println("\tsize = " + sizes1D[i] + ";\terror = " + err);
            } else {
                System.out.println("\tsize = " + sizes1D[i] + ";\terror = " + err);
            }
            a = null;
            b = null;
            fft = null;
            System.gc();
            ++i;
        }
        System.out.println("Checking accuracy of on 1D real forward full FFT...");
        i = 0;
        while (i < sizes1D.length) {
            fft = new FloatFFT_1D(sizes1D[i]);
            err = 0.0;
            a = new float[2 * sizes1D[i]];
            IOUtils.fillMatrix_1D(sizes1D[i], a);
            b = new float[2 * sizes1D[i]];
            j = 0;
            while (j < sizes1D[i]) {
                b[2 * j] = a[j];
                ++j;
            }
            fft.realForwardFull(a);
            fft.complexInverse(a, true);
            err = AccuracyCheckFloatFFT.computeRMSE(a, b);
            if (err > eps) {
                System.err.println("\tsize = " + sizes1D[i] + ";\terror = " + err);
            } else {
                System.out.println("\tsize = " + sizes1D[i] + ";\terror = " + err);
            }
            a = null;
            b = null;
            fft = null;
            System.gc();
            ++i;
        }
        System.out.println("Checking accuracy of 1D real inverse full FFT...");
        i = 0;
        while (i < sizes1D.length) {
            fft = new FloatFFT_1D(sizes1D[i]);
            err = 0.0;
            a = new float[2 * sizes1D[i]];
            IOUtils.fillMatrix_1D(sizes1D[i], a);
            b = new float[2 * sizes1D[i]];
            j = 0;
            while (j < sizes1D[i]) {
                b[2 * j] = a[j];
                ++j;
            }
            fft.realInverseFull(a, true);
            fft.complexForward(a);
            err = AccuracyCheckFloatFFT.computeRMSE(a, b);
            if (err > eps) {
                System.err.println("\tsize = " + sizes1D[i] + ";\terror = " + err);
            } else {
                System.out.println("\tsize = " + sizes1D[i] + ";\terror = " + err);
            }
            a = null;
            b = null;
            fft = null;
            System.gc();
            ++i;
        }
    }

    public static void checkAccuracyRealFFT_2D() {
        int c;
        int r;
        Object b;
        Object a;
        double err;
        FloatFFT_2D fft2;
        System.out.println("Checking accuracy of 2D real FFT (float[] input)...");
        int i = 0;
        while (i < sizes2D2.length) {
            fft2 = new FloatFFT_2D(sizes2D2[i], sizes2D2[i]);
            err = 0.0;
            a = new float[sizes2D2[i] * sizes2D2[i]];
            IOUtils.fillMatrix_2D(sizes2D2[i], sizes2D2[i], a);
            b = new float[sizes2D2[i] * sizes2D2[i]];
            IOUtils.fillMatrix_2D(sizes2D2[i], sizes2D2[i], b);
            fft2.realForward((float[])a);
            fft2.realInverse((float[])a, true);
            err = AccuracyCheckFloatFFT.computeRMSE(a, b);
            if (err > eps) {
                System.err.println("\tsize = " + sizes2D2[i] + " x " + sizes2D2[i] + ";\terror = " + err);
            } else {
                System.out.println("\tsize = " + sizes2D2[i] + " x " + sizes2D2[i] + ";\terror = " + err);
            }
            a = null;
            b = null;
            fft2 = null;
            System.gc();
            ++i;
        }
        System.out.println("Checking accuracy of 2D real FFT (float[][] input)...");
        i = 0;
        while (i < sizes2D2.length) {
            fft2 = new FloatFFT_2D(sizes2D2[i], sizes2D2[i]);
            err = 0.0;
            a = new float[sizes2D2[i]][sizes2D2[i]];
            IOUtils.fillMatrix_2D(sizes2D2[i], sizes2D2[i], (float[][])a);
            b = new float[sizes2D2[i]][sizes2D2[i]];
            IOUtils.fillMatrix_2D(sizes2D2[i], sizes2D2[i], (float[][])b);
            fft2.realForward((float[][])a);
            fft2.realInverse((float[][])a, true);
            err = AccuracyCheckFloatFFT.computeRMSE((float[][])a, (float[][])b);
            if (err > eps) {
                System.err.println("\tsize = " + sizes2D2[i] + " x " + sizes2D2[i] + ";\terror = " + err);
            } else {
                System.out.println("\tsize = " + sizes2D2[i] + " x " + sizes2D2[i] + ";\terror = " + err);
            }
            a = null;
            b = null;
            fft2 = null;
            System.gc();
            ++i;
        }
        System.out.println("Checking accuracy of 2D real forward full FFT (float[] input)...");
        i = 0;
        while (i < sizes2D.length) {
            fft2 = new FloatFFT_2D(sizes2D[i], sizes2D[i]);
            err = 0.0;
            a = new float[2 * sizes2D[i] * sizes2D[i]];
            IOUtils.fillMatrix_2D(sizes2D[i], sizes2D[i], a);
            b = new float[2 * sizes2D[i] * sizes2D[i]];
            r = 0;
            while (r < sizes2D[i]) {
                c = 0;
                while (c < sizes2D[i]) {
                    b[r * 2 * AccuracyCheckFloatFFT.sizes2D[i] + 2 * c] = a[r * sizes2D[i] + c];
                    ++c;
                }
                ++r;
            }
            fft2.realForwardFull((float[])a);
            fft2.complexInverse((float[])a, true);
            err = AccuracyCheckFloatFFT.computeRMSE(a, b);
            if (err > eps) {
                System.err.println("\tsize = " + sizes2D[i] + " x " + sizes2D[i] + ";\terror = " + err);
            } else {
                System.out.println("\tsize = " + sizes2D[i] + " x " + sizes2D[i] + ";\terror = " + err);
            }
            a = null;
            b = null;
            fft2 = null;
            System.gc();
            ++i;
        }
        System.out.println("Checking accuracy of 2D real forward full FFT (float[][] input)...");
        i = 0;
        while (i < sizes2D.length) {
            fft2 = new FloatFFT_2D(sizes2D[i], sizes2D[i]);
            err = 0.0;
            a = new float[sizes2D[i]][2 * sizes2D[i]];
            IOUtils.fillMatrix_2D(sizes2D[i], sizes2D[i], (float[][])a);
            b = new float[sizes2D[i]][2 * sizes2D[i]];
            r = 0;
            while (r < sizes2D[i]) {
                c = 0;
                while (c < sizes2D[i]) {
                    b[r][2 * c] = a[r][c];
                    ++c;
                }
                ++r;
            }
            fft2.realForwardFull((float[][])a);
            fft2.complexInverse((float[][])a, true);
            err = AccuracyCheckFloatFFT.computeRMSE((float[][])a, (float[][])b);
            if (err > eps) {
                System.err.println("\tsize = " + sizes2D[i] + " x " + sizes2D[i] + ";\terror = " + err);
            } else {
                System.out.println("\tsize = " + sizes2D[i] + " x " + sizes2D[i] + ";\terror = " + err);
            }
            a = null;
            b = null;
            fft2 = null;
            System.gc();
            ++i;
        }
        System.out.println("Checking accuracy of 2D real inverse full FFT (float[] input)...");
        i = 0;
        while (i < sizes2D.length) {
            fft2 = new FloatFFT_2D(sizes2D[i], sizes2D[i]);
            err = 0.0;
            a = new float[2 * sizes2D[i] * sizes2D[i]];
            IOUtils.fillMatrix_2D(sizes2D[i], sizes2D[i], a);
            b = new float[2 * sizes2D[i] * sizes2D[i]];
            r = 0;
            while (r < sizes2D[i]) {
                c = 0;
                while (c < sizes2D[i]) {
                    b[r * 2 * AccuracyCheckFloatFFT.sizes2D[i] + 2 * c] = a[r * sizes2D[i] + c];
                    ++c;
                }
                ++r;
            }
            fft2.realInverseFull((float[])a, true);
            fft2.complexForward((float[])a);
            err = AccuracyCheckFloatFFT.computeRMSE(a, b);
            if (err > eps) {
                System.err.println("\tsize = " + sizes2D[i] + " x " + sizes2D[i] + ";\terror = " + err);
            } else {
                System.out.println("\tsize = " + sizes2D[i] + " x " + sizes2D[i] + ";\terror = " + err);
            }
            a = null;
            b = null;
            fft2 = null;
            System.gc();
            ++i;
        }
        System.out.println("Checking accuracy of 2D real inverse full FFT (float[][] input)...");
        i = 0;
        while (i < sizes2D.length) {
            fft2 = new FloatFFT_2D(sizes2D[i], sizes2D[i]);
            err = 0.0;
            a = new float[sizes2D[i]][2 * sizes2D[i]];
            IOUtils.fillMatrix_2D(sizes2D[i], sizes2D[i], (float[][])a);
            b = new float[sizes2D[i]][2 * sizes2D[i]];
            r = 0;
            while (r < sizes2D[i]) {
                c = 0;
                while (c < sizes2D[i]) {
                    b[r][2 * c] = a[r][c];
                    ++c;
                }
                ++r;
            }
            fft2.realInverseFull((float[][])a, true);
            fft2.complexForward((float[][])a);
            err = AccuracyCheckFloatFFT.computeRMSE((float[][])a, (float[][])b);
            if (err > eps) {
                System.err.println("\tsize = " + sizes2D[i] + " x " + sizes2D[i] + ";\terror = " + err);
            } else {
                System.out.println("\tsize = " + sizes2D[i] + " x " + sizes2D[i] + ";\terror = " + err);
            }
            a = null;
            b = null;
            fft2 = null;
            System.gc();
            ++i;
        }
    }

    public static void checkAccuracyRealFFT_3D() {
        int c;
        int r;
        int s;
        Object b;
        Object a;
        double err;
        FloatFFT_3D fft3;
        System.out.println("Checking accuracy of 3D real FFT (float[] input)...");
        int i = 0;
        while (i < sizes3D2.length) {
            fft3 = new FloatFFT_3D(sizes3D2[i], sizes3D2[i], sizes3D2[i]);
            err = 0.0;
            a = new float[sizes3D2[i] * sizes3D2[i] * sizes3D2[i]];
            IOUtils.fillMatrix_3D(sizes3D2[i], sizes3D2[i], sizes3D2[i], a);
            b = new float[sizes3D2[i] * sizes3D2[i] * sizes3D2[i]];
            IOUtils.fillMatrix_3D(sizes3D2[i], sizes3D2[i], sizes3D2[i], b);
            fft3.realForward((float[])b);
            fft3.realInverse((float[])b, true);
            err = AccuracyCheckFloatFFT.computeRMSE(a, b);
            if (err > eps) {
                System.err.println("\tsize = " + sizes3D2[i] + " x " + sizes3D2[i] + " x " + sizes3D2[i] + ";\t\terror = " + err);
            } else {
                System.out.println("\tsize = " + sizes3D2[i] + " x " + sizes3D2[i] + " x " + sizes3D2[i] + ";\t\terror = " + err);
            }
            a = null;
            b = null;
            fft3 = null;
            System.gc();
            ++i;
        }
        System.out.println("Checking accuracy of 3D real FFT (float[][][] input)...");
        i = 0;
        while (i < sizes3D2.length) {
            fft3 = new FloatFFT_3D(sizes3D2[i], sizes3D2[i], sizes3D2[i]);
            err = 0.0;
            a = new float[sizes3D2[i]][sizes3D2[i]][sizes3D2[i]];
            IOUtils.fillMatrix_3D(sizes3D2[i], sizes3D2[i], sizes3D2[i], (float[][][])a);
            b = new float[sizes3D2[i]][sizes3D2[i]][sizes3D2[i]];
            IOUtils.fillMatrix_3D(sizes3D2[i], sizes3D2[i], sizes3D2[i], (float[][][])b);
            fft3.realForward((float[][][])b);
            fft3.realInverse((float[][][])b, true);
            err = AccuracyCheckFloatFFT.computeRMSE((float[][][])a, (float[][][])b);
            if (err > eps) {
                System.err.println("\tsize = " + sizes3D2[i] + " x " + sizes3D2[i] + " x " + sizes3D2[i] + ";\t\terror = " + err);
            } else {
                System.out.println("\tsize = " + sizes3D2[i] + " x " + sizes3D2[i] + " x " + sizes3D2[i] + ";\t\terror = " + err);
            }
            a = null;
            b = null;
            fft3 = null;
            System.gc();
            ++i;
        }
        System.out.println("Checking accuracy of 3D real forward full FFT (float[] input)...");
        i = 0;
        while (i < sizes3D.length) {
            fft3 = new FloatFFT_3D(sizes3D[i], sizes3D[i], sizes3D[i]);
            err = 0.0;
            a = new float[2 * sizes3D[i] * sizes3D[i] * sizes3D[i]];
            IOUtils.fillMatrix_3D(sizes3D[i], sizes3D[i], sizes3D[i], a);
            b = new float[2 * sizes3D[i] * sizes3D[i] * sizes3D[i]];
            s = 0;
            while (s < sizes3D[i]) {
                r = 0;
                while (r < sizes3D[i]) {
                    c = 0;
                    while (c < sizes3D[i]) {
                        b[s * 2 * AccuracyCheckFloatFFT.sizes3D[i] * AccuracyCheckFloatFFT.sizes3D[i] + r * 2 * AccuracyCheckFloatFFT.sizes3D[i] + 2 * c] = a[s * sizes3D[i] * sizes3D[i] + r * sizes3D[i] + c];
                        ++c;
                    }
                    ++r;
                }
                ++s;
            }
            fft3.realForwardFull((float[])a);
            fft3.complexInverse((float[])a, true);
            err = AccuracyCheckFloatFFT.computeRMSE(a, b);
            if (err > eps) {
                System.err.println("\tsize = " + sizes3D[i] + " x " + sizes3D[i] + " x " + sizes3D[i] + ";\t\terror = " + err);
            } else {
                System.out.println("\tsize = " + sizes3D[i] + " x " + sizes3D[i] + " x " + sizes3D[i] + ";\t\terror = " + err);
            }
            a = null;
            b = null;
            fft3 = null;
            System.gc();
            ++i;
        }
        System.out.println("Checking accuracy of 3D real forward full FFT (float[][][] input)...");
        i = 0;
        while (i < sizes3D.length) {
            fft3 = new FloatFFT_3D(sizes3D[i], sizes3D[i], sizes3D[i]);
            err = 0.0;
            a = new float[sizes3D[i]][sizes3D[i]][2 * sizes3D[i]];
            IOUtils.fillMatrix_3D(sizes3D[i], sizes3D[i], sizes3D[i], (float[][][])a);
            b = new float[sizes3D[i]][sizes3D[i]][2 * sizes3D[i]];
            s = 0;
            while (s < sizes3D[i]) {
                r = 0;
                while (r < sizes3D[i]) {
                    c = 0;
                    while (c < sizes3D[i]) {
                        b[s][r][2 * c] = a[s][r][c];
                        ++c;
                    }
                    ++r;
                }
                ++s;
            }
            fft3.realForwardFull((float[][][])a);
            fft3.complexInverse((float[][][])a, true);
            err = AccuracyCheckFloatFFT.computeRMSE((float[][][])a, (float[][][])b);
            if (err > eps) {
                System.err.println("\tsize = " + sizes3D[i] + " x " + sizes3D[i] + " x " + sizes3D[i] + ";\t\terror = " + err);
            } else {
                System.out.println("\tsize = " + sizes3D[i] + " x " + sizes3D[i] + " x " + sizes3D[i] + ";\t\terror = " + err);
            }
            a = null;
            b = null;
            fft3 = null;
            System.gc();
            ++i;
        }
        System.out.println("Checking accuracy of 3D real inverse full FFT (float[] input)...");
        i = 0;
        while (i < sizes3D.length) {
            fft3 = new FloatFFT_3D(sizes3D[i], sizes3D[i], sizes3D[i]);
            err = 0.0;
            a = new float[2 * sizes3D[i] * sizes3D[i] * sizes3D[i]];
            IOUtils.fillMatrix_3D(sizes3D[i], sizes3D[i], sizes3D[i], a);
            b = new float[2 * sizes3D[i] * sizes3D[i] * sizes3D[i]];
            s = 0;
            while (s < sizes3D[i]) {
                r = 0;
                while (r < sizes3D[i]) {
                    c = 0;
                    while (c < sizes3D[i]) {
                        b[s * 2 * AccuracyCheckFloatFFT.sizes3D[i] * AccuracyCheckFloatFFT.sizes3D[i] + r * 2 * AccuracyCheckFloatFFT.sizes3D[i] + 2 * c] = a[s * sizes3D[i] * sizes3D[i] + r * sizes3D[i] + c];
                        ++c;
                    }
                    ++r;
                }
                ++s;
            }
            fft3.realInverseFull((float[])a, true);
            fft3.complexForward((float[])a);
            err = AccuracyCheckFloatFFT.computeRMSE(a, b);
            if (err > eps) {
                System.err.println("\tsize = " + sizes3D[i] + " x " + sizes3D[i] + " x " + sizes3D[i] + ";\t\terror = " + err);
            } else {
                System.out.println("\tsize = " + sizes3D[i] + " x " + sizes3D[i] + " x " + sizes3D[i] + ";\t\terror = " + err);
            }
            a = null;
            b = null;
            fft3 = null;
            System.gc();
            ++i;
        }
        System.out.println("Checking accuracy of 3D real inverse full FFT (float[][][] input)...");
        i = 0;
        while (i < sizes3D.length) {
            fft3 = new FloatFFT_3D(sizes3D[i], sizes3D[i], sizes3D[i]);
            err = 0.0;
            a = new float[sizes3D[i]][sizes3D[i]][2 * sizes3D[i]];
            IOUtils.fillMatrix_3D(sizes3D[i], sizes3D[i], sizes3D[i], (float[][][])a);
            b = new float[sizes3D[i]][sizes3D[i]][2 * sizes3D[i]];
            s = 0;
            while (s < sizes3D[i]) {
                r = 0;
                while (r < sizes3D[i]) {
                    c = 0;
                    while (c < sizes3D[i]) {
                        b[s][r][2 * c] = a[s][r][c];
                        ++c;
                    }
                    ++r;
                }
                ++s;
            }
            fft3.realInverseFull((float[][][])a, true);
            fft3.complexForward((float[][][])a);
            err = AccuracyCheckFloatFFT.computeRMSE((float[][][])a, (float[][][])b);
            if (err > eps) {
                System.err.println("\tsize = " + sizes3D[i] + " x " + sizes3D[i] + " x " + sizes3D[i] + ";\t\terror = " + err);
            } else {
                System.out.println("\tsize = " + sizes3D[i] + " x " + sizes3D[i] + " x " + sizes3D[i] + ";\t\terror = " + err);
            }
            a = null;
            b = null;
            fft3 = null;
            System.gc();
            ++i;
        }
    }

    private static double computeRMSE(float[] a, float[] b) {
        if (a.length != b.length) {
            throw new IllegalArgumentException("Arrays are not the same size.");
        }
        double rms = 0.0;
        int i = 0;
        while (i < a.length) {
            double tmp = a[i] - b[i];
            rms += tmp * tmp;
            ++i;
        }
        return Math.sqrt(rms / (double)a.length);
    }

    private static double computeRMSE(float[][] a, float[][] b) {
        if (a.length != b.length || a[0].length != b[0].length) {
            throw new IllegalArgumentException("Arrays are not the same size.");
        }
        double rms = 0.0;
        int r = 0;
        while (r < a.length) {
            int c = 0;
            while (c < a[0].length) {
                double tmp = a[r][c] - b[r][c];
                rms += tmp * tmp;
                ++c;
            }
            ++r;
        }
        return Math.sqrt(rms / (double)(a.length * a[0].length));
    }

    private static double computeRMSE(float[][][] a, float[][][] b) {
        if (a.length != b.length || a[0].length != b[0].length || a[0][0].length != b[0][0].length) {
            throw new IllegalArgumentException("Arrays are not the same size.");
        }
        double rms = 0.0;
        int s = 0;
        while (s < a.length) {
            int r = 0;
            while (r < a[0].length) {
                int c = 0;
                while (c < a[0][0].length) {
                    double tmp = a[s][r][c] - b[s][r][c];
                    rms += tmp * tmp;
                    ++c;
                }
                ++r;
            }
            ++s;
        }
        return Math.sqrt(rms / (double)(a.length * a[0].length * a[0][0].length));
    }

    public static void main(String[] args) {
        AccuracyCheckFloatFFT.checkAccuracyComplexFFT_1D();
        AccuracyCheckFloatFFT.checkAccuracyRealFFT_1D();
        AccuracyCheckFloatFFT.checkAccuracyComplexFFT_2D();
        AccuracyCheckFloatFFT.checkAccuracyRealFFT_2D();
        AccuracyCheckFloatFFT.checkAccuracyComplexFFT_3D();
        AccuracyCheckFloatFFT.checkAccuracyRealFFT_3D();
        System.exit(0);
    }
}

