/*
 * Decompiled with CFR 0.152.
 */
package mcib3d.utils;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.io.Opener;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import ij.util.StringSorter;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.io.File;

public class StackFolderOpener {
    private static boolean grayscale;
    private static boolean halfSize;
    private int n;
    private int start;
    private int increment;
    private String filter;

    public ImageStack open(String directory) {
        return this.open(directory, true);
    }

    public ImageStack open(String directory, boolean ijshow) {
        String[] list = new File(directory).list();
        if (list == null) {
            return null;
        }
        StringSorter.sort((String[])list);
        int width = 0;
        int height = 0;
        int type = 0;
        ImageStack stack = null;
        try {
            for (String aList : list) {
                ImagePlus imp;
                if (aList.endsWith(".txt") || (imp = new Opener().openImage(directory, aList)) == null) continue;
                width = imp.getWidth();
                height = imp.getHeight();
                type = imp.getType();
                break;
            }
            this.increment = 1;
            this.n = list.length;
            this.start = 1;
            int count = 0;
            int counter = 0;
            for (int i = this.start - 1; i < list.length; ++i) {
                if (!list[i].endsWith(".tif") || counter++ % this.increment != 0) continue;
                ImagePlus imp = new Opener().openImage(directory, list[i]);
                if (imp != null && stack == null) {
                    width = imp.getWidth();
                    height = imp.getHeight();
                    type = imp.getType();
                    ColorModel cm = imp.getProcessor().getColorModel();
                    stack = new ImageStack(width, height, cm);
                }
                if (imp == null) {
                    if (ijshow) {
                        IJ.log((String)(list[i] + ": unable to open"));
                    }
                } else if (imp.getWidth() != width || imp.getHeight() != height) {
                    if (ijshow) {
                        IJ.log((String)(list[i] + ": wrong dimensions"));
                    }
                } else if (imp.getType() != type) {
                    if (ijshow) {
                        IJ.log((String)(list[i] + ": wrong type"));
                    }
                } else {
                    count = stack.getSize() + 1;
                    if (ijshow) {
                        IJ.showStatus((String)(count + "/" + this.n));
                    }
                    if (ijshow) {
                        IJ.showProgress((double)((double)count / (double)this.n));
                    }
                    ImageProcessor ip = imp.getProcessor();
                    if (grayscale) {
                        if (this.nonStandardLut(ip)) {
                            ip = new ColorProcessor(imp.getImage());
                        }
                        ip = ip.convertToByte(true);
                    }
                    stack.addSlice(imp.getTitle(), ip);
                }
                if (count < this.n) {
                    continue;
                }
                break;
            }
        }
        catch (OutOfMemoryError e) {
            if (ijshow) {
                IJ.outOfMemory((String)"FolderOpener");
            }
            stack.trim();
        }
        if (ijshow) {
            IJ.showProgress((double)1.0);
        }
        return stack;
    }

    boolean nonStandardLut(ImageProcessor ip) {
        ColorModel cm = ip.getColorModel();
        if (!(cm instanceof IndexColorModel)) {
            return false;
        }
        IndexColorModel icm = (IndexColorModel)cm;
        int mapSize = icm.getMapSize();
        if (mapSize != 256) {
            return true;
        }
        byte[] reds = new byte[256];
        byte[] greens = new byte[256];
        byte[] blues = new byte[256];
        icm.getReds(reds);
        icm.getGreens(greens);
        icm.getBlues(blues);
        boolean isStandard = true;
        int inc = (reds[1] & 0xFF) - (reds[0] & 0xFF);
        for (int i = 0; i < 256; ++i) {
            if (reds[i] != greens[i] || greens[i] != blues[i]) {
                isStandard = false;
                break;
            }
            if (i <= 0 || (reds[i] & 0xFF) - (reds[i - 1] & 0xFF) == inc) continue;
            isStandard = false;
            break;
        }
        return !isStandard;
    }
}

