/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array.impl;

import mitiv.array.Short1D;
import mitiv.array.ShortScalar;
import mitiv.array.impl.Helper;
import mitiv.array.impl.SelectedShort1D;
import mitiv.base.indexing.CompiledRange;
import mitiv.base.indexing.Range;
import mitiv.base.mapping.ShortFunction;
import mitiv.base.mapping.ShortScanner;
import mitiv.random.ShortGenerator;

public class StriddenShort1D
extends Short1D {
    final int order;
    final short[] data;
    final int offset;
    final int stride1;
    final boolean flat;

    public StriddenShort1D(short[] sArray, int n, int[] nArray, int[] nArray2) {
        super(nArray2);
        if (nArray.length != 1) {
            throw new IllegalArgumentException("There must be as many strides as the rank");
        }
        this.data = sArray;
        this.offset = n;
        this.stride1 = nArray[0];
        this.order = Short1D.checkViewStrides(this.data.length, n, this.stride1, this.dim1);
        this.flat = n == 0 && this.stride1 == 1;
    }

    public StriddenShort1D(short[] sArray, int n, int n2, int n3) {
        super(n3);
        this.data = sArray;
        this.offset = n;
        this.stride1 = n2;
        this.order = Short1D.checkViewStrides(this.data.length, n, n2, n3);
        this.flat = n == 0 && n2 == 1;
    }

    @Override
    public void checkSanity() {
        Short1D.checkViewStrides(this.data.length, this.offset, this.stride1, this.dim1);
    }

    final int index(int n) {
        return this.offset + this.stride1 * n;
    }

    @Override
    public final short get(int n) {
        return this.data[this.offset + this.stride1 * n];
    }

    @Override
    public final void set(int n, short s) {
        this.data[this.offset + this.stride1 * n] = s;
    }

    @Override
    public final int getOrder() {
        return this.order;
    }

    @Override
    public void fill(short s) {
        for (int i = 0; i < this.dim1; ++i) {
            int n = this.stride1 * i + this.offset;
            this.data[n] = s;
        }
    }

    @Override
    public void fill(ShortGenerator shortGenerator) {
        for (int i = 0; i < this.dim1; ++i) {
            int n = this.stride1 * i + this.offset;
            this.data[n] = shortGenerator.nextShort();
        }
    }

    @Override
    public void increment(short s) {
        for (int i = 0; i < this.dim1; ++i) {
            int n;
            int n2 = n = this.stride1 * i + this.offset;
            this.data[n2] = (short)(this.data[n2] + s);
        }
    }

    @Override
    public void decrement(short s) {
        for (int i = 0; i < this.dim1; ++i) {
            int n;
            int n2 = n = this.stride1 * i + this.offset;
            this.data[n2] = (short)(this.data[n2] - s);
        }
    }

    @Override
    public void scale(short s) {
        for (int i = 0; i < this.dim1; ++i) {
            int n;
            int n2 = n = this.stride1 * i + this.offset;
            this.data[n2] = (short)(this.data[n2] * s);
        }
    }

    @Override
    public void map(ShortFunction shortFunction) {
        for (int i = 0; i < this.dim1; ++i) {
            int n = this.stride1 * i + this.offset;
            this.data[n] = shortFunction.apply(this.data[n]);
        }
    }

    @Override
    public void scan(ShortScanner shortScanner) {
        boolean bl = false;
        for (int i = 0; i < this.dim1; ++i) {
            int n = this.stride1 * i + this.offset;
            if (bl) {
                shortScanner.update(this.data[n]);
                continue;
            }
            shortScanner.initialize(this.data[n]);
            bl = true;
        }
    }

    @Override
    public final boolean isFlat() {
        return this.flat;
    }

    @Override
    public short[] flatten(boolean bl) {
        if (!bl && this.flat) {
            return this.data;
        }
        short[] sArray = new short[this.number];
        if (this.flat) {
            System.arraycopy(this.data, 0, sArray, 0, this.number);
        } else {
            int n = -1;
            for (int i = 0; i < this.dim1; ++i) {
                int n2 = this.stride1 * i + this.offset;
                sArray[++n] = this.data[n2];
            }
        }
        return sArray;
    }

    @Override
    public short[] getData() {
        return this.flat ? this.data : null;
    }

    @Override
    public ShortScalar slice(int n) {
        return new ShortScalar(this.data, this.offset + this.stride1 * n);
    }

    @Override
    public ShortScalar slice(int n, int n2) {
        if (n2 < 0) {
            ++n2;
        }
        if (n2 != 0) {
            throw new IndexOutOfBoundsException("Dimension index out of bounds");
        }
        int n3 = this.offset + this.stride1 * n;
        return new ShortScalar(this.data, n3);
    }

    @Override
    public Short1D view(Range range) {
        CompiledRange compiledRange = new CompiledRange(range, this.dim1, this.offset, this.stride1);
        if (compiledRange.doesNothing()) {
            return this;
        }
        return new StriddenShort1D(this.data, compiledRange.getOffset(), compiledRange.getStride(), compiledRange.getNumber());
    }

    @Override
    public Short1D view(int[] nArray) {
        int[] nArray2 = Helper.select(this.offset, this.stride1, this.dim1, nArray);
        return new SelectedShort1D(this.data, nArray2);
    }

    @Override
    public Short1D as1D() {
        return this;
    }
}

