/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array.impl;

import mitiv.array.Short1D;
import mitiv.array.ShortScalar;
import mitiv.array.impl.Helper;
import mitiv.array.impl.SelectedShort1D;
import mitiv.array.impl.StriddenShort1D;
import mitiv.base.Shape;
import mitiv.base.indexing.CompiledRange;
import mitiv.base.indexing.Range;
import mitiv.base.mapping.ShortFunction;
import mitiv.base.mapping.ShortScanner;
import mitiv.exception.NonConformableArrayException;
import mitiv.random.ShortGenerator;

public class FlatShort1D
extends Short1D {
    static final int order = 1;
    final short[] data;

    public FlatShort1D(int n) {
        super(n);
        this.data = new short[this.number];
    }

    public FlatShort1D(int[] nArray) {
        super(nArray);
        this.data = new short[this.number];
    }

    public FlatShort1D(Shape shape) {
        super(shape);
        this.data = new short[this.number];
    }

    public FlatShort1D(short[] sArray, int n) {
        super(n);
        this.checkSize(sArray);
        this.data = sArray;
    }

    public FlatShort1D(short[] sArray, int[] nArray) {
        super(nArray);
        this.checkSize(sArray);
        this.data = sArray;
    }

    public FlatShort1D(short[] sArray, Shape shape) {
        super(shape);
        this.checkSize(sArray);
        this.data = sArray;
    }

    @Override
    public void checkSanity() {
        if (this.data == null) {
            throw new NonConformableArrayException("Wrapped array is null");
        }
        if (this.data.length < this.number) {
            throw new NonConformableArrayException("Wrapped array is too small");
        }
    }

    private void checkSize(short[] sArray) {
        if (sArray == null || sArray.length < this.number) {
            throw new NonConformableArrayException("Wrapped array is too small");
        }
    }

    final int index(int n) {
        return n;
    }

    @Override
    public final short get(int n) {
        return this.data[n];
    }

    @Override
    public final void set(int n, short s) {
        this.data[n] = s;
    }

    @Override
    public final int getOrder() {
        return 1;
    }

    @Override
    public void fill(short s) {
        for (int i = 0; i < this.number; ++i) {
            this.data[i] = s;
        }
    }

    @Override
    public void fill(ShortGenerator shortGenerator) {
        for (int i = 0; i < this.number; ++i) {
            this.data[i] = shortGenerator.nextShort();
        }
    }

    @Override
    public void increment(short s) {
        int n = 0;
        while (n < this.number) {
            int n2 = n++;
            this.data[n2] = (short)(this.data[n2] + s);
        }
    }

    @Override
    public void decrement(short s) {
        int n = 0;
        while (n < this.number) {
            int n2 = n++;
            this.data[n2] = (short)(this.data[n2] - s);
        }
    }

    @Override
    public void scale(short s) {
        int n = 0;
        while (n < this.number) {
            int n2 = n++;
            this.data[n2] = (short)(this.data[n2] * s);
        }
    }

    @Override
    public void map(ShortFunction shortFunction) {
        for (int i = 0; i < this.number; ++i) {
            this.data[i] = shortFunction.apply(this.data[i]);
        }
    }

    @Override
    public void scan(ShortScanner shortScanner) {
        shortScanner.initialize(this.data[0]);
        for (int i = 1; i < this.number; ++i) {
            shortScanner.update(this.data[i]);
        }
    }

    @Override
    public final boolean isFlat() {
        return true;
    }

    @Override
    public short[] flatten(boolean bl) {
        if (bl) {
            short[] sArray = new short[this.number];
            System.arraycopy(this.data, 0, sArray, 0, this.number);
            return sArray;
        }
        return this.data;
    }

    @Override
    public short[] getData() {
        return this.data;
    }

    @Override
    public ShortScalar slice(int n) {
        n = Helper.fixIndex(n, this.dim1);
        return new ShortScalar(this.data, n);
    }

    @Override
    public ShortScalar slice(int n, int n2) {
        Helper.fixSliceIndex(n2, 1);
        return new ShortScalar(this.data, Helper.fixIndex(n, this.dim1));
    }

    @Override
    public Short1D view(Range range) {
        CompiledRange compiledRange = new CompiledRange(range, this.dim1, 0, 1);
        if (compiledRange.doesNothing()) {
            return this;
        }
        return new StriddenShort1D(this.data, compiledRange.getOffset(), compiledRange.getStride(), compiledRange.getNumber());
    }

    @Override
    public Short1D view(int[] nArray) {
        int[] nArray2 = Helper.select(0, 1, this.dim1, nArray);
        return new SelectedShort1D(this.data, nArray2);
    }

    @Override
    public Short1D as1D() {
        return this;
    }
}

