/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeval;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import net.sourceforge.jeval.ArgumentTokenizer;
import net.sourceforge.jeval.EvaluationConstants;
import net.sourceforge.jeval.EvaluationException;
import net.sourceforge.jeval.EvaluationHelper;
import net.sourceforge.jeval.ExpressionOperand;
import net.sourceforge.jeval.ExpressionOperator;
import net.sourceforge.jeval.ExpressionTree;
import net.sourceforge.jeval.NextOperator;
import net.sourceforge.jeval.ParsedFunction;
import net.sourceforge.jeval.VariableResolver;
import net.sourceforge.jeval.function.Function;
import net.sourceforge.jeval.function.FunctionException;
import net.sourceforge.jeval.function.FunctionResult;
import net.sourceforge.jeval.function.math.MathFunctions;
import net.sourceforge.jeval.function.string.StringFunctions;
import net.sourceforge.jeval.operator.AdditionOperator;
import net.sourceforge.jeval.operator.BooleanAndOperator;
import net.sourceforge.jeval.operator.BooleanNotOperator;
import net.sourceforge.jeval.operator.BooleanOrOperator;
import net.sourceforge.jeval.operator.ClosedParenthesesOperator;
import net.sourceforge.jeval.operator.DivisionOperator;
import net.sourceforge.jeval.operator.EqualOperator;
import net.sourceforge.jeval.operator.GreaterThanOperator;
import net.sourceforge.jeval.operator.GreaterThanOrEqualOperator;
import net.sourceforge.jeval.operator.LessThanOperator;
import net.sourceforge.jeval.operator.LessThanOrEqualOperator;
import net.sourceforge.jeval.operator.ModulusOperator;
import net.sourceforge.jeval.operator.MultiplicationOperator;
import net.sourceforge.jeval.operator.NotEqualOperator;
import net.sourceforge.jeval.operator.OpenParenthesesOperator;
import net.sourceforge.jeval.operator.Operator;
import net.sourceforge.jeval.operator.SubtractionOperator;

public class Evaluator {
    private List operators = new ArrayList();
    private Map functions = new HashMap();
    private Map variables = new HashMap();
    private char quoteCharacter = (char)39;
    private Operator openParenthesesOperator = new OpenParenthesesOperator();
    private Operator closedParenthesesOperator = new ClosedParenthesesOperator();
    private boolean loadMathVariables;
    private boolean loadMathFunctions;
    private boolean loadStringFunctions;
    private boolean processNestedFunctions;
    private String previousExpression = null;
    private Stack previousOperatorStack = null;
    private Stack previousOperandStack = null;
    private Stack operatorStack = null;
    private Stack operandStack = null;
    private VariableResolver variableResolver = null;

    public Evaluator() {
        this('\'', true, true, true, true);
    }

    public Evaluator(char quoteCharacter, boolean loadMathVariables, boolean loadMathFunctions, boolean loadStringFunctions, boolean processNestedFunctions) {
        this.installOperators();
        this.loadMathVariables = loadMathVariables;
        this.loadSystemVariables();
        this.loadMathFunctions = loadMathFunctions;
        this.loadStringFunctions = loadStringFunctions;
        this.loadSystemFunctions();
        this.setQuoteCharacter(quoteCharacter);
        this.processNestedFunctions = processNestedFunctions;
    }

    public char getQuoteCharacter() {
        return this.quoteCharacter;
    }

    public void setQuoteCharacter(char quoteCharacter) {
        if (quoteCharacter != '\'' && quoteCharacter != '\"') {
            throw new IllegalArgumentException("Invalid quote character.");
        }
        this.quoteCharacter = quoteCharacter;
    }

    public void putFunction(Function function) {
        this.isValidName(function.getName());
        Function existingFunction = (Function)this.functions.get(function.getName());
        if (existingFunction != null) {
            throw new IllegalArgumentException("A function with the same name already exists.");
        }
        this.functions.put(function.getName(), function);
    }

    public Function getFunction(String functionName) {
        return (Function)this.functions.get(functionName);
    }

    public void removeFunction(String functionName) {
        if (!this.functions.containsKey(functionName)) {
            throw new IllegalArgumentException("The function does not exist.");
        }
        this.functions.remove(functionName);
    }

    public void clearFunctions() {
        this.functions.clear();
        this.loadSystemFunctions();
    }

    public Map getFunctions() {
        return this.functions;
    }

    public void setFunctions(Map functions) {
        this.functions = functions;
    }

    public void putVariable(String variableName, String variableValue) {
        this.isValidName(variableName);
        this.variables.put(variableName, variableValue);
    }

    public String getVariableValue(String variableName) throws EvaluationException {
        String variableValue = null;
        if (this.variableResolver != null) {
            try {
                variableValue = this.variableResolver.resolveVariable(variableName);
            }
            catch (FunctionException fe) {
                throw new EvaluationException(fe.getMessage(), fe);
            }
        }
        if (variableValue == null) {
            variableValue = (String)this.variables.get(variableName);
        }
        if (variableValue == null) {
            throw new EvaluationException("Can not resolve variable with name equal to \"" + variableName + "\".");
        }
        return variableValue;
    }

    public void removeVaraible(String variableName) {
        if (!this.variables.containsKey(variableName)) {
            throw new IllegalArgumentException("The variable does not exist.");
        }
        this.variables.remove(variableName);
    }

    public void clearVariables() {
        this.variables.clear();
        this.loadSystemVariables();
    }

    public Map getVariables() {
        return this.variables;
    }

    public void setVariables(Map variables) {
        this.variables = variables;
    }

    public VariableResolver getVariableResolver() {
        return this.variableResolver;
    }

    public void setVariableResolver(VariableResolver variableResolver) {
        this.variableResolver = variableResolver;
    }

    public String evaluate(String expression) throws EvaluationException {
        return this.evaluate(expression, true, true);
    }

    public String evaluate() throws EvaluationException {
        String expression = this.previousExpression;
        if (expression == null || expression.length() == 0) {
            throw new EvaluationException("No expression has been specified.");
        }
        return this.evaluate(expression, true, true);
    }

    public String evaluate(String expression, boolean keepQuotes, boolean wrapStringFunctionResults) throws EvaluationException {
        this.parse(expression);
        String result = this.getResult(this.operatorStack, this.operandStack, wrapStringFunctionResults);
        if (this.isExpressionString(result) && !keepQuotes) {
            result = result.substring(1, result.length() - 1);
        }
        return result;
    }

    public String evaluate(boolean keepQuotes, boolean wrapStringFunctionResults) throws EvaluationException {
        String expression = this.previousExpression;
        if (expression == null || expression.length() == 0) {
            throw new EvaluationException("No expression has been specified.");
        }
        return this.evaluate(expression, keepQuotes, wrapStringFunctionResults);
    }

    public boolean getBooleanResult(String expression) throws EvaluationException {
        String result = this.evaluate(expression);
        try {
            Double doubleResult = new Double(result);
            if (doubleResult == 1.0) {
                return true;
            }
        }
        catch (NumberFormatException exception) {
            return false;
        }
        return false;
    }

    public double getNumberResult(String expression) throws EvaluationException {
        String result = this.evaluate(expression);
        Double doubleResult = null;
        try {
            doubleResult = new Double(result);
        }
        catch (NumberFormatException nfe) {
            throw new EvaluationException("Expression does not produce a number.", nfe);
        }
        return doubleResult;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void parse(String expression) throws EvaluationException {
        boolean parse = true;
        if (!expression.equals(this.previousExpression)) {
            this.previousExpression = expression;
        } else {
            parse = false;
            this.operatorStack = (Stack)this.previousOperatorStack.clone();
            this.operandStack = (Stack)this.previousOperandStack.clone();
        }
        try {
            if (!parse) return;
            this.operandStack = new Stack();
            this.operatorStack = new Stack();
            boolean haveOperand = false;
            boolean haveOperator = false;
            Operator unaryOperator = null;
            int numChars = expression.length();
            int charCtr = 0;
            while (charCtr < numChars) {
                Operator operator = null;
                int operatorIndex = -1;
                if (EvaluationHelper.isSpace(expression.charAt(charCtr))) {
                    ++charCtr;
                    continue;
                }
                NextOperator nextOperator = this.getNextOperator(expression, charCtr, null);
                if (nextOperator != null) {
                    operator = nextOperator.getOperator();
                    operatorIndex = nextOperator.getIndex();
                }
                if (operatorIndex > charCtr || operatorIndex == -1) {
                    charCtr = this.processOperand(expression, charCtr, operatorIndex, this.operandStack, unaryOperator);
                    haveOperand = true;
                    haveOperator = false;
                    unaryOperator = null;
                }
                if (operatorIndex != charCtr) continue;
                if (nextOperator.getOperator().isUnary() && (haveOperator || charCtr == 0)) {
                    charCtr = this.processUnaryOperator(operatorIndex, nextOperator.getOperator());
                    if (unaryOperator != null) throw new EvaluationException("Consecutive unary operators are not allowed (index=" + charCtr + ").");
                    unaryOperator = nextOperator.getOperator();
                } else {
                    charCtr = this.processOperator(expression, operatorIndex, operator, this.operatorStack, this.operandStack, haveOperand, unaryOperator);
                    unaryOperator = null;
                }
                if (nextOperator.getOperator() instanceof ClosedParenthesesOperator) continue;
                haveOperand = false;
                haveOperator = true;
            }
            this.previousOperatorStack = (Stack)this.operatorStack.clone();
            this.previousOperandStack = (Stack)this.operandStack.clone();
            return;
        }
        catch (Exception e) {
            this.previousExpression = "";
            throw new EvaluationException(e.getMessage(), e);
        }
    }

    private void installOperators() {
        this.operators.add(this.openParenthesesOperator);
        this.operators.add(this.closedParenthesesOperator);
        this.operators.add(new AdditionOperator());
        this.operators.add(new SubtractionOperator());
        this.operators.add(new MultiplicationOperator());
        this.operators.add(new DivisionOperator());
        this.operators.add(new EqualOperator());
        this.operators.add(new NotEqualOperator());
        this.operators.add(new LessThanOrEqualOperator());
        this.operators.add(new LessThanOperator());
        this.operators.add(new GreaterThanOrEqualOperator());
        this.operators.add(new GreaterThanOperator());
        this.operators.add(new BooleanAndOperator());
        this.operators.add(new BooleanOrOperator());
        this.operators.add(new BooleanNotOperator());
        this.operators.add(new ModulusOperator());
    }

    private int processOperand(String expression, int charCtr, int operatorIndex, Stack operandStack, Operator unaryOperator) throws EvaluationException {
        String operandString = null;
        int rtnCtr = -1;
        if (operatorIndex == -1) {
            operandString = expression.substring(charCtr).trim();
            rtnCtr = expression.length();
        } else {
            operandString = expression.substring(charCtr, operatorIndex).trim();
            rtnCtr = operatorIndex;
        }
        if (operandString.length() == 0) {
            throw new EvaluationException("Expression is invalid.");
        }
        ExpressionOperand operand = new ExpressionOperand(operandString, unaryOperator);
        operandStack.push(operand);
        return rtnCtr;
    }

    private int processOperator(String expression, int originalOperatorIndex, Operator originalOperator, Stack operatorStack, Stack operandStack, boolean haveOperand, Operator unaryOperator) throws EvaluationException {
        ExpressionOperator stackOperator;
        ExpressionOperator expressionOperator;
        int operatorIndex = originalOperatorIndex;
        Operator operator = originalOperator;
        if (haveOperand && operator instanceof OpenParenthesesOperator) {
            NextOperator nextOperator = this.processFunction(expression, operatorIndex, operandStack);
            operator = nextOperator.getOperator();
            operatorIndex = nextOperator.getIndex() + operator.getLength();
            if ((nextOperator = this.getNextOperator(expression, operatorIndex, null)) != null) {
                operator = nextOperator.getOperator();
                operatorIndex = nextOperator.getIndex();
            } else {
                return operatorIndex;
            }
        }
        if (operator instanceof OpenParenthesesOperator) {
            expressionOperator = new ExpressionOperator(operator, unaryOperator);
            operatorStack.push(expressionOperator);
        } else if (operator instanceof ClosedParenthesesOperator) {
            stackOperator = null;
            if (operatorStack.size() > 0) {
                stackOperator = (ExpressionOperator)operatorStack.peek();
            }
            while (stackOperator != null && !(stackOperator.getOperator() instanceof OpenParenthesesOperator)) {
                this.processTree(operandStack, operatorStack);
                if (operatorStack.size() > 0) {
                    stackOperator = (ExpressionOperator)operatorStack.peek();
                    continue;
                }
                stackOperator = null;
            }
            if (operatorStack.isEmpty()) {
                throw new EvaluationException("Expression is invalid.");
            }
            ExpressionOperator expressionOperator2 = (ExpressionOperator)operatorStack.pop();
            if (!(expressionOperator2.getOperator() instanceof OpenParenthesesOperator)) {
                throw new EvaluationException("Expression is invalid.");
            }
            if (expressionOperator2.getUnaryOperator() != null) {
                Object operand = operandStack.pop();
                ExpressionTree tree = new ExpressionTree(this, operand, null, null, expressionOperator2.getUnaryOperator());
                operandStack.push(tree);
            }
        } else {
            if (operatorStack.size() > 0) {
                stackOperator = (ExpressionOperator)operatorStack.peek();
                while (stackOperator != null && stackOperator.getOperator().getPrecedence() >= operator.getPrecedence()) {
                    this.processTree(operandStack, operatorStack);
                    if (operatorStack.size() > 0) {
                        stackOperator = (ExpressionOperator)operatorStack.peek();
                        continue;
                    }
                    stackOperator = null;
                }
            }
            expressionOperator = new ExpressionOperator(operator, unaryOperator);
            operatorStack.push(expressionOperator);
        }
        int rtnCtr = operatorIndex + operator.getLength();
        return rtnCtr;
    }

    private int processUnaryOperator(int operatorIndex, Operator operator) {
        int rtnCtr = operatorIndex + operator.getSymbol().length();
        return rtnCtr;
    }

    private NextOperator processFunction(String expression, int operatorIndex, Stack operandStack) throws EvaluationException {
        int parenthesisCount = 1;
        NextOperator nextOperator = null;
        int nextOperatorIndex = operatorIndex;
        while (parenthesisCount > 0) {
            nextOperator = this.getNextOperator(expression, nextOperatorIndex + 1, null);
            if (nextOperator == null) {
                throw new EvaluationException("Function is not closed.");
            }
            if (nextOperator.getOperator() instanceof OpenParenthesesOperator) {
                ++parenthesisCount;
            } else if (nextOperator.getOperator() instanceof ClosedParenthesesOperator) {
                --parenthesisCount;
            }
            nextOperatorIndex = nextOperator.getIndex();
        }
        String arguments = expression.substring(operatorIndex + 1, nextOperatorIndex);
        ExpressionOperand operand = (ExpressionOperand)operandStack.pop();
        Operator unaryOperator = operand.getUnaryOperator();
        String functionName = operand.getValue();
        try {
            this.isValidName(functionName);
        }
        catch (IllegalArgumentException iae) {
            throw new EvaluationException("Invalid function name of \"" + functionName + "\".", iae);
        }
        Function function = (Function)this.functions.get(functionName);
        if (function == null) {
            throw new EvaluationException("A function is not defined (index=" + operatorIndex + ").");
        }
        ParsedFunction parsedFunction = new ParsedFunction(function, arguments, unaryOperator);
        operandStack.push(parsedFunction);
        return nextOperator;
    }

    private void processTree(Stack operandStack, Stack operatorStack) {
        Object rightOperand = null;
        Object leftOperand = null;
        Operator operator = null;
        if (operandStack.size() > 0) {
            rightOperand = operandStack.pop();
        }
        if (operandStack.size() > 0) {
            leftOperand = operandStack.pop();
        }
        operator = ((ExpressionOperator)operatorStack.pop()).getOperator();
        ExpressionTree tree = new ExpressionTree(this, leftOperand, rightOperand, operator, null);
        operandStack.push(tree);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getResult(Stack operatorStack, Stack operandStack, boolean wrapStringFunctionResults) throws EvaluationException {
        String resultString = null;
        while (operatorStack.size() > 0) {
            this.processTree(operandStack, operatorStack);
        }
        if (operandStack.size() != 1) {
            throw new EvaluationException("Expression is invalid.");
        }
        Object finalOperand = operandStack.pop();
        if (finalOperand instanceof ExpressionTree) {
            return ((ExpressionTree)finalOperand).evaluate(wrapStringFunctionResults);
        }
        if (finalOperand instanceof ExpressionOperand) {
            ExpressionOperand resultExpressionOperand = (ExpressionOperand)finalOperand;
            resultString = ((ExpressionOperand)finalOperand).getValue();
            if (!this.isExpressionString(resultString = this.replaceVariables(resultString))) {
                Double resultDouble = null;
                try {
                    resultDouble = new Double(resultString);
                }
                catch (Exception e) {
                    throw new EvaluationException("Expression is invalid.", e);
                }
                if (resultExpressionOperand.getUnaryOperator() == null) return resultDouble.toString();
                resultDouble = new Double(resultExpressionOperand.getUnaryOperator().evaluate(resultDouble));
                return resultDouble.toString();
            }
            if (resultExpressionOperand.getUnaryOperator() == null) return resultString;
            throw new EvaluationException("Invalid operand for unary operator.");
        }
        if (!(finalOperand instanceof ParsedFunction)) throw new EvaluationException("Expression is invalid.");
        ParsedFunction parsedFunction = (ParsedFunction)finalOperand;
        Function function = parsedFunction.getFunction();
        String arguments = parsedFunction.getArguments();
        if (this.processNestedFunctions) {
            arguments = this.processNestedFunctions(arguments);
        }
        arguments = this.replaceVariables(arguments);
        try {
            FunctionResult functionResult = function.execute(this, arguments);
            resultString = functionResult.getResult();
            if (functionResult.getType() == 0) {
                Double resultDouble = new Double(resultString);
                if (parsedFunction.getUnaryOperator() == null) return resultDouble.toString();
                resultDouble = new Double(parsedFunction.getUnaryOperator().evaluate(resultDouble));
                return resultDouble.toString();
            }
            if (functionResult.getType() != 1) return resultString;
            if (wrapStringFunctionResults) {
                resultString = this.quoteCharacter + resultString + this.quoteCharacter;
            }
            if (parsedFunction.getUnaryOperator() == null) return resultString;
            throw new EvaluationException("Invalid operand for unary operator.");
        }
        catch (FunctionException fe) {
            throw new EvaluationException(fe.getMessage(), fe);
        }
    }

    private NextOperator getNextOperator(String expression, int start, Operator match) {
        int numChars = expression.length();
        int numQuoteCharacters = 0;
        for (int charCtr = start; charCtr < numChars; ++charCtr) {
            if (expression.charAt(charCtr) == this.quoteCharacter) {
                ++numQuoteCharacters;
            }
            if (numQuoteCharacters % 2 == 1) continue;
            int numOperators = this.operators.size();
            for (int operatorCtr = 0; operatorCtr < numOperators; ++operatorCtr) {
                Operator operator = (Operator)this.operators.get(operatorCtr);
                if (match != null && !match.equals(operator)) continue;
                if (operator.getLength() == 2) {
                    int endCtr = -1;
                    endCtr = charCtr + 2 <= expression.length() ? charCtr + 2 : expression.length();
                    if (!expression.substring(charCtr, endCtr).equals(operator.getSymbol())) continue;
                    NextOperator nextOperator = new NextOperator(operator, charCtr);
                    return nextOperator;
                }
                if (expression.charAt(charCtr) != operator.getSymbol().charAt(0)) continue;
                NextOperator nextOperator = new NextOperator(operator, charCtr);
                return nextOperator;
            }
        }
        return null;
    }

    protected boolean isExpressionString(String expressionString) throws EvaluationException {
        if (expressionString.length() > 1 && expressionString.charAt(0) == this.quoteCharacter && expressionString.charAt(expressionString.length() - 1) == this.quoteCharacter) {
            return true;
        }
        if (expressionString.indexOf(this.quoteCharacter) >= 0) {
            throw new EvaluationException("Invalid use of quotes.");
        }
        return false;
    }

    public void isValidName(String name) throws IllegalArgumentException {
        if (name.length() == 0) {
            throw new IllegalArgumentException("Variable is empty.");
        }
        char firstChar = name.charAt(0);
        if (firstChar >= '0' && firstChar <= '9') {
            throw new IllegalArgumentException("A variable or function name can not start with a number.");
        }
        if (name.indexOf(39) > -1) {
            throw new IllegalArgumentException("A variable or function name can not contain a quote character.");
        }
        if (name.indexOf(34) > -1) {
            throw new IllegalArgumentException("A variable or function name can not contain a quote character.");
        }
        if (name.indexOf(123) > -1) {
            throw new IllegalArgumentException("A variable or function name can not contain an open brace character.");
        }
        if (name.indexOf(125) > -1) {
            throw new IllegalArgumentException("A variable or function name can not contain a closed brace character.");
        }
        if (name.indexOf(35) > -1) {
            throw new IllegalArgumentException("A variable or function name can not contain a pound sign character.");
        }
        for (Operator operator : this.operators) {
            if (name.indexOf(operator.getSymbol()) <= -1) continue;
            throw new IllegalArgumentException("A variable or function name can not contain an operator symbol.");
        }
        if (name.indexOf("!") > -1) {
            throw new IllegalArgumentException("A variable or function name can not contain a special character.");
        }
        if (name.indexOf("~") > -1) {
            throw new IllegalArgumentException("A variable or function name can not contain a special character.");
        }
        if (name.indexOf("^") > -1) {
            throw new IllegalArgumentException("A variable or function name can not contain a special character.");
        }
        if (name.indexOf(",") > -1) {
            throw new IllegalArgumentException("A variable or function name can not contain a special character.");
        }
    }

    private void loadSystemFunctions() {
        if (this.loadMathFunctions) {
            MathFunctions mathFunctions = new MathFunctions();
            mathFunctions.load(this);
        }
        if (this.loadStringFunctions) {
            StringFunctions stringFunctions = new StringFunctions();
            stringFunctions.load(this);
        }
    }

    private void loadSystemVariables() {
        if (this.loadMathVariables) {
            this.putVariable("E", new Double(Math.E).toString());
            this.putVariable("PI", new Double(Math.PI).toString());
        }
    }

    public String replaceVariables(String expression) throws EvaluationException {
        int openBraceIndex;
        int openIndex = expression.indexOf(EvaluationConstants.OPEN_VARIABLE);
        if (openIndex < 0) {
            return expression;
        }
        String replacedExpression = expression;
        while (openIndex >= 0) {
            int closedIndex = -1;
            if (openIndex >= 0) {
                closedIndex = replacedExpression.indexOf(EvaluationConstants.CLOSED_VARIABLE, openIndex + 1);
                if (closedIndex <= openIndex) break;
                String variableName = replacedExpression.substring(openIndex + EvaluationConstants.OPEN_VARIABLE.length(), closedIndex);
                try {
                    this.isValidName(variableName);
                }
                catch (IllegalArgumentException iae) {
                    throw new EvaluationException("Invalid variable name of \"" + variableName + "\".", iae);
                }
                String variableValue = this.getVariableValue(variableName);
                String variableString = EvaluationConstants.OPEN_VARIABLE + variableName + EvaluationConstants.CLOSED_VARIABLE;
                replacedExpression = EvaluationHelper.replaceAll(replacedExpression, variableString, variableValue);
            }
            openIndex = replacedExpression.indexOf(EvaluationConstants.OPEN_VARIABLE);
        }
        if ((openBraceIndex = replacedExpression.indexOf(EvaluationConstants.OPEN_VARIABLE)) > -1) {
            throw new EvaluationException("A variable has not been closed (index=" + openBraceIndex + ").");
        }
        return replacedExpression;
    }

    protected String processNestedFunctions(String arguments) throws EvaluationException {
        StringBuffer evaluatedArguments = new StringBuffer();
        if (arguments.length() > 0) {
            Evaluator argumentsEvaluator = new Evaluator(this.quoteCharacter, this.loadMathVariables, this.loadMathFunctions, this.loadStringFunctions, this.processNestedFunctions);
            argumentsEvaluator.setFunctions(this.getFunctions());
            argumentsEvaluator.setVariables(this.getVariables());
            argumentsEvaluator.setVariableResolver(this.getVariableResolver());
            ArgumentTokenizer tokenizer = new ArgumentTokenizer(arguments, ',');
            ArrayList<String> evalautedArgumentList = new ArrayList<String>();
            while (tokenizer.hasMoreTokens()) {
                String argument = tokenizer.nextToken().trim();
                try {
                    argument = argumentsEvaluator.evaluate(argument);
                }
                catch (Exception e) {
                    throw new EvaluationException(e.getMessage(), e);
                }
                evalautedArgumentList.add(argument);
            }
            Iterator evaluatedArgumentIterator = evalautedArgumentList.iterator();
            while (evaluatedArgumentIterator.hasNext()) {
                if (evaluatedArguments.length() > 0) {
                    evaluatedArguments.append(',');
                }
                String evaluatedArgument = (String)evaluatedArgumentIterator.next();
                evaluatedArguments.append(evaluatedArgument);
            }
        }
        return evaluatedArguments.toString();
    }

    public boolean isLoadMathVariables() {
        return this.loadMathVariables;
    }

    public boolean getLoadMathFunctions() {
        return this.loadMathFunctions;
    }

    public boolean getLoadStringFunctions() {
        return this.loadStringFunctions;
    }

    public boolean getProcessNestedFunctions() {
        return this.processNestedFunctions;
    }
}

