/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.tools;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import loci.common.xml.XMLTools;
import loci.formats.tiff.TiffParser;
import loci.formats.tools.CommandLineTools;

public class XMLValidate {
    public static void process(String label, BufferedReader in) throws IOException {
        String line;
        StringBuffer sb = new StringBuffer();
        while ((line = in.readLine()) != null) {
            sb.append(line);
        }
        in.close();
        XMLTools.validateXML(sb.toString(), label);
    }

    public static void main(String[] args) throws Exception {
        CommandLineTools.runUpgradeCheck(args);
        if (args.length == 0) {
            XMLValidate.process("<stdin>", new BufferedReader(new InputStreamReader(System.in, "UTF-8")));
        } else {
            for (int i = 0; i < args.length; ++i) {
                if (args[i].toLowerCase().endsWith("tif") || args[i].toLowerCase().endsWith("tiff")) {
                    String comment = new TiffParser(args[i]).getComment();
                    XMLValidate.process(args[i], new BufferedReader(new StringReader(comment)));
                    continue;
                }
                XMLValidate.process(args[i], new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(args[i]), "UTF-8")));
            }
        }
    }
}

