/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array;

import mitiv.array.Array1D;
import mitiv.array.Array2D;
import mitiv.array.Array3D;
import mitiv.array.Array4D;
import mitiv.array.Array5D;
import mitiv.array.Array6D;
import mitiv.array.Array7D;
import mitiv.array.Array8D;
import mitiv.array.Array9D;
import mitiv.array.Byte1D;
import mitiv.array.Byte2D;
import mitiv.array.Byte3D;
import mitiv.array.Byte4D;
import mitiv.array.Byte5D;
import mitiv.array.Byte6D;
import mitiv.array.Byte7D;
import mitiv.array.Byte8D;
import mitiv.array.Byte9D;
import mitiv.array.ByteArray;
import mitiv.array.ByteScalar;
import mitiv.array.Double1D;
import mitiv.array.Double2D;
import mitiv.array.Double3D;
import mitiv.array.Double4D;
import mitiv.array.Double5D;
import mitiv.array.Double6D;
import mitiv.array.Double7D;
import mitiv.array.Double8D;
import mitiv.array.Double9D;
import mitiv.array.DoubleArray;
import mitiv.array.DoubleScalar;
import mitiv.array.Float1D;
import mitiv.array.Float2D;
import mitiv.array.Float3D;
import mitiv.array.Float4D;
import mitiv.array.Float5D;
import mitiv.array.Float6D;
import mitiv.array.Float7D;
import mitiv.array.Float8D;
import mitiv.array.Float9D;
import mitiv.array.FloatArray;
import mitiv.array.FloatScalar;
import mitiv.array.Int1D;
import mitiv.array.Int2D;
import mitiv.array.Int3D;
import mitiv.array.Int4D;
import mitiv.array.Int5D;
import mitiv.array.Int6D;
import mitiv.array.Int7D;
import mitiv.array.Int8D;
import mitiv.array.Int9D;
import mitiv.array.IntArray;
import mitiv.array.IntScalar;
import mitiv.array.Long1D;
import mitiv.array.Long2D;
import mitiv.array.Long3D;
import mitiv.array.Long4D;
import mitiv.array.Long5D;
import mitiv.array.Long6D;
import mitiv.array.Long7D;
import mitiv.array.Long8D;
import mitiv.array.Long9D;
import mitiv.array.LongArray;
import mitiv.array.LongScalar;
import mitiv.array.Scalar;
import mitiv.array.ShapedArray;
import mitiv.array.Short1D;
import mitiv.array.Short2D;
import mitiv.array.Short3D;
import mitiv.array.Short4D;
import mitiv.array.Short5D;
import mitiv.array.Short6D;
import mitiv.array.Short7D;
import mitiv.array.Short8D;
import mitiv.array.Short9D;
import mitiv.array.ShortArray;
import mitiv.array.ShortScalar;
import mitiv.base.Shape;
import mitiv.exception.IllegalTypeException;
import mitiv.linalg.shaped.DoubleShapedVector;
import mitiv.linalg.shaped.FloatShapedVector;
import mitiv.linalg.shaped.ShapedVector;

public class ArrayFactory {
    public static final ArrayFactory factory = new ArrayFactory();

    protected ArrayFactory() {
    }

    public static Scalar create(int n) {
        switch (n) {
            case 0: {
                return new ByteScalar();
            }
            case 1: {
                return new ShortScalar();
            }
            case 2: {
                return new IntScalar();
            }
            case 3: {
                return new LongScalar();
            }
            case 4: {
                return new FloatScalar();
            }
            case 5: {
                return new DoubleScalar();
            }
        }
        throw new IllegalTypeException();
    }

    public static Array1D create(int n, int n2) {
        switch (n) {
            case 0: {
                return Byte1D.create(n2);
            }
            case 1: {
                return Short1D.create(n2);
            }
            case 2: {
                return Int1D.create(n2);
            }
            case 3: {
                return Long1D.create(n2);
            }
            case 4: {
                return Float1D.create(n2);
            }
            case 5: {
                return Double1D.create(n2);
            }
        }
        throw new IllegalTypeException();
    }

    public static Array2D create(int n, int n2, int n3) {
        switch (n) {
            case 0: {
                return Byte2D.create(n2, n3);
            }
            case 1: {
                return Short2D.create(n2, n3);
            }
            case 2: {
                return Int2D.create(n2, n3);
            }
            case 3: {
                return Long2D.create(n2, n3);
            }
            case 4: {
                return Float2D.create(n2, n3);
            }
            case 5: {
                return Double2D.create(n2, n3);
            }
        }
        throw new IllegalTypeException();
    }

    public static Array3D create(int n, int n2, int n3, int n4) {
        switch (n) {
            case 0: {
                return Byte3D.create(n2, n3, n4);
            }
            case 1: {
                return Short3D.create(n2, n3, n4);
            }
            case 2: {
                return Int3D.create(n2, n3, n4);
            }
            case 3: {
                return Long3D.create(n2, n3, n4);
            }
            case 4: {
                return Float3D.create(n2, n3, n4);
            }
            case 5: {
                return Double3D.create(n2, n3, n4);
            }
        }
        throw new IllegalTypeException();
    }

    public static Array4D create(int n, int n2, int n3, int n4, int n5) {
        switch (n) {
            case 0: {
                return Byte4D.create(n2, n3, n4, n5);
            }
            case 1: {
                return Short4D.create(n2, n3, n4, n5);
            }
            case 2: {
                return Int4D.create(n2, n3, n4, n5);
            }
            case 3: {
                return Long4D.create(n2, n3, n4, n5);
            }
            case 4: {
                return Float4D.create(n2, n3, n4, n5);
            }
            case 5: {
                return Double4D.create(n2, n3, n4, n5);
            }
        }
        throw new IllegalTypeException();
    }

    public static Array5D create(int n, int n2, int n3, int n4, int n5, int n6) {
        switch (n) {
            case 0: {
                return Byte5D.create(n2, n3, n4, n5, n6);
            }
            case 1: {
                return Short5D.create(n2, n3, n4, n5, n6);
            }
            case 2: {
                return Int5D.create(n2, n3, n4, n5, n6);
            }
            case 3: {
                return Long5D.create(n2, n3, n4, n5, n6);
            }
            case 4: {
                return Float5D.create(n2, n3, n4, n5, n6);
            }
            case 5: {
                return Double5D.create(n2, n3, n4, n5, n6);
            }
        }
        throw new IllegalTypeException();
    }

    public static Array6D create(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        switch (n) {
            case 0: {
                return Byte6D.create(n2, n3, n4, n5, n6, n7);
            }
            case 1: {
                return Short6D.create(n2, n3, n4, n5, n6, n7);
            }
            case 2: {
                return Int6D.create(n2, n3, n4, n5, n6, n7);
            }
            case 3: {
                return Long6D.create(n2, n3, n4, n5, n6, n7);
            }
            case 4: {
                return Float6D.create(n2, n3, n4, n5, n6, n7);
            }
            case 5: {
                return Double6D.create(n2, n3, n4, n5, n6, n7);
            }
        }
        throw new IllegalTypeException();
    }

    public static Array7D create(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        switch (n) {
            case 0: {
                return Byte7D.create(n2, n3, n4, n5, n6, n7, n8);
            }
            case 1: {
                return Short7D.create(n2, n3, n4, n5, n6, n7, n8);
            }
            case 2: {
                return Int7D.create(n2, n3, n4, n5, n6, n7, n8);
            }
            case 3: {
                return Long7D.create(n2, n3, n4, n5, n6, n7, n8);
            }
            case 4: {
                return Float7D.create(n2, n3, n4, n5, n6, n7, n8);
            }
            case 5: {
                return Double7D.create(n2, n3, n4, n5, n6, n7, n8);
            }
        }
        throw new IllegalTypeException();
    }

    public static Array8D create(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        switch (n) {
            case 0: {
                return Byte8D.create(n2, n3, n4, n5, n6, n7, n8, n9);
            }
            case 1: {
                return Short8D.create(n2, n3, n4, n5, n6, n7, n8, n9);
            }
            case 2: {
                return Int8D.create(n2, n3, n4, n5, n6, n7, n8, n9);
            }
            case 3: {
                return Long8D.create(n2, n3, n4, n5, n6, n7, n8, n9);
            }
            case 4: {
                return Float8D.create(n2, n3, n4, n5, n6, n7, n8, n9);
            }
            case 5: {
                return Double8D.create(n2, n3, n4, n5, n6, n7, n8, n9);
            }
        }
        throw new IllegalTypeException();
    }

    public static Array9D create(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) {
        switch (n) {
            case 0: {
                return Byte9D.create(n2, n3, n4, n5, n6, n7, n8, n9, n10);
            }
            case 1: {
                return Short9D.create(n2, n3, n4, n5, n6, n7, n8, n9, n10);
            }
            case 2: {
                return Int9D.create(n2, n3, n4, n5, n6, n7, n8, n9, n10);
            }
            case 3: {
                return Long9D.create(n2, n3, n4, n5, n6, n7, n8, n9, n10);
            }
            case 4: {
                return Float9D.create(n2, n3, n4, n5, n6, n7, n8, n9, n10);
            }
            case 5: {
                return Double9D.create(n2, n3, n4, n5, n6, n7, n8, n9, n10);
            }
        }
        throw new IllegalTypeException();
    }

    public static ShapedArray create(int n, int[] nArray) {
        int n2 = nArray.length;
        switch (n) {
            case 0: {
                switch (n2) {
                    case 0: {
                        return new ByteScalar();
                    }
                    case 1: {
                        return Byte1D.create(nArray);
                    }
                    case 2: {
                        return Byte2D.create(nArray);
                    }
                    case 3: {
                        return Byte3D.create(nArray);
                    }
                    case 4: {
                        return Byte4D.create(nArray);
                    }
                    case 5: {
                        return Byte5D.create(nArray);
                    }
                    case 6: {
                        return Byte6D.create(nArray);
                    }
                    case 7: {
                        return Byte7D.create(nArray);
                    }
                    case 8: {
                        return Byte8D.create(nArray);
                    }
                    case 9: {
                        return Byte9D.create(nArray);
                    }
                }
                break;
            }
            case 1: {
                switch (n2) {
                    case 0: {
                        return new ShortScalar();
                    }
                    case 1: {
                        return Short1D.create(nArray);
                    }
                    case 2: {
                        return Short2D.create(nArray);
                    }
                    case 3: {
                        return Short3D.create(nArray);
                    }
                    case 4: {
                        return Short4D.create(nArray);
                    }
                    case 5: {
                        return Short5D.create(nArray);
                    }
                    case 6: {
                        return Short6D.create(nArray);
                    }
                    case 7: {
                        return Short7D.create(nArray);
                    }
                    case 8: {
                        return Short8D.create(nArray);
                    }
                    case 9: {
                        return Short9D.create(nArray);
                    }
                }
                break;
            }
            case 2: {
                switch (n2) {
                    case 0: {
                        return new IntScalar();
                    }
                    case 1: {
                        return Int1D.create(nArray);
                    }
                    case 2: {
                        return Int2D.create(nArray);
                    }
                    case 3: {
                        return Int3D.create(nArray);
                    }
                    case 4: {
                        return Int4D.create(nArray);
                    }
                    case 5: {
                        return Int5D.create(nArray);
                    }
                    case 6: {
                        return Int6D.create(nArray);
                    }
                    case 7: {
                        return Int7D.create(nArray);
                    }
                    case 8: {
                        return Int8D.create(nArray);
                    }
                    case 9: {
                        return Int9D.create(nArray);
                    }
                }
                break;
            }
            case 3: {
                switch (n2) {
                    case 0: {
                        return new LongScalar();
                    }
                    case 1: {
                        return Long1D.create(nArray);
                    }
                    case 2: {
                        return Long2D.create(nArray);
                    }
                    case 3: {
                        return Long3D.create(nArray);
                    }
                    case 4: {
                        return Long4D.create(nArray);
                    }
                    case 5: {
                        return Long5D.create(nArray);
                    }
                    case 6: {
                        return Long6D.create(nArray);
                    }
                    case 7: {
                        return Long7D.create(nArray);
                    }
                    case 8: {
                        return Long8D.create(nArray);
                    }
                    case 9: {
                        return Long9D.create(nArray);
                    }
                }
                break;
            }
            case 4: {
                switch (n2) {
                    case 0: {
                        return new FloatScalar();
                    }
                    case 1: {
                        return Float1D.create(nArray);
                    }
                    case 2: {
                        return Float2D.create(nArray);
                    }
                    case 3: {
                        return Float3D.create(nArray);
                    }
                    case 4: {
                        return Float4D.create(nArray);
                    }
                    case 5: {
                        return Float5D.create(nArray);
                    }
                    case 6: {
                        return Float6D.create(nArray);
                    }
                    case 7: {
                        return Float7D.create(nArray);
                    }
                    case 8: {
                        return Float8D.create(nArray);
                    }
                    case 9: {
                        return Float9D.create(nArray);
                    }
                }
                break;
            }
            case 5: {
                switch (n2) {
                    case 0: {
                        return new DoubleScalar();
                    }
                    case 1: {
                        return Double1D.create(nArray);
                    }
                    case 2: {
                        return Double2D.create(nArray);
                    }
                    case 3: {
                        return Double3D.create(nArray);
                    }
                    case 4: {
                        return Double4D.create(nArray);
                    }
                    case 5: {
                        return Double5D.create(nArray);
                    }
                    case 6: {
                        return Double6D.create(nArray);
                    }
                    case 7: {
                        return Double7D.create(nArray);
                    }
                    case 8: {
                        return Double8D.create(nArray);
                    }
                    case 9: {
                        return Double9D.create(nArray);
                    }
                }
                break;
            }
            default: {
                throw new IllegalTypeException();
            }
        }
        throw new IllegalArgumentException("Invalid rank in shape");
    }

    public static ShapedArray create(int n, Shape shape) {
        int n2 = shape.rank();
        switch (n) {
            case 0: {
                switch (n2) {
                    case 0: {
                        return new ByteScalar();
                    }
                    case 1: {
                        return Byte1D.create(shape);
                    }
                    case 2: {
                        return Byte2D.create(shape);
                    }
                    case 3: {
                        return Byte3D.create(shape);
                    }
                    case 4: {
                        return Byte4D.create(shape);
                    }
                    case 5: {
                        return Byte5D.create(shape);
                    }
                    case 6: {
                        return Byte6D.create(shape);
                    }
                    case 7: {
                        return Byte7D.create(shape);
                    }
                    case 8: {
                        return Byte8D.create(shape);
                    }
                    case 9: {
                        return Byte9D.create(shape);
                    }
                }
                break;
            }
            case 1: {
                switch (n2) {
                    case 0: {
                        return new ShortScalar();
                    }
                    case 1: {
                        return Short1D.create(shape);
                    }
                    case 2: {
                        return Short2D.create(shape);
                    }
                    case 3: {
                        return Short3D.create(shape);
                    }
                    case 4: {
                        return Short4D.create(shape);
                    }
                    case 5: {
                        return Short5D.create(shape);
                    }
                    case 6: {
                        return Short6D.create(shape);
                    }
                    case 7: {
                        return Short7D.create(shape);
                    }
                    case 8: {
                        return Short8D.create(shape);
                    }
                    case 9: {
                        return Short9D.create(shape);
                    }
                }
                break;
            }
            case 2: {
                switch (n2) {
                    case 0: {
                        return new IntScalar();
                    }
                    case 1: {
                        return Int1D.create(shape);
                    }
                    case 2: {
                        return Int2D.create(shape);
                    }
                    case 3: {
                        return Int3D.create(shape);
                    }
                    case 4: {
                        return Int4D.create(shape);
                    }
                    case 5: {
                        return Int5D.create(shape);
                    }
                    case 6: {
                        return Int6D.create(shape);
                    }
                    case 7: {
                        return Int7D.create(shape);
                    }
                    case 8: {
                        return Int8D.create(shape);
                    }
                    case 9: {
                        return Int9D.create(shape);
                    }
                }
                break;
            }
            case 3: {
                switch (n2) {
                    case 0: {
                        return new LongScalar();
                    }
                    case 1: {
                        return Long1D.create(shape);
                    }
                    case 2: {
                        return Long2D.create(shape);
                    }
                    case 3: {
                        return Long3D.create(shape);
                    }
                    case 4: {
                        return Long4D.create(shape);
                    }
                    case 5: {
                        return Long5D.create(shape);
                    }
                    case 6: {
                        return Long6D.create(shape);
                    }
                    case 7: {
                        return Long7D.create(shape);
                    }
                    case 8: {
                        return Long8D.create(shape);
                    }
                    case 9: {
                        return Long9D.create(shape);
                    }
                }
                break;
            }
            case 4: {
                switch (n2) {
                    case 0: {
                        return new FloatScalar();
                    }
                    case 1: {
                        return Float1D.create(shape);
                    }
                    case 2: {
                        return Float2D.create(shape);
                    }
                    case 3: {
                        return Float3D.create(shape);
                    }
                    case 4: {
                        return Float4D.create(shape);
                    }
                    case 5: {
                        return Float5D.create(shape);
                    }
                    case 6: {
                        return Float6D.create(shape);
                    }
                    case 7: {
                        return Float7D.create(shape);
                    }
                    case 8: {
                        return Float8D.create(shape);
                    }
                    case 9: {
                        return Float9D.create(shape);
                    }
                }
                break;
            }
            case 5: {
                switch (n2) {
                    case 0: {
                        return new DoubleScalar();
                    }
                    case 1: {
                        return Double1D.create(shape);
                    }
                    case 2: {
                        return Double2D.create(shape);
                    }
                    case 3: {
                        return Double3D.create(shape);
                    }
                    case 4: {
                        return Double4D.create(shape);
                    }
                    case 5: {
                        return Double5D.create(shape);
                    }
                    case 6: {
                        return Double6D.create(shape);
                    }
                    case 7: {
                        return Double7D.create(shape);
                    }
                    case 8: {
                        return Double8D.create(shape);
                    }
                    case 9: {
                        return Double9D.create(shape);
                    }
                }
                break;
            }
            default: {
                throw new IllegalTypeException();
            }
        }
        throw new IllegalArgumentException("Invalid rank in shape");
    }

    @Deprecated
    public ByteArray toByte(ShapedArray shapedArray) {
        if (shapedArray.getType() == 0) {
            return (ByteArray)shapedArray;
        }
        int n = shapedArray.getNumber();
        byte[] byArray = new byte[n];
        switch (shapedArray.getType()) {
            case 1: {
                short[] sArray = ((ShortArray)shapedArray).flatten(false);
                for (int i = 0; i < n; ++i) {
                    byArray[i] = (byte)sArray[i];
                }
                break;
            }
            case 2: {
                int[] nArray = ((IntArray)shapedArray).flatten(false);
                for (int i = 0; i < n; ++i) {
                    byArray[i] = (byte)nArray[i];
                }
                break;
            }
            case 3: {
                long[] lArray = ((LongArray)shapedArray).flatten(false);
                for (int i = 0; i < n; ++i) {
                    byArray[i] = (byte)lArray[i];
                }
                break;
            }
            case 4: {
                float[] fArray = ((FloatArray)shapedArray).flatten(false);
                for (int i = 0; i < n; ++i) {
                    byArray[i] = (byte)fArray[i];
                }
                break;
            }
            case 5: {
                double[] dArray = ((DoubleArray)shapedArray).flatten(false);
                for (int i = 0; i < n; ++i) {
                    byArray[i] = (byte)dArray[i];
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("unexpected type (BUG)");
            }
        }
        return ArrayFactory.wrap(byArray, shapedArray.getShape());
    }

    @Deprecated
    public ShortArray toShort(ShapedArray shapedArray) {
        if (shapedArray.getType() == 1) {
            return (ShortArray)shapedArray;
        }
        int n = shapedArray.getNumber();
        short[] sArray = new short[n];
        switch (shapedArray.getType()) {
            case 0: {
                byte[] byArray = ((ByteArray)shapedArray).flatten(false);
                for (int i = 0; i < n; ++i) {
                    sArray[i] = (short)(byArray[i] & 0xFF);
                }
                break;
            }
            case 2: {
                int[] nArray = ((IntArray)shapedArray).flatten(false);
                for (int i = 0; i < n; ++i) {
                    sArray[i] = (short)nArray[i];
                }
                break;
            }
            case 3: {
                long[] lArray = ((LongArray)shapedArray).flatten(false);
                for (int i = 0; i < n; ++i) {
                    sArray[i] = (short)lArray[i];
                }
                break;
            }
            case 4: {
                float[] fArray = ((FloatArray)shapedArray).flatten(false);
                for (int i = 0; i < n; ++i) {
                    sArray[i] = (short)fArray[i];
                }
                break;
            }
            case 5: {
                double[] dArray = ((DoubleArray)shapedArray).flatten(false);
                for (int i = 0; i < n; ++i) {
                    sArray[i] = (short)dArray[i];
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("unexpected type (BUG)");
            }
        }
        return ArrayFactory.wrap(sArray, shapedArray.getShape());
    }

    @Deprecated
    public IntArray toInt(ShapedArray shapedArray) {
        if (shapedArray.getType() == 2) {
            return (IntArray)shapedArray;
        }
        int n = shapedArray.getNumber();
        int[] nArray = new int[n];
        switch (shapedArray.getType()) {
            case 0: {
                byte[] byArray = ((ByteArray)shapedArray).flatten(false);
                for (int i = 0; i < n; ++i) {
                    nArray[i] = byArray[i] & 0xFF;
                }
                break;
            }
            case 1: {
                short[] sArray = ((ShortArray)shapedArray).flatten(false);
                for (int i = 0; i < n; ++i) {
                    nArray[i] = sArray[i];
                }
                break;
            }
            case 3: {
                long[] lArray = ((LongArray)shapedArray).flatten(false);
                for (int i = 0; i < n; ++i) {
                    nArray[i] = (int)lArray[i];
                }
                break;
            }
            case 4: {
                float[] fArray = ((FloatArray)shapedArray).flatten(false);
                for (int i = 0; i < n; ++i) {
                    nArray[i] = (int)fArray[i];
                }
                break;
            }
            case 5: {
                double[] dArray = ((DoubleArray)shapedArray).flatten(false);
                for (int i = 0; i < n; ++i) {
                    nArray[i] = (int)dArray[i];
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("unexpected type (BUG)");
            }
        }
        return ArrayFactory.wrap(nArray, shapedArray.getShape());
    }

    @Deprecated
    public LongArray toLong(ShapedArray shapedArray) {
        if (shapedArray.getType() == 3) {
            return (LongArray)shapedArray;
        }
        int n = shapedArray.getNumber();
        long[] lArray = new long[n];
        switch (shapedArray.getType()) {
            case 0: {
                byte[] byArray = ((ByteArray)shapedArray).flatten(false);
                for (int i = 0; i < n; ++i) {
                    lArray[i] = byArray[i] & 0xFF;
                }
                break;
            }
            case 1: {
                short[] sArray = ((ShortArray)shapedArray).flatten(false);
                for (int i = 0; i < n; ++i) {
                    lArray[i] = sArray[i];
                }
                break;
            }
            case 2: {
                int[] nArray = ((IntArray)shapedArray).flatten(false);
                for (int i = 0; i < n; ++i) {
                    lArray[i] = nArray[i];
                }
                break;
            }
            case 4: {
                float[] fArray = ((FloatArray)shapedArray).flatten(false);
                for (int i = 0; i < n; ++i) {
                    lArray[i] = (long)fArray[i];
                }
                break;
            }
            case 5: {
                double[] dArray = ((DoubleArray)shapedArray).flatten(false);
                for (int i = 0; i < n; ++i) {
                    lArray[i] = (long)dArray[i];
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("unexpected type (BUG)");
            }
        }
        return ArrayFactory.wrap(lArray, shapedArray.getShape());
    }

    @Deprecated
    public FloatArray toFloat(ShapedArray shapedArray) {
        if (shapedArray.getType() == 4) {
            return (FloatArray)shapedArray;
        }
        int n = shapedArray.getNumber();
        float[] fArray = new float[n];
        switch (shapedArray.getType()) {
            case 0: {
                byte[] byArray = ((ByteArray)shapedArray).flatten(false);
                for (int i = 0; i < n; ++i) {
                    fArray[i] = byArray[i] & 0xFF;
                }
                break;
            }
            case 1: {
                short[] sArray = ((ShortArray)shapedArray).flatten(false);
                for (int i = 0; i < n; ++i) {
                    fArray[i] = sArray[i];
                }
                break;
            }
            case 2: {
                int[] nArray = ((IntArray)shapedArray).flatten(false);
                for (int i = 0; i < n; ++i) {
                    fArray[i] = nArray[i];
                }
                break;
            }
            case 3: {
                long[] lArray = ((LongArray)shapedArray).flatten(false);
                for (int i = 0; i < n; ++i) {
                    fArray[i] = lArray[i];
                }
                break;
            }
            case 5: {
                double[] dArray = ((DoubleArray)shapedArray).flatten(false);
                for (int i = 0; i < n; ++i) {
                    fArray[i] = (float)dArray[i];
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("unexpected type (BUG)");
            }
        }
        return ArrayFactory.wrap(fArray, shapedArray.getShape());
    }

    @Deprecated
    public DoubleArray toDouble(ShapedArray shapedArray) {
        if (shapedArray.getType() == 5) {
            return (DoubleArray)shapedArray;
        }
        int n = shapedArray.getNumber();
        double[] dArray = new double[n];
        switch (shapedArray.getType()) {
            case 0: {
                byte[] byArray = ((ByteArray)shapedArray).flatten(false);
                for (int i = 0; i < n; ++i) {
                    dArray[i] = byArray[i] & 0xFF;
                }
                break;
            }
            case 1: {
                short[] sArray = ((ShortArray)shapedArray).flatten(false);
                for (int i = 0; i < n; ++i) {
                    dArray[i] = sArray[i];
                }
                break;
            }
            case 2: {
                int[] nArray = ((IntArray)shapedArray).flatten(false);
                for (int i = 0; i < n; ++i) {
                    dArray[i] = nArray[i];
                }
                break;
            }
            case 3: {
                long[] lArray = ((LongArray)shapedArray).flatten(false);
                for (int i = 0; i < n; ++i) {
                    dArray[i] = lArray[i];
                }
                break;
            }
            case 4: {
                float[] fArray = ((FloatArray)shapedArray).flatten(false);
                for (int i = 0; i < n; ++i) {
                    dArray[i] = fArray[i];
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("unexpected type (BUG)");
            }
        }
        return ArrayFactory.wrap(dArray, shapedArray.getShape());
    }

    public static ByteScalar wrap(byte[] byArray) {
        return ByteScalar.wrap(byArray, 0);
    }

    public static Byte1D wrap(byte[] byArray, int n) {
        return Byte1D.wrap(byArray, n);
    }

    public static Byte2D wrap(byte[] byArray, int n, int n2) {
        return Byte2D.wrap(byArray, n, n2);
    }

    public static Byte3D wrap(byte[] byArray, int n, int n2, int n3) {
        return Byte3D.wrap(byArray, n, n2, n3);
    }

    public static Byte4D wrap(byte[] byArray, int n, int n2, int n3, int n4) {
        return Byte4D.wrap(byArray, n, n2, n3, n4);
    }

    public static Byte5D wrap(byte[] byArray, int n, int n2, int n3, int n4, int n5) {
        return Byte5D.wrap(byArray, n, n2, n3, n4, n5);
    }

    public static Byte6D wrap(byte[] byArray, int n, int n2, int n3, int n4, int n5, int n6) {
        return Byte6D.wrap(byArray, n, n2, n3, n4, n5, n6);
    }

    public static Byte7D wrap(byte[] byArray, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        return Byte7D.wrap(byArray, n, n2, n3, n4, n5, n6, n7);
    }

    public static Byte8D wrap(byte[] byArray, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        return Byte8D.wrap(byArray, n, n2, n3, n4, n5, n6, n7, n8);
    }

    public static Byte9D wrap(byte[] byArray, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        return Byte9D.wrap(byArray, n, n2, n3, n4, n5, n6, n7, n8, n9);
    }

    public static ByteArray wrap(byte[] byArray, int[] nArray) {
        return ArrayFactory.wrap(byArray, new Shape(nArray));
    }

    public static ByteArray wrap(byte[] byArray, Shape shape) {
        switch (shape.rank()) {
            case 0: {
                return ByteScalar.wrap(byArray, 0);
            }
            case 1: {
                return Byte1D.wrap(byArray, shape);
            }
            case 2: {
                return Byte2D.wrap(byArray, shape);
            }
            case 3: {
                return Byte3D.wrap(byArray, shape);
            }
            case 4: {
                return Byte4D.wrap(byArray, shape);
            }
            case 5: {
                return Byte5D.wrap(byArray, shape);
            }
            case 6: {
                return Byte6D.wrap(byArray, shape);
            }
            case 7: {
                return Byte7D.wrap(byArray, shape);
            }
            case 8: {
                return Byte8D.wrap(byArray, shape);
            }
            case 9: {
                return Byte9D.wrap(byArray, shape);
            }
        }
        throw new IllegalArgumentException("Invalid shape");
    }

    public static ShortScalar wrap(short[] sArray) {
        return ShortScalar.wrap(sArray, 0);
    }

    public static Short1D wrap(short[] sArray, int n) {
        return Short1D.wrap(sArray, n);
    }

    public static Short2D wrap(short[] sArray, int n, int n2) {
        return Short2D.wrap(sArray, n, n2);
    }

    public static Short3D wrap(short[] sArray, int n, int n2, int n3) {
        return Short3D.wrap(sArray, n, n2, n3);
    }

    public static Short4D wrap(short[] sArray, int n, int n2, int n3, int n4) {
        return Short4D.wrap(sArray, n, n2, n3, n4);
    }

    public static Short5D wrap(short[] sArray, int n, int n2, int n3, int n4, int n5) {
        return Short5D.wrap(sArray, n, n2, n3, n4, n5);
    }

    public static Short6D wrap(short[] sArray, int n, int n2, int n3, int n4, int n5, int n6) {
        return Short6D.wrap(sArray, n, n2, n3, n4, n5, n6);
    }

    public static Short7D wrap(short[] sArray, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        return Short7D.wrap(sArray, n, n2, n3, n4, n5, n6, n7);
    }

    public static Short8D wrap(short[] sArray, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        return Short8D.wrap(sArray, n, n2, n3, n4, n5, n6, n7, n8);
    }

    public static Short9D wrap(short[] sArray, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        return Short9D.wrap(sArray, n, n2, n3, n4, n5, n6, n7, n8, n9);
    }

    public static ShortArray wrap(short[] sArray, int[] nArray) {
        return ArrayFactory.wrap(sArray, new Shape(nArray));
    }

    public static ShortArray wrap(short[] sArray, Shape shape) {
        switch (shape.rank()) {
            case 0: {
                return ShortScalar.wrap(sArray, 0);
            }
            case 1: {
                return Short1D.wrap(sArray, shape);
            }
            case 2: {
                return Short2D.wrap(sArray, shape);
            }
            case 3: {
                return Short3D.wrap(sArray, shape);
            }
            case 4: {
                return Short4D.wrap(sArray, shape);
            }
            case 5: {
                return Short5D.wrap(sArray, shape);
            }
            case 6: {
                return Short6D.wrap(sArray, shape);
            }
            case 7: {
                return Short7D.wrap(sArray, shape);
            }
            case 8: {
                return Short8D.wrap(sArray, shape);
            }
            case 9: {
                return Short9D.wrap(sArray, shape);
            }
        }
        throw new IllegalArgumentException("Invalid shape");
    }

    public static IntScalar wrap(int[] nArray) {
        return IntScalar.wrap(nArray, 0);
    }

    public static Int1D wrap(int[] nArray, int n) {
        return Int1D.wrap(nArray, n);
    }

    public static Int2D wrap(int[] nArray, int n, int n2) {
        return Int2D.wrap(nArray, n, n2);
    }

    public static Int3D wrap(int[] nArray, int n, int n2, int n3) {
        return Int3D.wrap(nArray, n, n2, n3);
    }

    public static Int4D wrap(int[] nArray, int n, int n2, int n3, int n4) {
        return Int4D.wrap(nArray, n, n2, n3, n4);
    }

    public static Int5D wrap(int[] nArray, int n, int n2, int n3, int n4, int n5) {
        return Int5D.wrap(nArray, n, n2, n3, n4, n5);
    }

    public static Int6D wrap(int[] nArray, int n, int n2, int n3, int n4, int n5, int n6) {
        return Int6D.wrap(nArray, n, n2, n3, n4, n5, n6);
    }

    public static Int7D wrap(int[] nArray, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        return Int7D.wrap(nArray, n, n2, n3, n4, n5, n6, n7);
    }

    public static Int8D wrap(int[] nArray, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        return Int8D.wrap(nArray, n, n2, n3, n4, n5, n6, n7, n8);
    }

    public static Int9D wrap(int[] nArray, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        return Int9D.wrap(nArray, n, n2, n3, n4, n5, n6, n7, n8, n9);
    }

    public static IntArray wrap(int[] nArray, int[] nArray2) {
        return ArrayFactory.wrap(nArray, new Shape(nArray2));
    }

    public static IntArray wrap(int[] nArray, Shape shape) {
        switch (shape.rank()) {
            case 0: {
                return IntScalar.wrap(nArray, 0);
            }
            case 1: {
                return Int1D.wrap(nArray, shape);
            }
            case 2: {
                return Int2D.wrap(nArray, shape);
            }
            case 3: {
                return Int3D.wrap(nArray, shape);
            }
            case 4: {
                return Int4D.wrap(nArray, shape);
            }
            case 5: {
                return Int5D.wrap(nArray, shape);
            }
            case 6: {
                return Int6D.wrap(nArray, shape);
            }
            case 7: {
                return Int7D.wrap(nArray, shape);
            }
            case 8: {
                return Int8D.wrap(nArray, shape);
            }
            case 9: {
                return Int9D.wrap(nArray, shape);
            }
        }
        throw new IllegalArgumentException("Invalid shape");
    }

    public static LongScalar wrap(long[] lArray) {
        return LongScalar.wrap(lArray, 0);
    }

    public static Long1D wrap(long[] lArray, int n) {
        return Long1D.wrap(lArray, n);
    }

    public static Long2D wrap(long[] lArray, int n, int n2) {
        return Long2D.wrap(lArray, n, n2);
    }

    public static Long3D wrap(long[] lArray, int n, int n2, int n3) {
        return Long3D.wrap(lArray, n, n2, n3);
    }

    public static Long4D wrap(long[] lArray, int n, int n2, int n3, int n4) {
        return Long4D.wrap(lArray, n, n2, n3, n4);
    }

    public static Long5D wrap(long[] lArray, int n, int n2, int n3, int n4, int n5) {
        return Long5D.wrap(lArray, n, n2, n3, n4, n5);
    }

    public static Long6D wrap(long[] lArray, int n, int n2, int n3, int n4, int n5, int n6) {
        return Long6D.wrap(lArray, n, n2, n3, n4, n5, n6);
    }

    public static Long7D wrap(long[] lArray, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        return Long7D.wrap(lArray, n, n2, n3, n4, n5, n6, n7);
    }

    public static Long8D wrap(long[] lArray, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        return Long8D.wrap(lArray, n, n2, n3, n4, n5, n6, n7, n8);
    }

    public static Long9D wrap(long[] lArray, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        return Long9D.wrap(lArray, n, n2, n3, n4, n5, n6, n7, n8, n9);
    }

    public static LongArray wrap(long[] lArray, int[] nArray) {
        return ArrayFactory.wrap(lArray, new Shape(nArray));
    }

    public static LongArray wrap(long[] lArray, Shape shape) {
        switch (shape.rank()) {
            case 0: {
                return LongScalar.wrap(lArray, 0);
            }
            case 1: {
                return Long1D.wrap(lArray, shape);
            }
            case 2: {
                return Long2D.wrap(lArray, shape);
            }
            case 3: {
                return Long3D.wrap(lArray, shape);
            }
            case 4: {
                return Long4D.wrap(lArray, shape);
            }
            case 5: {
                return Long5D.wrap(lArray, shape);
            }
            case 6: {
                return Long6D.wrap(lArray, shape);
            }
            case 7: {
                return Long7D.wrap(lArray, shape);
            }
            case 8: {
                return Long8D.wrap(lArray, shape);
            }
            case 9: {
                return Long9D.wrap(lArray, shape);
            }
        }
        throw new IllegalArgumentException("Invalid shape");
    }

    public static FloatScalar wrap(float[] fArray) {
        return FloatScalar.wrap(fArray, 0);
    }

    public static Float1D wrap(float[] fArray, int n) {
        return Float1D.wrap(fArray, n);
    }

    public static Float2D wrap(float[] fArray, int n, int n2) {
        return Float2D.wrap(fArray, n, n2);
    }

    public static Float3D wrap(float[] fArray, int n, int n2, int n3) {
        return Float3D.wrap(fArray, n, n2, n3);
    }

    public static Float4D wrap(float[] fArray, int n, int n2, int n3, int n4) {
        return Float4D.wrap(fArray, n, n2, n3, n4);
    }

    public static Float5D wrap(float[] fArray, int n, int n2, int n3, int n4, int n5) {
        return Float5D.wrap(fArray, n, n2, n3, n4, n5);
    }

    public static Float6D wrap(float[] fArray, int n, int n2, int n3, int n4, int n5, int n6) {
        return Float6D.wrap(fArray, n, n2, n3, n4, n5, n6);
    }

    public static Float7D wrap(float[] fArray, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        return Float7D.wrap(fArray, n, n2, n3, n4, n5, n6, n7);
    }

    public static Float8D wrap(float[] fArray, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        return Float8D.wrap(fArray, n, n2, n3, n4, n5, n6, n7, n8);
    }

    public static Float9D wrap(float[] fArray, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        return Float9D.wrap(fArray, n, n2, n3, n4, n5, n6, n7, n8, n9);
    }

    public static FloatArray wrap(float[] fArray, int[] nArray) {
        return ArrayFactory.wrap(fArray, new Shape(nArray));
    }

    public static FloatArray wrap(float[] fArray, Shape shape) {
        switch (shape.rank()) {
            case 0: {
                return FloatScalar.wrap(fArray, 0);
            }
            case 1: {
                return Float1D.wrap(fArray, shape);
            }
            case 2: {
                return Float2D.wrap(fArray, shape);
            }
            case 3: {
                return Float3D.wrap(fArray, shape);
            }
            case 4: {
                return Float4D.wrap(fArray, shape);
            }
            case 5: {
                return Float5D.wrap(fArray, shape);
            }
            case 6: {
                return Float6D.wrap(fArray, shape);
            }
            case 7: {
                return Float7D.wrap(fArray, shape);
            }
            case 8: {
                return Float8D.wrap(fArray, shape);
            }
            case 9: {
                return Float9D.wrap(fArray, shape);
            }
        }
        throw new IllegalArgumentException("Invalid shape");
    }

    public static DoubleScalar wrap(double[] dArray) {
        return DoubleScalar.wrap(dArray, 0);
    }

    public static Double1D wrap(double[] dArray, int n) {
        return Double1D.wrap(dArray, n);
    }

    public static Double2D wrap(double[] dArray, int n, int n2) {
        return Double2D.wrap(dArray, n, n2);
    }

    public static Double3D wrap(double[] dArray, int n, int n2, int n3) {
        return Double3D.wrap(dArray, n, n2, n3);
    }

    public static Double4D wrap(double[] dArray, int n, int n2, int n3, int n4) {
        return Double4D.wrap(dArray, n, n2, n3, n4);
    }

    public static Double5D wrap(double[] dArray, int n, int n2, int n3, int n4, int n5) {
        return Double5D.wrap(dArray, n, n2, n3, n4, n5);
    }

    public static Double6D wrap(double[] dArray, int n, int n2, int n3, int n4, int n5, int n6) {
        return Double6D.wrap(dArray, n, n2, n3, n4, n5, n6);
    }

    public static Double7D wrap(double[] dArray, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        return Double7D.wrap(dArray, n, n2, n3, n4, n5, n6, n7);
    }

    public static Double8D wrap(double[] dArray, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        return Double8D.wrap(dArray, n, n2, n3, n4, n5, n6, n7, n8);
    }

    public static Double9D wrap(double[] dArray, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        return Double9D.wrap(dArray, n, n2, n3, n4, n5, n6, n7, n8, n9);
    }

    public static DoubleArray wrap(double[] dArray, int[] nArray) {
        return ArrayFactory.wrap(dArray, new Shape(nArray));
    }

    public static DoubleArray wrap(double[] dArray, Shape shape) {
        switch (shape.rank()) {
            case 0: {
                return DoubleScalar.wrap(dArray, 0);
            }
            case 1: {
                return Double1D.wrap(dArray, shape);
            }
            case 2: {
                return Double2D.wrap(dArray, shape);
            }
            case 3: {
                return Double3D.wrap(dArray, shape);
            }
            case 4: {
                return Double4D.wrap(dArray, shape);
            }
            case 5: {
                return Double5D.wrap(dArray, shape);
            }
            case 6: {
                return Double6D.wrap(dArray, shape);
            }
            case 7: {
                return Double7D.wrap(dArray, shape);
            }
            case 8: {
                return Double8D.wrap(dArray, shape);
            }
            case 9: {
                return Double9D.wrap(dArray, shape);
            }
        }
        throw new IllegalArgumentException("Invalid shape");
    }

    public static ShapedArray wrap(Object object, Shape shape) {
        int n = 0;
        Class<?> clazz = object.getClass();
        while (clazz.isArray()) {
            clazz = clazz.getComponentType();
            ++n;
        }
        if (n == 1) {
            if (clazz.equals(Byte.TYPE)) {
                return ArrayFactory.wrap((byte[])object, shape);
            }
            if (clazz.equals(Short.TYPE)) {
                return ArrayFactory.wrap((short[])object, shape);
            }
            if (clazz.equals(Integer.TYPE)) {
                return ArrayFactory.wrap((int[])object, shape);
            }
            if (clazz.equals(Long.TYPE)) {
                return ArrayFactory.wrap((long[])object, shape);
            }
            if (clazz.equals(Float.TYPE)) {
                return ArrayFactory.wrap((float[])object, shape);
            }
            if (clazz.equals(Double.TYPE)) {
                return ArrayFactory.wrap((double[])object, shape);
            }
        }
        throw new IllegalTypeException("Only 1D array of numerical primitive types are supported");
    }

    public static ShapedArray wrap(Object object, int[] nArray) {
        int n = 0;
        Class<?> clazz = object.getClass();
        while (clazz.isArray()) {
            clazz = clazz.getComponentType();
            ++n;
        }
        if (n == 1) {
            if (clazz.equals(Byte.TYPE)) {
                return ArrayFactory.wrap((byte[])object, new Shape(nArray));
            }
            if (clazz.equals(Short.TYPE)) {
                return ArrayFactory.wrap((short[])object, new Shape(nArray));
            }
            if (clazz.equals(Integer.TYPE)) {
                return ArrayFactory.wrap((int[])object, new Shape(nArray));
            }
            if (clazz.equals(Long.TYPE)) {
                return ArrayFactory.wrap((long[])object, new Shape(nArray));
            }
            if (clazz.equals(Float.TYPE)) {
                return ArrayFactory.wrap((float[])object, new Shape(nArray));
            }
            if (clazz.equals(Double.TYPE)) {
                return ArrayFactory.wrap((double[])object, new Shape(nArray));
            }
        }
        throw new IllegalTypeException("Only 1D array of numerical primitive types are supported");
    }

    public static Array1D wrap(Object object, int n) {
        return (Array1D)ArrayFactory.wrap(object, new Shape(n));
    }

    public static Array2D wrap(Object object, int n, int n2) {
        return (Array2D)ArrayFactory.wrap(object, new Shape(n, n2));
    }

    public static Array3D wrap(Object object, int n, int n2, int n3) {
        return (Array3D)ArrayFactory.wrap(object, new Shape(n, n2, n3));
    }

    public static Array4D wrap(Object object, int n, int n2, int n3, int n4) {
        return (Array4D)ArrayFactory.wrap(object, new Shape(n, n2, n3, n4));
    }

    public static Array5D wrap(Object object, int n, int n2, int n3, int n4, int n5) {
        return (Array5D)ArrayFactory.wrap(object, new Shape(n, n2, n3, n4, n5));
    }

    public static Array6D wrap(Object object, int n, int n2, int n3, int n4, int n5, int n6) {
        return (Array6D)ArrayFactory.wrap(object, new Shape(n, n2, n3, n4, n5, n6));
    }

    public static Array7D wrap(Object object, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        return (Array7D)ArrayFactory.wrap(object, new Shape(n, n2, n3, n4, n5, n6, n7));
    }

    public static Array8D wrap(Object object, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        return (Array8D)ArrayFactory.wrap(object, new Shape(n, n2, n3, n4, n5, n6, n7, n8));
    }

    public static Array9D wrap(Object object, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        return (Array9D)ArrayFactory.wrap(object, new Shape(n, n2, n3, n4, n5, n6, n7, n8, n9));
    }

    public static ShapedArray wrap(ShapedVector shapedVector) {
        switch (shapedVector.getType()) {
            case 4: {
                return ArrayFactory.wrap(((FloatShapedVector)shapedVector).getData(), shapedVector.getShape());
            }
            case 5: {
                return ArrayFactory.wrap(((DoubleShapedVector)shapedVector).getData(), shapedVector.getShape());
            }
        }
        throw new IllegalArgumentException("Unsupported shaped vector type");
    }

    public static FloatArray wrap(FloatShapedVector floatShapedVector) {
        return ArrayFactory.wrap(floatShapedVector.getData(), floatShapedVector.getShape());
    }

    public static DoubleArray wrap(DoubleShapedVector doubleShapedVector) {
        return ArrayFactory.wrap(doubleShapedVector.getData(), doubleShapedVector.getShape());
    }
}

