/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array;

import mitiv.array.Array5D;
import mitiv.array.Byte1D;
import mitiv.array.Byte4D;
import mitiv.array.ByteArray;
import mitiv.array.Double5D;
import mitiv.array.Float5D;
import mitiv.array.Int5D;
import mitiv.array.Long5D;
import mitiv.array.ShapedArray;
import mitiv.array.Short5D;
import mitiv.array.impl.FlatByte5D;
import mitiv.array.impl.StriddenByte5D;
import mitiv.base.Shape;
import mitiv.base.indexing.Range;
import mitiv.base.mapping.ByteFunction;
import mitiv.base.mapping.ByteScanner;
import mitiv.exception.IllegalTypeException;
import mitiv.exception.NonConformableArrayException;
import mitiv.linalg.shaped.DoubleShapedVector;
import mitiv.linalg.shaped.FloatShapedVector;
import mitiv.linalg.shaped.ShapedVector;
import mitiv.random.ByteGenerator;

public abstract class Byte5D
extends Array5D
implements ByteArray {
    protected Byte5D(int n, int n2, int n3, int n4, int n5) {
        super(n, n2, n3, n4, n5);
    }

    protected Byte5D(int[] nArray) {
        super(nArray);
    }

    protected Byte5D(Shape shape) {
        super(shape);
    }

    @Override
    public final int getType() {
        return 0;
    }

    public abstract byte get(int var1, int var2, int var3, int var4, int var5);

    public abstract void set(int var1, int var2, int var3, int var4, int var5, byte var6);

    @Override
    public void fill(byte by) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                this.set(i, j, k, i2, i3, by);
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim5; ++i) {
                for (int j = 0; j < this.dim4; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i4 = 0; i4 < this.dim2; ++i4) {
                            for (int i5 = 0; i5 < this.dim1; ++i5) {
                                this.set(i5, i4, k, j, i, by);
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void increment(byte by) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                this.set(i, j, k, i2, i3, (byte)(this.get(i, j, k, i2, i3) + by));
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim5; ++i) {
                for (int j = 0; j < this.dim4; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i4 = 0; i4 < this.dim2; ++i4) {
                            for (int i5 = 0; i5 < this.dim1; ++i5) {
                                this.set(i5, i4, k, j, i, (byte)(this.get(i5, i4, k, j, i) + by));
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void decrement(byte by) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                this.set(i, j, k, i2, i3, (byte)(this.get(i, j, k, i2, i3) - by));
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim5; ++i) {
                for (int j = 0; j < this.dim4; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i4 = 0; i4 < this.dim2; ++i4) {
                            for (int i5 = 0; i5 < this.dim1; ++i5) {
                                this.set(i5, i4, k, j, i, (byte)(this.get(i5, i4, k, j, i) - by));
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void scale(byte by) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                this.set(i, j, k, i2, i3, (byte)(this.get(i, j, k, i2, i3) * by));
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim5; ++i) {
                for (int j = 0; j < this.dim4; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i4 = 0; i4 < this.dim2; ++i4) {
                            for (int i5 = 0; i5 < this.dim1; ++i5) {
                                this.set(i5, i4, k, j, i, (byte)(this.get(i5, i4, k, j, i) * by));
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void map(ByteFunction byteFunction) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                this.set(i, j, k, i2, i3, byteFunction.apply(this.get(i, j, k, i2, i3)));
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim5; ++i) {
                for (int j = 0; j < this.dim4; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i4 = 0; i4 < this.dim2; ++i4) {
                            for (int i5 = 0; i5 < this.dim1; ++i5) {
                                this.set(i5, i4, k, j, i, byteFunction.apply(this.get(i5, i4, k, j, i)));
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void fill(ByteGenerator byteGenerator) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                this.set(i, j, k, i2, i3, byteGenerator.nextByte());
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim5; ++i) {
                for (int j = 0; j < this.dim4; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i4 = 0; i4 < this.dim2; ++i4) {
                            for (int i5 = 0; i5 < this.dim1; ++i5) {
                                this.set(i5, i4, k, j, i, byteGenerator.nextByte());
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void scan(ByteScanner byteScanner) {
        boolean bl = false;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                if (bl) {
                                    byteScanner.update(this.get(i, j, k, i2, i3));
                                    continue;
                                }
                                byteScanner.initialize(this.get(i, j, k, i2, i3));
                                bl = true;
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim5; ++i) {
                for (int j = 0; j < this.dim4; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i4 = 0; i4 < this.dim2; ++i4) {
                            for (int i5 = 0; i5 < this.dim1; ++i5) {
                                if (bl) {
                                    byteScanner.update(this.get(i5, i4, k, j, i));
                                    continue;
                                }
                                byteScanner.initialize(this.get(i5, i4, k, j, i));
                                bl = true;
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public final byte[] flatten() {
        return this.flatten(false);
    }

    @Override
    public int min() {
        int n = this.get(0, 0, 0, 0, 0) & 0xFF;
        boolean bl = true;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                if (bl) {
                                    bl = false;
                                    continue;
                                }
                                int n2 = this.get(i, j, k, i2, i3) & 0xFF;
                                if (n2 >= n) continue;
                                n = n2;
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim5; ++i) {
                for (int j = 0; j < this.dim4; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i4 = 0; i4 < this.dim2; ++i4) {
                            for (int i5 = 0; i5 < this.dim1; ++i5) {
                                if (bl) {
                                    bl = false;
                                    continue;
                                }
                                int n3 = this.get(i5, i4, k, j, i) & 0xFF;
                                if (n3 >= n) continue;
                                n = n3;
                            }
                        }
                    }
                }
            }
        }
        return n;
    }

    @Override
    public int max() {
        int n = this.get(0, 0, 0, 0, 0) & 0xFF;
        boolean bl = true;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                if (bl) {
                                    bl = false;
                                    continue;
                                }
                                int n2 = this.get(i, j, k, i2, i3) & 0xFF;
                                if (n2 <= n) continue;
                                n = n2;
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim5; ++i) {
                for (int j = 0; j < this.dim4; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i4 = 0; i4 < this.dim2; ++i4) {
                            for (int i5 = 0; i5 < this.dim1; ++i5) {
                                if (bl) {
                                    bl = false;
                                    continue;
                                }
                                int n3 = this.get(i5, i4, k, j, i) & 0xFF;
                                if (n3 <= n) continue;
                                n = n3;
                            }
                        }
                    }
                }
            }
        }
        return n;
    }

    @Override
    public int[] getMinAndMax() {
        int[] nArray = new int[2];
        this.getMinAndMax(nArray);
        return nArray;
    }

    @Override
    public void getMinAndMax(int[] nArray) {
        int n;
        int n2 = n = this.get(0, 0, 0, 0, 0) & 0xFF;
        boolean bl = true;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                if (bl) {
                                    bl = false;
                                    continue;
                                }
                                int n3 = this.get(i, j, k, i2, i3) & 0xFF;
                                if (n3 < n) {
                                    n = n3;
                                }
                                if (n3 <= n2) continue;
                                n2 = n3;
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim5; ++i) {
                for (int j = 0; j < this.dim4; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i4 = 0; i4 < this.dim2; ++i4) {
                            for (int i5 = 0; i5 < this.dim1; ++i5) {
                                if (bl) {
                                    bl = false;
                                    continue;
                                }
                                int n4 = this.get(i5, i4, k, j, i) & 0xFF;
                                if (n4 < n) {
                                    n = n4;
                                }
                                if (n4 <= n2) continue;
                                n2 = n4;
                            }
                        }
                    }
                }
            }
        }
        nArray[0] = n;
        nArray[1] = n2;
    }

    @Override
    public int sum() {
        int n = 0;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                n += this.get(i, j, k, i2, i3) & 0xFF;
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim5; ++i) {
                for (int j = 0; j < this.dim4; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i4 = 0; i4 < this.dim2; ++i4) {
                            for (int i5 = 0; i5 < this.dim1; ++i5) {
                                n += this.get(i5, i4, k, j, i) & 0xFF;
                            }
                        }
                    }
                }
            }
        }
        return n;
    }

    @Override
    public double average() {
        return (double)this.sum() / (double)this.number;
    }

    @Override
    public Byte5D toByte() {
        return this;
    }

    @Override
    public Short5D toShort() {
        short[] sArray = new short[this.number];
        if (this.isFlat()) {
            byte[] byArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                sArray[i] = (short)(byArray[i] & 0xFF);
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim5; ++i) {
                for (int j = 0; j < this.dim4; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim2; ++i2) {
                            for (int i3 = 0; i3 < this.dim1; ++i3) {
                                sArray[++n] = (short)(this.get(i3, i2, k, j, i) & 0xFF);
                            }
                        }
                    }
                }
            }
        }
        return Short5D.wrap(sArray, this.getShape());
    }

    @Override
    public Int5D toInt() {
        int[] nArray = new int[this.number];
        if (this.isFlat()) {
            byte[] byArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                nArray[i] = byArray[i] & 0xFF;
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim5; ++i) {
                for (int j = 0; j < this.dim4; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim2; ++i2) {
                            for (int i3 = 0; i3 < this.dim1; ++i3) {
                                nArray[++n] = this.get(i3, i2, k, j, i) & 0xFF;
                            }
                        }
                    }
                }
            }
        }
        return Int5D.wrap(nArray, this.getShape());
    }

    @Override
    public Long5D toLong() {
        long[] lArray = new long[this.number];
        if (this.isFlat()) {
            byte[] byArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                lArray[i] = byArray[i] & 0xFF;
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim5; ++i) {
                for (int j = 0; j < this.dim4; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim2; ++i2) {
                            for (int i3 = 0; i3 < this.dim1; ++i3) {
                                lArray[++n] = this.get(i3, i2, k, j, i) & 0xFF;
                            }
                        }
                    }
                }
            }
        }
        return Long5D.wrap(lArray, this.getShape());
    }

    @Override
    public Float5D toFloat() {
        float[] fArray = new float[this.number];
        if (this.isFlat()) {
            byte[] byArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                fArray[i] = byArray[i] & 0xFF;
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim5; ++i) {
                for (int j = 0; j < this.dim4; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim2; ++i2) {
                            for (int i3 = 0; i3 < this.dim1; ++i3) {
                                fArray[++n] = this.get(i3, i2, k, j, i) & 0xFF;
                            }
                        }
                    }
                }
            }
        }
        return Float5D.wrap(fArray, this.getShape());
    }

    @Override
    public Double5D toDouble() {
        double[] dArray = new double[this.number];
        if (this.isFlat()) {
            byte[] byArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                dArray[i] = byArray[i] & 0xFF;
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim5; ++i) {
                for (int j = 0; j < this.dim4; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim2; ++i2) {
                            for (int i3 = 0; i3 < this.dim1; ++i3) {
                                dArray[++n] = this.get(i3, i2, k, j, i) & 0xFF;
                            }
                        }
                    }
                }
            }
        }
        return Double5D.wrap(dArray, this.getShape());
    }

    @Override
    public Byte5D copy() {
        return new FlatByte5D(this.flatten(true), this.shape);
    }

    @Override
    public void assign(ShapedArray shapedArray) {
        if (!this.getShape().equals(shapedArray.getShape())) {
            throw new NonConformableArrayException("Source and destination must have the same shape");
        }
        Byte5D byte5D = shapedArray.getType() == 0 ? (Byte5D)shapedArray : (Byte5D)shapedArray.toByte();
        if (this.getOrder() == 2 && byte5D.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                this.set(i, j, k, i2, i3, byte5D.get(i, j, k, i2, i3));
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim5; ++i) {
                for (int j = 0; j < this.dim4; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i4 = 0; i4 < this.dim2; ++i4) {
                            for (int i5 = 0; i5 < this.dim1; ++i5) {
                                this.set(i5, i4, k, j, i, byte5D.get(i5, i4, k, j, i));
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void assign(ShapedVector shapedVector) {
        if (!this.getShape().equals(shapedVector.getShape())) {
            throw new NonConformableArrayException("Source and destination must have the same shape");
        }
        int n = -1;
        if (shapedVector.getType() == 5) {
            DoubleShapedVector doubleShapedVector = (DoubleShapedVector)shapedVector;
            for (int i = 0; i < this.dim5; ++i) {
                for (int j = 0; j < this.dim4; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim2; ++i2) {
                            for (int i3 = 0; i3 < this.dim1; ++i3) {
                                this.set(i3, i2, k, j, i, (byte)doubleShapedVector.get(++n));
                            }
                        }
                    }
                }
            }
        } else if (shapedVector.getType() == 4) {
            FloatShapedVector floatShapedVector = (FloatShapedVector)shapedVector;
            for (int i = 0; i < this.dim5; ++i) {
                for (int j = 0; j < this.dim4; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i4 = 0; i4 < this.dim2; ++i4) {
                            for (int i5 = 0; i5 < this.dim1; ++i5) {
                                this.set(i5, i4, k, j, i, (byte)floatShapedVector.get(++n));
                            }
                        }
                    }
                }
            }
        } else {
            throw new IllegalTypeException();
        }
    }

    @Override
    public Byte5D create() {
        return new FlatByte5D(this.getShape());
    }

    public static Byte5D create(int n, int n2, int n3, int n4, int n5) {
        return new FlatByte5D(n, n2, n3, n4, n5);
    }

    public static Byte5D create(int[] nArray) {
        return new FlatByte5D(nArray);
    }

    public static Byte5D create(Shape shape) {
        return new FlatByte5D(shape);
    }

    public static Byte5D wrap(byte[] byArray, int n, int n2, int n3, int n4, int n5) {
        return new FlatByte5D(byArray, n, n2, n3, n4, n5);
    }

    public static Byte5D wrap(byte[] byArray, int[] nArray) {
        return new FlatByte5D(byArray, nArray);
    }

    public static Byte5D wrap(byte[] byArray, Shape shape) {
        return new FlatByte5D(byArray, shape);
    }

    public static Byte5D wrap(byte[] byArray, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11) {
        return new StriddenByte5D(byArray, n, n2, n3, n4, n5, n6, n7, n8, n9, n10, n11);
    }

    @Override
    public abstract Byte4D slice(int var1);

    @Override
    public abstract Byte4D slice(int var1, int var2);

    @Override
    public abstract Byte5D view(Range var1, Range var2, Range var3, Range var4, Range var5);

    @Override
    public abstract Byte5D view(int[] var1, int[] var2, int[] var3, int[] var4, int[] var5);

    @Override
    public abstract Byte1D as1D();
}

