/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeval;

import net.sourceforge.jeval.EvaluationException;
import net.sourceforge.jeval.Evaluator;
import net.sourceforge.jeval.ExpressionOperand;
import net.sourceforge.jeval.ParsedFunction;
import net.sourceforge.jeval.function.Function;
import net.sourceforge.jeval.function.FunctionException;
import net.sourceforge.jeval.function.FunctionResult;
import net.sourceforge.jeval.operator.Operator;

public class ExpressionTree {
    private Object leftOperand = null;
    private Object rightOperand = null;
    private Operator operator = null;
    private Operator unaryOperator = null;
    private Evaluator evaluator = null;

    public ExpressionTree(Evaluator evaluator, Object leftOperand, Object rightOperand, Operator operator, Operator unaryOperator) {
        this.evaluator = evaluator;
        this.leftOperand = leftOperand;
        this.rightOperand = rightOperand;
        this.operator = operator;
        this.unaryOperator = unaryOperator;
    }

    public Object getLeftOperand() {
        return this.leftOperand;
    }

    public Object getRightOperand() {
        return this.rightOperand;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public Operator getUnaryOperator() {
        return this.unaryOperator;
    }

    public String evaluate(boolean wrapStringFunctionResults) throws EvaluationException {
        String rtnResult = null;
        String leftResultString = null;
        Double leftResultDouble = null;
        if (this.leftOperand instanceof ExpressionTree) {
            leftResultString = ((ExpressionTree)this.leftOperand).evaluate(wrapStringFunctionResults);
            try {
                leftResultDouble = new Double(leftResultString);
                leftResultString = null;
            }
            catch (NumberFormatException exception) {
                leftResultDouble = null;
            }
        } else if (this.leftOperand instanceof ExpressionOperand) {
            ExpressionOperand leftExpressionOperand = (ExpressionOperand)this.leftOperand;
            leftResultString = leftExpressionOperand.getValue();
            if (!this.evaluator.isExpressionString(leftResultString = this.evaluator.replaceVariables(leftResultString))) {
                try {
                    leftResultDouble = new Double(leftResultString);
                    leftResultString = null;
                }
                catch (NumberFormatException nfe) {
                    throw new EvaluationException("Expression is invalid.", nfe);
                }
                if (leftExpressionOperand.getUnaryOperator() != null) {
                    leftResultDouble = new Double(leftExpressionOperand.getUnaryOperator().evaluate(leftResultDouble));
                }
            } else if (leftExpressionOperand.getUnaryOperator() != null) {
                throw new EvaluationException("Invalid operand for unary operator.");
            }
        } else if (this.leftOperand instanceof ParsedFunction) {
            ParsedFunction parsedFunction = (ParsedFunction)this.leftOperand;
            Function function = parsedFunction.getFunction();
            String arguments = parsedFunction.getArguments();
            arguments = this.evaluator.replaceVariables(arguments);
            if (this.evaluator.getProcessNestedFunctions()) {
                arguments = this.evaluator.processNestedFunctions(arguments);
            }
            try {
                FunctionResult functionResult = function.execute(this.evaluator, arguments);
                leftResultString = functionResult.getResult();
                if (functionResult.getType() == 0) {
                    Double resultDouble = new Double(leftResultString);
                    if (parsedFunction.getUnaryOperator() != null) {
                        resultDouble = new Double(parsedFunction.getUnaryOperator().evaluate(resultDouble));
                    }
                    leftResultString = resultDouble.toString();
                } else if (functionResult.getType() == 1) {
                    if (wrapStringFunctionResults) {
                        leftResultString = this.evaluator.getQuoteCharacter() + leftResultString + this.evaluator.getQuoteCharacter();
                    }
                    if (parsedFunction.getUnaryOperator() != null) {
                        throw new EvaluationException("Invalid operand for unary operator.");
                    }
                }
            }
            catch (FunctionException fe) {
                throw new EvaluationException(fe.getMessage(), fe);
            }
            if (!this.evaluator.isExpressionString(leftResultString)) {
                try {
                    leftResultDouble = new Double(leftResultString);
                    leftResultString = null;
                }
                catch (NumberFormatException nfe) {
                    throw new EvaluationException("Expression is invalid.", nfe);
                }
            }
        } else if (this.leftOperand != null) {
            throw new EvaluationException("Expression is invalid.");
        }
        String rightResultString = null;
        Double rightResultDouble = null;
        if (this.rightOperand instanceof ExpressionTree) {
            rightResultString = ((ExpressionTree)this.rightOperand).evaluate(wrapStringFunctionResults);
            try {
                rightResultDouble = new Double(rightResultString);
                rightResultString = null;
            }
            catch (NumberFormatException exception) {
                rightResultDouble = null;
            }
        } else if (this.rightOperand instanceof ExpressionOperand) {
            ExpressionOperand rightExpressionOperand = (ExpressionOperand)this.rightOperand;
            rightResultString = ((ExpressionOperand)this.rightOperand).getValue();
            if (!this.evaluator.isExpressionString(rightResultString = this.evaluator.replaceVariables(rightResultString))) {
                try {
                    rightResultDouble = new Double(rightResultString);
                    rightResultString = null;
                }
                catch (NumberFormatException nfe) {
                    throw new EvaluationException("Expression is invalid.", nfe);
                }
                if (rightExpressionOperand.getUnaryOperator() != null) {
                    rightResultDouble = new Double(rightExpressionOperand.getUnaryOperator().evaluate(rightResultDouble));
                }
            } else if (rightExpressionOperand.getUnaryOperator() != null) {
                throw new EvaluationException("Invalid operand for unary operator.");
            }
        } else if (this.rightOperand instanceof ParsedFunction) {
            ParsedFunction parsedFunction = (ParsedFunction)this.rightOperand;
            Function function = parsedFunction.getFunction();
            String arguments = parsedFunction.getArguments();
            arguments = this.evaluator.replaceVariables(arguments);
            if (this.evaluator.getProcessNestedFunctions()) {
                arguments = this.evaluator.processNestedFunctions(arguments);
            }
            try {
                FunctionResult functionResult = function.execute(this.evaluator, arguments);
                rightResultString = functionResult.getResult();
                if (functionResult.getType() == 0) {
                    Double resultDouble = new Double(rightResultString);
                    if (parsedFunction.getUnaryOperator() != null) {
                        resultDouble = new Double(parsedFunction.getUnaryOperator().evaluate(resultDouble));
                    }
                    rightResultString = resultDouble.toString();
                } else if (functionResult.getType() == 1) {
                    if (wrapStringFunctionResults) {
                        rightResultString = this.evaluator.getQuoteCharacter() + rightResultString + this.evaluator.getQuoteCharacter();
                    }
                    if (parsedFunction.getUnaryOperator() != null) {
                        throw new EvaluationException("Invalid operand for unary operator.");
                    }
                }
            }
            catch (FunctionException fe) {
                throw new EvaluationException(fe.getMessage(), fe);
            }
            if (!this.evaluator.isExpressionString(rightResultString)) {
                try {
                    rightResultDouble = new Double(rightResultString);
                    rightResultString = null;
                }
                catch (NumberFormatException nfe) {
                    throw new EvaluationException("Expression is invalid.", nfe);
                }
            }
        } else if (this.rightOperand != null) {
            throw new EvaluationException("Expression is invalid.");
        }
        if (leftResultDouble != null && rightResultDouble != null) {
            double doubleResult = this.operator.evaluate(leftResultDouble, rightResultDouble);
            if (this.getUnaryOperator() != null) {
                doubleResult = this.getUnaryOperator().evaluate(doubleResult);
            }
            rtnResult = new Double(doubleResult).toString();
        } else if (leftResultString != null && rightResultString != null) {
            rtnResult = this.operator.evaluate(leftResultString, rightResultString);
        } else if (leftResultDouble != null && rightResultDouble == null) {
            double doubleResult = -1.0;
            if (this.unaryOperator == null) {
                throw new EvaluationException("Expression is invalid.");
            }
            doubleResult = this.unaryOperator.evaluate(leftResultDouble);
            rtnResult = new Double(doubleResult).toString();
        } else {
            throw new EvaluationException("Expression is invalid.");
        }
        return rtnResult;
    }
}

