/*
 * Decompiled with CFR 0.152.
 */
package loci.common.xml;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import loci.common.RandomAccessInputStream;
import loci.common.xml.LSInputI;
import loci.common.xml.MetadataHandler;
import loci.common.xml.ParserErrorHandler;
import loci.common.xml.ValidationErrorHandler;
import loci.common.xml.ValidationSAXHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class XMLTools {
    static final Logger LOGGER = LoggerFactory.getLogger(XMLTools.class);
    private static final String XSI_NS = "http://www.w3.org/2001/XMLSchema-instance";
    private static final String XML_SCHEMA_PATH = "http://www.w3.org/2001/XMLSchema";
    private static final TransformerFactory transformFactory = XMLTools.createTransformFactory();
    private static ThreadLocal<HashMap<URI, Schema>> schemas = new ThreadLocal<HashMap<URI, Schema>>(){

        @Override
        protected HashMap<URI, Schema> initialValue() {
            return new HashMap<URI, Schema>();
        }
    };

    private static TransformerFactory createTransformFactory() {
        TransformerFactory factory = TransformerFactory.newInstance();
        factory.setErrorListener(new XMLListener());
        return factory;
    }

    private XMLTools() {
    }

    public static DocumentBuilder createBuilder() {
        try {
            return DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            LOGGER.error("Cannot create DocumentBuilder", e);
            throw new RuntimeException(e);
        }
    }

    public static Document createDocument() {
        return XMLTools.createBuilder().newDocument();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document parseDOM(File file2) throws ParserConfigurationException, SAXException, IOException {
        try (FileInputStream is = new FileInputStream(file2);){
            Document doc;
            Document document = doc = XMLTools.parseDOM(is);
            return document;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document parseDOM(String xml) throws ParserConfigurationException, SAXException, IOException {
        byte[] bytes = xml.getBytes("UTF-8");
        try (ByteArrayInputStream is = new ByteArrayInputStream(bytes);){
            Document doc;
            Document document = doc = XMLTools.parseDOM(is);
            return document;
        }
    }

    public static Document parseDOM(InputStream is) throws ParserConfigurationException, SAXException, IOException {
        InputStream in = is.markSupported() ? is : new BufferedInputStream(is);
        XMLTools.checkUTF8(in);
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = factory.newDocumentBuilder();
        db.setErrorHandler(new ParserErrorHandler());
        return db.parse(in);
    }

    public static String getXML(Document doc) throws TransformerConfigurationException, TransformerException {
        StringWriter stringWriter = new StringWriter();
        StreamResult result = new StreamResult(stringWriter);
        XMLTools.writeXML(result, doc, true);
        return stringWriter.getBuffer().toString();
    }

    public static String dumpXML(String schemaLocation, Document doc, Element r) {
        return XMLTools.dumpXML(schemaLocation, doc, r, true);
    }

    public static String dumpXML(String schemaLocation, Document doc, Element r, boolean includeXMLDeclaration) {
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            if (schemaLocation != null) {
                r.setAttribute("xmlns:xsi", XSI_NS);
                r.setAttribute("xsi:schemaLocation", schemaLocation);
            }
            doc.appendChild(r);
            XMLTools.writeXML(os, doc, includeXMLDeclaration);
            return os.toString("UTF-8");
        }
        catch (TransformerException exc) {
            LOGGER.warn("Failed to create XML", exc);
            throw new RuntimeException(exc);
        }
        catch (UnsupportedEncodingException exc) {
            LOGGER.warn("Failed to create XML", exc);
            throw new RuntimeException(exc);
        }
    }

    public static String escapeXML(String s) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '<') {
                sb.append("&lt;");
                continue;
            }
            if (c == '>') {
                sb.append("&gt;");
                continue;
            }
            if (c == '&') {
                sb.append("&amp;");
                continue;
            }
            if (c == '\"') {
                sb.append("&quot;");
                continue;
            }
            if (c == '\'') {
                sb.append("&apos;");
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String sanitizeXML(String s) {
        char[] c = s.toCharArray();
        for (int i = 0; i < s.length(); ++i) {
            if (Character.isISOControl(c[i]) && c[i] != '\n' && c[i] != '\t' && c[i] != '\r' || !Character.isDefined(c[i])) {
                c[i] = 32;
            }
            if (i <= 0 || c[i - 1] != '&' || c[i] != '#') continue;
            c[i - 1] = 32;
        }
        return new String(c);
    }

    public static String indentXML(String xml) {
        return XMLTools.indentXML(xml, 3, false);
    }

    public static String indentXML(String xml, int spacing) {
        return XMLTools.indentXML(xml, spacing, false);
    }

    public static String indentXML(String xml, boolean preserveCData) {
        return XMLTools.indentXML(xml, 3, preserveCData);
    }

    public static String indentXML(String xml, int spacing, boolean preserveCData) {
        if (xml == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        StringTokenizer st = new StringTokenizer(xml, "<>", true);
        int indent = 0;
        int noSpace = 0;
        boolean first = true;
        boolean element = false;
        while (st.hasMoreTokens()) {
            String token = st.nextToken().trim();
            if (token.equals("")) continue;
            if (token.equals("<")) {
                element = true;
                continue;
            }
            if (element && token.equals(">")) {
                element = false;
                continue;
            }
            if (!element && preserveCData) {
                noSpace = 2;
            }
            if (noSpace == 0) {
                if (first) {
                    first = false;
                } else {
                    sb.append("\n");
                }
            }
            if (element && token.startsWith("/")) {
                indent -= spacing;
            }
            if (noSpace == 0) {
                for (int j = 0; j < indent; ++j) {
                    sb.append(" ");
                }
            }
            if (element) {
                sb.append("<");
            }
            sb.append(token);
            if (element) {
                sb.append(">");
            }
            if (!(noSpace != 0 || !element || token.startsWith("?") || token.startsWith("/") || token.endsWith("/") || token.startsWith("!"))) {
                indent += spacing;
            }
            if (noSpace <= 0) continue;
            --noSpace;
        }
        sb.append("\n");
        return sb.toString();
    }

    public static Hashtable<String, String> parseXML(String xml) throws IOException {
        MetadataHandler handler = new MetadataHandler();
        XMLTools.parseXML(xml, (DefaultHandler)handler);
        return handler.getMetadata();
    }

    public static void parseXML(String xml, DefaultHandler handler) throws IOException {
        XMLTools.parseXML(xml.getBytes("UTF-8"), handler);
    }

    public static void parseXML(RandomAccessInputStream stream, DefaultHandler handler) throws IOException {
        XMLTools.parseXML((InputStream)stream, handler);
    }

    public static void parseXML(byte[] xml, DefaultHandler handler) throws IOException {
        XMLTools.parseXML(new ByteArrayInputStream(xml), handler);
    }

    public static void parseXML(InputStream xml, DefaultHandler handler) throws IOException {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser parser = factory.newSAXParser();
            parser.parse(xml, handler);
        }
        catch (ParserConfigurationException exc) {
            IOException e = new IOException();
            e.initCause(exc);
            throw e;
        }
        catch (SAXException exc) {
            IOException e = new IOException();
            e.initCause(exc);
            throw e;
        }
    }

    public static void writeXML(OutputStream os, Document doc) throws TransformerException {
        XMLTools.writeXML(os, doc, true);
    }

    public static void writeXML(OutputStream os, Document doc, boolean includeXMLDeclaration) throws TransformerException {
        XMLTools.writeXML(new StreamResult(os), doc, includeXMLDeclaration);
    }

    public static void writeXML(Result output, Document doc, boolean includeXMLDeclaration) throws TransformerException {
        Transformer idTransform = transformFactory.newTransformer();
        if (!includeXMLDeclaration) {
            idTransform.setOutputProperty("omit-xml-declaration", "yes");
        }
        DOMSource input = new DOMSource(doc);
        idTransform.transform(input, output);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Templates getStylesheet(String resourcePath, Class<?> sourceClass) {
        InputStream xsltStream;
        if (sourceClass == null) {
            try {
                xsltStream = new FileInputStream(resourcePath);
            }
            catch (IOException exc) {
                LOGGER.debug("Could not open file", exc);
                return null;
            }
        } else {
            xsltStream = sourceClass.getResourceAsStream(resourcePath);
        }
        try {
            StreamSource xsltSource = new StreamSource(xsltStream);
            Templates templates = transformFactory.newTemplates(xsltSource);
            return templates;
        }
        catch (TransformerConfigurationException exc) {
            LOGGER.debug("Could not construct template", exc);
        }
        finally {
            try {
                if (xsltStream != null) {
                    xsltStream.close();
                }
            }
            catch (IOException e) {
                LOGGER.debug("Could not close file", e);
            }
        }
        return null;
    }

    public static String avoidUndeclaredNamespaces(String xml) {
        int gt = xml.indexOf(62);
        if (gt > 0 && xml.startsWith("<?xml ")) {
            gt = xml.indexOf(62, gt + 1);
        }
        if (gt > 0) {
            String firstTag = xml.substring(0, gt + 1).toLowerCase();
            while (firstTag.endsWith("-->")) {
                gt = xml.indexOf(62, gt + 1);
                firstTag = xml.substring(0, gt + 1).toLowerCase();
            }
            HashSet<String> namespaces = new HashSet<String>();
            Pattern pattern = Pattern.compile(" xmlns:(\\w+)");
            Matcher matcher = pattern.matcher(firstTag);
            while (matcher.find()) {
                namespaces.add(matcher.group(1));
            }
            pattern = Pattern.compile("</?(\\w+):");
            matcher = pattern.matcher(xml);
            while (matcher.find()) {
                String namespace = matcher.group(1);
                if (namespace.equalsIgnoreCase("OME") || namespace.startsWith("ns") || namespaces.contains(namespace.toLowerCase())) continue;
                int end = matcher.end();
                xml = xml.substring(0, end - 1) + "_" + xml.substring(end);
            }
            Pattern emptyNamespaces = Pattern.compile(" xmlns:(\\w+)=\"\"");
            matcher = emptyNamespaces.matcher(firstTag);
            while (matcher.find()) {
                int start = matcher.start();
                int end = matcher.end();
                xml = xml.substring(0, start + 1) + xml.substring(end);
            }
        }
        return xml;
    }

    public static String transformXML(String xml, Templates xslt) throws IOException {
        xml = XMLTools.avoidUndeclaredNamespaces(xml);
        return XMLTools.transformXML(new StreamSource(new StringReader(xml)), xslt);
    }

    public static String transformXML(Source xmlSource, Templates xslt) throws IOException {
        Transformer trans;
        try {
            trans = xslt.newTransformer();
            trans.setErrorListener(new XMLListener());
        }
        catch (TransformerConfigurationException exc) {
            IOException e = new IOException();
            e.initCause(exc);
            throw e;
        }
        StringWriter xmlWriter = new StringWriter();
        StreamResult xmlResult = new StreamResult(xmlWriter);
        try {
            trans.transform(xmlSource, xmlResult);
        }
        catch (TransformerException exc) {
            IOException e = new IOException();
            e.initCause(exc);
            throw e;
        }
        return xmlWriter.toString();
    }

    public static boolean validateXML(String xml) {
        return XMLTools.validateXML(xml, null, null);
    }

    public static boolean validateXML(String xml, String label) {
        return XMLTools.validateXML(xml, label, null);
    }

    public static boolean validateXML(String xml, String label, final SchemaReader schemaReader) {
        Schema schema;
        if (label == null) {
            label = "XML";
        }
        Exception exception = null;
        LOGGER.info("Parsing schema path");
        ValidationSAXHandler saxHandler = new ValidationSAXHandler();
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser saxParser = factory.newSAXParser();
            ByteArrayInputStream is = new ByteArrayInputStream(xml.getBytes("UTF-8"));
            saxParser.parse((InputStream)is, (DefaultHandler)saxHandler);
        }
        catch (ParserConfigurationException exc) {
            exception = exc;
        }
        catch (SAXException exc) {
            exception = exc;
        }
        catch (IOException exc) {
            exception = exc;
        }
        if (exception != null) {
            LOGGER.warn("Error parsing schema path from {}", (Object)label, (Object)exception);
            return false;
        }
        String schemaPath = saxHandler.getSchemaPath();
        if (schemaPath == null) {
            LOGGER.error("No schema path found. Validation cannot continue.");
            return false;
        }
        LOGGER.info(schemaPath);
        LOGGER.info("Validating {}", (Object)label);
        URI schemaLocation = null;
        try {
            schemaLocation = new URI(schemaPath);
        }
        catch (URISyntaxException exc) {
            LOGGER.info("Error accessing schema at {}", (Object)schemaPath, (Object)exc);
            return false;
        }
        SchemaFactory schemaFactory = SchemaFactory.newInstance(XML_SCHEMA_PATH);
        if (schemaReader != null) {
            LSResourceResolver resolver = new LSResourceResolver(){

                @Override
                public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
                    InputStream stream = schemaReader.getSchemaAsStream(systemId);
                    if (stream == null) {
                        return null;
                    }
                    LSInputI input = new LSInputI();
                    input.setPublicId(publicId);
                    input.setSystemId(systemId);
                    input.setBaseURI(baseURI);
                    try {
                        input.setCharacterStream(new InputStreamReader(stream, "UTF-8"));
                    }
                    catch (UnsupportedEncodingException e) {
                        LOGGER.warn("no UTF-8 character encoding available");
                        return null;
                    }
                    return input;
                }
            };
            schemaFactory.setResourceResolver(resolver);
        }
        if ((schema = schemas.get().get(schemaLocation)) == null) {
            try {
                InputStream schemaIn;
                InputStream inputStream = schemaIn = schemaReader == null ? null : schemaReader.getSchemaAsStream(schemaPath);
                if (schemaIn == null) {
                    schema = schemaFactory.newSchema(schemaLocation.toURL());
                } else {
                    StreamSource schemaSource = new StreamSource(schemaIn, schemaPath);
                    schema = schemaFactory.newSchema(schemaSource);
                    schemaIn.close();
                }
                schemas.get().put(schemaLocation, schema);
            }
            catch (IOException exc) {
                LOGGER.info("Error parsing schema at {}", (Object)schemaPath, (Object)exc);
                return false;
            }
            catch (SAXException exc) {
                LOGGER.info("Error parsing schema at {}", (Object)schemaPath, (Object)exc);
                return false;
            }
        }
        Validator validator = schema.newValidator();
        StringReader reader = new StringReader(xml);
        InputSource is = new InputSource(reader);
        SAXSource source = new SAXSource(is);
        ValidationErrorHandler errorHandler = new ValidationErrorHandler();
        validator.setErrorHandler(errorHandler);
        try {
            validator.validate(source);
        }
        catch (IOException exc) {
            exception = exc;
        }
        catch (SAXException exc) {
            exception = exc;
        }
        int errors = errorHandler.getErrorCount();
        if (errors > 0) {
            LOGGER.info("Error validating document: {} errors found", (Object)errors);
            return false;
        }
        LOGGER.info("No validation errors found.");
        return errorHandler.ok();
    }

    private static void checkUTF8(InputStream is) throws IOException {
        is.mark(3);
        if (is.read() != 239 || is.read() != 187 || is.read() != 191) {
            is.reset();
        }
    }

    static class XMLListener
    implements ErrorListener {
        XMLListener() {
        }

        @Override
        public void error(TransformerException e) {
            LOGGER.debug("", e);
        }

        @Override
        public void fatalError(TransformerException e) {
            LOGGER.debug("", e);
        }

        @Override
        public void warning(TransformerException e) {
            LOGGER.debug("", e);
        }
    }

    public static interface SchemaReader {
        public InputStream getSchemaAsStream(String var1);
    }
}

