/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.AbstractDataLine;
import com.sun.media.sound.AbstractLine;
import com.sun.media.sound.AbstractMixer;
import com.sun.media.sound.CircularBuffer;
import com.sun.media.sound.Platform;
import com.sun.media.sound.Printer;
import com.sun.media.sound.SimpleOutputDeviceProvider;
import java.util.Vector;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.Control;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Port;
import javax.sound.sampled.SourceDataLine;

class SimpleOutputDevice
extends AbstractMixer {
    private Port[] ports;
    static /* synthetic */ Class class$javax$sound$sampled$DataLine;
    static /* synthetic */ Class class$javax$sound$sampled$SourceDataLine;
    static /* synthetic */ Class class$com$sun$media$sound$SimpleOutputDevice$OutputDeviceDataLine;

    SimpleOutputDevice(SimpleOutputDeviceProvider.OutputDeviceInfo outputDeviceInfo) {
        super(null, new Control[0], null, -1, outputDeviceInfo, null, null);
        AudioFormat[] formatArray;
        if (Printer.trace) {
            Printer.trace(">> SimpleOutputDevice: constructor");
        }
        Platform.initialize();
        boolean supports8 = this.nSupportsSampleSizeInBits(8);
        boolean supports16 = this.nSupportsSampleSizeInBits(16);
        boolean supportsMono = this.nSupportsChannels(1);
        boolean supportsStereo = this.nSupportsChannels(2);
        boolean supports8k = this.nSupportsSampleRate(8000.0f);
        boolean supports11k = this.nSupportsSampleRate(11025.0f);
        boolean supports16k = this.nSupportsSampleRate(16000.0f);
        boolean supports22k = this.nSupportsSampleRate(22050.0f);
        boolean supports32k = this.nSupportsSampleRate(32000.0f);
        boolean supports44k = this.nSupportsSampleRate(44100.0f);
        if (supports8 && supportsMono && supports8k) {
            this.formats.addElement(new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 8000.0f, 8, 1, 1, 8000.0f, false));
            this.formats.addElement(new AudioFormat(AudioFormat.Encoding.PCM_UNSIGNED, 8000.0f, 8, 1, 1, 8000.0f, false));
        }
        if (supports8 && supportsStereo && supports8k) {
            this.formats.addElement(new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 8000.0f, 8, 2, 2, 8000.0f, false));
            this.formats.addElement(new AudioFormat(AudioFormat.Encoding.PCM_UNSIGNED, 8000.0f, 8, 2, 2, 8000.0f, false));
        }
        if (supports16 && supportsMono && supports8k) {
            this.formats.addElement(new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 8000.0f, 16, 1, 2, 8000.0f, false));
            this.formats.addElement(new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 8000.0f, 16, 1, 2, 8000.0f, true));
        }
        if (supports16 && supportsStereo && supports8k) {
            this.formats.addElement(new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 8000.0f, 16, 2, 4, 8000.0f, false));
            this.formats.addElement(new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 8000.0f, 16, 2, 4, 8000.0f, true));
        }
        if (supports8 && supportsMono && supports11k) {
            this.formats.addElement(new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 11025.0f, 8, 1, 1, 11025.0f, false));
            this.formats.addElement(new AudioFormat(AudioFormat.Encoding.PCM_UNSIGNED, 11025.0f, 8, 1, 1, 11025.0f, false));
        }
        if (supports8 && supportsStereo && supports11k) {
            this.formats.addElement(new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 11025.0f, 8, 2, 2, 11025.0f, false));
            this.formats.addElement(new AudioFormat(AudioFormat.Encoding.PCM_UNSIGNED, 11025.0f, 8, 2, 2, 11025.0f, false));
        }
        if (supports16 && supportsMono && supports11k) {
            this.formats.addElement(new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 11025.0f, 16, 1, 2, 11025.0f, false));
            this.formats.addElement(new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 11025.0f, 16, 1, 2, 11025.0f, true));
        }
        if (supports16 && supportsStereo && supports11k) {
            this.formats.addElement(new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 11025.0f, 16, 2, 4, 11025.0f, false));
            this.formats.addElement(new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 11025.0f, 16, 2, 4, 11025.0f, true));
        }
        if (supports8 && supportsMono && supports16k) {
            this.formats.addElement(new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 16000.0f, 8, 1, 1, 16000.0f, false));
            this.formats.addElement(new AudioFormat(AudioFormat.Encoding.PCM_UNSIGNED, 16000.0f, 8, 1, 1, 16000.0f, false));
        }
        if (supports8 && supportsStereo && supports16k) {
            this.formats.addElement(new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 16000.0f, 8, 2, 2, 16000.0f, false));
            this.formats.addElement(new AudioFormat(AudioFormat.Encoding.PCM_UNSIGNED, 16000.0f, 8, 2, 2, 16000.0f, false));
        }
        if (supports16 && supportsMono && supports16k) {
            this.formats.addElement(new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 16000.0f, 16, 1, 2, 16000.0f, false));
            this.formats.addElement(new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 16000.0f, 16, 1, 2, 16000.0f, true));
        }
        if (supports16 && supportsStereo && supports16k) {
            this.formats.addElement(new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 16000.0f, 16, 2, 4, 16000.0f, false));
            this.formats.addElement(new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 16000.0f, 16, 2, 4, 16000.0f, true));
        }
        if (supports8 && supportsMono && supports22k) {
            this.formats.addElement(new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 22050.0f, 8, 1, 1, 22050.0f, false));
            this.formats.addElement(new AudioFormat(AudioFormat.Encoding.PCM_UNSIGNED, 22050.0f, 8, 1, 1, 22050.0f, false));
        }
        if (supports8 && supportsStereo && supports22k) {
            this.formats.addElement(new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 22050.0f, 8, 2, 2, 22050.0f, false));
            this.formats.addElement(new AudioFormat(AudioFormat.Encoding.PCM_UNSIGNED, 22050.0f, 8, 2, 2, 22050.0f, false));
        }
        if (supports16 && supportsMono && supports22k) {
            this.formats.addElement(new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 22050.0f, 16, 1, 2, 22050.0f, false));
            this.formats.addElement(new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 22050.0f, 16, 1, 2, 22050.0f, true));
        }
        if (supports16 && supportsStereo && supports22k) {
            this.formats.addElement(new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 22050.0f, 16, 2, 4, 22050.0f, false));
            this.formats.addElement(new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 22050.0f, 16, 2, 4, 22050.0f, true));
        }
        if (supports8 && supportsMono && supports32k) {
            this.formats.addElement(new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 32000.0f, 8, 1, 1, 32000.0f, false));
            this.formats.addElement(new AudioFormat(AudioFormat.Encoding.PCM_UNSIGNED, 32000.0f, 8, 1, 1, 32000.0f, false));
        }
        if (supports8 && supportsStereo && supports32k) {
            this.formats.addElement(new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 32000.0f, 8, 2, 2, 32000.0f, false));
            this.formats.addElement(new AudioFormat(AudioFormat.Encoding.PCM_UNSIGNED, 32000.0f, 8, 2, 2, 32000.0f, false));
        }
        if (supports16 && supportsMono && supports32k) {
            this.formats.addElement(new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 32000.0f, 16, 1, 2, 32000.0f, false));
            this.formats.addElement(new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 32000.0f, 16, 1, 2, 32000.0f, true));
        }
        if (supports16 && supportsStereo && supports32k) {
            this.formats.addElement(new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 32000.0f, 16, 2, 4, 32000.0f, false));
            this.formats.addElement(new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 32000.0f, 16, 2, 4, 32000.0f, true));
        }
        if (supports8 && supportsMono && supports44k) {
            this.formats.addElement(new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 44100.0f, 8, 1, 1, 44100.0f, false));
            this.formats.addElement(new AudioFormat(AudioFormat.Encoding.PCM_UNSIGNED, 44100.0f, 8, 1, 1, 44100.0f, false));
        }
        if (supports8 && supportsStereo && supports44k) {
            this.formats.addElement(new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 44100.0f, 8, 2, 2, 44100.0f, false));
            this.formats.addElement(new AudioFormat(AudioFormat.Encoding.PCM_UNSIGNED, 44100.0f, 8, 2, 2, 44100.0f, false));
        }
        if (supports16 && supportsMono && supports44k) {
            this.formats.addElement(new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 44100.0f, 16, 1, 2, 44100.0f, false));
            this.formats.addElement(new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 44100.0f, 16, 1, 2, 44100.0f, true));
        }
        if (supports16 && supportsStereo && supports44k) {
            this.formats.addElement(new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 44100.0f, 16, 2, 4, 44100.0f, false));
            this.formats.addElement(new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 44100.0f, 16, 2, 4, 44100.0f, true));
        }
        Vector vector = this.formats;
        synchronized (vector) {
            formatArray = new AudioFormat[this.formats.size()];
            int i = 0;
            while (i < formatArray.length) {
                formatArray[i] = (AudioFormat)this.formats.elementAt(i);
                ++i;
            }
        }
        this.info = new DataLine.Info(class$javax$sound$sampled$DataLine == null ? (class$javax$sound$sampled$DataLine = SimpleOutputDevice.class$("javax.sound.sampled.DataLine")) : class$javax$sound$sampled$DataLine, formatArray, 0, -1);
        int numPorts = this.nGetNumPorts();
        this.targetLineInfo = new Port.Info[numPorts];
        this.ports = new Port[numPorts];
        int i = 0;
        while (i < numPorts) {
            String name = this.nGetPortName(i);
            this.targetLineInfo[i] = this.getPortInfo(name);
            this.ports[i] = new OutputDevicePort((Port.Info)this.targetLineInfo[i], this, new Control[0]);
            ++i;
        }
        this.sourceLineInfo = new DataLine.Info[1];
        this.sourceLineInfo[0] = new DataLine.Info(class$javax$sound$sampled$SourceDataLine == null ? (class$javax$sound$sampled$SourceDataLine = SimpleOutputDevice.class$("javax.sound.sampled.SourceDataLine")) : class$javax$sound$sampled$SourceDataLine, formatArray, 0, -1);
        this.format = this.formats.size() > 0 ? (AudioFormat)this.formats.lastElement() : null;
        if (Printer.trace) {
            Printer.trace("<< SimpleOutputDevice: constructor completed");
        }
    }

    public Line getLine(Line.Info info) throws LineUnavailableException {
        DataLine.Info dataLineInfo;
        Line.Info fullInfo = this.getLineInfo(info);
        if (fullInfo == null) {
            throw new IllegalArgumentException("Line unsupported: " + info);
        }
        if (fullInfo instanceof Port.Info) {
            int i = 0;
            while (i < this.ports.length) {
                if (fullInfo.equals(this.ports[i].getLineInfo())) {
                    return this.ports[i];
                }
                ++i;
            }
        }
        if (fullInfo instanceof DataLine.Info && (dataLineInfo = (DataLine.Info)info).getLineClass().isAssignableFrom(class$com$sun$media$sound$SimpleOutputDevice$OutputDeviceDataLine == null ? (class$com$sun$media$sound$SimpleOutputDevice$OutputDeviceDataLine = SimpleOutputDevice.class$("com.sun.media.sound.SimpleOutputDevice$OutputDeviceDataLine")) : class$com$sun$media$sound$SimpleOutputDevice$OutputDeviceDataLine)) {
            AudioFormat[] supportedFormats = dataLineInfo.getFormats();
            AudioFormat defaultFormat = supportedFormats[supportedFormats.length - 1];
            return new OutputDeviceDataLine(dataLineInfo, this, defaultFormat, dataLineInfo.getMaxBufferSize());
        }
        throw new IllegalArgumentException("Line unsupported: " + info);
    }

    public int getMaxLines(Line.Info info) {
        Line.Info fullInfo = this.getLineInfo(info);
        if (fullInfo == null) {
            return 0;
        }
        if (fullInfo instanceof Port.Info) {
            return this.ports.length;
        }
        if (fullInfo instanceof DataLine.Info) {
            return 1;
        }
        return 0;
    }

    void implOpen(AudioFormat format, int bufferSize) throws LineUnavailableException {
        this.nOpen(((SimpleOutputDeviceProvider.OutputDeviceInfo)this.getMixerInfo()).getIndex(), (int)format.getSampleRate(), format.getSampleSizeInBits(), format.getChannels(), bufferSize / format.getFrameSize());
        this.format = format;
        this.bufferSize = bufferSize;
    }

    public void implClose() {
        this.nClose();
    }

    void implStart() {
        this.nStart();
    }

    void implStop() {
        this.nStart();
    }

    private Port.Info getPortInfo(String name) {
        if (name.equals(Port.Info.SPEAKER.toString())) {
            return Port.Info.SPEAKER;
        }
        if (name.equals(Port.Info.HEADPHONE.toString())) {
            return Port.Info.HEADPHONE;
        }
        if (name.equals(Port.Info.LINE_OUT.toString())) {
            return Port.Info.LINE_OUT;
        }
        return new OutputDevicePortInfo(name);
    }

    private native void nOpen(int var1, float var2, int var3, int var4, int var5) throws LineUnavailableException;

    private native void nClose();

    private native void nStart();

    private native void nStop();

    private native boolean nSupportsSampleRate(float var1);

    private native boolean nSupportsSampleSizeInBits(int var1);

    private native boolean nSupportsChannels(int var1);

    private native int nGetNumPorts();

    private native String nGetPortName(int var1);

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class OutputDevicePortInfo
    extends Port.Info {
        static /* synthetic */ Class class$javax$sound$sampled$Port;

        private OutputDevicePortInfo(String name) {
            super(class$javax$sound$sampled$Port == null ? (class$javax$sound$sampled$Port = OutputDevicePortInfo.class$("javax.sound.sampled.Port")) : class$javax$sound$sampled$Port, name, false);
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    private class OutputDevicePort
    extends AbstractLine
    implements Port {
        private OutputDevicePort(Port.Info info, AbstractMixer mixer, Control[] controls) {
            super(info, mixer, controls);
        }

        public void open() throws LineUnavailableException {
        }

        public void close() {
        }
    }

    private class OutputDeviceDataLine
    extends AbstractDataLine
    implements SourceDataLine {
        private CircularBuffer circularBuffer = null;

        private OutputDeviceDataLine(DataLine.Info info, SimpleOutputDevice mixer, AudioFormat initialFormat, int initialBufferSize) {
            super(info, mixer, null, initialFormat, initialBufferSize);
        }

        public int write(byte[] b, int off, int len) {
            throw new SecurityException("Permission to read data from the output device not granted.");
        }

        public int available() {
            return 0;
        }

        void implOpen(AudioFormat format, int bufferSize) throws LineUnavailableException {
            throw new SecurityException("Permission to read data from the output device not granted.");
        }

        void implClose() {
            throw new SecurityException("Permission to read data from the output device not granted.");
        }

        void implStart() {
            throw new SecurityException("Permission to read data from the output device not granted.");
        }

        void implStop() {
            throw new SecurityException("Permission to read data from the output device not granted.");
        }

        private CircularBuffer getCircularBuffer() {
            return this.circularBuffer;
        }
    }
}

