/*
 * Decompiled with CFR 0.152.
 */
package com.xuggle.xuggler.demos;

import com.xuggle.xuggler.IAudioSamples;
import com.xuggle.xuggler.ICodec;
import com.xuggle.xuggler.IContainer;
import com.xuggle.xuggler.IPacket;
import com.xuggle.xuggler.IStream;
import com.xuggle.xuggler.IStreamCoder;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;

public class DecodeAndPlayAudio {
    private static SourceDataLine mLine;

    public static void main(String[] args) {
        if (args.length <= 0) {
            throw new IllegalArgumentException("must pass in a filename as the first argument");
        }
        String filename = args[0];
        IContainer container = IContainer.make();
        if (container.open(filename, IContainer.Type.READ, null) < 0) {
            throw new IllegalArgumentException("could not open file: " + filename);
        }
        int numStreams = container.getNumStreams();
        int audioStreamId = -1;
        IStreamCoder audioCoder = null;
        for (int i = 0; i < numStreams; ++i) {
            IStream stream = container.getStream(i);
            IStreamCoder coder = stream.getStreamCoder();
            if (coder.getCodecType() != ICodec.Type.CODEC_TYPE_AUDIO) continue;
            audioStreamId = i;
            audioCoder = coder;
            break;
        }
        if (audioStreamId == -1) {
            throw new RuntimeException("could not find audio stream in container: " + filename);
        }
        if (audioCoder.open(null, null) < 0) {
            throw new RuntimeException("could not open audio decoder for container: " + filename);
        }
        DecodeAndPlayAudio.openJavaSound(audioCoder);
        IPacket packet = IPacket.make();
        while (container.readNextPacket(packet) >= 0) {
            int bytesDecoded;
            if (packet.getStreamIndex() != audioStreamId) continue;
            IAudioSamples samples = IAudioSamples.make(1024L, audioCoder.getChannels());
            for (int offset = 0; offset < packet.getSize(); offset += bytesDecoded) {
                bytesDecoded = audioCoder.decodeAudio(samples, packet, offset);
                if (bytesDecoded >= 0) continue;
                throw new RuntimeException("got error decoding audio in: " + filename);
            }
        }
        DecodeAndPlayAudio.closeJavaSound();
        if (audioCoder != null) {
            audioCoder.close();
            audioCoder = null;
        }
        if (container != null) {
            container.close();
            container = null;
        }
    }

    private static void openJavaSound(IStreamCoder aAudioCoder) {
        AudioFormat audioFormat = new AudioFormat(aAudioCoder.getSampleRate(), (int)IAudioSamples.findSampleBitDepth(aAudioCoder.getSampleFormat()), aAudioCoder.getChannels(), true, false);
        DataLine.Info info = new DataLine.Info(SourceDataLine.class, audioFormat);
        try {
            mLine = (SourceDataLine)AudioSystem.getLine(info);
            mLine.open(audioFormat);
            mLine.start();
        }
        catch (LineUnavailableException e) {
            throw new RuntimeException("could not open audio line");
        }
    }

    private static void playJavaSound(IAudioSamples aSamples) {
        byte[] rawBytes = aSamples.getData().getByteArray(0, aSamples.getSize());
        mLine.write(rawBytes, 0, aSamples.getSize());
    }

    private static void closeJavaSound() {
        if (mLine != null) {
            mLine.drain();
            mLine.close();
            mLine = null;
        }
    }
}

