/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfcomplex.impl;

import cern.colt.ConcurrencyUtils;
import cern.colt.function.tfcomplex.FComplexFComplexFComplexFunction;
import cern.colt.function.tfcomplex.FComplexFComplexFunction;
import cern.colt.function.tfcomplex.FComplexProcedure;
import cern.colt.function.tfcomplex.FComplexRealFunction;
import cern.colt.list.tint.IntArrayList;
import cern.colt.matrix.AbstractMatrix2D;
import cern.colt.matrix.AbstractMatrix3D;
import cern.colt.matrix.tfcomplex.FComplexMatrix1D;
import cern.colt.matrix.tfcomplex.FComplexMatrix2D;
import cern.colt.matrix.tfcomplex.FComplexMatrix3D;
import cern.colt.matrix.tfcomplex.impl.DenseFComplexMatrix2D;
import cern.colt.matrix.tfcomplex.impl.DenseFComplexMatrix3D;
import cern.colt.matrix.tfcomplex.impl.SelectedDenseFComplexMatrix1D;
import cern.colt.matrix.tfloat.FloatMatrix1D;
import cern.colt.matrix.tfloat.impl.DenseFloatMatrix1D;
import cern.jet.math.tfcomplex.FComplex;
import cern.jet.math.tfcomplex.FComplexFunctions;
import cern.jet.math.tfcomplex.FComplexMult;
import edu.emory.mathcs.jtransforms.fft.FloatFFT_1D;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class DenseFComplexMatrix1D
extends FComplexMatrix1D {
    private static final long serialVersionUID = 1L;
    private FloatFFT_1D fft;
    protected float[] elements;

    public DenseFComplexMatrix1D(float[] values) {
        this(values.length / 2);
        this.assign(values);
    }

    public DenseFComplexMatrix1D(FloatMatrix1D realPart) {
        this((int)realPart.size());
        this.assignReal(realPart);
    }

    public DenseFComplexMatrix1D(int size) {
        this.setUp(size, 0, 2);
        this.isNoView = true;
        this.elements = new float[2 * size];
    }

    public DenseFComplexMatrix1D(int size, float[] elements, int zero, int stride, boolean isNoView) {
        this.setUp(size, zero, stride);
        this.elements = elements;
        this.isNoView = isNoView;
    }

    @Override
    public float[] aggregate(final FComplexFComplexFComplexFunction aggr, final FComplexFComplexFunction f) {
        float[] b = new float[2];
        if (this.size == 0) {
            b[0] = Float.NaN;
            b[1] = Float.NaN;
            return b;
        }
        float[] a = null;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<float[]>(){

                    @Override
                    public float[] call() throws Exception {
                        int idx = DenseFComplexMatrix1D.this.zero + firstIdx * DenseFComplexMatrix1D.this.stride;
                        float[] a = f.apply(new float[]{DenseFComplexMatrix1D.this.elements[idx], DenseFComplexMatrix1D.this.elements[idx + 1]});
                        int i = firstIdx + 1;
                        while (i < lastIdx) {
                            a = aggr.apply(a, f.apply(new float[]{DenseFComplexMatrix1D.this.elements[idx += DenseFComplexMatrix1D.this.stride], DenseFComplexMatrix1D.this.elements[idx + 1]}));
                            ++i;
                        }
                        return a;
                    }
                });
                ++j;
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            a = f.apply(new float[]{this.elements[this.zero], this.elements[this.zero + 1]});
            int idx = this.zero;
            int i = 1;
            while (i < this.size) {
                a = aggr.apply(a, f.apply(new float[]{this.elements[idx += this.stride], this.elements[idx + 1]}));
                ++i;
            }
        }
        return a;
    }

    @Override
    public float[] aggregate(FComplexMatrix1D other, final FComplexFComplexFComplexFunction aggr, final FComplexFComplexFComplexFunction f) {
        if (!(other instanceof DenseFComplexMatrix1D)) {
            return super.aggregate(other, aggr, f);
        }
        this.checkSize(other);
        if (this.size == 0) {
            float[] b = new float[]{Float.NaN, Float.NaN};
            return b;
        }
        final int zeroOther = (int)other.index(0);
        final int strideOther = other.stride();
        final float[] elemsOther = (float[])other.elements();
        float[] a = null;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<float[]>(){

                    @Override
                    public float[] call() throws Exception {
                        int idx = DenseFComplexMatrix1D.this.zero + firstIdx * DenseFComplexMatrix1D.this.stride;
                        int idxOther = zeroOther + firstIdx * strideOther;
                        float[] a = f.apply(new float[]{DenseFComplexMatrix1D.this.elements[idx], DenseFComplexMatrix1D.this.elements[idx + 1]}, new float[]{elemsOther[idxOther], elemsOther[idxOther + 1]});
                        int i = firstIdx + 1;
                        while (i < lastIdx) {
                            a = aggr.apply(a, f.apply(new float[]{DenseFComplexMatrix1D.this.elements[idx += DenseFComplexMatrix1D.this.stride], DenseFComplexMatrix1D.this.elements[idx + 1]}, new float[]{elemsOther[idxOther += strideOther], elemsOther[idxOther + 1]}));
                            ++i;
                        }
                        return a;
                    }
                });
                ++j;
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            int idx = this.zero;
            int idxOther = zeroOther;
            a = f.apply(new float[]{this.elements[this.zero], this.elements[this.zero + 1]}, new float[]{elemsOther[zeroOther], elemsOther[zeroOther + 1]});
            int i = 1;
            while (i < this.size) {
                a = aggr.apply(a, f.apply(new float[]{this.elements[idx += this.stride], this.elements[idx + 1]}, new float[]{elemsOther[idxOther += strideOther], elemsOther[idxOther + 1]}));
                ++i;
            }
        }
        return a;
    }

    @Override
    public FComplexMatrix1D assign(final FComplexFComplexFunction function) {
        float[] multiplicator;
        if (this.elements == null) {
            throw new InternalError();
        }
        if (function instanceof FComplexMult && (multiplicator = ((FComplexMult)function).multiplicator)[0] == 1.0f && multiplicator[1] == 0.0f) {
            return this;
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        float[] tmp = new float[2];
                        int idx = DenseFComplexMatrix1D.this.zero + firstIdx * DenseFComplexMatrix1D.this.stride;
                        if (function instanceof FComplexMult) {
                            float[] multiplicator = ((FComplexMult)function).multiplicator;
                            int k = firstIdx;
                            while (k < lastIdx) {
                                DenseFComplexMatrix1D.this.elements[idx] = DenseFComplexMatrix1D.this.elements[idx] * multiplicator[0] - DenseFComplexMatrix1D.this.elements[idx + 1] * multiplicator[1];
                                DenseFComplexMatrix1D.this.elements[idx + 1] = DenseFComplexMatrix1D.this.elements[idx + 1] * multiplicator[0] + DenseFComplexMatrix1D.this.elements[idx] * multiplicator[1];
                                idx += DenseFComplexMatrix1D.this.stride;
                                ++k;
                            }
                        } else {
                            int k = firstIdx;
                            while (k < lastIdx) {
                                tmp[0] = DenseFComplexMatrix1D.this.elements[idx];
                                tmp[1] = DenseFComplexMatrix1D.this.elements[idx + 1];
                                tmp = function.apply(tmp);
                                DenseFComplexMatrix1D.this.elements[idx] = tmp[0];
                                DenseFComplexMatrix1D.this.elements[idx + 1] = tmp[1];
                                idx += DenseFComplexMatrix1D.this.stride;
                                ++k;
                            }
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            float[] tmp = new float[2];
            int idx = this.zero;
            if (function instanceof FComplexMult) {
                float[] multiplicator2 = ((FComplexMult)function).multiplicator;
                int k = 0;
                while (k < this.size) {
                    this.elements[idx] = this.elements[idx] * multiplicator2[0] - this.elements[idx + 1] * multiplicator2[1];
                    this.elements[idx + 1] = this.elements[idx + 1] * multiplicator2[0] + this.elements[idx] * multiplicator2[1];
                    idx += this.stride;
                    ++k;
                }
            } else {
                int k = 0;
                while (k < this.size) {
                    tmp[0] = this.elements[idx];
                    tmp[1] = this.elements[idx + 1];
                    tmp = function.apply(tmp);
                    this.elements[idx] = tmp[0];
                    this.elements[idx + 1] = tmp[1];
                    idx += this.stride;
                    ++k;
                }
            }
        }
        return this;
    }

    @Override
    public FComplexMatrix1D assign(final FComplexProcedure cond, final FComplexFComplexFunction function) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        float[] elem = new float[2];
                        int idx = DenseFComplexMatrix1D.this.zero + firstIdx * DenseFComplexMatrix1D.this.stride;
                        int i = firstIdx;
                        while (i < lastIdx) {
                            elem[0] = DenseFComplexMatrix1D.this.elements[idx];
                            elem[1] = DenseFComplexMatrix1D.this.elements[idx + 1];
                            if (cond.apply(elem)) {
                                elem = function.apply(elem);
                                DenseFComplexMatrix1D.this.elements[idx] = elem[0];
                                DenseFComplexMatrix1D.this.elements[idx + 1] = elem[1];
                            }
                            idx += DenseFComplexMatrix1D.this.stride;
                            ++i;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            float[] elem = new float[2];
            int idx = this.zero;
            int i = 0;
            while (i < this.size) {
                elem[0] = this.elements[idx];
                elem[1] = this.elements[idx + 1];
                if (cond.apply(elem)) {
                    elem = function.apply(elem);
                    this.elements[idx] = elem[0];
                    this.elements[idx + 1] = elem[1];
                }
                idx += this.stride;
                ++i;
            }
        }
        return this;
    }

    @Override
    public FComplexMatrix1D assign(final FComplexProcedure cond, final float[] value) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        float[] elem = new float[2];
                        int idx = DenseFComplexMatrix1D.this.zero + firstIdx * DenseFComplexMatrix1D.this.stride;
                        int i = firstIdx;
                        while (i < lastIdx) {
                            elem[0] = DenseFComplexMatrix1D.this.elements[idx];
                            elem[1] = DenseFComplexMatrix1D.this.elements[idx + 1];
                            if (cond.apply(elem)) {
                                DenseFComplexMatrix1D.this.elements[idx] = value[0];
                                DenseFComplexMatrix1D.this.elements[idx + 1] = value[1];
                            }
                            idx += DenseFComplexMatrix1D.this.stride;
                            ++i;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            float[] elem = new float[2];
            int idx = this.zero;
            int i = 0;
            while (i < this.size) {
                elem[0] = this.elements[idx];
                elem[1] = this.elements[idx + 1];
                if (cond.apply(elem)) {
                    this.elements[idx] = value[0];
                    this.elements[idx + 1] = value[1];
                }
                idx += this.stride;
                ++i;
            }
        }
        return this;
    }

    @Override
    public FComplexMatrix1D assign(final FComplexRealFunction function) {
        if (this.elements == null) {
            throw new InternalError();
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = DenseFComplexMatrix1D.this.zero + firstIdx * DenseFComplexMatrix1D.this.stride;
                        if (function == FComplexFunctions.abs) {
                            int k = firstIdx;
                            while (k < lastIdx) {
                                float d;
                                float absX = Math.abs(DenseFComplexMatrix1D.this.elements[idx]);
                                float absY = Math.abs(DenseFComplexMatrix1D.this.elements[idx + 1]);
                                if ((double)absX == 0.0 && (double)absY == 0.0) {
                                    DenseFComplexMatrix1D.this.elements[idx] = 0.0f;
                                } else if (absX >= absY) {
                                    d = DenseFComplexMatrix1D.this.elements[idx + 1] / DenseFComplexMatrix1D.this.elements[idx];
                                    DenseFComplexMatrix1D.this.elements[idx] = absX * (float)Math.sqrt(1.0 + (double)(d * d));
                                } else {
                                    d = DenseFComplexMatrix1D.this.elements[idx] / DenseFComplexMatrix1D.this.elements[idx + 1];
                                    DenseFComplexMatrix1D.this.elements[idx] = absY * (float)Math.sqrt(1.0 + (double)(d * d));
                                }
                                DenseFComplexMatrix1D.this.elements[idx + 1] = 0.0f;
                                idx += DenseFComplexMatrix1D.this.stride;
                                ++k;
                            }
                        } else {
                            float[] tmp = new float[2];
                            int k = firstIdx;
                            while (k < lastIdx) {
                                tmp[0] = DenseFComplexMatrix1D.this.elements[idx];
                                tmp[1] = DenseFComplexMatrix1D.this.elements[idx + 1];
                                tmp[0] = function.apply(tmp);
                                DenseFComplexMatrix1D.this.elements[idx] = tmp[0];
                                DenseFComplexMatrix1D.this.elements[idx + 1] = 0.0f;
                                idx += DenseFComplexMatrix1D.this.stride;
                                ++k;
                            }
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = this.zero;
            if (function == FComplexFunctions.abs) {
                int k = 0;
                while (k < this.size) {
                    float d;
                    float absX = Math.abs(this.elements[idx]);
                    float absY = Math.abs(this.elements[idx + 1]);
                    if ((double)absX == 0.0 && (double)absY == 0.0) {
                        this.elements[idx] = 0.0f;
                    } else if (absX >= absY) {
                        d = this.elements[idx + 1] / this.elements[idx];
                        this.elements[idx] = absX * (float)Math.sqrt(1.0 + (double)(d * d));
                    } else {
                        d = this.elements[idx] / this.elements[idx + 1];
                        this.elements[idx] = absY * (float)Math.sqrt(1.0 + (double)(d * d));
                    }
                    this.elements[idx + 1] = 0.0f;
                    idx += this.stride;
                    ++k;
                }
            } else {
                float[] tmp = new float[2];
                int k = 0;
                while (k < this.size) {
                    tmp[0] = this.elements[idx];
                    tmp[1] = this.elements[idx + 1];
                    tmp[0] = function.apply(tmp);
                    this.elements[idx] = tmp[0];
                    this.elements[idx + 1] = 0.0f;
                    idx += this.stride;
                    ++k;
                }
            }
        }
        return this;
    }

    @Override
    public FComplexMatrix1D assign(FComplexMatrix1D source) {
        if (!(source instanceof DenseFComplexMatrix1D)) {
            return super.assign(source);
        }
        DenseFComplexMatrix1D other = (DenseFComplexMatrix1D)source;
        if (other == this) {
            return this;
        }
        this.checkSize(other);
        if (this.isNoView && other.isNoView) {
            System.arraycopy(other.elements, 0, this.elements, 0, this.elements.length);
            return this;
        }
        if (this.haveSharedCells(other)) {
            FComplexMatrix1D c = other.copy();
            if (!(c instanceof DenseFComplexMatrix1D)) {
                return super.assign(source);
            }
            other = (DenseFComplexMatrix1D)c;
        }
        final float[] elemsOther = other.elements;
        if (this.elements == null || elemsOther == null) {
            throw new InternalError();
        }
        final int strideOther = other.stride;
        final int zeroOther = (int)other.index(0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = DenseFComplexMatrix1D.this.zero + firstIdx * DenseFComplexMatrix1D.this.stride;
                        int idxOther = zeroOther + firstIdx * strideOther;
                        int k = firstIdx;
                        while (k < lastIdx) {
                            DenseFComplexMatrix1D.this.elements[idx] = elemsOther[idxOther];
                            DenseFComplexMatrix1D.this.elements[idx + 1] = elemsOther[idxOther + 1];
                            idx += DenseFComplexMatrix1D.this.stride;
                            idxOther += strideOther;
                            ++k;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = this.zero;
            int idxOther = zeroOther;
            int k = 0;
            while (k < this.size) {
                this.elements[idx] = elemsOther[idxOther];
                this.elements[idx + 1] = elemsOther[idxOther + 1];
                idx += this.stride;
                idxOther += strideOther;
                ++k;
            }
        }
        return this;
    }

    @Override
    public FComplexMatrix1D assign(FComplexMatrix1D y, final FComplexFComplexFComplexFunction function) {
        if (!(y instanceof DenseFComplexMatrix1D)) {
            return super.assign(y, function);
        }
        this.checkSize(y);
        final float[] elemsOther = (float[])y.elements();
        final int zeroOther = (int)y.index(0);
        final int strideOther = y.stride();
        if (this.elements == null || elemsOther == null) {
            throw new InternalError();
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = DenseFComplexMatrix1D.this.zero + firstIdx * DenseFComplexMatrix1D.this.stride;
                        int idxOther = zeroOther + firstIdx * strideOther;
                        if (function == FComplexFunctions.plus) {
                            int k = firstIdx;
                            while (k < lastIdx) {
                                int n = idx;
                                DenseFComplexMatrix1D.this.elements[n] = DenseFComplexMatrix1D.this.elements[n] + elemsOther[idxOther];
                                int n2 = idx + 1;
                                DenseFComplexMatrix1D.this.elements[n2] = DenseFComplexMatrix1D.this.elements[n2] + elemsOther[idxOther + 1];
                                idx += DenseFComplexMatrix1D.this.stride;
                                idxOther += strideOther;
                                ++k;
                            }
                        } else if (function == FComplexFunctions.minus) {
                            int k = firstIdx;
                            while (k < lastIdx) {
                                int n = idx;
                                DenseFComplexMatrix1D.this.elements[n] = DenseFComplexMatrix1D.this.elements[n] - elemsOther[idxOther];
                                int n3 = idx + 1;
                                DenseFComplexMatrix1D.this.elements[n3] = DenseFComplexMatrix1D.this.elements[n3] - elemsOther[idxOther + 1];
                                idx += DenseFComplexMatrix1D.this.stride;
                                idxOther += strideOther;
                                ++k;
                            }
                        } else if (function == FComplexFunctions.div) {
                            float[] tmp = new float[2];
                            int k = firstIdx;
                            while (k < lastIdx) {
                                float scalar;
                                float re = elemsOther[idxOther];
                                float im = elemsOther[idxOther + 1];
                                if (Math.abs(re) >= Math.abs(im)) {
                                    scalar = (float)(1.0 / (double)(re + im * (im / re)));
                                    tmp[0] = scalar * (DenseFComplexMatrix1D.this.elements[idx] + DenseFComplexMatrix1D.this.elements[idx + 1] * (im / re));
                                    tmp[1] = scalar * (DenseFComplexMatrix1D.this.elements[idx + 1] - DenseFComplexMatrix1D.this.elements[idx] * (im / re));
                                } else {
                                    scalar = (float)(1.0 / (double)(re * (re / im) + im));
                                    tmp[0] = scalar * (DenseFComplexMatrix1D.this.elements[idx] * (re / im) + DenseFComplexMatrix1D.this.elements[idx + 1]);
                                    tmp[1] = scalar * (DenseFComplexMatrix1D.this.elements[idx + 1] * (re / im) - DenseFComplexMatrix1D.this.elements[idx]);
                                }
                                DenseFComplexMatrix1D.this.elements[idx] = tmp[0];
                                DenseFComplexMatrix1D.this.elements[idx + 1] = tmp[1];
                                idx += DenseFComplexMatrix1D.this.stride;
                                idxOther += strideOther;
                                ++k;
                            }
                        } else if (function == FComplexFunctions.mult) {
                            float[] tmp = new float[2];
                            int k = firstIdx;
                            while (k < lastIdx) {
                                tmp[0] = DenseFComplexMatrix1D.this.elements[idx] * elemsOther[idxOther] - DenseFComplexMatrix1D.this.elements[idx + 1] * elemsOther[idxOther + 1];
                                tmp[1] = DenseFComplexMatrix1D.this.elements[idx + 1] * elemsOther[idxOther] + DenseFComplexMatrix1D.this.elements[idx] * elemsOther[idxOther + 1];
                                DenseFComplexMatrix1D.this.elements[idx] = tmp[0];
                                DenseFComplexMatrix1D.this.elements[idx + 1] = tmp[1];
                                idx += DenseFComplexMatrix1D.this.stride;
                                idxOther += strideOther;
                                ++k;
                            }
                        } else if (function == FComplexFunctions.multConjFirst) {
                            float[] tmp = new float[2];
                            int k = firstIdx;
                            while (k < lastIdx) {
                                tmp[0] = DenseFComplexMatrix1D.this.elements[idx] * elemsOther[idxOther] + DenseFComplexMatrix1D.this.elements[idx + 1] * elemsOther[idxOther + 1];
                                tmp[1] = -DenseFComplexMatrix1D.this.elements[idx + 1] * elemsOther[idxOther] + DenseFComplexMatrix1D.this.elements[idx] * elemsOther[idxOther + 1];
                                DenseFComplexMatrix1D.this.elements[idx] = tmp[0];
                                DenseFComplexMatrix1D.this.elements[idx + 1] = tmp[1];
                                idx += DenseFComplexMatrix1D.this.stride;
                                idxOther += strideOther;
                                ++k;
                            }
                        } else if (function == FComplexFunctions.multConjSecond) {
                            float[] tmp = new float[2];
                            int k = firstIdx;
                            while (k < lastIdx) {
                                tmp[0] = DenseFComplexMatrix1D.this.elements[idx] * elemsOther[idxOther] + DenseFComplexMatrix1D.this.elements[idx + 1] * elemsOther[idxOther + 1];
                                tmp[1] = DenseFComplexMatrix1D.this.elements[idx + 1] * elemsOther[idxOther] - DenseFComplexMatrix1D.this.elements[idx] * elemsOther[idxOther + 1];
                                DenseFComplexMatrix1D.this.elements[idx] = tmp[0];
                                DenseFComplexMatrix1D.this.elements[idx + 1] = tmp[1];
                                idx += DenseFComplexMatrix1D.this.stride;
                                idxOther += strideOther;
                                ++k;
                            }
                        } else {
                            float[] tmp1 = new float[2];
                            float[] tmp2 = new float[2];
                            int k = firstIdx;
                            while (k < lastIdx) {
                                tmp1[0] = DenseFComplexMatrix1D.this.elements[idx];
                                tmp1[1] = DenseFComplexMatrix1D.this.elements[idx + 1];
                                tmp2[0] = elemsOther[idxOther];
                                tmp2[1] = elemsOther[idxOther + 1];
                                tmp1 = function.apply(tmp1, tmp2);
                                DenseFComplexMatrix1D.this.elements[idx] = tmp1[0];
                                DenseFComplexMatrix1D.this.elements[idx + 1] = tmp1[1];
                                idx += DenseFComplexMatrix1D.this.stride;
                                idxOther += strideOther;
                                ++k;
                            }
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = this.zero;
            int idxOther = zeroOther;
            if (function == FComplexFunctions.plus) {
                int k = 0;
                while (k < this.size) {
                    int n = idx;
                    this.elements[n] = this.elements[n] + elemsOther[idxOther];
                    int n2 = idx + 1;
                    this.elements[n2] = this.elements[n2] + elemsOther[idxOther + 1];
                    idx += this.stride;
                    idxOther += strideOther;
                    ++k;
                }
            } else if (function == FComplexFunctions.minus) {
                int k = 0;
                while (k < this.size) {
                    int n = idx;
                    this.elements[n] = this.elements[n] - elemsOther[idxOther];
                    int n3 = idx + 1;
                    this.elements[n3] = this.elements[n3] - elemsOther[idxOther + 1];
                    idx += this.stride;
                    idxOther += strideOther;
                    ++k;
                }
            } else if (function == FComplexFunctions.div) {
                float[] tmp = new float[2];
                int k = 0;
                while (k < this.size) {
                    float scalar;
                    float re = elemsOther[idxOther];
                    float im = elemsOther[idxOther + 1];
                    if (Math.abs(re) >= Math.abs(im)) {
                        scalar = (float)(1.0 / (double)(re + im * (im / re)));
                        tmp[0] = scalar * (this.elements[idx] + this.elements[idx + 1] * (im / re));
                        tmp[1] = scalar * (this.elements[idx + 1] - this.elements[idx] * (im / re));
                    } else {
                        scalar = (float)(1.0 / (double)(re * (re / im) + im));
                        tmp[0] = scalar * (this.elements[idx] * (re / im) + this.elements[idx + 1]);
                        tmp[1] = scalar * (this.elements[idx + 1] * (re / im) - this.elements[idx]);
                    }
                    this.elements[idx] = tmp[0];
                    this.elements[idx + 1] = tmp[1];
                    idx += this.stride;
                    idxOther += strideOther;
                    ++k;
                }
            } else if (function == FComplexFunctions.mult) {
                float[] tmp = new float[2];
                int k = 0;
                while (k < this.size) {
                    tmp[0] = this.elements[idx] * elemsOther[idxOther] - this.elements[idx + 1] * elemsOther[idxOther + 1];
                    tmp[1] = this.elements[idx + 1] * elemsOther[idxOther] + this.elements[idx] * elemsOther[idxOther + 1];
                    this.elements[idx] = tmp[0];
                    this.elements[idx + 1] = tmp[1];
                    idx += this.stride;
                    idxOther += strideOther;
                    ++k;
                }
            } else if (function == FComplexFunctions.multConjFirst) {
                float[] tmp = new float[2];
                int k = 0;
                while (k < this.size) {
                    tmp[0] = this.elements[idx] * elemsOther[idxOther] + this.elements[idx + 1] * elemsOther[idxOther + 1];
                    tmp[1] = -this.elements[idx + 1] * elemsOther[idxOther] + this.elements[idx] * elemsOther[idxOther + 1];
                    this.elements[idx] = tmp[0];
                    this.elements[idx + 1] = tmp[1];
                    idx += this.stride;
                    idxOther += strideOther;
                    ++k;
                }
            } else if (function == FComplexFunctions.multConjSecond) {
                float[] tmp = new float[2];
                int k = 0;
                while (k < this.size) {
                    tmp[0] = this.elements[idx] * elemsOther[idxOther] + this.elements[idx + 1] * elemsOther[idxOther + 1];
                    tmp[1] = this.elements[idx + 1] * elemsOther[idxOther] - this.elements[idx] * elemsOther[idxOther + 1];
                    this.elements[idx] = tmp[0];
                    this.elements[idx + 1] = tmp[1];
                    idx += this.stride;
                    idxOther += strideOther;
                    ++k;
                }
            } else {
                float[] tmp1 = new float[2];
                float[] tmp2 = new float[2];
                int k = 0;
                while (k < this.size) {
                    tmp1[0] = this.elements[idx];
                    tmp1[1] = this.elements[idx + 1];
                    tmp2[0] = elemsOther[idxOther];
                    tmp2[1] = elemsOther[idxOther + 1];
                    tmp1 = function.apply(tmp1, tmp2);
                    this.elements[idx] = tmp1[0];
                    this.elements[idx + 1] = tmp1[1];
                    idx += this.stride;
                    idxOther += strideOther;
                    ++k;
                }
            }
        }
        return this;
    }

    @Override
    public FComplexMatrix1D assign(final float re, final float im) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = DenseFComplexMatrix1D.this.zero + firstIdx * DenseFComplexMatrix1D.this.stride;
                        int k = firstIdx;
                        while (k < lastIdx) {
                            DenseFComplexMatrix1D.this.elements[idx] = re;
                            DenseFComplexMatrix1D.this.elements[idx + 1] = im;
                            idx += DenseFComplexMatrix1D.this.stride;
                            ++k;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = this.zero;
            int i = 0;
            while (i < this.size) {
                this.elements[idx] = re;
                this.elements[idx + 1] = im;
                idx += this.stride;
                ++i;
            }
        }
        return this;
    }

    @Override
    public FComplexMatrix1D assign(float[] values) {
        if (this.isNoView) {
            if (values.length != 2 * this.size) {
                throw new IllegalArgumentException("The length of values[] must be equal to 2*size()=" + 2L * this.size());
            }
            System.arraycopy(values, 0, this.elements, 0, values.length);
        } else {
            super.assign(values);
        }
        return this;
    }

    @Override
    public FComplexMatrix1D assignImaginary(FloatMatrix1D other) {
        if (!(other instanceof DenseFloatMatrix1D)) {
            return super.assignImaginary(other);
        }
        this.checkSize(other);
        final int zeroOther = (int)other.index(0);
        final int strideOther = other.stride();
        final float[] elemsOther = (float[])other.elements();
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = DenseFComplexMatrix1D.this.zero + firstIdx * DenseFComplexMatrix1D.this.stride;
                        int idxOther = zeroOther + firstIdx * strideOther;
                        int i = firstIdx;
                        while (i < lastIdx) {
                            DenseFComplexMatrix1D.this.elements[idx + 1] = elemsOther[idxOther];
                            idx += DenseFComplexMatrix1D.this.stride;
                            idxOther += strideOther;
                            ++i;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = this.zero;
            int idxOther = zeroOther;
            int i = 0;
            while (i < this.size) {
                this.elements[idx + 1] = elemsOther[idxOther];
                idx += this.stride;
                idxOther += strideOther;
                ++i;
            }
        }
        return this;
    }

    @Override
    public FComplexMatrix1D assignReal(FloatMatrix1D other) {
        if (!(other instanceof DenseFloatMatrix1D)) {
            return super.assignReal(other);
        }
        this.checkSize(other);
        final int zeroOther = (int)other.index(0);
        final int strideOther = other.stride();
        final float[] elemsOther = (float[])other.elements();
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = DenseFComplexMatrix1D.this.zero + firstIdx * DenseFComplexMatrix1D.this.stride;
                        int idxOther = zeroOther + firstIdx * strideOther;
                        int i = firstIdx;
                        while (i < lastIdx) {
                            DenseFComplexMatrix1D.this.elements[idx] = elemsOther[idxOther];
                            idx += DenseFComplexMatrix1D.this.stride;
                            idxOther += strideOther;
                            ++i;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = this.zero;
            int idxOther = zeroOther;
            int i = 0;
            while (i < this.size) {
                this.elements[idx] = elemsOther[idxOther];
                idx += this.stride;
                idxOther += strideOther;
                ++i;
            }
        }
        return this;
    }

    public void fft() {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        if (this.fft == null) {
            this.fft = new FloatFFT_1D(this.size);
        }
        if (this.isNoView) {
            this.fft.complexForward(this.elements);
        } else {
            FComplexMatrix1D copy = this.copy();
            this.fft.complexForward((float[])copy.elements());
            this.assign((float[])copy.elements());
        }
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    public float[] elements() {
        return this.elements;
    }

    @Override
    public FloatMatrix1D getImaginaryPart() {
        DenseFloatMatrix1D Im = new DenseFloatMatrix1D(this.size);
        final float[] elemsOther = Im.elements();
        final int zeroOther = (int)Im.index(0);
        final int strideOther = Im.stride();
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = DenseFComplexMatrix1D.this.zero + firstIdx * DenseFComplexMatrix1D.this.stride;
                        int idxOther = zeroOther + firstIdx * strideOther;
                        int k = firstIdx;
                        while (k < lastIdx) {
                            elemsOther[idxOther] = DenseFComplexMatrix1D.this.elements[idx + 1];
                            idx += DenseFComplexMatrix1D.this.stride;
                            idxOther += strideOther;
                            ++k;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = this.zero;
            int idxOther = zeroOther;
            int i = 0;
            while (i < this.size) {
                elemsOther[idxOther] = this.elements[idx + 1];
                idx += this.stride;
                idxOther += strideOther;
                ++i;
            }
        }
        return Im;
    }

    @Override
    public void getNonZeros(IntArrayList indexList, ArrayList<float[]> valueList) {
        indexList.clear();
        valueList.clear();
        int s = (int)this.size();
        int idx = this.zero;
        int k = 0;
        while (k < s) {
            float[] value = new float[]{this.elements[idx], this.elements[idx + 1]};
            if (value[0] != 0.0f || value[1] != 0.0f) {
                indexList.add(k);
                valueList.add(value);
            }
            idx += this.stride;
            ++k;
        }
    }

    @Override
    public float[] getQuick(int index) {
        int idx = this.zero + index * this.stride;
        return new float[]{this.elements[idx], this.elements[idx + 1]};
    }

    @Override
    public FloatMatrix1D getRealPart() {
        DenseFloatMatrix1D R = new DenseFloatMatrix1D(this.size);
        final float[] elemsOther = R.elements();
        final int zeroOther = (int)R.index(0);
        final int strideOther = R.stride();
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = DenseFComplexMatrix1D.this.zero + firstIdx * DenseFComplexMatrix1D.this.stride;
                        int idxOther = zeroOther + firstIdx * strideOther;
                        int k = firstIdx;
                        while (k < lastIdx) {
                            elemsOther[idxOther] = DenseFComplexMatrix1D.this.elements[idx];
                            idx += DenseFComplexMatrix1D.this.stride;
                            idxOther += strideOther;
                            ++k;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = this.zero;
            int idxOther = zeroOther;
            int i = 0;
            while (i < this.size) {
                elemsOther[idxOther] = this.elements[idx];
                idx += this.stride;
                idxOther += strideOther;
                ++i;
            }
        }
        return R;
    }

    public void ifft(boolean scale) {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        if (this.fft == null) {
            this.fft = new FloatFFT_1D(this.size);
        }
        if (this.isNoView) {
            this.fft.complexInverse(this.elements, scale);
        } else {
            FComplexMatrix1D copy = this.copy();
            this.fft.complexInverse((float[])copy.elements(), scale);
            this.assign((float[])copy.elements());
        }
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    @Override
    public FComplexMatrix1D like(int size) {
        return new DenseFComplexMatrix1D(size);
    }

    @Override
    public FComplexMatrix2D like2D(int rows, int columns) {
        return new DenseFComplexMatrix2D(rows, columns);
    }

    @Override
    public FComplexMatrix2D reshape(final int rows, int columns) {
        if (rows * columns != this.size) {
            throw new IllegalArgumentException("rows*columns != size");
        }
        DenseFComplexMatrix2D M = new DenseFComplexMatrix2D(rows, columns);
        final float[] elemsOther = (float[])((FComplexMatrix2D)M).elements();
        final int zeroOther = (int)((AbstractMatrix2D)M).index(0, 0);
        final int rowStrideOther = M.rowStride();
        final int columnStrideOther = M.columnStride();
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = columns / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstColumn = j * k;
                final int lastColumn = j == nthreads - 1 ? columns : firstColumn + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int c = firstColumn;
                        while (c < lastColumn) {
                            int idxOther = zeroOther + c * columnStrideOther;
                            int idx = DenseFComplexMatrix1D.this.zero + c * rows * DenseFComplexMatrix1D.this.stride;
                            int r = 0;
                            while (r < rows) {
                                elemsOther[idxOther] = DenseFComplexMatrix1D.this.elements[idx];
                                elemsOther[idxOther + 1] = DenseFComplexMatrix1D.this.elements[idx + 1];
                                idxOther += rowStrideOther;
                                idx += DenseFComplexMatrix1D.this.stride;
                                ++r;
                            }
                            ++c;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = this.zero;
            int c = 0;
            while (c < columns) {
                int idxOther = zeroOther + c * columnStrideOther;
                int r = 0;
                while (r < rows) {
                    elemsOther[idxOther] = this.elements[idx];
                    elemsOther[idxOther + 1] = this.elements[idx + 1];
                    idxOther += rowStrideOther;
                    idx += this.stride;
                    ++r;
                }
                ++c;
            }
        }
        return M;
    }

    @Override
    public FComplexMatrix3D reshape(int slices, final int rows, final int columns) {
        if (slices * rows * columns != this.size) {
            throw new IllegalArgumentException("slices*rows*columns != size");
        }
        DenseFComplexMatrix3D M = new DenseFComplexMatrix3D(slices, rows, columns);
        final float[] elemsOther = (float[])((FComplexMatrix3D)M).elements();
        final int zeroOther = (int)((AbstractMatrix3D)M).index(0, 0, 0);
        final int sliceStrideOther = M.sliceStride();
        final int rowStrideOther = M.rowStride();
        final int columnStrideOther = M.columnStride();
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = slices / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int s = firstSlice;
                        while (s < lastSlice) {
                            int c = 0;
                            while (c < columns) {
                                int idxOther = zeroOther + s * sliceStrideOther + c * columnStrideOther;
                                int idx = DenseFComplexMatrix1D.this.zero + (s * rows * columns + c * rows) * DenseFComplexMatrix1D.this.stride;
                                int r = 0;
                                while (r < rows) {
                                    elemsOther[idxOther] = DenseFComplexMatrix1D.this.elements[idx];
                                    elemsOther[idxOther + 1] = DenseFComplexMatrix1D.this.elements[idx + 1];
                                    idxOther += rowStrideOther;
                                    idx += DenseFComplexMatrix1D.this.stride;
                                    ++r;
                                }
                                ++c;
                            }
                            ++s;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = this.zero;
            int s = 0;
            while (s < slices) {
                int c = 0;
                while (c < columns) {
                    int idxOther = zeroOther + s * sliceStrideOther + c * columnStrideOther;
                    int r = 0;
                    while (r < rows) {
                        elemsOther[idxOther] = this.elements[idx];
                        elemsOther[idxOther + 1] = this.elements[idx + 1];
                        idxOther += rowStrideOther;
                        idx += this.stride;
                        ++r;
                    }
                    ++c;
                }
                ++s;
            }
        }
        return M;
    }

    @Override
    public void setQuick(int index, float re, float im) {
        int idx = this.zero + index * this.stride;
        this.elements[idx] = re;
        this.elements[idx + 1] = im;
    }

    @Override
    public void setQuick(int index, float[] value) {
        int idx = this.zero + index * this.stride;
        this.elements[idx] = value[0];
        this.elements[idx + 1] = value[1];
    }

    @Override
    public void swap(FComplexMatrix1D other) {
        DenseFComplexMatrix1D y;
        if (!(other instanceof DenseFComplexMatrix1D)) {
            super.swap(other);
        }
        if ((y = (DenseFComplexMatrix1D)other) == this) {
            return;
        }
        this.checkSize(y);
        final float[] elemsOther = y.elements;
        if (this.elements == null || elemsOther == null) {
            throw new InternalError();
        }
        final int strideOther = y.stride;
        final int zeroOther = (int)y.index(0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int idx = DenseFComplexMatrix1D.this.zero + firstIdx * DenseFComplexMatrix1D.this.stride;
                        int idxOther = zeroOther + firstIdx * strideOther;
                        int k = firstIdx;
                        while (k < lastIdx) {
                            float tmp = DenseFComplexMatrix1D.this.elements[idx];
                            DenseFComplexMatrix1D.this.elements[idx] = elemsOther[idxOther];
                            elemsOther[idxOther] = tmp;
                            tmp = DenseFComplexMatrix1D.this.elements[idx + 1];
                            DenseFComplexMatrix1D.this.elements[idx + 1] = elemsOther[idxOther + 1];
                            elemsOther[idxOther + 1] = tmp;
                            idx += DenseFComplexMatrix1D.this.stride;
                            idxOther += strideOther;
                            ++k;
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int idx = this.zero;
            int idxOther = zeroOther;
            int k = 0;
            while (k < this.size) {
                float tmp = this.elements[idx];
                this.elements[idx] = elemsOther[idxOther];
                elemsOther[idxOther] = tmp;
                tmp = this.elements[idx + 1];
                this.elements[idx + 1] = elemsOther[idxOther + 1];
                elemsOther[idxOther + 1] = tmp;
                idx += this.stride;
                idxOther += strideOther;
                ++k;
            }
        }
    }

    @Override
    public void toArray(float[] values) {
        if (values.length < 2 * this.size) {
            throw new IllegalArgumentException("values too small");
        }
        if (this.isNoView) {
            System.arraycopy(this.elements, 0, values, 0, this.elements.length);
        } else {
            super.toArray(values);
        }
    }

    @Override
    public float[] zDotProduct(FComplexMatrix1D y, int from, int length) {
        int size = (int)this.size();
        if (from < 0 || length <= 0) {
            return new float[]{0.0f, 0.0f};
        }
        int tail = from + length;
        if (size < tail) {
            tail = size;
        }
        if (y.size() < (long)tail) {
            tail = (int)y.size();
        }
        length = tail - from;
        final float[] elemsOther = (float[])y.elements();
        if (this.elements == null || elemsOther == null) {
            throw new InternalError();
        }
        final int strideOther = y.stride();
        final int zero = (int)this.index(from);
        final int zeroOther = (int)y.index(from);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        float[] sum = new float[2];
        if (nthreads > 1 && length >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, length);
            Future[] futures = new Future[nthreads];
            float[][] results = new float[nthreads][2];
            int k = length / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? length : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<float[]>(){

                    @Override
                    public float[] call() throws Exception {
                        float[] sum = new float[2];
                        int idx = zero + firstIdx * DenseFComplexMatrix1D.this.stride;
                        int idxOther = zeroOther + firstIdx * strideOther;
                        int k = firstIdx;
                        while (k < lastIdx) {
                            sum[0] = sum[0] + (DenseFComplexMatrix1D.this.elements[idx] * elemsOther[idxOther] + DenseFComplexMatrix1D.this.elements[idx + 1] * elemsOther[idxOther + 1]);
                            sum[1] = sum[1] + (DenseFComplexMatrix1D.this.elements[idx + 1] * elemsOther[idxOther] - DenseFComplexMatrix1D.this.elements[idx] * elemsOther[idxOther + 1]);
                            idx += DenseFComplexMatrix1D.this.stride;
                            idxOther += strideOther;
                            ++k;
                        }
                        return sum;
                    }
                });
                ++j;
            }
            try {
                j = 0;
                while (j < nthreads) {
                    results[j] = (float[])futures[j].get();
                    ++j;
                }
                sum = results[0];
                j = 1;
                while (j < nthreads) {
                    sum = FComplex.plus(sum, results[j]);
                    ++j;
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            int idx = zero;
            int idxOther = zeroOther;
            int k = 0;
            while (k < length) {
                sum[0] = sum[0] + (this.elements[idx] * elemsOther[idxOther] + this.elements[idx + 1] * elemsOther[idxOther + 1]);
                sum[1] = sum[1] + (this.elements[idx + 1] * elemsOther[idxOther] - this.elements[idx] * elemsOther[idxOther + 1]);
                idx += this.stride;
                idxOther += strideOther;
                ++k;
            }
        }
        return sum;
    }

    @Override
    public float[] zSum() {
        float[] sum = new float[2];
        if (this.elements == null) {
            throw new InternalError();
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            float[][] results = new float[nthreads][2];
            int k = this.size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<float[]>(){

                    @Override
                    public float[] call() throws Exception {
                        float[] sum = new float[2];
                        int idx = DenseFComplexMatrix1D.this.zero + firstIdx * DenseFComplexMatrix1D.this.stride;
                        int k = firstIdx;
                        while (k < lastIdx) {
                            sum[0] = sum[0] + DenseFComplexMatrix1D.this.elements[idx];
                            sum[1] = sum[1] + DenseFComplexMatrix1D.this.elements[idx + 1];
                            idx += DenseFComplexMatrix1D.this.stride;
                            ++k;
                        }
                        return sum;
                    }
                });
                ++j;
            }
            try {
                j = 0;
                while (j < nthreads) {
                    results[j] = (float[])futures[j].get();
                    ++j;
                }
                sum = results[0];
                j = 1;
                while (j < nthreads) {
                    sum[0] = sum[0] + results[j][0];
                    sum[1] = sum[1] + results[j][1];
                    ++j;
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            int idx = this.zero;
            int k = 0;
            while (k < this.size) {
                sum[0] = sum[0] + this.elements[idx];
                sum[1] = sum[1] + this.elements[idx + 1];
                idx += this.stride;
                ++k;
            }
        }
        return sum;
    }

    @Override
    protected int cardinality(int maxCardinality) {
        int cardinality = 0;
        int idx = this.zero;
        int i = 0;
        while (i < this.size && cardinality < maxCardinality) {
            if (this.elements[idx] != 0.0f || this.elements[idx + 1] != 0.0f) {
                ++cardinality;
            }
            idx += this.stride;
            ++i;
        }
        return cardinality;
    }

    @Override
    protected boolean haveSharedCellsRaw(FComplexMatrix1D other) {
        if (other instanceof SelectedDenseFComplexMatrix1D) {
            SelectedDenseFComplexMatrix1D otherMatrix = (SelectedDenseFComplexMatrix1D)other;
            return this.elements == otherMatrix.elements;
        }
        if (other instanceof DenseFComplexMatrix1D) {
            DenseFComplexMatrix1D otherMatrix = (DenseFComplexMatrix1D)other;
            return this.elements == otherMatrix.elements;
        }
        return false;
    }

    @Override
    public long index(int rank) {
        return this.zero + rank * this.stride;
    }

    @Override
    protected FComplexMatrix1D viewSelectionLike(int[] offsets) {
        return new SelectedDenseFComplexMatrix1D(this.elements, offsets);
    }
}

