/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tlong.algo;

import cern.colt.ConcurrencyUtils;
import cern.colt.GenericSorting;
import cern.colt.PersistentObject;
import cern.colt.Swapper;
import cern.colt.function.tint.IntComparator;
import cern.colt.list.tobject.ObjectArrayList;
import cern.colt.matrix.AbstractFormatter;
import cern.colt.matrix.tlong.LongFactory2D;
import cern.colt.matrix.tlong.LongMatrix1D;
import cern.colt.matrix.tlong.LongMatrix2D;
import cern.colt.matrix.tlong.LongMatrix3D;
import cern.jet.math.tlong.LongFunctions;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class LongProperty
extends PersistentObject {
    private static final long serialVersionUID = 1L;
    public static final LongProperty DEFAULT = new LongProperty();

    protected static String blanks(int length) {
        if (length < 0) {
            length = 0;
        }
        StringBuffer buf = new StringBuffer(length);
        int k = 0;
        while (k < length) {
            buf.append(' ');
            ++k;
        }
        return buf.toString();
    }

    public void checkRectangular(LongMatrix2D A) {
        if (A.rows() < A.columns()) {
            throw new IllegalArgumentException("Matrix must be rectangular: " + AbstractFormatter.shape(A));
        }
    }

    public void checkSquare(LongMatrix2D A) {
        if (A.rows() != A.columns()) {
            throw new IllegalArgumentException("Matrix must be square: " + AbstractFormatter.shape(A));
        }
    }

    public int density(LongMatrix2D A) {
        return A.cardinality() / (int)A.size();
    }

    public boolean equals(final LongMatrix1D A, final long value) {
        if (A == null) {
            return false;
        }
        int size = (int)A.size();
        boolean result = false;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, size);
            Future[] futures = new Future[nthreads];
            Boolean[] results = new Boolean[nthreads];
            int k = size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        int i = firstIdx;
                        while (i < lastIdx) {
                            if (A.getQuick(i) != value) {
                                return false;
                            }
                            ++i;
                        }
                        return true;
                    }
                });
                ++j;
            }
            try {
                j = 0;
                while (j < nthreads) {
                    results[j] = (Boolean)futures[j].get();
                    ++j;
                }
                result = results[0];
                j = 1;
                while (j < nthreads) {
                    result = result && results[j] != false;
                    ++j;
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            return result;
        }
        int i = 0;
        while (i < size) {
            if (A.getQuick(i) != value) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean equals(final LongMatrix1D A, final LongMatrix1D B) {
        if (A == B) {
            return true;
        }
        if (A == null || B == null) {
            return false;
        }
        int size = (int)A.size();
        if ((long)size != B.size()) {
            return false;
        }
        boolean result = false;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, size);
            Future[] futures = new Future[nthreads];
            Boolean[] results = new Boolean[nthreads];
            int k = size / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        int i = firstIdx;
                        while (i < lastIdx) {
                            if (A.getQuick(i) != B.getQuick(i)) {
                                return false;
                            }
                            ++i;
                        }
                        return true;
                    }
                });
                ++j;
            }
            try {
                j = 0;
                while (j < nthreads) {
                    results[j] = (Boolean)futures[j].get();
                    ++j;
                }
                result = results[0];
                j = 1;
                while (j < nthreads) {
                    result = result && results[j] != false;
                    ++j;
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            return result;
        }
        int i = 0;
        while (i < size) {
            if (A.getQuick(i) != B.getQuick(i)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean equals(final LongMatrix2D A, final long value) {
        if (A == null) {
            return false;
        }
        int rows = A.rows();
        final int columns = A.columns();
        boolean result = false;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && A.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, A.rows());
            Future[] futures = new Future[nthreads];
            Boolean[] results = new Boolean[nthreads];
            int k = A.rows() / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? A.rows() : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        int r = firstRow;
                        while (r < lastRow) {
                            int c = 0;
                            while (c < columns) {
                                if (A.getQuick(r, c) != value) {
                                    return false;
                                }
                                ++c;
                            }
                            ++r;
                        }
                        return true;
                    }
                });
                ++j;
            }
            try {
                j = 0;
                while (j < nthreads) {
                    results[j] = (Boolean)futures[j].get();
                    ++j;
                }
                result = results[0];
                j = 1;
                while (j < nthreads) {
                    result = result && results[j] != false;
                    ++j;
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            return result;
        }
        int r = 0;
        while (r < rows) {
            int c = 0;
            while (c < columns) {
                if (A.getQuick(r, c) != value) {
                    return false;
                }
                ++c;
            }
            ++r;
        }
        return true;
    }

    public boolean equals(final LongMatrix2D A, final LongMatrix2D B) {
        if (A == B) {
            return true;
        }
        if (A == null || B == null) {
            return false;
        }
        int rows = A.rows();
        final int columns = A.columns();
        if (columns != B.columns() || rows != B.rows()) {
            return false;
        }
        boolean result = false;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && A.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, A.rows());
            Future[] futures = new Future[nthreads];
            Boolean[] results = new Boolean[nthreads];
            int k = A.rows() / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? A.rows() : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        int r = firstRow;
                        while (r < lastRow) {
                            int c = 0;
                            while (c < columns) {
                                if (A.getQuick(r, c) != B.getQuick(r, c)) {
                                    return false;
                                }
                                ++c;
                            }
                            ++r;
                        }
                        return true;
                    }
                });
                ++j;
            }
            try {
                j = 0;
                while (j < nthreads) {
                    results[j] = (Boolean)futures[j].get();
                    ++j;
                }
                result = results[0];
                j = 1;
                while (j < nthreads) {
                    result = result && results[j] != false;
                    ++j;
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            return result;
        }
        int r = 0;
        while (r < rows) {
            int c = 0;
            while (c < columns) {
                if (A.getQuick(r, c) != B.getQuick(r, c)) {
                    return false;
                }
                ++c;
            }
            ++r;
        }
        return true;
    }

    public boolean equals(final LongMatrix3D A, final long value) {
        if (A == null) {
            return false;
        }
        int slices = A.slices();
        final int rows = A.rows();
        final int columns = A.columns();
        boolean result = false;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && A.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, slices);
            Future[] futures = new Future[nthreads];
            Boolean[] results = new Boolean[nthreads];
            int k = slices / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int startslice = j * k;
                final int stopslice = j == nthreads - 1 ? slices : startslice + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        int s = startslice;
                        while (s < stopslice) {
                            int r = 0;
                            while (r < rows) {
                                int c = 0;
                                while (c < columns) {
                                    if (A.getQuick(s, r, c) != value) {
                                        return false;
                                    }
                                    ++c;
                                }
                                ++r;
                            }
                            ++s;
                        }
                        return true;
                    }
                });
                ++j;
            }
            try {
                j = 0;
                while (j < nthreads) {
                    results[j] = (Boolean)futures[j].get();
                    ++j;
                }
                result = results[0];
                j = 1;
                while (j < nthreads) {
                    result = result && results[j] != false;
                    ++j;
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            return result;
        }
        int s = 0;
        while (s < slices) {
            int r = 0;
            while (r < rows) {
                int c = 0;
                while (c < columns) {
                    if (A.getQuick(s, r, c) != value) {
                        return false;
                    }
                    ++c;
                }
                ++r;
            }
            ++s;
        }
        return true;
    }

    public boolean equals(final LongMatrix3D A, final LongMatrix3D B) {
        if (A == B) {
            return true;
        }
        if (A == null || B == null) {
            return false;
        }
        int slices = A.slices();
        final int rows = A.rows();
        final int columns = A.columns();
        if (columns != B.columns() || rows != B.rows() || slices != B.slices()) {
            return false;
        }
        boolean result = false;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && A.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            nthreads = Math.min(nthreads, slices);
            Future[] futures = new Future[nthreads];
            Boolean[] results = new Boolean[nthreads];
            int k = slices / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int startslice = j * k;
                final int stopslice = j == nthreads - 1 ? slices : startslice + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        int s = startslice;
                        while (s < stopslice) {
                            int r = 0;
                            while (r < rows) {
                                int c = 0;
                                while (c < columns) {
                                    if (A.getQuick(s, r, c) != B.getQuick(s, r, c)) {
                                        return false;
                                    }
                                    ++c;
                                }
                                ++r;
                            }
                            ++s;
                        }
                        return true;
                    }
                });
                ++j;
            }
            try {
                j = 0;
                while (j < nthreads) {
                    results[j] = (Boolean)futures[j].get();
                    ++j;
                }
                result = results[0];
                j = 1;
                while (j < nthreads) {
                    result = result && results[j] != false;
                    ++j;
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            return result;
        }
        int s = 0;
        while (s < slices) {
            int r = 0;
            while (r < rows) {
                int c = 0;
                while (c < columns) {
                    if (A.getQuick(s, r, c) != B.getQuick(s, r, c)) {
                        return false;
                    }
                    ++c;
                }
                ++r;
            }
            ++s;
        }
        return true;
    }

    public void generateNonSingular(LongMatrix2D A) {
        int min;
        this.checkSquare(A);
        LongFunctions F = LongFunctions.longFunctions;
        int i = min = Math.min(A.rows(), A.columns());
        while (--i >= 0) {
            A.setQuick(i, i, 0L);
        }
        i = min;
        while (--i >= 0) {
            long rowSum = A.viewRow(i).aggregate(LongFunctions.plus, LongFunctions.abs);
            long colSum = A.viewColumn(i).aggregate(LongFunctions.plus, LongFunctions.abs);
            A.setQuick(i, i, Math.max(rowSum, colSum) + (long)i + 1L);
        }
    }

    protected static String get(ObjectArrayList list, int index) {
        return (String)list.get(index);
    }

    public boolean isDiagonal(LongMatrix2D A) {
        int rows = A.rows();
        int columns = A.columns();
        int row = rows;
        while (--row >= 0) {
            int column = columns;
            while (--column >= 0) {
                if (row == column || A.getQuick(row, column) == 0L) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isDiagonallyDominantByColumn(LongMatrix2D A) {
        int min;
        LongFunctions F = LongFunctions.longFunctions;
        int i = min = Math.min(A.rows(), A.columns());
        while (--i >= 0) {
            long diag = Math.abs(A.getQuick(i, i));
            if ((diag += diag) > A.viewColumn(i).aggregate(LongFunctions.plus, LongFunctions.abs)) continue;
            return false;
        }
        return true;
    }

    public boolean isDiagonallyDominantByRow(LongMatrix2D A) {
        int min;
        LongFunctions F = LongFunctions.longFunctions;
        int i = min = Math.min(A.rows(), A.columns());
        while (--i >= 0) {
            long diag = Math.abs(A.getQuick(i, i));
            if ((diag += diag) > A.viewRow(i).aggregate(LongFunctions.plus, LongFunctions.abs)) continue;
            return false;
        }
        return true;
    }

    public boolean isIdentity(LongMatrix2D A) {
        int rows = A.rows();
        int columns = A.columns();
        int row = rows;
        while (--row >= 0) {
            int column = columns;
            while (--column >= 0) {
                long v = A.getQuick(row, column);
                if (!(row == column ? v != 1L : v != 0L)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isLowerBidiagonal(LongMatrix2D A) {
        int rows = A.rows();
        int columns = A.columns();
        int row = rows;
        while (--row >= 0) {
            int column = columns;
            while (--column >= 0) {
                if (row == column || row == column + 1 || A.getQuick(row, column) == 0L) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isLowerTriangular(LongMatrix2D A) {
        int columns;
        int rows = A.rows();
        int column = columns = A.columns();
        while (--column >= 0) {
            int row = Math.min(column, rows);
            while (--row >= 0) {
                if (A.getQuick(row, column) == 0L) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isNonNegative(LongMatrix2D A) {
        int rows = A.rows();
        int columns = A.columns();
        int row = rows;
        while (--row >= 0) {
            int column = columns;
            while (--column >= 0) {
                if (A.getQuick(row, column) >= 0L) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isOrthogonal(LongMatrix2D A) {
        this.checkSquare(A);
        return this.equals(A.zMult(A, null, 1L, 0L, false, true), LongFactory2D.dense.identity(A.rows()));
    }

    public boolean isPositive(LongMatrix2D A) {
        int rows = A.rows();
        int columns = A.columns();
        int row = rows;
        while (--row >= 0) {
            int column = columns;
            while (--column >= 0) {
                if (A.getQuick(row, column) > 0L) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isSkewSymmetric(LongMatrix2D A) {
        this.checkSquare(A);
        int rows = A.rows();
        int columns = A.columns();
        int row = rows;
        while (--row >= 0) {
            int column = rows;
            while (--column >= 0) {
                if (A.getQuick(row, column) == -A.getQuick(column, row)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isSquare(LongMatrix2D A) {
        return A.rows() == A.columns();
    }

    public boolean isStrictlyLowerTriangular(LongMatrix2D A) {
        int columns;
        int rows = A.rows();
        int column = columns = A.columns();
        while (--column >= 0) {
            int row = Math.min(rows, column + 1);
            while (--row >= 0) {
                if (A.getQuick(row, column) == 0L) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isStrictlyTriangular(LongMatrix2D A) {
        if (!this.isTriangular(A)) {
            return false;
        }
        int i = Math.min(A.rows(), A.columns());
        while (--i >= 0) {
            if (A.getQuick(i, i) == 0L) continue;
            return false;
        }
        return true;
    }

    public boolean isStrictlyUpperTriangular(LongMatrix2D A) {
        int columns;
        int rows = A.rows();
        int column = columns = A.columns();
        while (--column >= 0) {
            int row = rows;
            while (--row >= column) {
                if (A.getQuick(row, column) == 0L) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isSymmetric(LongMatrix2D A) {
        this.checkSquare(A);
        return this.equals(A, A.viewDice());
    }

    public boolean isTriangular(LongMatrix2D A) {
        return this.isLowerTriangular(A) || this.isUpperTriangular(A);
    }

    public boolean isTridiagonal(LongMatrix2D A) {
        int rows = A.rows();
        int columns = A.columns();
        int row = rows;
        while (--row >= 0) {
            int column = columns;
            while (--column >= 0) {
                if (Math.abs(row - column) <= 1 || A.getQuick(row, column) == 0L) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isUnitTriangular(LongMatrix2D A) {
        if (!this.isTriangular(A)) {
            return false;
        }
        int i = Math.min(A.rows(), A.columns());
        while (--i >= 0) {
            if (A.getQuick(i, i) == 1L) continue;
            return false;
        }
        return true;
    }

    public boolean isUpperBidiagonal(LongMatrix2D A) {
        int rows = A.rows();
        int columns = A.columns();
        int row = rows;
        while (--row >= 0) {
            int column = columns;
            while (--column >= 0) {
                if (row == column || row == column - 1 || A.getQuick(row, column) == 0L) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isUpperTriangular(LongMatrix2D A) {
        int columns;
        int rows = A.rows();
        int column = columns = A.columns();
        while (--column >= 0) {
            int row = rows;
            while (--row > column) {
                if (A.getQuick(row, column) == 0L) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isZero(LongMatrix2D A) {
        return this.equals(A, 0L);
    }

    public int lowerBandwidth(LongMatrix2D A) {
        int rows;
        this.checkSquare(A);
        int k = rows = A.rows();
        while (--k >= 0) {
            int i = rows - k;
            while (--i >= 0) {
                int j = i + k;
                if (A.getQuick(j, i) == 0L) continue;
                return k;
            }
        }
        return 0;
    }

    public int semiBandwidth(LongMatrix2D A) {
        int rows;
        this.checkSquare(A);
        int k = rows = A.rows();
        while (--k >= 0) {
            int i = rows - k;
            while (--i >= 0) {
                int j = i + k;
                if (A.getQuick(j, i) != 0L) {
                    return k + 1;
                }
                if (A.getQuick(i, j) == 0L) continue;
                return k + 1;
            }
        }
        return 1;
    }

    public String toString(LongMatrix2D A) {
        final ObjectArrayList names = new ObjectArrayList();
        final ObjectArrayList values = new ObjectArrayList();
        String unknown = "Illegal operation or error: ";
        names.add("density");
        try {
            values.add(String.valueOf(this.density(A)));
        }
        catch (IllegalArgumentException exc) {
            values.add(String.valueOf(unknown) + exc.getMessage());
        }
        names.add("isDiagonal");
        try {
            values.add(String.valueOf(this.isDiagonal(A)));
        }
        catch (IllegalArgumentException exc) {
            values.add(String.valueOf(unknown) + exc.getMessage());
        }
        names.add("isDiagonallyDominantByRow");
        try {
            values.add(String.valueOf(this.isDiagonallyDominantByRow(A)));
        }
        catch (IllegalArgumentException exc) {
            values.add(String.valueOf(unknown) + exc.getMessage());
        }
        names.add("isDiagonallyDominantByColumn");
        try {
            values.add(String.valueOf(this.isDiagonallyDominantByColumn(A)));
        }
        catch (IllegalArgumentException exc) {
            values.add(String.valueOf(unknown) + exc.getMessage());
        }
        names.add("isIdentity");
        try {
            values.add(String.valueOf(this.isIdentity(A)));
        }
        catch (IllegalArgumentException exc) {
            values.add(String.valueOf(unknown) + exc.getMessage());
        }
        names.add("isLowerBidiagonal");
        try {
            values.add(String.valueOf(this.isLowerBidiagonal(A)));
        }
        catch (IllegalArgumentException exc) {
            values.add(String.valueOf(unknown) + exc.getMessage());
        }
        names.add("isLowerTriangular");
        try {
            values.add(String.valueOf(this.isLowerTriangular(A)));
        }
        catch (IllegalArgumentException exc) {
            values.add(String.valueOf(unknown) + exc.getMessage());
        }
        names.add("isNonNegative");
        try {
            values.add(String.valueOf(this.isNonNegative(A)));
        }
        catch (IllegalArgumentException exc) {
            values.add(String.valueOf(unknown) + exc.getMessage());
        }
        names.add("isOrthogonal");
        try {
            values.add(String.valueOf(this.isOrthogonal(A)));
        }
        catch (IllegalArgumentException exc) {
            values.add(String.valueOf(unknown) + exc.getMessage());
        }
        names.add("isPositive");
        try {
            values.add(String.valueOf(this.isPositive(A)));
        }
        catch (IllegalArgumentException exc) {
            values.add(String.valueOf(unknown) + exc.getMessage());
        }
        names.add("isSkewSymmetric");
        try {
            values.add(String.valueOf(this.isSkewSymmetric(A)));
        }
        catch (IllegalArgumentException exc) {
            values.add(String.valueOf(unknown) + exc.getMessage());
        }
        names.add("isSquare");
        try {
            values.add(String.valueOf(this.isSquare(A)));
        }
        catch (IllegalArgumentException exc) {
            values.add(String.valueOf(unknown) + exc.getMessage());
        }
        names.add("isStrictlyLowerTriangular");
        try {
            values.add(String.valueOf(this.isStrictlyLowerTriangular(A)));
        }
        catch (IllegalArgumentException exc) {
            values.add(String.valueOf(unknown) + exc.getMessage());
        }
        names.add("isStrictlyTriangular");
        try {
            values.add(String.valueOf(this.isStrictlyTriangular(A)));
        }
        catch (IllegalArgumentException exc) {
            values.add(String.valueOf(unknown) + exc.getMessage());
        }
        names.add("isStrictlyUpperTriangular");
        try {
            values.add(String.valueOf(this.isStrictlyUpperTriangular(A)));
        }
        catch (IllegalArgumentException exc) {
            values.add(String.valueOf(unknown) + exc.getMessage());
        }
        names.add("isSymmetric");
        try {
            values.add(String.valueOf(this.isSymmetric(A)));
        }
        catch (IllegalArgumentException exc) {
            values.add(String.valueOf(unknown) + exc.getMessage());
        }
        names.add("isTriangular");
        try {
            values.add(String.valueOf(this.isTriangular(A)));
        }
        catch (IllegalArgumentException exc) {
            values.add(String.valueOf(unknown) + exc.getMessage());
        }
        names.add("isTridiagonal");
        try {
            values.add(String.valueOf(this.isTridiagonal(A)));
        }
        catch (IllegalArgumentException exc) {
            values.add(String.valueOf(unknown) + exc.getMessage());
        }
        names.add("isUnitTriangular");
        try {
            values.add(String.valueOf(this.isUnitTriangular(A)));
        }
        catch (IllegalArgumentException exc) {
            values.add(String.valueOf(unknown) + exc.getMessage());
        }
        names.add("isUpperBidiagonal");
        try {
            values.add(String.valueOf(this.isUpperBidiagonal(A)));
        }
        catch (IllegalArgumentException exc) {
            values.add(String.valueOf(unknown) + exc.getMessage());
        }
        names.add("isUpperTriangular");
        try {
            values.add(String.valueOf(this.isUpperTriangular(A)));
        }
        catch (IllegalArgumentException exc) {
            values.add(String.valueOf(unknown) + exc.getMessage());
        }
        names.add("isZero");
        try {
            values.add(String.valueOf(this.isZero(A)));
        }
        catch (IllegalArgumentException exc) {
            values.add(String.valueOf(unknown) + exc.getMessage());
        }
        names.add("lowerBandwidth");
        try {
            values.add(String.valueOf(this.lowerBandwidth(A)));
        }
        catch (IllegalArgumentException exc) {
            values.add(String.valueOf(unknown) + exc.getMessage());
        }
        names.add("semiBandwidth");
        try {
            values.add(String.valueOf(this.semiBandwidth(A)));
        }
        catch (IllegalArgumentException exc) {
            values.add(String.valueOf(unknown) + exc.getMessage());
        }
        names.add("upperBandwidth");
        try {
            values.add(String.valueOf(this.upperBandwidth(A)));
        }
        catch (IllegalArgumentException exc) {
            values.add(String.valueOf(unknown) + exc.getMessage());
        }
        IntComparator comp = new IntComparator(){

            @Override
            public int compare(int a, int b) {
                return LongProperty.get(names, a).compareTo(LongProperty.get(names, b));
            }
        };
        Swapper swapper = new Swapper(){

            @Override
            public void swap(int a, int b) {
                Object tmp = names.get(a);
                names.set(a, names.get(b));
                names.set(b, tmp);
                tmp = values.get(a);
                values.set(a, values.get(b));
                values.set(b, tmp);
            }
        };
        GenericSorting.quickSort(0, names.size(), comp, swapper);
        int maxLength = 0;
        int i = 0;
        while (i < names.size()) {
            int length = ((String)names.get(i)).length();
            maxLength = Math.max(length, maxLength);
            ++i;
        }
        StringBuffer buf = new StringBuffer();
        int i2 = 0;
        while (i2 < names.size()) {
            String name = (String)names.get(i2);
            buf.append(name);
            buf.append(LongProperty.blanks(maxLength - name.length()));
            buf.append(" : ");
            buf.append(values.get(i2));
            if (i2 < names.size() - 1) {
                buf.append('\n');
            }
            ++i2;
        }
        return buf.toString();
    }

    public int upperBandwidth(LongMatrix2D A) {
        int rows;
        this.checkSquare(A);
        int k = rows = A.rows();
        while (--k >= 0) {
            int i = rows - k;
            while (--i >= 0) {
                int j = i + k;
                if (A.getQuick(i, j) == 0L) continue;
                return k;
            }
        }
        return 0;
    }
}

