/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tlong.impl;

import cern.colt.ConcurrencyUtils;
import cern.colt.function.tlong.IntIntLongFunction;
import cern.colt.function.tlong.LongFunction;
import cern.colt.function.tlong.LongLongFunction;
import cern.colt.list.tint.IntArrayList;
import cern.colt.list.tlong.LongArrayList;
import cern.colt.matrix.tlong.LongMatrix1D;
import cern.colt.matrix.tlong.LongMatrix2D;
import cern.colt.matrix.tlong.impl.DenseLongMatrix1D;
import cern.colt.matrix.tlong.impl.DenseLongMatrix2D;
import cern.colt.matrix.tlong.impl.SparseCCLongMatrix2D;
import cern.colt.matrix.tlong.impl.SparseLongMatrix1D;
import cern.colt.matrix.tlong.impl.WrapperLongMatrix2D;
import cern.jet.math.tlong.LongFunctions;
import cern.jet.math.tlong.LongMult;
import cern.jet.math.tlong.LongPlusMultFirst;
import cern.jet.math.tlong.LongPlusMultSecond;
import java.util.Arrays;
import java.util.concurrent.Future;

public class SparseRCLongMatrix2D
extends WrapperLongMatrix2D {
    private static final long serialVersionUID = 1L;
    protected int[] rowPointers;
    protected int[] columnIndexes;
    protected long[] values;
    protected boolean columnIndexesSorted;

    private static int searchFromTo(int[] list, int key, int from, int to) {
        while (from <= to) {
            if (list[from] == key) {
                return from;
            }
            ++from;
        }
        return -(from + 1);
    }

    public SparseRCLongMatrix2D(long[][] values) {
        this(values.length, values.length == 0 ? 0 : values[0].length);
        this.assign(values);
    }

    public SparseRCLongMatrix2D(int rows, int columns) {
        this(rows, columns, (int)Math.min(10L * (long)rows, Integer.MAX_VALUE));
    }

    public SparseRCLongMatrix2D(int rows, int columns, int nzmax) {
        block2: {
            super(null);
            this.columnIndexesSorted = false;
            try {
                this.setUp(rows, columns);
            }
            catch (IllegalArgumentException exc) {
                if ("matrix too large".equals(exc.getMessage())) break block2;
                throw exc;
            }
        }
        this.columnIndexes = new int[nzmax];
        this.values = new long[nzmax];
        this.rowPointers = new int[rows + 1];
    }

    public SparseRCLongMatrix2D(int rows, int columns, int[] rowIndexes, int[] columnIndexes, long value, boolean removeDuplicates, boolean sortColumnIndexes) {
        block8: {
            super(null);
            this.columnIndexesSorted = false;
            try {
                this.setUp(rows, columns);
            }
            catch (IllegalArgumentException exc) {
                if ("matrix too large".equals(exc.getMessage())) break block8;
                throw exc;
            }
        }
        if (rowIndexes.length != columnIndexes.length) {
            throw new IllegalArgumentException("rowIndexes.length != columnIndexes.length");
        }
        if (value == 0L) {
            throw new IllegalArgumentException("value cannot be 0");
        }
        int nz = Math.max(rowIndexes.length, 1);
        this.columnIndexes = new int[nz];
        this.values = new long[nz];
        this.rowPointers = new int[rows + 1];
        int[] w = new int[rows];
        int k = 0;
        while (k < nz) {
            int n = rowIndexes[k];
            w[n] = w[n] + 1;
            ++k;
        }
        this.cumsum(this.rowPointers, w, rows);
        k = 0;
        while (k < nz) {
            int n = rowIndexes[k];
            w[n] = w[n] + 1;
            this.columnIndexes[r] = columnIndexes[k];
            this.values[r] = value;
            ++k;
        }
        if (removeDuplicates) {
            this.removeDuplicates();
        }
        if (sortColumnIndexes) {
            this.sortColumnIndexes();
        }
    }

    public SparseRCLongMatrix2D(int rows, int columns, int[] rowIndexes, int[] columnIndexes, long[] values, boolean removeDuplicates, boolean removeZeroes, boolean sortColumnIndexes) {
        block9: {
            super(null);
            this.columnIndexesSorted = false;
            try {
                this.setUp(rows, columns);
            }
            catch (IllegalArgumentException exc) {
                if ("matrix too large".equals(exc.getMessage())) break block9;
                throw exc;
            }
        }
        if (rowIndexes.length != columnIndexes.length) {
            throw new IllegalArgumentException("rowIndexes.length != columnIndexes.length");
        }
        if (rowIndexes.length != values.length) {
            throw new IllegalArgumentException("rowIndexes.length != values.length");
        }
        int nz = Math.max(rowIndexes.length, 1);
        this.columnIndexes = new int[nz];
        this.values = new long[nz];
        this.rowPointers = new int[rows + 1];
        int[] w = new int[rows];
        int k = 0;
        while (k < nz) {
            int n = rowIndexes[k];
            w[n] = w[n] + 1;
            ++k;
        }
        this.cumsum(this.rowPointers, w, rows);
        k = 0;
        while (k < nz) {
            int n = rowIndexes[k];
            w[n] = w[n] + 1;
            this.columnIndexes[r] = columnIndexes[k];
            this.values[r] = values[k];
            ++k;
        }
        if (removeZeroes) {
            this.removeZeroes();
        }
        if (removeDuplicates) {
            this.removeDuplicates();
        }
        if (sortColumnIndexes) {
            this.sortColumnIndexes();
        }
    }

    public SparseRCLongMatrix2D(int rows, int columns, int[] rowPointers, int[] columnIndexes, long[] values) {
        block3: {
            super(null);
            this.columnIndexesSorted = false;
            try {
                this.setUp(rows, columns);
            }
            catch (IllegalArgumentException exc) {
                if ("matrix too large".equals(exc.getMessage())) break block3;
                throw exc;
            }
        }
        if (rowPointers.length != rows + 1) {
            throw new IllegalArgumentException("rowPointers.length != rows + 1");
        }
        this.rowPointers = rowPointers;
        this.columnIndexes = columnIndexes;
        this.values = values;
    }

    @Override
    public LongMatrix2D assign(final LongFunction function) {
        if (function instanceof LongMult) {
            long alpha = ((LongMult)function).multiplicator;
            if (alpha == 1L) {
                return this;
            }
            if (alpha == 0L) {
                return this.assign(0L);
            }
            if (alpha != alpha) {
                return this.assign(alpha);
            }
            int nz = this.cardinality();
            int j = 0;
            while (j < nz) {
                int n = j++;
                this.values[n] = this.values[n] * alpha;
            }
        } else {
            this.forEachNonZero(new IntIntLongFunction(){

                @Override
                public long apply(int i, int j, long value) {
                    return function.apply(value);
                }
            });
        }
        return this;
    }

    @Override
    public LongMatrix2D assign(long value) {
        if (value == 0L) {
            Arrays.fill(this.rowPointers, 0);
            Arrays.fill(this.columnIndexes, 0);
            Arrays.fill(this.values, 0L);
        } else {
            int nnz = this.cardinality();
            int i = 0;
            while (i < nnz) {
                this.values[i] = value;
                ++i;
            }
        }
        return this;
    }

    @Override
    public LongMatrix2D assign(LongMatrix2D source) {
        if (source == this) {
            return this;
        }
        this.checkShape(source);
        if (source instanceof SparseRCLongMatrix2D) {
            SparseRCLongMatrix2D other = (SparseRCLongMatrix2D)source;
            System.arraycopy(other.rowPointers, 0, this.rowPointers, 0, this.rows + 1);
            int nzmax = other.columnIndexes.length;
            if (this.columnIndexes.length < nzmax) {
                this.columnIndexes = new int[nzmax];
                this.values = new long[nzmax];
            }
            System.arraycopy(other.columnIndexes, 0, this.columnIndexes, 0, nzmax);
            System.arraycopy(other.values, 0, this.values, 0, nzmax);
            this.columnIndexesSorted = other.columnIndexesSorted;
        } else if (source instanceof SparseCCLongMatrix2D) {
            SparseCCLongMatrix2D other = ((SparseCCLongMatrix2D)source).getTranspose();
            this.rowPointers = other.getColumnPointers();
            this.columnIndexes = other.getRowIndexes();
            this.values = other.getValues();
            this.columnIndexesSorted = true;
        } else {
            this.assign(0L);
            source.forEachNonZero(new IntIntLongFunction(){

                @Override
                public long apply(int i, int j, long value) {
                    SparseRCLongMatrix2D.this.setQuick(i, j, value);
                    return value;
                }
            });
        }
        return this;
    }

    @Override
    public LongMatrix2D assign(LongMatrix2D y, LongLongFunction function) {
        this.checkShape(y);
        if (y instanceof SparseRCLongMatrix2D && function == LongFunctions.plus) {
            SparseRCLongMatrix2D yy = (SparseRCLongMatrix2D)y;
            int[] rowPointersY = yy.rowPointers;
            int[] columnIndexesY = yy.columnIndexes;
            long[] valuesY = yy.values;
            int[] rowPointersC = new int[this.rows + 1];
            int cnz = Math.max(this.columnIndexes.length, (int)Math.min(Integer.MAX_VALUE, (long)this.rowPointers[this.rows] + (long)rowPointersY[this.rows]));
            int[] columnIndexesC = new int[cnz];
            long[] valuesC = new long[cnz];
            int nrow = this.rows;
            int ncol = this.columns;
            int nzmax = valuesC.length;
            if (function == LongFunctions.plus) {
                int kc;
                rowPointersC[0] = kc = 0;
                int i = 0;
                while (i < nrow) {
                    int ka = this.rowPointers[i];
                    int kb = rowPointersY[i];
                    int kamax = this.rowPointers[i + 1] - 1;
                    int kbmax = rowPointersY[i + 1] - 1;
                    while (ka <= kamax || kb <= kbmax) {
                        int j2;
                        int j1 = ka <= kamax ? this.columnIndexes[ka] : ncol + 1;
                        if (j1 == (j2 = kb <= kbmax ? columnIndexesY[kb] : ncol + 1)) {
                            valuesC[kc] = this.values[ka] + valuesY[kb];
                            columnIndexesC[kc] = j1;
                            ++ka;
                            ++kb;
                            ++kc;
                        } else if (j1 < j2) {
                            columnIndexesC[kc] = j1;
                            valuesC[kc] = this.values[ka];
                            ++ka;
                            ++kc;
                        } else if (j1 > j2) {
                            columnIndexesC[kc] = j2;
                            valuesC[kc] = valuesY[kb];
                            ++kb;
                            ++kc;
                        }
                        if (kc < nzmax) continue;
                        throw new IllegalArgumentException("The number of elements in C exceeds nzmax");
                    }
                    rowPointersC[i + 1] = kc;
                    ++i;
                }
                this.rowPointers = rowPointersC;
                this.columnIndexes = columnIndexesC;
                this.values = valuesC;
                return this;
            }
        }
        if (function instanceof LongPlusMultSecond) {
            final long alpha = ((LongPlusMultSecond)function).multiplicator;
            if (alpha == 0L) {
                return this;
            }
            y.forEachNonZero(new IntIntLongFunction(){

                @Override
                public long apply(int i, int j, long value) {
                    SparseRCLongMatrix2D.this.setQuick(i, j, SparseRCLongMatrix2D.this.getQuick(i, j) + alpha * value);
                    return value;
                }
            });
            return this;
        }
        if (function instanceof LongPlusMultFirst) {
            final long alpha = ((LongPlusMultFirst)function).multiplicator;
            if (alpha == 0L) {
                return this.assign(y);
            }
            y.forEachNonZero(new IntIntLongFunction(){

                @Override
                public long apply(int i, int j, long value) {
                    SparseRCLongMatrix2D.this.setQuick(i, j, alpha * SparseRCLongMatrix2D.this.getQuick(i, j) + value);
                    return value;
                }
            });
            return this;
        }
        if (function == LongFunctions.mult) {
            int i = this.rows;
            while (--i >= 0) {
                int low = this.rowPointers[i];
                int k = this.rowPointers[i + 1];
                while (--k >= low) {
                    int j = this.columnIndexes[k];
                    int n = k;
                    this.values[n] = this.values[n] * y.getQuick(i, j);
                    if (this.values[k] != 0L) continue;
                    this.remove(i, j);
                }
            }
            return this;
        }
        if (function == LongFunctions.div) {
            int i = this.rows;
            while (--i >= 0) {
                int low = this.rowPointers[i];
                int k = this.rowPointers[i + 1];
                while (--k >= low) {
                    int j = this.columnIndexes[k];
                    int n = k;
                    this.values[n] = this.values[n] / y.getQuick(i, j);
                    if (this.values[k] != 0L) continue;
                    this.remove(i, j);
                }
            }
            return this;
        }
        return super.assign(y, function);
    }

    @Override
    public int cardinality() {
        return this.rowPointers[this.rows];
    }

    @Override
    public LongMatrix2D forEachNonZero(IntIntLongFunction function) {
        int i = this.rows;
        while (--i >= 0) {
            int low = this.rowPointers[i];
            int k = this.rowPointers[i + 1];
            while (--k >= low) {
                int j = this.columnIndexes[k];
                long value = this.values[k];
                long r = function.apply(i, j, value);
                if (r == value) continue;
                this.values[k] = r;
            }
        }
        return this;
    }

    public SparseCCLongMatrix2D getColumnCompressed() {
        SparseRCLongMatrix2D tr = this.getTranspose();
        SparseCCLongMatrix2D cc = new SparseCCLongMatrix2D(this.rows, this.columns);
        cc.rowIndexes = tr.columnIndexes;
        cc.columnPointers = tr.rowPointers;
        cc.values = tr.values;
        cc.rowIndexesSorted = true;
        return cc;
    }

    public int[] getColumnIndexes() {
        return this.columnIndexes;
    }

    public DenseLongMatrix2D getDense() {
        final DenseLongMatrix2D dense = new DenseLongMatrix2D(this.rows, this.columns);
        this.forEachNonZero(new IntIntLongFunction(){

            @Override
            public long apply(int i, int j, long value) {
                dense.setQuick(i, j, SparseRCLongMatrix2D.this.getQuick(i, j));
                return value;
            }
        });
        return dense;
    }

    @Override
    public synchronized long getQuick(int row, int column) {
        int k = SparseRCLongMatrix2D.searchFromTo(this.columnIndexes, column, this.rowPointers[row], this.rowPointers[row + 1] - 1);
        long v = 0L;
        if (k >= 0) {
            v = this.values[k];
        }
        return v;
    }

    public int[] getRowPointers() {
        return this.rowPointers;
    }

    public SparseRCLongMatrix2D getTranspose() {
        int nnz = this.rowPointers[this.rows];
        int[] w = new int[this.columns];
        int[] rowPointersT = new int[this.columns + 1];
        int[] columnIndexesT = new int[nnz];
        long[] valuesT = new long[nnz];
        int p = 0;
        while (p < nnz) {
            int n = this.columnIndexes[p];
            w[n] = w[n] + 1;
            ++p;
        }
        this.cumsum(rowPointersT, w, this.columns);
        int j = 0;
        while (j < this.rows) {
            int high = this.rowPointers[j + 1];
            int p2 = this.rowPointers[j];
            while (p2 < high) {
                int n = this.columnIndexes[p2];
                w[n] = w[n] + 1;
                columnIndexesT[q] = j;
                valuesT[q] = this.values[p2];
                ++p2;
            }
            ++j;
        }
        SparseRCLongMatrix2D T = new SparseRCLongMatrix2D(this.columns, this.rows);
        T.rowPointers = rowPointersT;
        T.columnIndexes = columnIndexesT;
        T.values = valuesT;
        return T;
    }

    public long[] getValues() {
        return this.values;
    }

    public boolean hasColumnIndexesSorted() {
        return this.columnIndexesSorted;
    }

    @Override
    public LongMatrix2D like(int rows, int columns) {
        return new SparseRCLongMatrix2D(rows, columns);
    }

    @Override
    public LongMatrix1D like1D(int size) {
        return new SparseLongMatrix1D(size);
    }

    public void removeDuplicates() {
        int nz = 0;
        int[] w = new int[this.columns];
        int i = 0;
        while (i < this.columns) {
            w[i] = -1;
            ++i;
        }
        int j = 0;
        while (j < this.rows) {
            int q = nz;
            int p = this.rowPointers[j];
            while (p < this.rowPointers[j + 1]) {
                i = this.columnIndexes[p];
                if (w[i] >= q) {
                    int n = w[i];
                    this.values[n] = this.values[n] + this.values[p];
                } else {
                    w[i] = nz;
                    this.columnIndexes[nz] = i;
                    this.values[nz++] = this.values[p];
                }
                ++p;
            }
            this.rowPointers[j] = q;
            ++j;
        }
        this.rowPointers[this.rows] = nz;
    }

    public void removeZeroes() {
        int nz = 0;
        int j = 0;
        while (j < this.rows) {
            int p = this.rowPointers[j];
            this.rowPointers[j] = nz;
            while (p < this.rowPointers[j + 1]) {
                if (this.values[p] != 0L) {
                    this.values[nz] = this.values[p];
                    this.columnIndexes[nz++] = this.columnIndexes[p];
                }
                ++p;
            }
            ++j;
        }
        this.rowPointers[this.rows] = nz;
    }

    @Override
    public synchronized void setQuick(int row, int column, long value) {
        int k = SparseRCLongMatrix2D.searchFromTo(this.columnIndexes, column, this.rowPointers[row], this.rowPointers[row + 1] - 1);
        if (k >= 0) {
            if (value == 0L) {
                this.remove(row, k);
            } else {
                this.values[k] = value;
            }
            return;
        }
        if (value != 0L) {
            k = -k - 1;
            this.insert(row, column, k, value);
        }
    }

    public void sortColumnIndexes() {
        SparseRCLongMatrix2D T = this.getTranspose();
        this.rows = T.rows;
        this.columns = T.columns;
        this.columnIndexes = T.columnIndexes;
        this.rowPointers = T.rowPointers;
        this.values = T.values;
        T = this.getTranspose();
        this.rows = T.rows;
        this.columns = T.columns;
        this.columnIndexes = T.columnIndexes;
        this.rowPointers = T.rowPointers;
        this.values = T.values;
        this.columnIndexesSorted = true;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.rows).append(" x ").append(this.columns).append(" sparse matrix, nnz = ").append(this.cardinality()).append('\n');
        int i = 0;
        while (i < this.rows) {
            int high = this.rowPointers[i + 1];
            int j = this.rowPointers[i];
            while (j < high) {
                builder.append('(').append(i).append(',').append(this.columnIndexes[j]).append(')').append('\t').append(this.values[j]).append('\n');
                ++j;
            }
            ++i;
        }
        return builder.toString();
    }

    @Override
    public void trimToSize() {
        this.realloc(0);
    }

    @Override
    public LongMatrix1D zMult(LongMatrix1D y, LongMatrix1D z, final long alpha, final long beta, boolean transposeA) {
        boolean ignore;
        int rowsA = transposeA ? this.columns : this.rows;
        int columnsA = transposeA ? this.rows : this.columns;
        boolean bl = ignore = z == null || !transposeA;
        if (z == null) {
            z = new DenseLongMatrix1D(rowsA);
        }
        if (!(y instanceof DenseLongMatrix1D) || !(z instanceof DenseLongMatrix1D)) {
            return super.zMult(y, z, alpha, beta, transposeA);
        }
        if ((long)columnsA != y.size() || (long)rowsA > z.size()) {
            throw new IllegalArgumentException("Incompatible args: " + (transposeA ? this.viewDice() : this).toStringShort() + ", " + y.toStringShort() + ", " + z.toStringShort());
        }
        DenseLongMatrix1D zz = (DenseLongMatrix1D)z;
        final long[] elementsZ = zz.elements;
        final int strideZ = zz.stride();
        final int zeroZ = (int)z.index(0);
        DenseLongMatrix1D yy = (DenseLongMatrix1D)y;
        final long[] elementsY = yy.elements;
        final int strideY = yy.stride();
        final int zeroY = (int)y.index(0);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (transposeA) {
            if (!ignore && (double)beta != 1.0) {
                z.assign(LongFunctions.mult(beta));
            }
            if (nthreads > 1 && this.cardinality() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
                int rem;
                nthreads = 2;
                Future[] futures = new Future[nthreads];
                final long[] result = new long[rowsA];
                int k = this.rows / nthreads;
                int j = 0;
                while (j < nthreads) {
                    final int firstRow = j * k;
                    final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                    final int threadID = j;
                    futures[j] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            if (threadID == 0) {
                                int i = firstRow;
                                while (i < lastRow) {
                                    int high = SparseRCLongMatrix2D.this.rowPointers[i + 1];
                                    long yElem = alpha * elementsY[zeroY + strideY * i];
                                    int k = SparseRCLongMatrix2D.this.rowPointers[i];
                                    while (k < high) {
                                        int j = SparseRCLongMatrix2D.this.columnIndexes[k];
                                        int n = zeroZ + strideZ * j;
                                        elementsZ[n] = elementsZ[n] + SparseRCLongMatrix2D.this.values[k] * yElem;
                                        ++k;
                                    }
                                    ++i;
                                }
                            } else {
                                int i = firstRow;
                                while (i < lastRow) {
                                    int high = SparseRCLongMatrix2D.this.rowPointers[i + 1];
                                    long yElem = alpha * elementsY[zeroY + strideY * i];
                                    int k = SparseRCLongMatrix2D.this.rowPointers[i];
                                    while (k < high) {
                                        int j;
                                        int n = j = SparseRCLongMatrix2D.this.columnIndexes[k];
                                        result[n] = result[n] + SparseRCLongMatrix2D.this.values[k] * yElem;
                                        ++k;
                                    }
                                    ++i;
                                }
                            }
                        }
                    });
                    ++j;
                }
                ConcurrencyUtils.waitForCompletion(futures);
                int j2 = rem = rowsA % 10;
                while (j2 < rowsA) {
                    int n = zeroZ + j2 * strideZ;
                    elementsZ[n] = elementsZ[n] + result[j2];
                    int n2 = zeroZ + (j2 + 1) * strideZ;
                    elementsZ[n2] = elementsZ[n2] + result[j2 + 1];
                    int n3 = zeroZ + (j2 + 2) * strideZ;
                    elementsZ[n3] = elementsZ[n3] + result[j2 + 2];
                    int n4 = zeroZ + (j2 + 3) * strideZ;
                    elementsZ[n4] = elementsZ[n4] + result[j2 + 3];
                    int n5 = zeroZ + (j2 + 4) * strideZ;
                    elementsZ[n5] = elementsZ[n5] + result[j2 + 4];
                    int n6 = zeroZ + (j2 + 5) * strideZ;
                    elementsZ[n6] = elementsZ[n6] + result[j2 + 5];
                    int n7 = zeroZ + (j2 + 6) * strideZ;
                    elementsZ[n7] = elementsZ[n7] + result[j2 + 6];
                    int n8 = zeroZ + (j2 + 7) * strideZ;
                    elementsZ[n8] = elementsZ[n8] + result[j2 + 7];
                    int n9 = zeroZ + (j2 + 8) * strideZ;
                    elementsZ[n9] = elementsZ[n9] + result[j2 + 8];
                    int n10 = zeroZ + (j2 + 9) * strideZ;
                    elementsZ[n10] = elementsZ[n10] + result[j2 + 9];
                    j2 += 10;
                }
                j2 = 0;
                while (j2 < rem) {
                    int n = zeroZ + j2 * strideZ;
                    elementsZ[n] = elementsZ[n] + result[j2];
                    ++j2;
                }
            } else {
                int i = 0;
                while (i < this.rows) {
                    int high = this.rowPointers[i + 1];
                    long yElem = alpha * elementsY[zeroY + strideY * i];
                    int k = this.rowPointers[i];
                    while (k < high) {
                        int j = this.columnIndexes[k];
                        int n = zeroZ + strideZ * j;
                        elementsZ[n] = elementsZ[n] + this.values[k] * yElem;
                        ++k;
                    }
                    ++i;
                }
            }
            return z;
        }
        if (nthreads > 1 && this.cardinality() >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, this.rows);
            Future[] futures = new Future[nthreads];
            int k = this.rows / nthreads;
            int j = 0;
            while (j < nthreads) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? this.rows : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        int zidx = zeroZ + firstRow * strideZ;
                        int k = SparseRCLongMatrix2D.this.rowPointers[firstRow];
                        if ((double)beta == 0.0) {
                            int i = firstRow;
                            while (i < lastRow) {
                                long sum = 0L;
                                int high = SparseRCLongMatrix2D.this.rowPointers[i + 1];
                                while (k + 10 < high) {
                                    int ind = k + 9;
                                    sum += SparseRCLongMatrix2D.this.values[ind] * elementsY[zeroY + strideY * SparseRCLongMatrix2D.this.columnIndexes[ind--]] + SparseRCLongMatrix2D.this.values[ind] * elementsY[zeroY + strideY * SparseRCLongMatrix2D.this.columnIndexes[ind--]] + SparseRCLongMatrix2D.this.values[ind] * elementsY[zeroY + strideY * SparseRCLongMatrix2D.this.columnIndexes[ind--]] + SparseRCLongMatrix2D.this.values[ind] * elementsY[zeroY + strideY * SparseRCLongMatrix2D.this.columnIndexes[ind--]] + SparseRCLongMatrix2D.this.values[ind] * elementsY[zeroY + strideY * SparseRCLongMatrix2D.this.columnIndexes[ind--]] + SparseRCLongMatrix2D.this.values[ind] * elementsY[zeroY + strideY * SparseRCLongMatrix2D.this.columnIndexes[ind--]] + SparseRCLongMatrix2D.this.values[ind] * elementsY[zeroY + strideY * SparseRCLongMatrix2D.this.columnIndexes[ind--]] + SparseRCLongMatrix2D.this.values[ind] * elementsY[zeroY + strideY * SparseRCLongMatrix2D.this.columnIndexes[ind--]] + SparseRCLongMatrix2D.this.values[ind] * elementsY[zeroY + strideY * SparseRCLongMatrix2D.this.columnIndexes[ind--]] + SparseRCLongMatrix2D.this.values[ind] * elementsY[zeroY + strideY * SparseRCLongMatrix2D.this.columnIndexes[ind--]];
                                    k += 10;
                                }
                                while (k < high) {
                                    sum += SparseRCLongMatrix2D.this.values[k] * elementsY[SparseRCLongMatrix2D.this.columnIndexes[k]];
                                    ++k;
                                }
                                elementsZ[zidx] = alpha * sum;
                                zidx += strideZ;
                                ++i;
                            }
                        } else {
                            int i = firstRow;
                            while (i < lastRow) {
                                long sum = 0L;
                                int high = SparseRCLongMatrix2D.this.rowPointers[i + 1];
                                while (k + 10 < high) {
                                    int ind = k + 9;
                                    sum += SparseRCLongMatrix2D.this.values[ind] * elementsY[zeroY + strideY * SparseRCLongMatrix2D.this.columnIndexes[ind--]] + SparseRCLongMatrix2D.this.values[ind] * elementsY[zeroY + strideY * SparseRCLongMatrix2D.this.columnIndexes[ind--]] + SparseRCLongMatrix2D.this.values[ind] * elementsY[zeroY + strideY * SparseRCLongMatrix2D.this.columnIndexes[ind--]] + SparseRCLongMatrix2D.this.values[ind] * elementsY[zeroY + strideY * SparseRCLongMatrix2D.this.columnIndexes[ind--]] + SparseRCLongMatrix2D.this.values[ind] * elementsY[zeroY + strideY * SparseRCLongMatrix2D.this.columnIndexes[ind--]] + SparseRCLongMatrix2D.this.values[ind] * elementsY[zeroY + strideY * SparseRCLongMatrix2D.this.columnIndexes[ind--]] + SparseRCLongMatrix2D.this.values[ind] * elementsY[zeroY + strideY * SparseRCLongMatrix2D.this.columnIndexes[ind--]] + SparseRCLongMatrix2D.this.values[ind] * elementsY[zeroY + strideY * SparseRCLongMatrix2D.this.columnIndexes[ind--]] + SparseRCLongMatrix2D.this.values[ind] * elementsY[zeroY + strideY * SparseRCLongMatrix2D.this.columnIndexes[ind--]] + SparseRCLongMatrix2D.this.values[ind] * elementsY[zeroY + strideY * SparseRCLongMatrix2D.this.columnIndexes[ind--]];
                                    k += 10;
                                }
                                while (k < high) {
                                    sum += SparseRCLongMatrix2D.this.values[k] * elementsY[SparseRCLongMatrix2D.this.columnIndexes[k]];
                                    ++k;
                                }
                                elementsZ[zidx] = alpha * sum + beta * elementsZ[zidx];
                                zidx += strideZ;
                                ++i;
                            }
                        }
                    }
                });
                ++j;
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            int zidx = zeroZ;
            int k = this.rowPointers[0];
            if ((double)beta == 0.0) {
                int i = 0;
                while (i < this.rows) {
                    long sum = 0L;
                    int high = this.rowPointers[i + 1];
                    while (k + 10 < high) {
                        int ind = k + 9;
                        sum += this.values[ind] * elementsY[zeroY + strideY * this.columnIndexes[ind--]] + this.values[ind] * elementsY[zeroY + strideY * this.columnIndexes[ind--]] + this.values[ind] * elementsY[zeroY + strideY * this.columnIndexes[ind--]] + this.values[ind] * elementsY[zeroY + strideY * this.columnIndexes[ind--]] + this.values[ind] * elementsY[zeroY + strideY * this.columnIndexes[ind--]] + this.values[ind] * elementsY[zeroY + strideY * this.columnIndexes[ind--]] + this.values[ind] * elementsY[zeroY + strideY * this.columnIndexes[ind--]] + this.values[ind] * elementsY[zeroY + strideY * this.columnIndexes[ind--]] + this.values[ind] * elementsY[zeroY + strideY * this.columnIndexes[ind--]] + this.values[ind] * elementsY[zeroY + strideY * this.columnIndexes[ind--]];
                        k += 10;
                    }
                    while (k < high) {
                        sum += this.values[k] * elementsY[this.columnIndexes[k]];
                        ++k;
                    }
                    elementsZ[zidx] = alpha * sum;
                    zidx += strideZ;
                    ++i;
                }
            } else {
                int i = 0;
                while (i < this.rows) {
                    long sum = 0L;
                    int high = this.rowPointers[i + 1];
                    while (k + 10 < high) {
                        int ind = k + 9;
                        sum += this.values[ind] * elementsY[zeroY + strideY * this.columnIndexes[ind--]] + this.values[ind] * elementsY[zeroY + strideY * this.columnIndexes[ind--]] + this.values[ind] * elementsY[zeroY + strideY * this.columnIndexes[ind--]] + this.values[ind] * elementsY[zeroY + strideY * this.columnIndexes[ind--]] + this.values[ind] * elementsY[zeroY + strideY * this.columnIndexes[ind--]] + this.values[ind] * elementsY[zeroY + strideY * this.columnIndexes[ind--]] + this.values[ind] * elementsY[zeroY + strideY * this.columnIndexes[ind--]] + this.values[ind] * elementsY[zeroY + strideY * this.columnIndexes[ind--]] + this.values[ind] * elementsY[zeroY + strideY * this.columnIndexes[ind--]] + this.values[ind] * elementsY[zeroY + strideY * this.columnIndexes[ind--]];
                        k += 10;
                    }
                    while (k < high) {
                        sum += this.values[k] * elementsY[this.columnIndexes[k]];
                        ++k;
                    }
                    elementsZ[zidx] = alpha * sum + beta * elementsZ[zidx];
                    zidx += strideZ;
                    ++i;
                }
            }
        }
        return z;
    }

    @Override
    public LongMatrix2D zMult(LongMatrix2D B, LongMatrix2D C, long alpha, long beta, boolean transposeA, boolean transposeB) {
        boolean ignore;
        int rowsA = this.rows;
        int columnsA = this.columns;
        if (transposeA) {
            rowsA = this.columns;
            columnsA = this.rows;
        }
        int rowsB = B.rows();
        int columnsB = B.columns();
        if (transposeB) {
            rowsB = B.columns();
            columnsB = B.rows();
        }
        int p = columnsB;
        boolean bl = ignore = C == null;
        if (C == null) {
            C = B instanceof SparseRCLongMatrix2D ? new SparseRCLongMatrix2D(rowsA, p, rowsA * p) : new DenseLongMatrix2D(rowsA, p);
        }
        if (rowsB != columnsA) {
            throw new IllegalArgumentException("Matrix2D inner dimensions must agree:" + this.toStringShort() + ", " + (transposeB ? B.viewDice() : B).toStringShort());
        }
        if (C.rows() != rowsA || C.columns() != p) {
            throw new IllegalArgumentException("Incompatible result matrix: " + this.toStringShort() + ", " + (transposeB ? B.viewDice() : B).toStringShort() + ", " + C.toStringShort());
        }
        if (this == C || B == C) {
            throw new IllegalArgumentException("Matrices must not be identical");
        }
        if (!ignore && (double)beta != 1.0) {
            C.assign(LongFunctions.mult(beta));
        }
        if (B instanceof DenseLongMatrix2D && C instanceof DenseLongMatrix2D) {
            SparseRCLongMatrix2D AA = transposeA ? this.getTranspose() : this;
            DenseLongMatrix2D BB = transposeB ? (DenseLongMatrix2D)B.viewDice() : (DenseLongMatrix2D)B;
            DenseLongMatrix2D CC = (DenseLongMatrix2D)C;
            int[] rowPointersA = AA.rowPointers;
            int[] columnIndexesA = AA.columnIndexes;
            long[] valuesA = AA.values;
            int ii = 0;
            while (ii < rowsA) {
                int highA = rowPointersA[ii + 1];
                int ka = rowPointersA[ii];
                while (ka < highA) {
                    long scal = valuesA[ka] * alpha;
                    int jj = columnIndexesA[ka];
                    CC.viewRow(ii).assign(BB.viewRow(jj), LongFunctions.plusMultSecond(scal));
                    ++ka;
                }
                ++ii;
            }
        } else if (B instanceof SparseRCLongMatrix2D && C instanceof SparseRCLongMatrix2D) {
            SparseRCLongMatrix2D CC = (SparseRCLongMatrix2D)C;
            SparseRCLongMatrix2D AA = transposeA ? this.getTranspose() : this;
            SparseRCLongMatrix2D BB = transposeB ? ((SparseRCLongMatrix2D)B).getTranspose() : (SparseRCLongMatrix2D)B;
            int[] rowPointersA = AA.rowPointers;
            int[] columnIndexesA = AA.columnIndexes;
            long[] valuesA = AA.values;
            int[] rowPointersB = BB.rowPointers;
            int[] columnIndexesB = BB.columnIndexes;
            long[] valuesB = BB.values;
            int[] rowPointersC = CC.rowPointers;
            int[] columnIndexesC = CC.columnIndexes;
            long[] valuesC = CC.values;
            int nzmax = valuesC.length;
            int[] iw = new int[columnsB + 1];
            int i = 0;
            while (i < iw.length) {
                iw[i] = -1;
                ++i;
            }
            int len = -1;
            int ii = 0;
            while (ii < rowsA) {
                int highA = rowPointersA[ii + 1];
                int ka = rowPointersA[ii];
                while (ka < highA) {
                    long scal = valuesA[ka] * alpha;
                    int jj = columnIndexesA[ka];
                    int highB = rowPointersB[jj + 1];
                    int kb = rowPointersB[jj];
                    while (kb < highB) {
                        int jcol = columnIndexesB[kb];
                        int jpos = iw[jcol];
                        if (jpos == -1) {
                            if (++len >= nzmax) {
                                throw new IllegalArgumentException("The max number of nonzero elements in C is too small.");
                            }
                            columnIndexesC[len] = jcol;
                            iw[jcol] = len;
                            valuesC[len] = scal * valuesB[kb];
                        } else {
                            int n = jpos;
                            valuesC[n] = valuesC[n] + scal * valuesB[kb];
                        }
                        ++kb;
                    }
                    ++ka;
                }
                int k = rowPointersC[ii];
                while (k < len + 1) {
                    iw[columnIndexesC[k]] = -1;
                    ++k;
                }
                rowPointersC[ii + 1] = len + 1;
                ++ii;
            }
        } else {
            if (transposeB) {
                B = B.viewDice();
            }
            LongMatrix1D[] Brows = new LongMatrix1D[columnsA];
            int i = columnsA;
            while (--i >= 0) {
                Brows[i] = B.viewRow(i);
            }
            LongMatrix1D[] Crows = new LongMatrix1D[rowsA];
            int i2 = rowsA;
            while (--i2 >= 0) {
                Crows[i2] = C.viewRow(i2);
            }
            LongPlusMultSecond fun = LongPlusMultSecond.plusMult(0L);
            int[] columnIndexesA = this.columnIndexes;
            long[] valuesA = this.values;
            int i3 = this.rows;
            while (--i3 >= 0) {
                int low = this.rowPointers[i3];
                int k = this.rowPointers[i3 + 1];
                while (--k >= low) {
                    int j = columnIndexesA[k];
                    fun.multiplicator = valuesA[k] * alpha;
                    if (!transposeA) {
                        Crows[i3].assign(Brows[j], fun);
                        continue;
                    }
                    Crows[j].assign(Brows[i3], fun);
                }
            }
        }
        return C;
    }

    private long cumsum(int[] p, int[] c, int n) {
        int nz = 0;
        long nz2 = 0L;
        int k = 0;
        while (k < n) {
            p[k] = nz;
            nz += c[k];
            nz2 += (long)c[k];
            c[k] = p[k];
            ++k;
        }
        p[n] = nz;
        return nz2;
    }

    private void realloc(int nzmax) {
        if (nzmax <= 0) {
            nzmax = this.rowPointers[this.rows];
        }
        int[] columnIndexesNew = new int[nzmax];
        int length = Math.min(nzmax, this.columnIndexes.length);
        System.arraycopy(this.columnIndexes, 0, columnIndexesNew, 0, length);
        this.columnIndexes = columnIndexesNew;
        long[] valuesNew = new long[nzmax];
        length = Math.min(nzmax, this.values.length);
        System.arraycopy(this.values, 0, valuesNew, 0, length);
        this.values = valuesNew;
    }

    @Override
    protected LongMatrix2D getContent() {
        return this;
    }

    protected void insert(int row, int column, int index, long value) {
        IntArrayList columnIndexesList = new IntArrayList(this.columnIndexes);
        columnIndexesList.setSizeRaw(this.rowPointers[this.rows]);
        LongArrayList valuesList = new LongArrayList(this.values);
        valuesList.setSizeRaw(this.rowPointers[this.rows]);
        columnIndexesList.beforeInsert(index, column);
        valuesList.beforeInsert(index, value);
        int i = this.rowPointers.length;
        while (--i > row) {
            int n = i;
            this.rowPointers[n] = this.rowPointers[n] + 1;
        }
        this.columnIndexes = columnIndexesList.elements();
        this.values = valuesList.elements();
    }

    protected void remove(int row, int index) {
        IntArrayList columnIndexesList = new IntArrayList(this.columnIndexes);
        columnIndexesList.setSizeRaw(this.rowPointers[this.rows]);
        LongArrayList valuesList = new LongArrayList(this.values);
        valuesList.setSizeRaw(this.rowPointers[this.rows]);
        columnIndexesList.remove(index);
        valuesList.remove(index);
        int i = this.rowPointers.length;
        while (--i > row) {
            int n = i;
            this.rowPointers[n] = this.rowPointers[n] - 1;
        }
        this.columnIndexes = columnIndexesList.elements();
        this.values = valuesList.elements();
    }
}

