/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.CompositeImage;
import ij.IJ;
import ij.ImageListener;
import ij.ImagePlus;
import ij.LookUpTable;
import ij.WindowManager;
import ij.gui.ImageWindow;
import ij.gui.NewImage;
import ij.gui.Roi;
import ij.gui.RoiListener;
import ij.gui.TrimmedButton;
import ij.measure.Calibration;
import ij.measure.Measurements;
import ij.measure.ResultsTable;
import ij.plugin.filter.Analyzer;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;
import ij.process.LUT;
import java.awt.Button;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.ColorModel;
import java.io.CharArrayWriter;
import java.io.PrintWriter;

public class HistogramWindow
extends ImageWindow
implements Measurements,
ActionListener,
ClipboardOwner,
ImageListener,
RoiListener,
Runnable {
    static final int WIN_WIDTH = 300;
    static final int WIN_HEIGHT = 240;
    static final int HIST_WIDTH = 256;
    static final int HIST_HEIGHT = 128;
    static final int BAR_HEIGHT = 12;
    static final int XMARGIN = 20;
    static final int YMARGIN = 10;
    static final int INTENSITY = 0;
    static final int RED = 1;
    static final int GREEN = 2;
    static final int BLUE = 3;
    protected ImageStatistics stats;
    protected long[] histogram;
    protected LookUpTable lut;
    protected Rectangle frame = null;
    protected Button list;
    protected Button save;
    protected Button copy;
    protected Button log;
    protected Button live;
    protected Button rgb;
    protected Label value;
    protected Label count;
    protected static String defaultDirectory = null;
    protected int decimalPlaces;
    protected int digits;
    protected long newMaxCount;
    protected int plotScale = 1;
    protected boolean logScale;
    protected Calibration cal;
    protected int yMax;
    public static int nBins = 256;
    private int srcImageID;
    private ImagePlus srcImp;
    private Thread bgThread;
    private boolean doUpdate;
    private int channel;
    private String blankLabel;
    private boolean stackHistogram;

    public HistogramWindow(ImagePlus imp) {
        super(NewImage.createRGBImage("Histogram of " + imp.getShortTitle(), 300, 240, 1, 4));
        this.showHistogram(imp, 256, 0.0, 0.0);
    }

    public HistogramWindow(String title, ImagePlus imp, int bins) {
        super(NewImage.createRGBImage(title, 300, 240, 1, 4));
        this.showHistogram(imp, bins, 0.0, 0.0);
    }

    public HistogramWindow(String title, ImagePlus imp, int bins, double histMin, double histMax) {
        super(NewImage.createRGBImage(title, 300, 240, 1, 4));
        this.showHistogram(imp, bins, histMin, histMax);
    }

    public HistogramWindow(String title, ImagePlus imp, int bins, double histMin, double histMax, int yMax) {
        super(NewImage.createRGBImage(title, 300, 240, 1, 4));
        this.yMax = yMax;
        this.showHistogram(imp, bins, histMin, histMax);
    }

    public HistogramWindow(String title, ImagePlus imp, ImageStatistics stats) {
        super(NewImage.createRGBImage(title, 300, 240, 1, 4));
        this.yMax = stats.histYMax;
        this.showHistogram(imp, stats);
    }

    public void showHistogram(ImagePlus imp, int bins) {
        this.showHistogram(imp, bins, 0.0, 0.0);
    }

    public void showHistogram(ImagePlus imp, int bins, double histMin, double histMax) {
        boolean limitToThreshold;
        boolean bl = limitToThreshold = (Analyzer.getMeasurements() & 0x100) != 0;
        if (this.channel != 0 && imp.getType() == 4) {
            ColorProcessor cp = (ColorProcessor)imp.getProcessor();
            ByteProcessor ip = cp.getChannel(this.channel, null);
            ImagePlus imp2 = new ImagePlus("", ip);
            imp2.setRoi(imp.getRoi());
            this.stats = imp2.getStatistics(27, bins, histMin, histMax);
        } else {
            this.stats = imp.getStatistics(27 + (limitToThreshold ? 256 : 0), bins, histMin, histMax);
        }
        this.showHistogram(imp, this.stats);
    }

    public void showHistogram(ImagePlus imp, ImageStatistics stats) {
        ImageProcessor ip;
        this.stackHistogram = stats.stackStatistics;
        if (this.list == null) {
            this.setup(imp);
        }
        this.stats = stats;
        this.cal = imp.getCalibration();
        boolean limitToThreshold = (Analyzer.getMeasurements() & 0x100) != 0;
        imp.getMask();
        this.histogram = stats.getHistogram();
        if (limitToThreshold && this.histogram.length == 256 && (ip = imp.getProcessor()).getMinThreshold() != -808080.0) {
            int i;
            int lower = this.scaleDown(ip, ip.getMinThreshold());
            int upper = this.scaleDown(ip, ip.getMaxThreshold());
            for (i = 0; i < lower; ++i) {
                this.histogram[i] = 0L;
            }
            for (i = upper + 1; i < 256; ++i) {
                this.histogram[i] = 0L;
            }
        }
        this.lut = imp.createLut();
        int type = imp.getType();
        boolean fixedRange = type == 0 || type == 3 || type == 4;
        ImageProcessor ip2 = this.imp.getProcessor();
        ip2.setColor(Color.white);
        ip2.resetRoi();
        ip2.fill();
        ImageProcessor srcIP = imp.getProcessor();
        this.drawHistogram(imp, ip2, fixedRange, stats.histMin, stats.histMax);
        this.imp.updateAndDraw();
    }

    private void setup(ImagePlus imp) {
        boolean isRGB = imp.getType() == 4;
        Panel buttons = new Panel();
        int hgap = IJ.isMacOSX() || isRGB ? 1 : 5;
        buttons.setLayout(new FlowLayout(2, hgap, 0));
        int trim = IJ.isMacOSX() ? 6 : 0;
        this.list = new TrimmedButton("List", trim);
        this.list.addActionListener(this);
        buttons.add(this.list);
        this.copy = new TrimmedButton("Copy", trim);
        this.copy.addActionListener(this);
        buttons.add(this.copy);
        this.log = new TrimmedButton("Log", trim);
        this.log.addActionListener(this);
        buttons.add(this.log);
        if (!this.stackHistogram) {
            this.live = new TrimmedButton("Live", trim);
            this.live.addActionListener(this);
            buttons.add(this.live);
        }
        if (imp != null && isRGB && !this.stackHistogram) {
            this.rgb = new TrimmedButton("RGB", trim);
            this.rgb.addActionListener(this);
            buttons.add(this.rgb);
        }
        if (!IJ.isMacOSX() || !isRGB) {
            Panel valueAndCount = new Panel();
            valueAndCount.setLayout(new GridLayout(2, 1, 0, 0));
            this.blankLabel = IJ.isMacOSX() ? "           " : "                ";
            this.value = new Label(this.blankLabel);
            Font font = new Font("Monospaced", 0, 12);
            this.value.setFont(font);
            valueAndCount.add(this.value);
            this.count = new Label(this.blankLabel);
            this.count.setFont(font);
            valueAndCount.add(this.count);
            buttons.add(valueAndCount);
        }
        this.add(buttons);
        this.pack();
    }

    public void setup() {
        this.setup(null);
    }

    public void mouseMoved(int x, int y) {
        if (this.value == null || this.count == null) {
            return;
        }
        if (this.frame != null && x >= this.frame.x && x <= this.frame.x + this.frame.width) {
            if ((x -= this.frame.x) > 255) {
                x = 255;
            }
            int index = (int)((double)x * (double)this.histogram.length / 256.0);
            String vlabel = null;
            String clabel = null;
            if (this.blankLabel.length() == 11) {
                vlabel = " ";
                clabel = " ";
            } else {
                vlabel = " value=";
                clabel = " count=";
            }
            String v = vlabel + this.d2s(this.cal.getCValue(this.stats.histMin + (double)index * this.stats.binSize)) + this.blankLabel;
            String c = clabel + this.histogram[index] + this.blankLabel;
            int len = vlabel.length() + this.blankLabel.length();
            this.value.setText(v.substring(0, len));
            this.count.setText(c.substring(0, len));
        } else {
            this.value.setText(this.blankLabel);
            this.count.setText(this.blankLabel);
        }
    }

    protected void drawHistogram(ImageProcessor ip, boolean fixedRange) {
        this.drawHistogram(null, ip, fixedRange, 0.0, 0.0);
    }

    void drawHistogram(ImagePlus imp, ImageProcessor ip, boolean fixedRange, double xMin, double xMax) {
        long maxCount2 = 0L;
        int mode2 = 0;
        ip.setColor(Color.black);
        ip.setLineWidth(1);
        this.decimalPlaces = Analyzer.getPrecision();
        this.digits = this.cal.calibrated() || this.stats.binSize != 1.0 ? this.decimalPlaces : 0;
        long saveModalCount = this.histogram[this.stats.mode];
        for (int i = 0; i < this.histogram.length; ++i) {
            if (this.histogram[i] <= maxCount2 || i == this.stats.mode) continue;
            maxCount2 = this.histogram[i];
            mode2 = i;
        }
        this.newMaxCount = this.histogram[this.stats.mode];
        if (this.newMaxCount > maxCount2 * 2L && maxCount2 != 0L) {
            this.newMaxCount = (int)((double)maxCount2 * 1.5);
        }
        if (this.logScale || IJ.shiftKeyDown() && !this.liveMode()) {
            this.drawLogPlot(this.yMax > 0 ? (long)this.yMax : this.newMaxCount, ip);
        }
        this.drawPlot(this.yMax > 0 ? (long)this.yMax : this.newMaxCount, ip);
        this.histogram[this.stats.mode] = saveModalCount;
        int x = 21;
        int y = 140;
        if (imp == null) {
            this.lut.drawUnscaledColorBar(ip, x - 1, y, 256, 12);
        } else {
            this.drawAlignedColorBar(imp, xMin, xMax, ip, x - 1, y, 256, 12);
        }
        this.drawText(ip, x, y += 27, fixedRange);
        this.srcImageID = imp.getID();
    }

    void drawAlignedColorBar(ImagePlus imp, double xMin, double xMax, ImageProcessor ip, int x, int y, int width, int height) {
        ImageProcessor ipSource = imp.getProcessor();
        float[] pixels = null;
        FloatProcessor ipRamp = null;
        if (ipSource instanceof ColorProcessor) {
            ipRamp = new FloatProcessor(width, height);
            if (this.channel == 1) {
                ipRamp.setColorModel(LUT.createLutFromColor(Color.red));
            } else if (this.channel == 2) {
                ipRamp.setColorModel(LUT.createLutFromColor(Color.green));
            } else if (this.channel == 3) {
                ipRamp.setColorModel(LUT.createLutFromColor(Color.blue));
            }
            pixels = (float[])((ImageProcessor)ipRamp).getPixels();
        } else {
            pixels = new float[width * height];
        }
        for (int j = 0; j < height; ++j) {
            for (int i = 0; i < width; ++i) {
                pixels[i + width * j] = (float)(xMin + (double)i * (xMax - xMin) / (double)(width - 1));
            }
        }
        double min = ipSource.getMin();
        double max = ipSource.getMax();
        if (!(ipSource instanceof ColorProcessor)) {
            ColorModel cm = null;
            if (imp.isComposite()) {
                if (this.stats != null && this.stats.pixelCount > ipSource.getPixelCount()) {
                    cm = LUT.createLutFromColor(Color.white);
                    min = this.stats.min;
                    max = this.stats.max;
                } else {
                    cm = ((CompositeImage)imp).getChannelLut();
                }
            } else {
                cm = ipSource.getMinThreshold() == -808080.0 ? ipSource.getColorModel() : ipSource.getCurrentColorModel();
            }
            ipRamp = new FloatProcessor(width, height, pixels, cm);
        }
        ((ImageProcessor)ipRamp).setMinAndMax(min, max);
        ImageProcessor bar = null;
        bar = ip instanceof ColorProcessor ? ipRamp.convertToRGB() : ipRamp.convertToByte(true);
        ip.insert(bar, x, y);
        ip.setColor(Color.black);
        ip.drawRect(x - 1, y, width + 2, height);
    }

    int scaleDown(ImageProcessor ip, double threshold) {
        double min = ip.getMin();
        double max = ip.getMax();
        if (max > min) {
            return (int)((threshold - min) / (max - min) * 255.0);
        }
        return 0;
    }

    void drawPlot(long maxCount, ImageProcessor ip) {
        if (maxCount == 0L) {
            maxCount = 1L;
        }
        this.frame = new Rectangle(20, 10, 256, 128);
        ip.drawRect(this.frame.x - 1, this.frame.y, this.frame.width + 2, this.frame.height + 1);
        if (this.histogram.length <= 256) {
            for (int i = 0; i < 256; ++i) {
                int index = (int)((double)i * (double)this.histogram.length / 256.0);
                int y = (int)(128.0 * (double)this.histogram[index] / (double)maxCount);
                if (y > 128) {
                    y = 128;
                }
                ip.drawLine(i + 20, 138, i + 20, 138 - y);
            }
        } else {
            double xscale = 256.0 / (double)this.histogram.length;
            for (int i = 0; i < this.histogram.length; ++i) {
                long value = this.histogram[i];
                if (value <= 0L) continue;
                int y = (int)(128.0 * (double)value / (double)maxCount);
                if (y > 128) {
                    y = 128;
                }
                int x = (int)((double)i * xscale) + 20;
                ip.drawLine(x, 138, x, 138 - y);
            }
        }
    }

    void drawLogPlot(long maxCount, ImageProcessor ip) {
        this.frame = new Rectangle(20, 10, 256, 128);
        ip.drawRect(this.frame.x - 1, this.frame.y, this.frame.width + 2, this.frame.height + 1);
        double max = Math.log(maxCount);
        ip.setColor(Color.gray);
        if (this.histogram.length <= 256) {
            for (int i = 0; i < 256; ++i) {
                int y;
                int index = (int)((double)i * (double)this.histogram.length / 256.0);
                int n = y = this.histogram[index] == 0L ? 0 : (int)(128.0 * Math.log(this.histogram[index]) / max);
                if (y > 128) {
                    y = 128;
                }
                ip.drawLine(i + 20, 138, i + 20, 138 - y);
            }
        } else {
            double xscale = 256.0 / (double)this.histogram.length;
            for (int i = 0; i < this.histogram.length; ++i) {
                long value = this.histogram[i];
                if (value <= 0L) continue;
                int y = (int)(128.0 * Math.log(value) / max);
                if (y > 128) {
                    y = 128;
                }
                int x = (int)((double)i * xscale) + 20;
                ip.drawLine(x, 138, x, 138 - y);
            }
        }
        ip.setColor(Color.black);
    }

    void drawText(ImageProcessor ip, int x, int y, boolean fixedRange) {
        ip.setFont(new Font("SansSerif", 0, 12));
        ip.setAntialiasedText(true);
        double hmin = this.cal.getCValue(this.stats.histMin);
        double hmax = this.cal.getCValue(this.stats.histMax);
        double range = hmax - hmin;
        if (fixedRange && !this.cal.calibrated() && hmin == 0.0 && hmax == 255.0) {
            range = 256.0;
        }
        ip.drawString(this.d2s(hmin), x - 4, y);
        ip.drawString(this.d2s(hmax), x + 256 - this.getWidth(hmax, ip) + 10, y);
        double binWidth = range / (double)this.stats.nBins;
        binWidth = Math.abs(binWidth);
        boolean showBins = binWidth != 1.0 || !fixedRange;
        int col1 = 25;
        int col2 = 148;
        int row1 = y + 25;
        if (showBins) {
            row1 -= 8;
        }
        int row2 = row1 + 15;
        int row3 = row2 + 15;
        int row4 = row3 + 15;
        long count = this.stats.longPixelCount > 0L ? this.stats.longPixelCount : (long)this.stats.pixelCount;
        String modeCount = " (" + this.stats.maxCount + ")";
        if (modeCount.length() > 12) {
            modeCount = "";
        }
        ip.drawString("Count: " + count, col1, row1);
        ip.drawString("Mean: " + this.d2s(this.stats.mean), col1, row2);
        ip.drawString("StdDev: " + this.d2s(this.stats.stdDev), col1, row3);
        ip.drawString("Mode: " + this.d2s(this.stats.dmode) + modeCount, col2, row3);
        ip.drawString("Min: " + this.d2s(this.stats.min), col2, row1);
        ip.drawString("Max: " + this.d2s(this.stats.max), col2, row2);
        if (showBins) {
            ip.drawString("Bins: " + this.d2s(this.stats.nBins), col1, row4);
            ip.drawString("Bin Width: " + this.d2s(binWidth), col2, row4);
        }
    }

    private String d2s(double d) {
        if ((double)((int)d) == d) {
            return IJ.d2s(d, 0);
        }
        return IJ.d2s(d, 3, 8);
    }

    int getWidth(double d, ImageProcessor ip) {
        return ip.getStringWidth(this.d2s(d));
    }

    public ResultsTable getResultsTable() {
        String vheading;
        ResultsTable rt = new ResultsTable();
        rt.showRowNumbers(false);
        rt.setPrecision(this.digits);
        String string = vheading = this.stats.binSize == 1.0 ? "value" : "bin start";
        if (this.cal.calibrated() && !this.cal.isSigned16Bit()) {
            for (int i = 0; i < this.stats.nBins; ++i) {
                rt.setValue("level", i, (double)i);
                rt.setValue(vheading, i, this.cal.getCValue(this.stats.histMin + (double)i * this.stats.binSize));
                rt.setValue("count", i, (double)this.histogram[i]);
            }
        } else {
            for (int i = 0; i < this.stats.nBins; ++i) {
                rt.setValue(vheading, i, this.cal.getCValue(this.stats.histMin + (double)i * this.stats.binSize));
                rt.setValue("count", i, (double)this.histogram[i]);
            }
        }
        return rt;
    }

    protected void showList() {
        ResultsTable rt = this.getResultsTable();
        rt.show(this.getTitle());
    }

    protected void copyToClipboard() {
        Clipboard systemClipboard = null;
        try {
            systemClipboard = this.getToolkit().getSystemClipboard();
        }
        catch (Exception e) {
            systemClipboard = null;
        }
        if (systemClipboard == null) {
            IJ.error("Unable to copy to Clipboard.");
            return;
        }
        IJ.showStatus("Copying histogram values...");
        CharArrayWriter aw = new CharArrayWriter(this.stats.nBins * 4);
        PrintWriter pw = new PrintWriter(aw);
        for (int i = 0; i < this.stats.nBins; ++i) {
            pw.print(ResultsTable.d2s(this.cal.getCValue(this.stats.histMin + (double)i * this.stats.binSize), this.digits) + "\t" + this.histogram[i] + "\n");
        }
        String text = aw.toString();
        pw.close();
        StringSelection contents = new StringSelection(text);
        systemClipboard.setContents(contents, this);
        IJ.showStatus(text.length() + " characters copied to Clipboard");
    }

    void replot() {
        ImageProcessor ip = this.imp.getProcessor();
        this.frame = new Rectangle(20, 10, 256, 128);
        ip.setColor(Color.white);
        ip.setRoi(this.frame.x - 1, this.frame.y, this.frame.width + 2, this.frame.height);
        ip.fill();
        ip.resetRoi();
        ip.setColor(Color.black);
        if (this.logScale) {
            this.drawLogPlot(this.yMax > 0 ? (long)this.yMax : this.newMaxCount, ip);
            this.drawPlot(this.yMax > 0 ? (long)this.yMax : this.newMaxCount, ip);
        } else {
            this.drawPlot(this.yMax > 0 ? (long)this.yMax : this.newMaxCount, ip);
        }
        this.imp.updateAndDraw();
    }

    public void actionPerformed(ActionEvent e) {
        Object b = e.getSource();
        if (b == this.live) {
            this.toggleLiveMode();
        } else if (b == this.rgb) {
            this.changeChannel();
        } else if (b == this.list) {
            this.showList();
        } else if (b == this.copy) {
            this.copyToClipboard();
        } else if (b == this.log) {
            this.logScale = !this.logScale;
            this.replot();
        }
    }

    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }

    public int[] getHistogram() {
        int[] hist = new int[this.histogram.length];
        for (int i = 0; i < this.histogram.length; ++i) {
            hist[i] = (int)this.histogram[i];
        }
        return hist;
    }

    public double[] getXValues() {
        double[] values = new double[this.stats.nBins];
        for (int i = 0; i < this.stats.nBins; ++i) {
            values[i] = this.cal.getCValue(this.stats.histMin + (double)i * this.stats.binSize);
        }
        return values;
    }

    private void toggleLiveMode() {
        if (this.liveMode()) {
            this.removeListeners();
        } else {
            this.enableLiveMode();
        }
    }

    private void changeChannel() {
        ImagePlus imp = WindowManager.getImage(this.srcImageID);
        if (imp == null || imp.getType() != 4) {
            this.channel = 0;
            return;
        }
        ++this.channel;
        if (this.channel > 3) {
            this.channel = 0;
        }
        this.showHistogram(imp, 256);
        String name = this.imp.getTitle();
        if (name.startsWith("Red ")) {
            name = name.substring(4);
        } else if (name.startsWith("Green ")) {
            name = name.substring(6);
        } else if (name.startsWith("Blue ")) {
            name = name.substring(5);
        }
        switch (this.channel) {
            case 0: {
                this.imp.setTitle(name);
                break;
            }
            case 1: {
                this.imp.setTitle("Red " + name);
                break;
            }
            case 2: {
                this.imp.setTitle("Green " + name);
                break;
            }
            case 3: {
                this.imp.setTitle("Blue " + name);
            }
        }
    }

    private boolean liveMode() {
        return this.live != null && this.live.getForeground() == Color.red;
    }

    private void enableLiveMode() {
        if (this.bgThread == null) {
            this.srcImp = WindowManager.getImage(this.srcImageID);
            if (this.srcImp == null) {
                return;
            }
            this.bgThread = new Thread((Runnable)this, "Live Histogram");
            this.bgThread.setPriority(Math.max(this.bgThread.getPriority() - 3, 1));
            this.bgThread.start();
            this.imageUpdated(this.srcImp);
        }
        this.createListeners();
        if (this.srcImp != null) {
            this.imageUpdated(this.srcImp);
        }
    }

    public void imageOpened(ImagePlus imp) {
    }

    public synchronized void imageUpdated(ImagePlus imp) {
        if (imp == this.srcImp) {
            this.doUpdate = true;
            this.notify();
        }
    }

    public synchronized void roiModified(ImagePlus img, int id) {
        if (img == this.srcImp) {
            this.doUpdate = true;
            this.notify();
        }
    }

    public void imageClosed(ImagePlus imp) {
        if (imp == this.srcImp || imp == this.imp) {
            if (this.bgThread != null) {
                this.bgThread.interrupt();
            }
            this.bgThread = null;
            this.removeListeners();
            this.srcImp = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            if (this.doUpdate && this.srcImp != null) {
                if (this.srcImp.getRoi() != null) {
                    IJ.wait(50);
                }
                if (this.srcImp != null) {
                    if (this.srcImp.getBitDepth() == 16 && ImagePlus.getDefault16bitRange() != 0) {
                        this.showHistogram(this.srcImp, 256, 0.0, Math.pow(2.0, ImagePlus.getDefault16bitRange()) - 1.0);
                    } else {
                        this.showHistogram(this.srcImp, 256);
                    }
                }
            }
            HistogramWindow histogramWindow = this;
            synchronized (histogramWindow) {
                if (this.doUpdate) {
                    this.doUpdate = false;
                } else {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                }
            }
        }
    }

    private void createListeners() {
        if (this.srcImp == null) {
            return;
        }
        ImagePlus.addImageListener(this);
        Roi.addRoiListener(this);
        if (this.live != null) {
            Font font = this.live.getFont();
            this.live.setFont(new Font(font.getName(), 1, font.getSize()));
            this.live.setForeground(Color.red);
        }
    }

    private void removeListeners() {
        if (this.srcImp == null) {
            return;
        }
        ImagePlus.removeImageListener(this);
        Roi.removeRoiListener(this);
        if (this.live != null) {
            Font font = this.live.getFont();
            this.live.setFont(new Font(font.getName(), 0, font.getSize()));
            this.live.setForeground(Color.black);
        }
    }
}

