/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array;

import mitiv.array.Array8D;
import mitiv.array.Byte8D;
import mitiv.array.Double1D;
import mitiv.array.Double7D;
import mitiv.array.DoubleArray;
import mitiv.array.Float8D;
import mitiv.array.Int8D;
import mitiv.array.Long8D;
import mitiv.array.ShapedArray;
import mitiv.array.Short8D;
import mitiv.array.impl.FlatDouble8D;
import mitiv.array.impl.StriddenDouble8D;
import mitiv.base.Shape;
import mitiv.base.indexing.Range;
import mitiv.base.mapping.DoubleFunction;
import mitiv.base.mapping.DoubleScanner;
import mitiv.exception.IllegalTypeException;
import mitiv.exception.NonConformableArrayException;
import mitiv.linalg.shaped.DoubleShapedVector;
import mitiv.linalg.shaped.FloatShapedVector;
import mitiv.linalg.shaped.ShapedVector;
import mitiv.random.DoubleGenerator;

public abstract class Double8D
extends Array8D
implements DoubleArray {
    protected Double8D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        super(n, n2, n3, n4, n5, n6, n7, n8);
    }

    protected Double8D(int[] nArray) {
        super(nArray);
    }

    protected Double8D(Shape shape) {
        super(shape);
    }

    @Override
    public final int getType() {
        return 5;
    }

    public abstract double get(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8);

    public abstract void set(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, double var9);

    @Override
    public void fill(double d) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    for (int i5 = 0; i5 < this.dim7; ++i5) {
                                        for (int i6 = 0; i6 < this.dim8; ++i6) {
                                            this.set(i, j, k, i2, i3, i4, i5, i6, d);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim8; ++i) {
                for (int j = 0; j < this.dim7; ++j) {
                    for (int k = 0; k < this.dim6; ++k) {
                        for (int i7 = 0; i7 < this.dim5; ++i7) {
                            for (int i8 = 0; i8 < this.dim4; ++i8) {
                                for (int i9 = 0; i9 < this.dim3; ++i9) {
                                    for (int i10 = 0; i10 < this.dim2; ++i10) {
                                        for (int i11 = 0; i11 < this.dim1; ++i11) {
                                            this.set(i11, i10, i9, i8, i7, k, j, i, d);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void increment(double d) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    for (int i5 = 0; i5 < this.dim7; ++i5) {
                                        for (int i6 = 0; i6 < this.dim8; ++i6) {
                                            this.set(i, j, k, i2, i3, i4, i5, i6, this.get(i, j, k, i2, i3, i4, i5, i6) + d);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim8; ++i) {
                for (int j = 0; j < this.dim7; ++j) {
                    for (int k = 0; k < this.dim6; ++k) {
                        for (int i7 = 0; i7 < this.dim5; ++i7) {
                            for (int i8 = 0; i8 < this.dim4; ++i8) {
                                for (int i9 = 0; i9 < this.dim3; ++i9) {
                                    for (int i10 = 0; i10 < this.dim2; ++i10) {
                                        for (int i11 = 0; i11 < this.dim1; ++i11) {
                                            this.set(i11, i10, i9, i8, i7, k, j, i, this.get(i11, i10, i9, i8, i7, k, j, i) + d);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void decrement(double d) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    for (int i5 = 0; i5 < this.dim7; ++i5) {
                                        for (int i6 = 0; i6 < this.dim8; ++i6) {
                                            this.set(i, j, k, i2, i3, i4, i5, i6, this.get(i, j, k, i2, i3, i4, i5, i6) - d);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim8; ++i) {
                for (int j = 0; j < this.dim7; ++j) {
                    for (int k = 0; k < this.dim6; ++k) {
                        for (int i7 = 0; i7 < this.dim5; ++i7) {
                            for (int i8 = 0; i8 < this.dim4; ++i8) {
                                for (int i9 = 0; i9 < this.dim3; ++i9) {
                                    for (int i10 = 0; i10 < this.dim2; ++i10) {
                                        for (int i11 = 0; i11 < this.dim1; ++i11) {
                                            this.set(i11, i10, i9, i8, i7, k, j, i, this.get(i11, i10, i9, i8, i7, k, j, i) - d);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void scale(double d) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    for (int i5 = 0; i5 < this.dim7; ++i5) {
                                        for (int i6 = 0; i6 < this.dim8; ++i6) {
                                            this.set(i, j, k, i2, i3, i4, i5, i6, this.get(i, j, k, i2, i3, i4, i5, i6) * d);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim8; ++i) {
                for (int j = 0; j < this.dim7; ++j) {
                    for (int k = 0; k < this.dim6; ++k) {
                        for (int i7 = 0; i7 < this.dim5; ++i7) {
                            for (int i8 = 0; i8 < this.dim4; ++i8) {
                                for (int i9 = 0; i9 < this.dim3; ++i9) {
                                    for (int i10 = 0; i10 < this.dim2; ++i10) {
                                        for (int i11 = 0; i11 < this.dim1; ++i11) {
                                            this.set(i11, i10, i9, i8, i7, k, j, i, this.get(i11, i10, i9, i8, i7, k, j, i) * d);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void map(DoubleFunction doubleFunction) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    for (int i5 = 0; i5 < this.dim7; ++i5) {
                                        for (int i6 = 0; i6 < this.dim8; ++i6) {
                                            this.set(i, j, k, i2, i3, i4, i5, i6, doubleFunction.apply(this.get(i, j, k, i2, i3, i4, i5, i6)));
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim8; ++i) {
                for (int j = 0; j < this.dim7; ++j) {
                    for (int k = 0; k < this.dim6; ++k) {
                        for (int i7 = 0; i7 < this.dim5; ++i7) {
                            for (int i8 = 0; i8 < this.dim4; ++i8) {
                                for (int i9 = 0; i9 < this.dim3; ++i9) {
                                    for (int i10 = 0; i10 < this.dim2; ++i10) {
                                        for (int i11 = 0; i11 < this.dim1; ++i11) {
                                            this.set(i11, i10, i9, i8, i7, k, j, i, doubleFunction.apply(this.get(i11, i10, i9, i8, i7, k, j, i)));
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void fill(DoubleGenerator doubleGenerator) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    for (int i5 = 0; i5 < this.dim7; ++i5) {
                                        for (int i6 = 0; i6 < this.dim8; ++i6) {
                                            this.set(i, j, k, i2, i3, i4, i5, i6, doubleGenerator.nextDouble());
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim8; ++i) {
                for (int j = 0; j < this.dim7; ++j) {
                    for (int k = 0; k < this.dim6; ++k) {
                        for (int i7 = 0; i7 < this.dim5; ++i7) {
                            for (int i8 = 0; i8 < this.dim4; ++i8) {
                                for (int i9 = 0; i9 < this.dim3; ++i9) {
                                    for (int i10 = 0; i10 < this.dim2; ++i10) {
                                        for (int i11 = 0; i11 < this.dim1; ++i11) {
                                            this.set(i11, i10, i9, i8, i7, k, j, i, doubleGenerator.nextDouble());
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void scan(DoubleScanner doubleScanner) {
        boolean bl = false;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    for (int i5 = 0; i5 < this.dim7; ++i5) {
                                        for (int i6 = 0; i6 < this.dim8; ++i6) {
                                            if (bl) {
                                                doubleScanner.update(this.get(i, j, k, i2, i3, i4, i5, i6));
                                                continue;
                                            }
                                            doubleScanner.initialize(this.get(i, j, k, i2, i3, i4, i5, i6));
                                            bl = true;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim8; ++i) {
                for (int j = 0; j < this.dim7; ++j) {
                    for (int k = 0; k < this.dim6; ++k) {
                        for (int i7 = 0; i7 < this.dim5; ++i7) {
                            for (int i8 = 0; i8 < this.dim4; ++i8) {
                                for (int i9 = 0; i9 < this.dim3; ++i9) {
                                    for (int i10 = 0; i10 < this.dim2; ++i10) {
                                        for (int i11 = 0; i11 < this.dim1; ++i11) {
                                            if (bl) {
                                                doubleScanner.update(this.get(i11, i10, i9, i8, i7, k, j, i));
                                                continue;
                                            }
                                            doubleScanner.initialize(this.get(i11, i10, i9, i8, i7, k, j, i));
                                            bl = true;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public final double[] flatten() {
        return this.flatten(false);
    }

    @Override
    public double min() {
        double d = this.get(0, 0, 0, 0, 0, 0, 0, 0);
        boolean bl = true;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    for (int i5 = 0; i5 < this.dim7; ++i5) {
                                        for (int i6 = 0; i6 < this.dim8; ++i6) {
                                            if (bl) {
                                                bl = false;
                                                continue;
                                            }
                                            double d2 = this.get(i, j, k, i2, i3, i4, i5, i6);
                                            if (!(d2 < d)) continue;
                                            d = d2;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim8; ++i) {
                for (int j = 0; j < this.dim7; ++j) {
                    for (int k = 0; k < this.dim6; ++k) {
                        for (int i7 = 0; i7 < this.dim5; ++i7) {
                            for (int i8 = 0; i8 < this.dim4; ++i8) {
                                for (int i9 = 0; i9 < this.dim3; ++i9) {
                                    for (int i10 = 0; i10 < this.dim2; ++i10) {
                                        for (int i11 = 0; i11 < this.dim1; ++i11) {
                                            if (bl) {
                                                bl = false;
                                                continue;
                                            }
                                            double d3 = this.get(i11, i10, i9, i8, i7, k, j, i);
                                            if (!(d3 < d)) continue;
                                            d = d3;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return d;
    }

    @Override
    public double max() {
        double d = this.get(0, 0, 0, 0, 0, 0, 0, 0);
        boolean bl = true;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    for (int i5 = 0; i5 < this.dim7; ++i5) {
                                        for (int i6 = 0; i6 < this.dim8; ++i6) {
                                            if (bl) {
                                                bl = false;
                                                continue;
                                            }
                                            double d2 = this.get(i, j, k, i2, i3, i4, i5, i6);
                                            if (!(d2 > d)) continue;
                                            d = d2;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim8; ++i) {
                for (int j = 0; j < this.dim7; ++j) {
                    for (int k = 0; k < this.dim6; ++k) {
                        for (int i7 = 0; i7 < this.dim5; ++i7) {
                            for (int i8 = 0; i8 < this.dim4; ++i8) {
                                for (int i9 = 0; i9 < this.dim3; ++i9) {
                                    for (int i10 = 0; i10 < this.dim2; ++i10) {
                                        for (int i11 = 0; i11 < this.dim1; ++i11) {
                                            if (bl) {
                                                bl = false;
                                                continue;
                                            }
                                            double d3 = this.get(i11, i10, i9, i8, i7, k, j, i);
                                            if (!(d3 > d)) continue;
                                            d = d3;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return d;
    }

    @Override
    public double[] getMinAndMax() {
        double[] dArray = new double[2];
        this.getMinAndMax(dArray);
        return dArray;
    }

    @Override
    public void getMinAndMax(double[] dArray) {
        double d;
        double d2 = d = this.get(0, 0, 0, 0, 0, 0, 0, 0);
        boolean bl = true;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    for (int i5 = 0; i5 < this.dim7; ++i5) {
                                        for (int i6 = 0; i6 < this.dim8; ++i6) {
                                            if (bl) {
                                                bl = false;
                                                continue;
                                            }
                                            double d3 = this.get(i, j, k, i2, i3, i4, i5, i6);
                                            if (d3 < d) {
                                                d = d3;
                                            }
                                            if (!(d3 > d2)) continue;
                                            d2 = d3;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim8; ++i) {
                for (int j = 0; j < this.dim7; ++j) {
                    for (int k = 0; k < this.dim6; ++k) {
                        for (int i7 = 0; i7 < this.dim5; ++i7) {
                            for (int i8 = 0; i8 < this.dim4; ++i8) {
                                for (int i9 = 0; i9 < this.dim3; ++i9) {
                                    for (int i10 = 0; i10 < this.dim2; ++i10) {
                                        for (int i11 = 0; i11 < this.dim1; ++i11) {
                                            if (bl) {
                                                bl = false;
                                                continue;
                                            }
                                            double d4 = this.get(i11, i10, i9, i8, i7, k, j, i);
                                            if (d4 < d) {
                                                d = d4;
                                            }
                                            if (!(d4 > d2)) continue;
                                            d2 = d4;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        dArray[0] = d;
        dArray[1] = d2;
    }

    @Override
    public double sum() {
        double d = 0.0;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    for (int i5 = 0; i5 < this.dim7; ++i5) {
                                        for (int i6 = 0; i6 < this.dim8; ++i6) {
                                            d += this.get(i, j, k, i2, i3, i4, i5, i6);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim8; ++i) {
                for (int j = 0; j < this.dim7; ++j) {
                    for (int k = 0; k < this.dim6; ++k) {
                        for (int i7 = 0; i7 < this.dim5; ++i7) {
                            for (int i8 = 0; i8 < this.dim4; ++i8) {
                                for (int i9 = 0; i9 < this.dim3; ++i9) {
                                    for (int i10 = 0; i10 < this.dim2; ++i10) {
                                        for (int i11 = 0; i11 < this.dim1; ++i11) {
                                            d += this.get(i11, i10, i9, i8, i7, k, j, i);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return d;
    }

    @Override
    public double average() {
        return this.sum() / (double)this.number;
    }

    @Override
    public Byte8D toByte() {
        byte[] byArray = new byte[this.number];
        if (this.isFlat()) {
            double[] dArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                byArray[i] = (byte)dArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim8; ++i) {
                for (int j = 0; j < this.dim7; ++j) {
                    for (int k = 0; k < this.dim6; ++k) {
                        for (int i2 = 0; i2 < this.dim5; ++i2) {
                            for (int i3 = 0; i3 < this.dim4; ++i3) {
                                for (int i4 = 0; i4 < this.dim3; ++i4) {
                                    for (int i5 = 0; i5 < this.dim2; ++i5) {
                                        for (int i6 = 0; i6 < this.dim1; ++i6) {
                                            byArray[++n] = (byte)this.get(i6, i5, i4, i3, i2, k, j, i);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return Byte8D.wrap(byArray, this.getShape());
    }

    @Override
    public Short8D toShort() {
        short[] sArray = new short[this.number];
        if (this.isFlat()) {
            double[] dArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                sArray[i] = (short)dArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim8; ++i) {
                for (int j = 0; j < this.dim7; ++j) {
                    for (int k = 0; k < this.dim6; ++k) {
                        for (int i2 = 0; i2 < this.dim5; ++i2) {
                            for (int i3 = 0; i3 < this.dim4; ++i3) {
                                for (int i4 = 0; i4 < this.dim3; ++i4) {
                                    for (int i5 = 0; i5 < this.dim2; ++i5) {
                                        for (int i6 = 0; i6 < this.dim1; ++i6) {
                                            sArray[++n] = (short)this.get(i6, i5, i4, i3, i2, k, j, i);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return Short8D.wrap(sArray, this.getShape());
    }

    @Override
    public Int8D toInt() {
        int[] nArray = new int[this.number];
        if (this.isFlat()) {
            double[] dArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                nArray[i] = (int)dArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim8; ++i) {
                for (int j = 0; j < this.dim7; ++j) {
                    for (int k = 0; k < this.dim6; ++k) {
                        for (int i2 = 0; i2 < this.dim5; ++i2) {
                            for (int i3 = 0; i3 < this.dim4; ++i3) {
                                for (int i4 = 0; i4 < this.dim3; ++i4) {
                                    for (int i5 = 0; i5 < this.dim2; ++i5) {
                                        for (int i6 = 0; i6 < this.dim1; ++i6) {
                                            nArray[++n] = (int)this.get(i6, i5, i4, i3, i2, k, j, i);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return Int8D.wrap(nArray, this.getShape());
    }

    @Override
    public Long8D toLong() {
        long[] lArray = new long[this.number];
        if (this.isFlat()) {
            double[] dArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                lArray[i] = (long)dArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim8; ++i) {
                for (int j = 0; j < this.dim7; ++j) {
                    for (int k = 0; k < this.dim6; ++k) {
                        for (int i2 = 0; i2 < this.dim5; ++i2) {
                            for (int i3 = 0; i3 < this.dim4; ++i3) {
                                for (int i4 = 0; i4 < this.dim3; ++i4) {
                                    for (int i5 = 0; i5 < this.dim2; ++i5) {
                                        for (int i6 = 0; i6 < this.dim1; ++i6) {
                                            lArray[++n] = (long)this.get(i6, i5, i4, i3, i2, k, j, i);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return Long8D.wrap(lArray, this.getShape());
    }

    @Override
    public Float8D toFloat() {
        float[] fArray = new float[this.number];
        if (this.isFlat()) {
            double[] dArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                fArray[i] = (float)dArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim8; ++i) {
                for (int j = 0; j < this.dim7; ++j) {
                    for (int k = 0; k < this.dim6; ++k) {
                        for (int i2 = 0; i2 < this.dim5; ++i2) {
                            for (int i3 = 0; i3 < this.dim4; ++i3) {
                                for (int i4 = 0; i4 < this.dim3; ++i4) {
                                    for (int i5 = 0; i5 < this.dim2; ++i5) {
                                        for (int i6 = 0; i6 < this.dim1; ++i6) {
                                            fArray[++n] = (float)this.get(i6, i5, i4, i3, i2, k, j, i);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return Float8D.wrap(fArray, this.getShape());
    }

    @Override
    public Double8D toDouble() {
        return this;
    }

    @Override
    public Double8D copy() {
        return new FlatDouble8D(this.flatten(true), this.shape);
    }

    @Override
    public void assign(ShapedArray shapedArray) {
        if (!this.getShape().equals(shapedArray.getShape())) {
            throw new NonConformableArrayException("Source and destination must have the same shape");
        }
        Double8D double8D = shapedArray.getType() == 5 ? (Double8D)shapedArray : (Double8D)shapedArray.toDouble();
        if (this.getOrder() == 2 && double8D.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    for (int i5 = 0; i5 < this.dim7; ++i5) {
                                        for (int i6 = 0; i6 < this.dim8; ++i6) {
                                            this.set(i, j, k, i2, i3, i4, i5, i6, double8D.get(i, j, k, i2, i3, i4, i5, i6));
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim8; ++i) {
                for (int j = 0; j < this.dim7; ++j) {
                    for (int k = 0; k < this.dim6; ++k) {
                        for (int i7 = 0; i7 < this.dim5; ++i7) {
                            for (int i8 = 0; i8 < this.dim4; ++i8) {
                                for (int i9 = 0; i9 < this.dim3; ++i9) {
                                    for (int i10 = 0; i10 < this.dim2; ++i10) {
                                        for (int i11 = 0; i11 < this.dim1; ++i11) {
                                            this.set(i11, i10, i9, i8, i7, k, j, i, double8D.get(i11, i10, i9, i8, i7, k, j, i));
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void assign(ShapedVector shapedVector) {
        if (!this.getShape().equals(shapedVector.getShape())) {
            throw new NonConformableArrayException("Source and destination must have the same shape");
        }
        int n = -1;
        if (shapedVector.getType() == 5) {
            DoubleShapedVector doubleShapedVector = (DoubleShapedVector)shapedVector;
            for (int i = 0; i < this.dim8; ++i) {
                for (int j = 0; j < this.dim7; ++j) {
                    for (int k = 0; k < this.dim6; ++k) {
                        for (int i2 = 0; i2 < this.dim5; ++i2) {
                            for (int i3 = 0; i3 < this.dim4; ++i3) {
                                for (int i4 = 0; i4 < this.dim3; ++i4) {
                                    for (int i5 = 0; i5 < this.dim2; ++i5) {
                                        for (int i6 = 0; i6 < this.dim1; ++i6) {
                                            this.set(i6, i5, i4, i3, i2, k, j, i, doubleShapedVector.get(++n));
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else if (shapedVector.getType() == 4) {
            FloatShapedVector floatShapedVector = (FloatShapedVector)shapedVector;
            for (int i = 0; i < this.dim8; ++i) {
                for (int j = 0; j < this.dim7; ++j) {
                    for (int k = 0; k < this.dim6; ++k) {
                        for (int i7 = 0; i7 < this.dim5; ++i7) {
                            for (int i8 = 0; i8 < this.dim4; ++i8) {
                                for (int i9 = 0; i9 < this.dim3; ++i9) {
                                    for (int i10 = 0; i10 < this.dim2; ++i10) {
                                        for (int i11 = 0; i11 < this.dim1; ++i11) {
                                            this.set(i11, i10, i9, i8, i7, k, j, i, floatShapedVector.get(++n));
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            throw new IllegalTypeException();
        }
    }

    @Override
    public Double8D create() {
        return new FlatDouble8D(this.getShape());
    }

    public static Double8D create(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        return new FlatDouble8D(n, n2, n3, n4, n5, n6, n7, n8);
    }

    public static Double8D create(int[] nArray) {
        return new FlatDouble8D(nArray);
    }

    public static Double8D create(Shape shape) {
        return new FlatDouble8D(shape);
    }

    public static Double8D wrap(double[] dArray, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        return new FlatDouble8D(dArray, n, n2, n3, n4, n5, n6, n7, n8);
    }

    public static Double8D wrap(double[] dArray, int[] nArray) {
        return new FlatDouble8D(dArray, nArray);
    }

    public static Double8D wrap(double[] dArray, Shape shape) {
        return new FlatDouble8D(dArray, shape);
    }

    public static Double8D wrap(double[] dArray, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13, int n14, int n15, int n16, int n17) {
        return new StriddenDouble8D(dArray, n, n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, n12, n13, n14, n15, n16, n17);
    }

    @Override
    public abstract Double7D slice(int var1);

    @Override
    public abstract Double7D slice(int var1, int var2);

    @Override
    public abstract Double8D view(Range var1, Range var2, Range var3, Range var4, Range var5, Range var6, Range var7, Range var8);

    @Override
    public abstract Double8D view(int[] var1, int[] var2, int[] var3, int[] var4, int[] var5, int[] var6, int[] var7, int[] var8);

    @Override
    public abstract Double1D as1D();
}

