/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array;

import mitiv.array.Array3D;
import mitiv.array.Byte3D;
import mitiv.array.Double3D;
import mitiv.array.Float3D;
import mitiv.array.Int3D;
import mitiv.array.Long1D;
import mitiv.array.Long2D;
import mitiv.array.LongArray;
import mitiv.array.ShapedArray;
import mitiv.array.Short3D;
import mitiv.array.impl.FlatLong3D;
import mitiv.array.impl.StriddenLong3D;
import mitiv.base.Shape;
import mitiv.base.indexing.Range;
import mitiv.base.mapping.LongFunction;
import mitiv.base.mapping.LongScanner;
import mitiv.exception.IllegalTypeException;
import mitiv.exception.NonConformableArrayException;
import mitiv.linalg.shaped.DoubleShapedVector;
import mitiv.linalg.shaped.FloatShapedVector;
import mitiv.linalg.shaped.ShapedVector;
import mitiv.random.LongGenerator;

public abstract class Long3D
extends Array3D
implements LongArray {
    protected Long3D(int n, int n2, int n3) {
        super(n, n2, n3);
    }

    protected Long3D(int[] nArray) {
        super(nArray);
    }

    protected Long3D(Shape shape) {
        super(shape);
    }

    @Override
    public final int getType() {
        return 3;
    }

    public abstract long get(int var1, int var2, int var3);

    public abstract void set(int var1, int var2, int var3, long var4);

    @Override
    public void fill(long l) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        this.set(i, j, k, l);
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim3; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim1; ++k) {
                        this.set(k, j, i, l);
                    }
                }
            }
        }
    }

    @Override
    public void increment(long l) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        this.set(i, j, k, this.get(i, j, k) + l);
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim3; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim1; ++k) {
                        this.set(k, j, i, this.get(k, j, i) + l);
                    }
                }
            }
        }
    }

    @Override
    public void decrement(long l) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        this.set(i, j, k, this.get(i, j, k) - l);
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim3; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim1; ++k) {
                        this.set(k, j, i, this.get(k, j, i) - l);
                    }
                }
            }
        }
    }

    @Override
    public void scale(long l) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        this.set(i, j, k, this.get(i, j, k) * l);
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim3; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim1; ++k) {
                        this.set(k, j, i, this.get(k, j, i) * l);
                    }
                }
            }
        }
    }

    @Override
    public void map(LongFunction longFunction) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        this.set(i, j, k, longFunction.apply(this.get(i, j, k)));
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim3; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim1; ++k) {
                        this.set(k, j, i, longFunction.apply(this.get(k, j, i)));
                    }
                }
            }
        }
    }

    @Override
    public void fill(LongGenerator longGenerator) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        this.set(i, j, k, longGenerator.nextLong());
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim3; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim1; ++k) {
                        this.set(k, j, i, longGenerator.nextLong());
                    }
                }
            }
        }
    }

    @Override
    public void scan(LongScanner longScanner) {
        boolean bl = false;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        if (bl) {
                            longScanner.update(this.get(i, j, k));
                            continue;
                        }
                        longScanner.initialize(this.get(i, j, k));
                        bl = true;
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim3; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim1; ++k) {
                        if (bl) {
                            longScanner.update(this.get(k, j, i));
                            continue;
                        }
                        longScanner.initialize(this.get(k, j, i));
                        bl = true;
                    }
                }
            }
        }
    }

    @Override
    public final long[] flatten() {
        return this.flatten(false);
    }

    @Override
    public long min() {
        long l = this.get(0, 0, 0);
        boolean bl = true;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        if (bl) {
                            bl = false;
                            continue;
                        }
                        long l2 = this.get(i, j, k);
                        if (l2 >= l) continue;
                        l = l2;
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim3; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim1; ++k) {
                        if (bl) {
                            bl = false;
                            continue;
                        }
                        long l3 = this.get(k, j, i);
                        if (l3 >= l) continue;
                        l = l3;
                    }
                }
            }
        }
        return l;
    }

    @Override
    public long max() {
        long l = this.get(0, 0, 0);
        boolean bl = true;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        if (bl) {
                            bl = false;
                            continue;
                        }
                        long l2 = this.get(i, j, k);
                        if (l2 <= l) continue;
                        l = l2;
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim3; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim1; ++k) {
                        if (bl) {
                            bl = false;
                            continue;
                        }
                        long l3 = this.get(k, j, i);
                        if (l3 <= l) continue;
                        l = l3;
                    }
                }
            }
        }
        return l;
    }

    @Override
    public long[] getMinAndMax() {
        long[] lArray = new long[2];
        this.getMinAndMax(lArray);
        return lArray;
    }

    @Override
    public void getMinAndMax(long[] lArray) {
        long l;
        long l2 = l = this.get(0, 0, 0);
        boolean bl = true;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        if (bl) {
                            bl = false;
                            continue;
                        }
                        long l3 = this.get(i, j, k);
                        if (l3 < l) {
                            l = l3;
                        }
                        if (l3 <= l2) continue;
                        l2 = l3;
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim3; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim1; ++k) {
                        if (bl) {
                            bl = false;
                            continue;
                        }
                        long l4 = this.get(k, j, i);
                        if (l4 < l) {
                            l = l4;
                        }
                        if (l4 <= l2) continue;
                        l2 = l4;
                    }
                }
            }
        }
        lArray[0] = l;
        lArray[1] = l2;
    }

    @Override
    public long sum() {
        long l = 0L;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        l += this.get(i, j, k);
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim3; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim1; ++k) {
                        l += this.get(k, j, i);
                    }
                }
            }
        }
        return l;
    }

    @Override
    public double average() {
        return (double)this.sum() / (double)this.number;
    }

    @Override
    public Byte3D toByte() {
        byte[] byArray = new byte[this.number];
        if (this.isFlat()) {
            long[] lArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                byArray[i] = (byte)lArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim3; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim1; ++k) {
                        byArray[++n] = (byte)this.get(k, j, i);
                    }
                }
            }
        }
        return Byte3D.wrap(byArray, this.getShape());
    }

    @Override
    public Short3D toShort() {
        short[] sArray = new short[this.number];
        if (this.isFlat()) {
            long[] lArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                sArray[i] = (short)lArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim3; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim1; ++k) {
                        sArray[++n] = (short)this.get(k, j, i);
                    }
                }
            }
        }
        return Short3D.wrap(sArray, this.getShape());
    }

    @Override
    public Int3D toInt() {
        int[] nArray = new int[this.number];
        if (this.isFlat()) {
            long[] lArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                nArray[i] = (int)lArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim3; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim1; ++k) {
                        nArray[++n] = (int)this.get(k, j, i);
                    }
                }
            }
        }
        return Int3D.wrap(nArray, this.getShape());
    }

    @Override
    public Long3D toLong() {
        return this;
    }

    @Override
    public Float3D toFloat() {
        float[] fArray = new float[this.number];
        if (this.isFlat()) {
            long[] lArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                fArray[i] = lArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim3; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim1; ++k) {
                        fArray[++n] = this.get(k, j, i);
                    }
                }
            }
        }
        return Float3D.wrap(fArray, this.getShape());
    }

    @Override
    public Double3D toDouble() {
        double[] dArray = new double[this.number];
        if (this.isFlat()) {
            long[] lArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                dArray[i] = lArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim3; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim1; ++k) {
                        dArray[++n] = this.get(k, j, i);
                    }
                }
            }
        }
        return Double3D.wrap(dArray, this.getShape());
    }

    @Override
    public Long3D copy() {
        return new FlatLong3D(this.flatten(true), this.shape);
    }

    @Override
    public void assign(ShapedArray shapedArray) {
        if (!this.getShape().equals(shapedArray.getShape())) {
            throw new NonConformableArrayException("Source and destination must have the same shape");
        }
        Long3D long3D = shapedArray.getType() == 3 ? (Long3D)shapedArray : (Long3D)shapedArray.toLong();
        if (this.getOrder() == 2 && long3D.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        this.set(i, j, k, long3D.get(i, j, k));
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim3; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim1; ++k) {
                        this.set(k, j, i, long3D.get(k, j, i));
                    }
                }
            }
        }
    }

    @Override
    public void assign(ShapedVector shapedVector) {
        if (!this.getShape().equals(shapedVector.getShape())) {
            throw new NonConformableArrayException("Source and destination must have the same shape");
        }
        int n = -1;
        if (shapedVector.getType() == 5) {
            DoubleShapedVector doubleShapedVector = (DoubleShapedVector)shapedVector;
            for (int i = 0; i < this.dim3; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim1; ++k) {
                        this.set(k, j, i, (long)doubleShapedVector.get(++n));
                    }
                }
            }
        } else if (shapedVector.getType() == 4) {
            FloatShapedVector floatShapedVector = (FloatShapedVector)shapedVector;
            for (int i = 0; i < this.dim3; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim1; ++k) {
                        this.set(k, j, i, (long)floatShapedVector.get(++n));
                    }
                }
            }
        } else {
            throw new IllegalTypeException();
        }
    }

    @Override
    public Long3D create() {
        return new FlatLong3D(this.getShape());
    }

    public static Long3D create(int n, int n2, int n3) {
        return new FlatLong3D(n, n2, n3);
    }

    public static Long3D create(int[] nArray) {
        return new FlatLong3D(nArray);
    }

    public static Long3D create(Shape shape) {
        return new FlatLong3D(shape);
    }

    public static Long3D wrap(long[] lArray, int n, int n2, int n3) {
        return new FlatLong3D(lArray, n, n2, n3);
    }

    public static Long3D wrap(long[] lArray, int[] nArray) {
        return new FlatLong3D(lArray, nArray);
    }

    public static Long3D wrap(long[] lArray, Shape shape) {
        return new FlatLong3D(lArray, shape);
    }

    public static Long3D wrap(long[] lArray, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        return new StriddenLong3D(lArray, n, n2, n3, n4, n5, n6, n7);
    }

    @Override
    public abstract Long2D slice(int var1);

    @Override
    public abstract Long2D slice(int var1, int var2);

    @Override
    public abstract Long3D view(Range var1, Range var2, Range var3);

    @Override
    public abstract Long3D view(int[] var1, int[] var2, int[] var3);

    @Override
    public abstract Long1D as1D();
}

