/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array;

import mitiv.array.Array5D;
import mitiv.array.Byte5D;
import mitiv.array.Double5D;
import mitiv.array.Float5D;
import mitiv.array.Int5D;
import mitiv.array.Long1D;
import mitiv.array.Long4D;
import mitiv.array.LongArray;
import mitiv.array.ShapedArray;
import mitiv.array.Short5D;
import mitiv.array.impl.FlatLong5D;
import mitiv.array.impl.StriddenLong5D;
import mitiv.base.Shape;
import mitiv.base.indexing.Range;
import mitiv.base.mapping.LongFunction;
import mitiv.base.mapping.LongScanner;
import mitiv.exception.IllegalTypeException;
import mitiv.exception.NonConformableArrayException;
import mitiv.linalg.shaped.DoubleShapedVector;
import mitiv.linalg.shaped.FloatShapedVector;
import mitiv.linalg.shaped.ShapedVector;
import mitiv.random.LongGenerator;

public abstract class Long5D
extends Array5D
implements LongArray {
    protected Long5D(int n, int n2, int n3, int n4, int n5) {
        super(n, n2, n3, n4, n5);
    }

    protected Long5D(int[] nArray) {
        super(nArray);
    }

    protected Long5D(Shape shape) {
        super(shape);
    }

    @Override
    public final int getType() {
        return 3;
    }

    public abstract long get(int var1, int var2, int var3, int var4, int var5);

    public abstract void set(int var1, int var2, int var3, int var4, int var5, long var6);

    @Override
    public void fill(long l) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                this.set(i, j, k, i2, i3, l);
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim5; ++i) {
                for (int j = 0; j < this.dim4; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i4 = 0; i4 < this.dim2; ++i4) {
                            for (int i5 = 0; i5 < this.dim1; ++i5) {
                                this.set(i5, i4, k, j, i, l);
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void increment(long l) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                this.set(i, j, k, i2, i3, this.get(i, j, k, i2, i3) + l);
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim5; ++i) {
                for (int j = 0; j < this.dim4; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i4 = 0; i4 < this.dim2; ++i4) {
                            for (int i5 = 0; i5 < this.dim1; ++i5) {
                                this.set(i5, i4, k, j, i, this.get(i5, i4, k, j, i) + l);
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void decrement(long l) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                this.set(i, j, k, i2, i3, this.get(i, j, k, i2, i3) - l);
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim5; ++i) {
                for (int j = 0; j < this.dim4; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i4 = 0; i4 < this.dim2; ++i4) {
                            for (int i5 = 0; i5 < this.dim1; ++i5) {
                                this.set(i5, i4, k, j, i, this.get(i5, i4, k, j, i) - l);
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void scale(long l) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                this.set(i, j, k, i2, i3, this.get(i, j, k, i2, i3) * l);
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim5; ++i) {
                for (int j = 0; j < this.dim4; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i4 = 0; i4 < this.dim2; ++i4) {
                            for (int i5 = 0; i5 < this.dim1; ++i5) {
                                this.set(i5, i4, k, j, i, this.get(i5, i4, k, j, i) * l);
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void map(LongFunction longFunction) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                this.set(i, j, k, i2, i3, longFunction.apply(this.get(i, j, k, i2, i3)));
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim5; ++i) {
                for (int j = 0; j < this.dim4; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i4 = 0; i4 < this.dim2; ++i4) {
                            for (int i5 = 0; i5 < this.dim1; ++i5) {
                                this.set(i5, i4, k, j, i, longFunction.apply(this.get(i5, i4, k, j, i)));
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void fill(LongGenerator longGenerator) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                this.set(i, j, k, i2, i3, longGenerator.nextLong());
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim5; ++i) {
                for (int j = 0; j < this.dim4; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i4 = 0; i4 < this.dim2; ++i4) {
                            for (int i5 = 0; i5 < this.dim1; ++i5) {
                                this.set(i5, i4, k, j, i, longGenerator.nextLong());
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void scan(LongScanner longScanner) {
        boolean bl = false;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                if (bl) {
                                    longScanner.update(this.get(i, j, k, i2, i3));
                                    continue;
                                }
                                longScanner.initialize(this.get(i, j, k, i2, i3));
                                bl = true;
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim5; ++i) {
                for (int j = 0; j < this.dim4; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i4 = 0; i4 < this.dim2; ++i4) {
                            for (int i5 = 0; i5 < this.dim1; ++i5) {
                                if (bl) {
                                    longScanner.update(this.get(i5, i4, k, j, i));
                                    continue;
                                }
                                longScanner.initialize(this.get(i5, i4, k, j, i));
                                bl = true;
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public final long[] flatten() {
        return this.flatten(false);
    }

    @Override
    public long min() {
        long l = this.get(0, 0, 0, 0, 0);
        boolean bl = true;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                if (bl) {
                                    bl = false;
                                    continue;
                                }
                                long l2 = this.get(i, j, k, i2, i3);
                                if (l2 >= l) continue;
                                l = l2;
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim5; ++i) {
                for (int j = 0; j < this.dim4; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i4 = 0; i4 < this.dim2; ++i4) {
                            for (int i5 = 0; i5 < this.dim1; ++i5) {
                                if (bl) {
                                    bl = false;
                                    continue;
                                }
                                long l3 = this.get(i5, i4, k, j, i);
                                if (l3 >= l) continue;
                                l = l3;
                            }
                        }
                    }
                }
            }
        }
        return l;
    }

    @Override
    public long max() {
        long l = this.get(0, 0, 0, 0, 0);
        boolean bl = true;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                if (bl) {
                                    bl = false;
                                    continue;
                                }
                                long l2 = this.get(i, j, k, i2, i3);
                                if (l2 <= l) continue;
                                l = l2;
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim5; ++i) {
                for (int j = 0; j < this.dim4; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i4 = 0; i4 < this.dim2; ++i4) {
                            for (int i5 = 0; i5 < this.dim1; ++i5) {
                                if (bl) {
                                    bl = false;
                                    continue;
                                }
                                long l3 = this.get(i5, i4, k, j, i);
                                if (l3 <= l) continue;
                                l = l3;
                            }
                        }
                    }
                }
            }
        }
        return l;
    }

    @Override
    public long[] getMinAndMax() {
        long[] lArray = new long[2];
        this.getMinAndMax(lArray);
        return lArray;
    }

    @Override
    public void getMinAndMax(long[] lArray) {
        long l;
        long l2 = l = this.get(0, 0, 0, 0, 0);
        boolean bl = true;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                if (bl) {
                                    bl = false;
                                    continue;
                                }
                                long l3 = this.get(i, j, k, i2, i3);
                                if (l3 < l) {
                                    l = l3;
                                }
                                if (l3 <= l2) continue;
                                l2 = l3;
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim5; ++i) {
                for (int j = 0; j < this.dim4; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i4 = 0; i4 < this.dim2; ++i4) {
                            for (int i5 = 0; i5 < this.dim1; ++i5) {
                                if (bl) {
                                    bl = false;
                                    continue;
                                }
                                long l4 = this.get(i5, i4, k, j, i);
                                if (l4 < l) {
                                    l = l4;
                                }
                                if (l4 <= l2) continue;
                                l2 = l4;
                            }
                        }
                    }
                }
            }
        }
        lArray[0] = l;
        lArray[1] = l2;
    }

    @Override
    public long sum() {
        long l = 0L;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                l += this.get(i, j, k, i2, i3);
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim5; ++i) {
                for (int j = 0; j < this.dim4; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i4 = 0; i4 < this.dim2; ++i4) {
                            for (int i5 = 0; i5 < this.dim1; ++i5) {
                                l += this.get(i5, i4, k, j, i);
                            }
                        }
                    }
                }
            }
        }
        return l;
    }

    @Override
    public double average() {
        return (double)this.sum() / (double)this.number;
    }

    @Override
    public Byte5D toByte() {
        byte[] byArray = new byte[this.number];
        if (this.isFlat()) {
            long[] lArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                byArray[i] = (byte)lArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim5; ++i) {
                for (int j = 0; j < this.dim4; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim2; ++i2) {
                            for (int i3 = 0; i3 < this.dim1; ++i3) {
                                byArray[++n] = (byte)this.get(i3, i2, k, j, i);
                            }
                        }
                    }
                }
            }
        }
        return Byte5D.wrap(byArray, this.getShape());
    }

    @Override
    public Short5D toShort() {
        short[] sArray = new short[this.number];
        if (this.isFlat()) {
            long[] lArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                sArray[i] = (short)lArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim5; ++i) {
                for (int j = 0; j < this.dim4; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim2; ++i2) {
                            for (int i3 = 0; i3 < this.dim1; ++i3) {
                                sArray[++n] = (short)this.get(i3, i2, k, j, i);
                            }
                        }
                    }
                }
            }
        }
        return Short5D.wrap(sArray, this.getShape());
    }

    @Override
    public Int5D toInt() {
        int[] nArray = new int[this.number];
        if (this.isFlat()) {
            long[] lArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                nArray[i] = (int)lArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim5; ++i) {
                for (int j = 0; j < this.dim4; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim2; ++i2) {
                            for (int i3 = 0; i3 < this.dim1; ++i3) {
                                nArray[++n] = (int)this.get(i3, i2, k, j, i);
                            }
                        }
                    }
                }
            }
        }
        return Int5D.wrap(nArray, this.getShape());
    }

    @Override
    public Long5D toLong() {
        return this;
    }

    @Override
    public Float5D toFloat() {
        float[] fArray = new float[this.number];
        if (this.isFlat()) {
            long[] lArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                fArray[i] = lArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim5; ++i) {
                for (int j = 0; j < this.dim4; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim2; ++i2) {
                            for (int i3 = 0; i3 < this.dim1; ++i3) {
                                fArray[++n] = this.get(i3, i2, k, j, i);
                            }
                        }
                    }
                }
            }
        }
        return Float5D.wrap(fArray, this.getShape());
    }

    @Override
    public Double5D toDouble() {
        double[] dArray = new double[this.number];
        if (this.isFlat()) {
            long[] lArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                dArray[i] = lArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim5; ++i) {
                for (int j = 0; j < this.dim4; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim2; ++i2) {
                            for (int i3 = 0; i3 < this.dim1; ++i3) {
                                dArray[++n] = this.get(i3, i2, k, j, i);
                            }
                        }
                    }
                }
            }
        }
        return Double5D.wrap(dArray, this.getShape());
    }

    @Override
    public Long5D copy() {
        return new FlatLong5D(this.flatten(true), this.shape);
    }

    @Override
    public void assign(ShapedArray shapedArray) {
        if (!this.getShape().equals(shapedArray.getShape())) {
            throw new NonConformableArrayException("Source and destination must have the same shape");
        }
        Long5D long5D = shapedArray.getType() == 3 ? (Long5D)shapedArray : (Long5D)shapedArray.toLong();
        if (this.getOrder() == 2 && long5D.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                this.set(i, j, k, i2, i3, long5D.get(i, j, k, i2, i3));
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim5; ++i) {
                for (int j = 0; j < this.dim4; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i4 = 0; i4 < this.dim2; ++i4) {
                            for (int i5 = 0; i5 < this.dim1; ++i5) {
                                this.set(i5, i4, k, j, i, long5D.get(i5, i4, k, j, i));
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void assign(ShapedVector shapedVector) {
        if (!this.getShape().equals(shapedVector.getShape())) {
            throw new NonConformableArrayException("Source and destination must have the same shape");
        }
        int n = -1;
        if (shapedVector.getType() == 5) {
            DoubleShapedVector doubleShapedVector = (DoubleShapedVector)shapedVector;
            for (int i = 0; i < this.dim5; ++i) {
                for (int j = 0; j < this.dim4; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim2; ++i2) {
                            for (int i3 = 0; i3 < this.dim1; ++i3) {
                                this.set(i3, i2, k, j, i, (long)doubleShapedVector.get(++n));
                            }
                        }
                    }
                }
            }
        } else if (shapedVector.getType() == 4) {
            FloatShapedVector floatShapedVector = (FloatShapedVector)shapedVector;
            for (int i = 0; i < this.dim5; ++i) {
                for (int j = 0; j < this.dim4; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i4 = 0; i4 < this.dim2; ++i4) {
                            for (int i5 = 0; i5 < this.dim1; ++i5) {
                                this.set(i5, i4, k, j, i, (long)floatShapedVector.get(++n));
                            }
                        }
                    }
                }
            }
        } else {
            throw new IllegalTypeException();
        }
    }

    @Override
    public Long5D create() {
        return new FlatLong5D(this.getShape());
    }

    public static Long5D create(int n, int n2, int n3, int n4, int n5) {
        return new FlatLong5D(n, n2, n3, n4, n5);
    }

    public static Long5D create(int[] nArray) {
        return new FlatLong5D(nArray);
    }

    public static Long5D create(Shape shape) {
        return new FlatLong5D(shape);
    }

    public static Long5D wrap(long[] lArray, int n, int n2, int n3, int n4, int n5) {
        return new FlatLong5D(lArray, n, n2, n3, n4, n5);
    }

    public static Long5D wrap(long[] lArray, int[] nArray) {
        return new FlatLong5D(lArray, nArray);
    }

    public static Long5D wrap(long[] lArray, Shape shape) {
        return new FlatLong5D(lArray, shape);
    }

    public static Long5D wrap(long[] lArray, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11) {
        return new StriddenLong5D(lArray, n, n2, n3, n4, n5, n6, n7, n8, n9, n10, n11);
    }

    @Override
    public abstract Long4D slice(int var1);

    @Override
    public abstract Long4D slice(int var1, int var2);

    @Override
    public abstract Long5D view(Range var1, Range var2, Range var3, Range var4, Range var5);

    @Override
    public abstract Long5D view(int[] var1, int[] var2, int[] var3, int[] var4, int[] var5);

    @Override
    public abstract Long1D as1D();
}

