/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array;

import mitiv.array.Array7D;
import mitiv.array.Byte7D;
import mitiv.array.Double7D;
import mitiv.array.Float7D;
import mitiv.array.Int7D;
import mitiv.array.Long1D;
import mitiv.array.Long6D;
import mitiv.array.LongArray;
import mitiv.array.ShapedArray;
import mitiv.array.Short7D;
import mitiv.array.impl.FlatLong7D;
import mitiv.array.impl.StriddenLong7D;
import mitiv.base.Shape;
import mitiv.base.indexing.Range;
import mitiv.base.mapping.LongFunction;
import mitiv.base.mapping.LongScanner;
import mitiv.exception.IllegalTypeException;
import mitiv.exception.NonConformableArrayException;
import mitiv.linalg.shaped.DoubleShapedVector;
import mitiv.linalg.shaped.FloatShapedVector;
import mitiv.linalg.shaped.ShapedVector;
import mitiv.random.LongGenerator;

public abstract class Long7D
extends Array7D
implements LongArray {
    protected Long7D(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        super(n, n2, n3, n4, n5, n6, n7);
    }

    protected Long7D(int[] nArray) {
        super(nArray);
    }

    protected Long7D(Shape shape) {
        super(shape);
    }

    @Override
    public final int getType() {
        return 3;
    }

    public abstract long get(int var1, int var2, int var3, int var4, int var5, int var6, int var7);

    public abstract void set(int var1, int var2, int var3, int var4, int var5, int var6, int var7, long var8);

    @Override
    public void fill(long l) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    for (int i5 = 0; i5 < this.dim7; ++i5) {
                                        this.set(i, j, k, i2, i3, i4, i5, l);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim7; ++i) {
                for (int j = 0; j < this.dim6; ++j) {
                    for (int k = 0; k < this.dim5; ++k) {
                        for (int i6 = 0; i6 < this.dim4; ++i6) {
                            for (int i7 = 0; i7 < this.dim3; ++i7) {
                                for (int i8 = 0; i8 < this.dim2; ++i8) {
                                    for (int i9 = 0; i9 < this.dim1; ++i9) {
                                        this.set(i9, i8, i7, i6, k, j, i, l);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void increment(long l) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    for (int i5 = 0; i5 < this.dim7; ++i5) {
                                        this.set(i, j, k, i2, i3, i4, i5, this.get(i, j, k, i2, i3, i4, i5) + l);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim7; ++i) {
                for (int j = 0; j < this.dim6; ++j) {
                    for (int k = 0; k < this.dim5; ++k) {
                        for (int i6 = 0; i6 < this.dim4; ++i6) {
                            for (int i7 = 0; i7 < this.dim3; ++i7) {
                                for (int i8 = 0; i8 < this.dim2; ++i8) {
                                    for (int i9 = 0; i9 < this.dim1; ++i9) {
                                        this.set(i9, i8, i7, i6, k, j, i, this.get(i9, i8, i7, i6, k, j, i) + l);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void decrement(long l) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    for (int i5 = 0; i5 < this.dim7; ++i5) {
                                        this.set(i, j, k, i2, i3, i4, i5, this.get(i, j, k, i2, i3, i4, i5) - l);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim7; ++i) {
                for (int j = 0; j < this.dim6; ++j) {
                    for (int k = 0; k < this.dim5; ++k) {
                        for (int i6 = 0; i6 < this.dim4; ++i6) {
                            for (int i7 = 0; i7 < this.dim3; ++i7) {
                                for (int i8 = 0; i8 < this.dim2; ++i8) {
                                    for (int i9 = 0; i9 < this.dim1; ++i9) {
                                        this.set(i9, i8, i7, i6, k, j, i, this.get(i9, i8, i7, i6, k, j, i) - l);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void scale(long l) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    for (int i5 = 0; i5 < this.dim7; ++i5) {
                                        this.set(i, j, k, i2, i3, i4, i5, this.get(i, j, k, i2, i3, i4, i5) * l);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim7; ++i) {
                for (int j = 0; j < this.dim6; ++j) {
                    for (int k = 0; k < this.dim5; ++k) {
                        for (int i6 = 0; i6 < this.dim4; ++i6) {
                            for (int i7 = 0; i7 < this.dim3; ++i7) {
                                for (int i8 = 0; i8 < this.dim2; ++i8) {
                                    for (int i9 = 0; i9 < this.dim1; ++i9) {
                                        this.set(i9, i8, i7, i6, k, j, i, this.get(i9, i8, i7, i6, k, j, i) * l);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void map(LongFunction longFunction) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    for (int i5 = 0; i5 < this.dim7; ++i5) {
                                        this.set(i, j, k, i2, i3, i4, i5, longFunction.apply(this.get(i, j, k, i2, i3, i4, i5)));
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim7; ++i) {
                for (int j = 0; j < this.dim6; ++j) {
                    for (int k = 0; k < this.dim5; ++k) {
                        for (int i6 = 0; i6 < this.dim4; ++i6) {
                            for (int i7 = 0; i7 < this.dim3; ++i7) {
                                for (int i8 = 0; i8 < this.dim2; ++i8) {
                                    for (int i9 = 0; i9 < this.dim1; ++i9) {
                                        this.set(i9, i8, i7, i6, k, j, i, longFunction.apply(this.get(i9, i8, i7, i6, k, j, i)));
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void fill(LongGenerator longGenerator) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    for (int i5 = 0; i5 < this.dim7; ++i5) {
                                        this.set(i, j, k, i2, i3, i4, i5, longGenerator.nextLong());
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim7; ++i) {
                for (int j = 0; j < this.dim6; ++j) {
                    for (int k = 0; k < this.dim5; ++k) {
                        for (int i6 = 0; i6 < this.dim4; ++i6) {
                            for (int i7 = 0; i7 < this.dim3; ++i7) {
                                for (int i8 = 0; i8 < this.dim2; ++i8) {
                                    for (int i9 = 0; i9 < this.dim1; ++i9) {
                                        this.set(i9, i8, i7, i6, k, j, i, longGenerator.nextLong());
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void scan(LongScanner longScanner) {
        boolean bl = false;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    for (int i5 = 0; i5 < this.dim7; ++i5) {
                                        if (bl) {
                                            longScanner.update(this.get(i, j, k, i2, i3, i4, i5));
                                            continue;
                                        }
                                        longScanner.initialize(this.get(i, j, k, i2, i3, i4, i5));
                                        bl = true;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim7; ++i) {
                for (int j = 0; j < this.dim6; ++j) {
                    for (int k = 0; k < this.dim5; ++k) {
                        for (int i6 = 0; i6 < this.dim4; ++i6) {
                            for (int i7 = 0; i7 < this.dim3; ++i7) {
                                for (int i8 = 0; i8 < this.dim2; ++i8) {
                                    for (int i9 = 0; i9 < this.dim1; ++i9) {
                                        if (bl) {
                                            longScanner.update(this.get(i9, i8, i7, i6, k, j, i));
                                            continue;
                                        }
                                        longScanner.initialize(this.get(i9, i8, i7, i6, k, j, i));
                                        bl = true;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public final long[] flatten() {
        return this.flatten(false);
    }

    @Override
    public long min() {
        long l = this.get(0, 0, 0, 0, 0, 0, 0);
        boolean bl = true;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    for (int i5 = 0; i5 < this.dim7; ++i5) {
                                        if (bl) {
                                            bl = false;
                                            continue;
                                        }
                                        long l2 = this.get(i, j, k, i2, i3, i4, i5);
                                        if (l2 >= l) continue;
                                        l = l2;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim7; ++i) {
                for (int j = 0; j < this.dim6; ++j) {
                    for (int k = 0; k < this.dim5; ++k) {
                        for (int i6 = 0; i6 < this.dim4; ++i6) {
                            for (int i7 = 0; i7 < this.dim3; ++i7) {
                                for (int i8 = 0; i8 < this.dim2; ++i8) {
                                    for (int i9 = 0; i9 < this.dim1; ++i9) {
                                        if (bl) {
                                            bl = false;
                                            continue;
                                        }
                                        long l3 = this.get(i9, i8, i7, i6, k, j, i);
                                        if (l3 >= l) continue;
                                        l = l3;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return l;
    }

    @Override
    public long max() {
        long l = this.get(0, 0, 0, 0, 0, 0, 0);
        boolean bl = true;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    for (int i5 = 0; i5 < this.dim7; ++i5) {
                                        if (bl) {
                                            bl = false;
                                            continue;
                                        }
                                        long l2 = this.get(i, j, k, i2, i3, i4, i5);
                                        if (l2 <= l) continue;
                                        l = l2;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim7; ++i) {
                for (int j = 0; j < this.dim6; ++j) {
                    for (int k = 0; k < this.dim5; ++k) {
                        for (int i6 = 0; i6 < this.dim4; ++i6) {
                            for (int i7 = 0; i7 < this.dim3; ++i7) {
                                for (int i8 = 0; i8 < this.dim2; ++i8) {
                                    for (int i9 = 0; i9 < this.dim1; ++i9) {
                                        if (bl) {
                                            bl = false;
                                            continue;
                                        }
                                        long l3 = this.get(i9, i8, i7, i6, k, j, i);
                                        if (l3 <= l) continue;
                                        l = l3;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return l;
    }

    @Override
    public long[] getMinAndMax() {
        long[] lArray = new long[2];
        this.getMinAndMax(lArray);
        return lArray;
    }

    @Override
    public void getMinAndMax(long[] lArray) {
        long l;
        long l2 = l = this.get(0, 0, 0, 0, 0, 0, 0);
        boolean bl = true;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    for (int i5 = 0; i5 < this.dim7; ++i5) {
                                        if (bl) {
                                            bl = false;
                                            continue;
                                        }
                                        long l3 = this.get(i, j, k, i2, i3, i4, i5);
                                        if (l3 < l) {
                                            l = l3;
                                        }
                                        if (l3 <= l2) continue;
                                        l2 = l3;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim7; ++i) {
                for (int j = 0; j < this.dim6; ++j) {
                    for (int k = 0; k < this.dim5; ++k) {
                        for (int i6 = 0; i6 < this.dim4; ++i6) {
                            for (int i7 = 0; i7 < this.dim3; ++i7) {
                                for (int i8 = 0; i8 < this.dim2; ++i8) {
                                    for (int i9 = 0; i9 < this.dim1; ++i9) {
                                        if (bl) {
                                            bl = false;
                                            continue;
                                        }
                                        long l4 = this.get(i9, i8, i7, i6, k, j, i);
                                        if (l4 < l) {
                                            l = l4;
                                        }
                                        if (l4 <= l2) continue;
                                        l2 = l4;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        lArray[0] = l;
        lArray[1] = l2;
    }

    @Override
    public long sum() {
        long l = 0L;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    for (int i5 = 0; i5 < this.dim7; ++i5) {
                                        l += this.get(i, j, k, i2, i3, i4, i5);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim7; ++i) {
                for (int j = 0; j < this.dim6; ++j) {
                    for (int k = 0; k < this.dim5; ++k) {
                        for (int i6 = 0; i6 < this.dim4; ++i6) {
                            for (int i7 = 0; i7 < this.dim3; ++i7) {
                                for (int i8 = 0; i8 < this.dim2; ++i8) {
                                    for (int i9 = 0; i9 < this.dim1; ++i9) {
                                        l += this.get(i9, i8, i7, i6, k, j, i);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return l;
    }

    @Override
    public double average() {
        return (double)this.sum() / (double)this.number;
    }

    @Override
    public Byte7D toByte() {
        byte[] byArray = new byte[this.number];
        if (this.isFlat()) {
            long[] lArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                byArray[i] = (byte)lArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim7; ++i) {
                for (int j = 0; j < this.dim6; ++j) {
                    for (int k = 0; k < this.dim5; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim3; ++i3) {
                                for (int i4 = 0; i4 < this.dim2; ++i4) {
                                    for (int i5 = 0; i5 < this.dim1; ++i5) {
                                        byArray[++n] = (byte)this.get(i5, i4, i3, i2, k, j, i);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return Byte7D.wrap(byArray, this.getShape());
    }

    @Override
    public Short7D toShort() {
        short[] sArray = new short[this.number];
        if (this.isFlat()) {
            long[] lArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                sArray[i] = (short)lArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim7; ++i) {
                for (int j = 0; j < this.dim6; ++j) {
                    for (int k = 0; k < this.dim5; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim3; ++i3) {
                                for (int i4 = 0; i4 < this.dim2; ++i4) {
                                    for (int i5 = 0; i5 < this.dim1; ++i5) {
                                        sArray[++n] = (short)this.get(i5, i4, i3, i2, k, j, i);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return Short7D.wrap(sArray, this.getShape());
    }

    @Override
    public Int7D toInt() {
        int[] nArray = new int[this.number];
        if (this.isFlat()) {
            long[] lArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                nArray[i] = (int)lArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim7; ++i) {
                for (int j = 0; j < this.dim6; ++j) {
                    for (int k = 0; k < this.dim5; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim3; ++i3) {
                                for (int i4 = 0; i4 < this.dim2; ++i4) {
                                    for (int i5 = 0; i5 < this.dim1; ++i5) {
                                        nArray[++n] = (int)this.get(i5, i4, i3, i2, k, j, i);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return Int7D.wrap(nArray, this.getShape());
    }

    @Override
    public Long7D toLong() {
        return this;
    }

    @Override
    public Float7D toFloat() {
        float[] fArray = new float[this.number];
        if (this.isFlat()) {
            long[] lArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                fArray[i] = lArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim7; ++i) {
                for (int j = 0; j < this.dim6; ++j) {
                    for (int k = 0; k < this.dim5; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim3; ++i3) {
                                for (int i4 = 0; i4 < this.dim2; ++i4) {
                                    for (int i5 = 0; i5 < this.dim1; ++i5) {
                                        fArray[++n] = this.get(i5, i4, i3, i2, k, j, i);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return Float7D.wrap(fArray, this.getShape());
    }

    @Override
    public Double7D toDouble() {
        double[] dArray = new double[this.number];
        if (this.isFlat()) {
            long[] lArray = this.getData();
            for (int i = 0; i < this.number; ++i) {
                dArray[i] = lArray[i];
            }
        } else {
            int n = -1;
            for (int i = 0; i < this.dim7; ++i) {
                for (int j = 0; j < this.dim6; ++j) {
                    for (int k = 0; k < this.dim5; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim3; ++i3) {
                                for (int i4 = 0; i4 < this.dim2; ++i4) {
                                    for (int i5 = 0; i5 < this.dim1; ++i5) {
                                        dArray[++n] = this.get(i5, i4, i3, i2, k, j, i);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return Double7D.wrap(dArray, this.getShape());
    }

    @Override
    public Long7D copy() {
        return new FlatLong7D(this.flatten(true), this.shape);
    }

    @Override
    public void assign(ShapedArray shapedArray) {
        if (!this.getShape().equals(shapedArray.getShape())) {
            throw new NonConformableArrayException("Source and destination must have the same shape");
        }
        Long7D long7D = shapedArray.getType() == 3 ? (Long7D)shapedArray : (Long7D)shapedArray.toLong();
        if (this.getOrder() == 2 && long7D.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                for (int j = 0; j < this.dim2; ++j) {
                    for (int k = 0; k < this.dim3; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim5; ++i3) {
                                for (int i4 = 0; i4 < this.dim6; ++i4) {
                                    for (int i5 = 0; i5 < this.dim7; ++i5) {
                                        this.set(i, j, k, i2, i3, i4, i5, long7D.get(i, j, k, i2, i3, i4, i5));
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < this.dim7; ++i) {
                for (int j = 0; j < this.dim6; ++j) {
                    for (int k = 0; k < this.dim5; ++k) {
                        for (int i6 = 0; i6 < this.dim4; ++i6) {
                            for (int i7 = 0; i7 < this.dim3; ++i7) {
                                for (int i8 = 0; i8 < this.dim2; ++i8) {
                                    for (int i9 = 0; i9 < this.dim1; ++i9) {
                                        this.set(i9, i8, i7, i6, k, j, i, long7D.get(i9, i8, i7, i6, k, j, i));
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void assign(ShapedVector shapedVector) {
        if (!this.getShape().equals(shapedVector.getShape())) {
            throw new NonConformableArrayException("Source and destination must have the same shape");
        }
        int n = -1;
        if (shapedVector.getType() == 5) {
            DoubleShapedVector doubleShapedVector = (DoubleShapedVector)shapedVector;
            for (int i = 0; i < this.dim7; ++i) {
                for (int j = 0; j < this.dim6; ++j) {
                    for (int k = 0; k < this.dim5; ++k) {
                        for (int i2 = 0; i2 < this.dim4; ++i2) {
                            for (int i3 = 0; i3 < this.dim3; ++i3) {
                                for (int i4 = 0; i4 < this.dim2; ++i4) {
                                    for (int i5 = 0; i5 < this.dim1; ++i5) {
                                        this.set(i5, i4, i3, i2, k, j, i, (long)doubleShapedVector.get(++n));
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else if (shapedVector.getType() == 4) {
            FloatShapedVector floatShapedVector = (FloatShapedVector)shapedVector;
            for (int i = 0; i < this.dim7; ++i) {
                for (int j = 0; j < this.dim6; ++j) {
                    for (int k = 0; k < this.dim5; ++k) {
                        for (int i6 = 0; i6 < this.dim4; ++i6) {
                            for (int i7 = 0; i7 < this.dim3; ++i7) {
                                for (int i8 = 0; i8 < this.dim2; ++i8) {
                                    for (int i9 = 0; i9 < this.dim1; ++i9) {
                                        this.set(i9, i8, i7, i6, k, j, i, (long)floatShapedVector.get(++n));
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            throw new IllegalTypeException();
        }
    }

    @Override
    public Long7D create() {
        return new FlatLong7D(this.getShape());
    }

    public static Long7D create(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        return new FlatLong7D(n, n2, n3, n4, n5, n6, n7);
    }

    public static Long7D create(int[] nArray) {
        return new FlatLong7D(nArray);
    }

    public static Long7D create(Shape shape) {
        return new FlatLong7D(shape);
    }

    public static Long7D wrap(long[] lArray, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        return new FlatLong7D(lArray, n, n2, n3, n4, n5, n6, n7);
    }

    public static Long7D wrap(long[] lArray, int[] nArray) {
        return new FlatLong7D(lArray, nArray);
    }

    public static Long7D wrap(long[] lArray, Shape shape) {
        return new FlatLong7D(lArray, shape);
    }

    public static Long7D wrap(long[] lArray, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13, int n14, int n15) {
        return new StriddenLong7D(lArray, n, n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, n12, n13, n14, n15);
    }

    @Override
    public abstract Long6D slice(int var1);

    @Override
    public abstract Long6D slice(int var1, int var2);

    @Override
    public abstract Long7D view(Range var1, Range var2, Range var3, Range var4, Range var5, Range var6, Range var7);

    @Override
    public abstract Long7D view(int[] var1, int[] var2, int[] var3, int[] var4, int[] var5, int[] var6, int[] var7);

    @Override
    public abstract Long1D as1D();
}

