/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array;

import mitiv.array.Float3D;
import mitiv.random.MersenneTwisterGenerator;
import mitiv.random.NormalDistribution;

public class TestArray {
    public static void main(String[] stringArray) {
        float[] fArray = new float[24583706];
        float[][][] fArray2 = new float[203][302][401];
        Float3D float3D = Float3D.wrap(fArray, 401, 302, 203);
        NormalDistribution normalDistribution = new NormalDistribution(new MersenneTwisterGenerator(7864), -1.0, 1.0);
        normalDistribution.nextFloat();
        System.out.println("dimensions: 401x302x203");
        System.out.println("number of elements: 24583706");
        for (int i = 1; i <= 20; ++i) {
            int n;
            int n2;
            int n3;
            System.out.println();
            System.out.println("loop #" + i);
            long l = System.currentTimeMillis();
            for (n3 = 0; n3 < 24583706; ++n3) {
                fArray[n3] = n3;
            }
            long l2 = System.currentTimeMillis();
            System.out.println("direct filling of flat array: " + (l2 - l) + " ms");
            l = System.currentTimeMillis();
            for (n3 = 0; n3 < 203; ++n3) {
                for (n2 = 0; n2 < 302; ++n2) {
                    for (n = 0; n < 401; ++n) {
                        fArray2[n3][n2][n] = n + 401 * (n2 + 302 * n3);
                    }
                }
            }
            l2 = System.currentTimeMillis();
            System.out.println("direct filling of cube array: " + (l2 - l) + " ms");
            l = System.currentTimeMillis();
            for (n3 = 0; n3 < 401; ++n3) {
                for (n2 = 0; n2 < 302; ++n2) {
                    for (n = 0; n < 203; ++n) {
                        fArray2[n][n2][n3] = n3 + 401 * (n2 + 302 * n);
                    }
                }
            }
            l2 = System.currentTimeMillis();
            System.out.println("direct filling of cube array in wrong order: " + (l2 - l) + " ms");
            l = System.currentTimeMillis();
            float3D.fill(1.0f);
            l2 = System.currentTimeMillis();
            System.out.println("filling of flat array: " + (l2 - l) + " ms");
            l = System.currentTimeMillis();
            float3D.fill(normalDistribution);
            l2 = System.currentTimeMillis();
            System.out.println("random fill of flat array: " + (l2 - l) + " ms");
        }
    }
}

