/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array.impl;

import mitiv.array.Double1D;
import mitiv.array.DoubleScalar;
import mitiv.array.impl.Helper;
import mitiv.array.impl.SelectedDouble1D;
import mitiv.array.impl.StriddenDouble1D;
import mitiv.base.Shape;
import mitiv.base.indexing.CompiledRange;
import mitiv.base.indexing.Range;
import mitiv.base.mapping.DoubleFunction;
import mitiv.base.mapping.DoubleScanner;
import mitiv.exception.NonConformableArrayException;
import mitiv.random.DoubleGenerator;

public class FlatDouble1D
extends Double1D {
    static final int order = 1;
    final double[] data;

    public FlatDouble1D(int n) {
        super(n);
        this.data = new double[this.number];
    }

    public FlatDouble1D(int[] nArray) {
        super(nArray);
        this.data = new double[this.number];
    }

    public FlatDouble1D(Shape shape) {
        super(shape);
        this.data = new double[this.number];
    }

    public FlatDouble1D(double[] dArray, int n) {
        super(n);
        this.checkSize(dArray);
        this.data = dArray;
    }

    public FlatDouble1D(double[] dArray, int[] nArray) {
        super(nArray);
        this.checkSize(dArray);
        this.data = dArray;
    }

    public FlatDouble1D(double[] dArray, Shape shape) {
        super(shape);
        this.checkSize(dArray);
        this.data = dArray;
    }

    @Override
    public void checkSanity() {
        if (this.data == null) {
            throw new NonConformableArrayException("Wrapped array is null");
        }
        if (this.data.length < this.number) {
            throw new NonConformableArrayException("Wrapped array is too small");
        }
    }

    private void checkSize(double[] dArray) {
        if (dArray == null || dArray.length < this.number) {
            throw new NonConformableArrayException("Wrapped array is too small");
        }
    }

    final int index(int n) {
        return n;
    }

    @Override
    public final double get(int n) {
        return this.data[n];
    }

    @Override
    public final void set(int n, double d) {
        this.data[n] = d;
    }

    @Override
    public final int getOrder() {
        return 1;
    }

    @Override
    public void fill(double d) {
        for (int i = 0; i < this.number; ++i) {
            this.data[i] = d;
        }
    }

    @Override
    public void fill(DoubleGenerator doubleGenerator) {
        for (int i = 0; i < this.number; ++i) {
            this.data[i] = doubleGenerator.nextDouble();
        }
    }

    @Override
    public void increment(double d) {
        int n = 0;
        while (n < this.number) {
            int n2 = n++;
            this.data[n2] = this.data[n2] + d;
        }
    }

    @Override
    public void decrement(double d) {
        int n = 0;
        while (n < this.number) {
            int n2 = n++;
            this.data[n2] = this.data[n2] - d;
        }
    }

    @Override
    public void scale(double d) {
        int n = 0;
        while (n < this.number) {
            int n2 = n++;
            this.data[n2] = this.data[n2] * d;
        }
    }

    @Override
    public void map(DoubleFunction doubleFunction) {
        for (int i = 0; i < this.number; ++i) {
            this.data[i] = doubleFunction.apply(this.data[i]);
        }
    }

    @Override
    public void scan(DoubleScanner doubleScanner) {
        doubleScanner.initialize(this.data[0]);
        for (int i = 1; i < this.number; ++i) {
            doubleScanner.update(this.data[i]);
        }
    }

    @Override
    public final boolean isFlat() {
        return true;
    }

    @Override
    public double[] flatten(boolean bl) {
        if (bl) {
            double[] dArray = new double[this.number];
            System.arraycopy(this.data, 0, dArray, 0, this.number);
            return dArray;
        }
        return this.data;
    }

    @Override
    public double[] getData() {
        return this.data;
    }

    @Override
    public DoubleScalar slice(int n) {
        n = Helper.fixIndex(n, this.dim1);
        return new DoubleScalar(this.data, n);
    }

    @Override
    public DoubleScalar slice(int n, int n2) {
        Helper.fixSliceIndex(n2, 1);
        return new DoubleScalar(this.data, Helper.fixIndex(n, this.dim1));
    }

    @Override
    public Double1D view(Range range) {
        CompiledRange compiledRange = new CompiledRange(range, this.dim1, 0, 1);
        if (compiledRange.doesNothing()) {
            return this;
        }
        return new StriddenDouble1D(this.data, compiledRange.getOffset(), compiledRange.getStride(), compiledRange.getNumber());
    }

    @Override
    public Double1D view(int[] nArray) {
        int[] nArray2 = Helper.select(0, 1, this.dim1, nArray);
        return new SelectedDouble1D(this.data, nArray2);
    }

    @Override
    public Double1D as1D() {
        return this;
    }
}

