/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array.impl;

import mitiv.array.Short1D;
import mitiv.array.Short2D;
import mitiv.array.impl.FlatShort1D;
import mitiv.array.impl.Helper;
import mitiv.array.impl.SelectedShort2D;
import mitiv.array.impl.StriddenShort1D;
import mitiv.array.impl.StriddenShort2D;
import mitiv.base.Shape;
import mitiv.base.indexing.CompiledRange;
import mitiv.base.indexing.Range;
import mitiv.base.mapping.ShortFunction;
import mitiv.base.mapping.ShortScanner;
import mitiv.exception.NonConformableArrayException;
import mitiv.random.ShortGenerator;

public class FlatShort2D
extends Short2D {
    static final int order = 1;
    final short[] data;

    public FlatShort2D(int n, int n2) {
        super(n, n2);
        this.data = new short[this.number];
    }

    public FlatShort2D(int[] nArray) {
        super(nArray);
        this.data = new short[this.number];
    }

    public FlatShort2D(Shape shape) {
        super(shape);
        this.data = new short[this.number];
    }

    public FlatShort2D(short[] sArray, int n, int n2) {
        super(n, n2);
        this.checkSize(sArray);
        this.data = sArray;
    }

    public FlatShort2D(short[] sArray, int[] nArray) {
        super(nArray);
        this.checkSize(sArray);
        this.data = sArray;
    }

    public FlatShort2D(short[] sArray, Shape shape) {
        super(shape);
        this.checkSize(sArray);
        this.data = sArray;
    }

    @Override
    public void checkSanity() {
        if (this.data == null) {
            throw new NonConformableArrayException("Wrapped array is null");
        }
        if (this.data.length < this.number) {
            throw new NonConformableArrayException("Wrapped array is too small");
        }
    }

    private void checkSize(short[] sArray) {
        if (sArray == null || sArray.length < this.number) {
            throw new NonConformableArrayException("Wrapped array is too small");
        }
    }

    final int index(int n, int n2) {
        return this.dim1 * n2 + n;
    }

    @Override
    public final short get(int n, int n2) {
        return this.data[this.dim1 * n2 + n];
    }

    @Override
    public final void set(int n, int n2, short s) {
        this.data[this.dim1 * n2 + n] = s;
    }

    @Override
    public final int getOrder() {
        return 1;
    }

    @Override
    public void fill(short s) {
        for (int i = 0; i < this.number; ++i) {
            this.data[i] = s;
        }
    }

    @Override
    public void fill(ShortGenerator shortGenerator) {
        for (int i = 0; i < this.number; ++i) {
            this.data[i] = shortGenerator.nextShort();
        }
    }

    @Override
    public void increment(short s) {
        int n = 0;
        while (n < this.number) {
            int n2 = n++;
            this.data[n2] = (short)(this.data[n2] + s);
        }
    }

    @Override
    public void decrement(short s) {
        int n = 0;
        while (n < this.number) {
            int n2 = n++;
            this.data[n2] = (short)(this.data[n2] - s);
        }
    }

    @Override
    public void scale(short s) {
        int n = 0;
        while (n < this.number) {
            int n2 = n++;
            this.data[n2] = (short)(this.data[n2] * s);
        }
    }

    @Override
    public void map(ShortFunction shortFunction) {
        for (int i = 0; i < this.number; ++i) {
            this.data[i] = shortFunction.apply(this.data[i]);
        }
    }

    @Override
    public void scan(ShortScanner shortScanner) {
        shortScanner.initialize(this.data[0]);
        for (int i = 1; i < this.number; ++i) {
            shortScanner.update(this.data[i]);
        }
    }

    @Override
    public final boolean isFlat() {
        return true;
    }

    @Override
    public short[] flatten(boolean bl) {
        if (bl) {
            short[] sArray = new short[this.number];
            System.arraycopy(this.data, 0, sArray, 0, this.number);
            return sArray;
        }
        return this.data;
    }

    @Override
    public short[] getData() {
        return this.data;
    }

    @Override
    public Short1D slice(int n) {
        if ((n = Helper.fixIndex(n, this.dim2)) == 0) {
            return new FlatShort1D(this.data, this.dim1);
        }
        return new StriddenShort1D(this.data, this.dim1 * n, 1, this.dim1);
    }

    @Override
    public Short1D slice(int n, int n2) {
        int n3;
        int n4;
        int n5;
        if ((n2 = Helper.fixSliceIndex(n2, 2)) == 0) {
            n5 = Helper.fixIndex(n, this.dim1);
            n4 = this.dim1;
            n3 = this.dim2;
        } else {
            n5 = this.dim1 * Helper.fixIndex(n, this.dim2);
            n4 = 1;
            n3 = this.dim1;
        }
        return new StriddenShort1D(this.data, n5, n4, n3);
    }

    @Override
    public Short2D view(Range range, Range range2) {
        CompiledRange compiledRange = new CompiledRange(range, this.dim1, 0, 1);
        CompiledRange compiledRange2 = new CompiledRange(range2, this.dim2, 0, this.dim1);
        if (compiledRange.doesNothing() && compiledRange2.doesNothing()) {
            return this;
        }
        return new StriddenShort2D(this.data, compiledRange.getOffset() + compiledRange2.getOffset(), compiledRange.getStride(), compiledRange2.getStride(), compiledRange.getNumber(), compiledRange2.getNumber());
    }

    @Override
    public Short2D view(int[] nArray, int[] nArray2) {
        int[] nArray3 = Helper.select(0, 1, this.dim1, nArray);
        int[] nArray4 = Helper.select(0, this.dim1, this.dim2, nArray2);
        return new SelectedShort2D(this.data, nArray3, nArray4);
    }

    @Override
    public Short1D as1D() {
        return new FlatShort1D(this.data, this.number);
    }
}

