/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array.impl;

import mitiv.array.Double1D;
import mitiv.array.Double2D;
import mitiv.array.impl.Helper;
import mitiv.array.impl.SelectedDouble1D;
import mitiv.base.indexing.Range;
import mitiv.base.mapping.DoubleFunction;
import mitiv.base.mapping.DoubleScanner;
import mitiv.random.DoubleGenerator;

public class SelectedDouble2D
extends Double2D {
    static final int order = 0;
    final double[] data;
    final int[] idx1;
    final int[] idx2;

    public SelectedDouble2D(double[] dArray, int[] nArray, int[] nArray2) {
        super(nArray.length, nArray2.length);
        this.data = dArray;
        this.idx1 = nArray;
        this.idx2 = nArray2;
    }

    @Override
    public final void checkSanity() {
        int n;
        int n2;
        int n3;
        int n4 = 0;
        int n5 = 0;
        int n6 = n3 = this.idx1[0];
        for (n2 = 1; n2 < this.dim1; ++n2) {
            n = this.idx1[n2];
            if (n < n6) {
                n6 = n;
            }
            if (n <= n3) continue;
            n3 = n;
        }
        n4 += n6;
        n5 += n3;
        n6 = n3 = this.idx2[0];
        for (n2 = 1; n2 < this.dim2; ++n2) {
            n = this.idx2[n2];
            if (n < n6) {
                n6 = n;
            }
            if (n <= n3) continue;
            n3 = n;
        }
        if ((n4 += n6) < 0 || (n5 += n3) >= this.data.length) {
            throw new IndexOutOfBoundsException("Selected indices are out of bounds");
        }
    }

    final int index(int n, int n2) {
        return this.idx2[n2] + this.idx1[n];
    }

    @Override
    public final double get(int n, int n2) {
        return this.data[this.idx2[n2] + this.idx1[n]];
    }

    @Override
    public final void set(int n, int n2, double d) {
        this.data[this.idx2[n2] + this.idx1[n]] = d;
    }

    @Override
    public final int getOrder() {
        return 0;
    }

    @Override
    public void fill(double d) {
        for (int i = 0; i < this.dim2; ++i) {
            int n = this.idx2[i];
            for (int j = 0; j < this.dim1; ++j) {
                int n2 = this.idx1[j] + n;
                this.data[n2] = d;
            }
        }
    }

    @Override
    public void fill(DoubleGenerator doubleGenerator) {
        for (int i = 0; i < this.dim2; ++i) {
            int n = this.idx2[i];
            for (int j = 0; j < this.dim1; ++j) {
                int n2 = this.idx1[j] + n;
                this.data[n2] = doubleGenerator.nextDouble();
            }
        }
    }

    @Override
    public void increment(double d) {
        for (int i = 0; i < this.dim2; ++i) {
            int n = this.idx2[i];
            for (int j = 0; j < this.dim1; ++j) {
                int n2;
                int n3 = n2 = this.idx1[j] + n;
                this.data[n3] = this.data[n3] + d;
            }
        }
    }

    @Override
    public void decrement(double d) {
        for (int i = 0; i < this.dim2; ++i) {
            int n = this.idx2[i];
            for (int j = 0; j < this.dim1; ++j) {
                int n2;
                int n3 = n2 = this.idx1[j] + n;
                this.data[n3] = this.data[n3] - d;
            }
        }
    }

    @Override
    public void scale(double d) {
        for (int i = 0; i < this.dim2; ++i) {
            int n = this.idx2[i];
            for (int j = 0; j < this.dim1; ++j) {
                int n2;
                int n3 = n2 = this.idx1[j] + n;
                this.data[n3] = this.data[n3] * d;
            }
        }
    }

    @Override
    public void map(DoubleFunction doubleFunction) {
        for (int i = 0; i < this.dim2; ++i) {
            int n = this.idx2[i];
            for (int j = 0; j < this.dim1; ++j) {
                int n2 = this.idx1[j] + n;
                this.data[n2] = doubleFunction.apply(this.data[n2]);
            }
        }
    }

    @Override
    public void scan(DoubleScanner doubleScanner) {
        boolean bl = false;
        for (int i = 0; i < this.dim2; ++i) {
            int n = this.idx2[i];
            for (int j = 0; j < this.dim1; ++j) {
                int n2 = this.idx1[j] + n;
                if (bl) {
                    doubleScanner.update(this.data[n2]);
                    continue;
                }
                doubleScanner.initialize(this.data[n2]);
                bl = true;
            }
        }
    }

    @Override
    public final boolean isFlat() {
        return false;
    }

    @Override
    public double[] flatten(boolean bl) {
        double[] dArray = new double[this.number];
        int n = -1;
        for (int i = 0; i < this.dim2; ++i) {
            int n2 = this.idx2[i];
            for (int j = 0; j < this.dim1; ++j) {
                int n3 = this.idx1[j] + n2;
                dArray[++n] = this.data[n3];
            }
        }
        return dArray;
    }

    @Override
    public double[] getData() {
        return null;
    }

    @Override
    public Double1D slice(int n) {
        int[] nArray;
        int n2 = this.idx2[Helper.fixIndex(n, this.dim2)];
        if (n2 == 0) {
            nArray = this.idx1;
        } else {
            nArray = new int[this.dim1];
            for (int i = 0; i < this.dim1; ++i) {
                nArray[i] = this.idx1[i] + n2;
            }
        }
        return new SelectedDouble1D(this.data, nArray);
    }

    @Override
    public Double1D slice(int n, int n2) {
        int[] nArray;
        int n3;
        if ((n2 = Helper.fixSliceIndex(n2, 2)) == 0) {
            n3 = this.idx1[Helper.fixIndex(n, this.dim1)];
            nArray = this.idx2;
        } else {
            nArray = this.idx1;
            n3 = this.idx2[Helper.fixIndex(n, this.dim2)];
        }
        if (n3 != 0) {
            int n4 = nArray.length;
            int[] nArray2 = new int[n4];
            for (int i = 0; i < n4; ++i) {
                nArray2[i] = n3 + nArray[i];
            }
            nArray = nArray2;
        }
        return new SelectedDouble1D(this.data, nArray);
    }

    @Override
    public Double2D view(Range range, Range range2) {
        int[] nArray = Helper.select(this.idx1, range);
        int[] nArray2 = Helper.select(this.idx2, range2);
        if (nArray == this.idx1 && nArray2 == this.idx2) {
            return this;
        }
        return new SelectedDouble2D(this.data, nArray, nArray2);
    }

    @Override
    public Double2D view(int[] nArray, int[] nArray2) {
        int[] nArray3 = Helper.select(this.idx1, nArray);
        int[] nArray4 = Helper.select(this.idx2, nArray2);
        if (nArray3 == this.idx1 && nArray4 == this.idx2) {
            return this;
        }
        return new SelectedDouble2D(this.data, nArray3, nArray4);
    }

    @Override
    public Double1D as1D() {
        int[] nArray = new int[this.number];
        int n = -1;
        for (int i = 0; i < this.dim2; ++i) {
            int n2 = this.idx2[i];
            for (int j = 0; j < this.dim1; ++j) {
                int n3 = this.idx1[j] + n2;
                nArray[++n] = n3;
            }
        }
        return new SelectedDouble1D(this.data, nArray);
    }
}

