/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array.impl;

import mitiv.array.Float1D;
import mitiv.array.FloatScalar;
import mitiv.array.impl.Helper;
import mitiv.base.indexing.Range;
import mitiv.base.mapping.FloatFunction;
import mitiv.base.mapping.FloatScanner;
import mitiv.random.FloatGenerator;

public class SelectedFloat1D
extends Float1D {
    static final int order = 0;
    final float[] data;
    final int[] idx1;

    public SelectedFloat1D(float[] fArray, int[] nArray) {
        super(nArray.length);
        this.data = fArray;
        this.idx1 = nArray;
    }

    @Override
    public final void checkSanity() {
        int n;
        int n2 = 0;
        int n3 = 0;
        int n4 = n = this.idx1[0];
        for (int i = 1; i < this.dim1; ++i) {
            int n5 = this.idx1[i];
            if (n5 < n4) {
                n4 = n5;
            }
            if (n5 <= n) continue;
            n = n5;
        }
        if ((n2 += n4) < 0 || (n3 += n) >= this.data.length) {
            throw new IndexOutOfBoundsException("Selected indices are out of bounds");
        }
    }

    final int index(int n) {
        return this.idx1[n];
    }

    @Override
    public final float get(int n) {
        return this.data[this.idx1[n]];
    }

    @Override
    public final void set(int n, float f) {
        this.data[this.idx1[n]] = f;
    }

    @Override
    public final int getOrder() {
        return 0;
    }

    @Override
    public void fill(float f) {
        for (int i = 0; i < this.dim1; ++i) {
            int n = this.idx1[i];
            this.data[n] = f;
        }
    }

    @Override
    public void fill(FloatGenerator floatGenerator) {
        for (int i = 0; i < this.dim1; ++i) {
            int n = this.idx1[i];
            this.data[n] = floatGenerator.nextFloat();
        }
    }

    @Override
    public void increment(float f) {
        for (int i = 0; i < this.dim1; ++i) {
            int n;
            int n2 = n = this.idx1[i];
            this.data[n2] = this.data[n2] + f;
        }
    }

    @Override
    public void decrement(float f) {
        for (int i = 0; i < this.dim1; ++i) {
            int n;
            int n2 = n = this.idx1[i];
            this.data[n2] = this.data[n2] - f;
        }
    }

    @Override
    public void scale(float f) {
        for (int i = 0; i < this.dim1; ++i) {
            int n;
            int n2 = n = this.idx1[i];
            this.data[n2] = this.data[n2] * f;
        }
    }

    @Override
    public void map(FloatFunction floatFunction) {
        for (int i = 0; i < this.dim1; ++i) {
            int n = this.idx1[i];
            this.data[n] = floatFunction.apply(this.data[n]);
        }
    }

    @Override
    public void scan(FloatScanner floatScanner) {
        boolean bl = false;
        for (int i = 0; i < this.dim1; ++i) {
            int n = this.idx1[i];
            if (bl) {
                floatScanner.update(this.data[n]);
                continue;
            }
            floatScanner.initialize(this.data[n]);
            bl = true;
        }
    }

    @Override
    public final boolean isFlat() {
        return false;
    }

    @Override
    public float[] flatten(boolean bl) {
        float[] fArray = new float[this.number];
        int n = -1;
        for (int i = 0; i < this.dim1; ++i) {
            int n2 = this.idx1[i];
            fArray[++n] = this.data[n2];
        }
        return fArray;
    }

    @Override
    public float[] getData() {
        return null;
    }

    @Override
    public FloatScalar slice(int n) {
        return new FloatScalar(this.data, this.idx1[Helper.fixIndex(n, this.dim1)]);
    }

    @Override
    public FloatScalar slice(int n, int n2) {
        Helper.fixSliceIndex(n2, 1);
        return new FloatScalar(this.data, Helper.fixIndex(n, this.dim1));
    }

    @Override
    public Float1D view(Range range) {
        int[] nArray = Helper.select(this.idx1, range);
        if (nArray == this.idx1) {
            return this;
        }
        return new SelectedFloat1D(this.data, nArray);
    }

    @Override
    public Float1D view(int[] nArray) {
        int[] nArray2 = Helper.select(this.idx1, nArray);
        if (nArray2 == this.idx1) {
            return this;
        }
        return new SelectedFloat1D(this.data, nArray2);
    }

    @Override
    public Float1D as1D() {
        return this;
    }
}

