/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array.impl;

import mitiv.array.Byte1D;
import mitiv.array.ByteScalar;
import mitiv.array.impl.Helper;
import mitiv.array.impl.SelectedByte1D;
import mitiv.base.indexing.CompiledRange;
import mitiv.base.indexing.Range;
import mitiv.base.mapping.ByteFunction;
import mitiv.base.mapping.ByteScanner;
import mitiv.random.ByteGenerator;

public class StriddenByte1D
extends Byte1D {
    final int order;
    final byte[] data;
    final int offset;
    final int stride1;
    final boolean flat;

    public StriddenByte1D(byte[] byArray, int n, int[] nArray, int[] nArray2) {
        super(nArray2);
        if (nArray.length != 1) {
            throw new IllegalArgumentException("There must be as many strides as the rank");
        }
        this.data = byArray;
        this.offset = n;
        this.stride1 = nArray[0];
        this.order = Byte1D.checkViewStrides(this.data.length, n, this.stride1, this.dim1);
        this.flat = n == 0 && this.stride1 == 1;
    }

    public StriddenByte1D(byte[] byArray, int n, int n2, int n3) {
        super(n3);
        this.data = byArray;
        this.offset = n;
        this.stride1 = n2;
        this.order = Byte1D.checkViewStrides(this.data.length, n, n2, n3);
        this.flat = n == 0 && n2 == 1;
    }

    @Override
    public void checkSanity() {
        Byte1D.checkViewStrides(this.data.length, this.offset, this.stride1, this.dim1);
    }

    final int index(int n) {
        return this.offset + this.stride1 * n;
    }

    @Override
    public final byte get(int n) {
        return this.data[this.offset + this.stride1 * n];
    }

    @Override
    public final void set(int n, byte by) {
        this.data[this.offset + this.stride1 * n] = by;
    }

    @Override
    public final int getOrder() {
        return this.order;
    }

    @Override
    public void fill(byte by) {
        for (int i = 0; i < this.dim1; ++i) {
            int n = this.stride1 * i + this.offset;
            this.data[n] = by;
        }
    }

    @Override
    public void fill(ByteGenerator byteGenerator) {
        for (int i = 0; i < this.dim1; ++i) {
            int n = this.stride1 * i + this.offset;
            this.data[n] = byteGenerator.nextByte();
        }
    }

    @Override
    public void increment(byte by) {
        for (int i = 0; i < this.dim1; ++i) {
            int n;
            int n2 = n = this.stride1 * i + this.offset;
            this.data[n2] = (byte)(this.data[n2] + by);
        }
    }

    @Override
    public void decrement(byte by) {
        for (int i = 0; i < this.dim1; ++i) {
            int n;
            int n2 = n = this.stride1 * i + this.offset;
            this.data[n2] = (byte)(this.data[n2] - by);
        }
    }

    @Override
    public void scale(byte by) {
        for (int i = 0; i < this.dim1; ++i) {
            int n;
            int n2 = n = this.stride1 * i + this.offset;
            this.data[n2] = (byte)(this.data[n2] * by);
        }
    }

    @Override
    public void map(ByteFunction byteFunction) {
        for (int i = 0; i < this.dim1; ++i) {
            int n = this.stride1 * i + this.offset;
            this.data[n] = byteFunction.apply(this.data[n]);
        }
    }

    @Override
    public void scan(ByteScanner byteScanner) {
        boolean bl = false;
        for (int i = 0; i < this.dim1; ++i) {
            int n = this.stride1 * i + this.offset;
            if (bl) {
                byteScanner.update(this.data[n]);
                continue;
            }
            byteScanner.initialize(this.data[n]);
            bl = true;
        }
    }

    @Override
    public final boolean isFlat() {
        return this.flat;
    }

    @Override
    public byte[] flatten(boolean bl) {
        if (!bl && this.flat) {
            return this.data;
        }
        byte[] byArray = new byte[this.number];
        if (this.flat) {
            System.arraycopy(this.data, 0, byArray, 0, this.number);
        } else {
            int n = -1;
            for (int i = 0; i < this.dim1; ++i) {
                int n2 = this.stride1 * i + this.offset;
                byArray[++n] = this.data[n2];
            }
        }
        return byArray;
    }

    @Override
    public byte[] getData() {
        return this.flat ? this.data : null;
    }

    @Override
    public ByteScalar slice(int n) {
        return new ByteScalar(this.data, this.offset + this.stride1 * n);
    }

    @Override
    public ByteScalar slice(int n, int n2) {
        if (n2 < 0) {
            ++n2;
        }
        if (n2 != 0) {
            throw new IndexOutOfBoundsException("Dimension index out of bounds");
        }
        int n3 = this.offset + this.stride1 * n;
        return new ByteScalar(this.data, n3);
    }

    @Override
    public Byte1D view(Range range) {
        CompiledRange compiledRange = new CompiledRange(range, this.dim1, this.offset, this.stride1);
        if (compiledRange.doesNothing()) {
            return this;
        }
        return new StriddenByte1D(this.data, compiledRange.getOffset(), compiledRange.getStride(), compiledRange.getNumber());
    }

    @Override
    public Byte1D view(int[] nArray) {
        int[] nArray2 = Helper.select(this.offset, this.stride1, this.dim1, nArray);
        return new SelectedByte1D(this.data, nArray2);
    }

    @Override
    public Byte1D as1D() {
        return this;
    }
}

