/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array.impl;

import mitiv.array.Float1D;
import mitiv.array.Float2D;
import mitiv.array.impl.FlatFloat1D;
import mitiv.array.impl.Helper;
import mitiv.array.impl.SelectedFloat2D;
import mitiv.array.impl.StriddenFloat1D;
import mitiv.base.indexing.CompiledRange;
import mitiv.base.indexing.Range;
import mitiv.base.mapping.FloatFunction;
import mitiv.base.mapping.FloatScanner;
import mitiv.random.FloatGenerator;

public class StriddenFloat2D
extends Float2D {
    final int order;
    final float[] data;
    final int offset;
    final int stride1;
    final int stride2;
    final boolean flat;

    public StriddenFloat2D(float[] fArray, int n, int[] nArray, int[] nArray2) {
        super(nArray2);
        if (nArray.length != 2) {
            throw new IllegalArgumentException("There must be as many strides as the rank");
        }
        this.data = fArray;
        this.offset = n;
        this.stride1 = nArray[0];
        this.stride2 = nArray[1];
        this.order = Float2D.checkViewStrides(this.data.length, n, this.stride1, this.stride2, this.dim1, this.dim2);
        this.flat = n == 0 && this.stride1 == 1 && this.stride2 == this.dim1;
    }

    public StriddenFloat2D(float[] fArray, int n, int n2, int n3, int n4, int n5) {
        super(n4, n5);
        this.data = fArray;
        this.offset = n;
        this.stride1 = n2;
        this.stride2 = n3;
        this.order = Float2D.checkViewStrides(this.data.length, n, n2, n3, n4, n5);
        this.flat = n == 0 && n2 == 1 && n3 == n4;
    }

    @Override
    public void checkSanity() {
        Float2D.checkViewStrides(this.data.length, this.offset, this.stride1, this.stride2, this.dim1, this.dim2);
    }

    final int index(int n, int n2) {
        return this.offset + this.stride2 * n2 + this.stride1 * n;
    }

    @Override
    public final float get(int n, int n2) {
        return this.data[this.offset + this.stride2 * n2 + this.stride1 * n];
    }

    @Override
    public final void set(int n, int n2, float f) {
        this.data[this.offset + this.stride2 * n2 + this.stride1 * n] = f;
    }

    @Override
    public final int getOrder() {
        return this.order;
    }

    @Override
    public void fill(float f) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                int n = this.stride1 * i + this.offset;
                for (int j = 0; j < this.dim2; ++j) {
                    int n2 = this.stride2 * j + n;
                    this.data[n2] = f;
                }
            }
        } else {
            for (int i = 0; i < this.dim2; ++i) {
                int n = this.stride2 * i + this.offset;
                for (int j = 0; j < this.dim1; ++j) {
                    int n3 = this.stride1 * j + n;
                    this.data[n3] = f;
                }
            }
        }
    }

    @Override
    public void fill(FloatGenerator floatGenerator) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                int n = this.stride1 * i + this.offset;
                for (int j = 0; j < this.dim2; ++j) {
                    int n2 = this.stride2 * j + n;
                    this.data[n2] = floatGenerator.nextFloat();
                }
            }
        } else {
            for (int i = 0; i < this.dim2; ++i) {
                int n = this.stride2 * i + this.offset;
                for (int j = 0; j < this.dim1; ++j) {
                    int n3 = this.stride1 * j + n;
                    this.data[n3] = floatGenerator.nextFloat();
                }
            }
        }
    }

    @Override
    public void increment(float f) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                int n = this.stride1 * i + this.offset;
                for (int j = 0; j < this.dim2; ++j) {
                    int n2;
                    int n3 = n2 = this.stride2 * j + n;
                    this.data[n3] = this.data[n3] + f;
                }
            }
        } else {
            for (int i = 0; i < this.dim2; ++i) {
                int n = this.stride2 * i + this.offset;
                for (int j = 0; j < this.dim1; ++j) {
                    int n4;
                    int n5 = n4 = this.stride1 * j + n;
                    this.data[n5] = this.data[n5] + f;
                }
            }
        }
    }

    @Override
    public void decrement(float f) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                int n = this.stride1 * i + this.offset;
                for (int j = 0; j < this.dim2; ++j) {
                    int n2;
                    int n3 = n2 = this.stride2 * j + n;
                    this.data[n3] = this.data[n3] - f;
                }
            }
        } else {
            for (int i = 0; i < this.dim2; ++i) {
                int n = this.stride2 * i + this.offset;
                for (int j = 0; j < this.dim1; ++j) {
                    int n4;
                    int n5 = n4 = this.stride1 * j + n;
                    this.data[n5] = this.data[n5] - f;
                }
            }
        }
    }

    @Override
    public void scale(float f) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                int n = this.stride1 * i + this.offset;
                for (int j = 0; j < this.dim2; ++j) {
                    int n2;
                    int n3 = n2 = this.stride2 * j + n;
                    this.data[n3] = this.data[n3] * f;
                }
            }
        } else {
            for (int i = 0; i < this.dim2; ++i) {
                int n = this.stride2 * i + this.offset;
                for (int j = 0; j < this.dim1; ++j) {
                    int n4;
                    int n5 = n4 = this.stride1 * j + n;
                    this.data[n5] = this.data[n5] * f;
                }
            }
        }
    }

    @Override
    public void map(FloatFunction floatFunction) {
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                int n = this.stride1 * i + this.offset;
                for (int j = 0; j < this.dim2; ++j) {
                    int n2 = this.stride2 * j + n;
                    this.data[n2] = floatFunction.apply(this.data[n2]);
                }
            }
        } else {
            for (int i = 0; i < this.dim2; ++i) {
                int n = this.stride2 * i + this.offset;
                for (int j = 0; j < this.dim1; ++j) {
                    int n3 = this.stride1 * j + n;
                    this.data[n3] = floatFunction.apply(this.data[n3]);
                }
            }
        }
    }

    @Override
    public void scan(FloatScanner floatScanner) {
        boolean bl = false;
        if (this.getOrder() == 2) {
            for (int i = 0; i < this.dim1; ++i) {
                int n = this.stride1 * i + this.offset;
                for (int j = 0; j < this.dim2; ++j) {
                    int n2 = this.stride2 * j + n;
                    if (bl) {
                        floatScanner.update(this.data[n2]);
                        continue;
                    }
                    floatScanner.initialize(this.data[n2]);
                    bl = true;
                }
            }
        } else {
            for (int i = 0; i < this.dim2; ++i) {
                int n = this.stride2 * i + this.offset;
                for (int j = 0; j < this.dim1; ++j) {
                    int n3 = this.stride1 * j + n;
                    if (bl) {
                        floatScanner.update(this.data[n3]);
                        continue;
                    }
                    floatScanner.initialize(this.data[n3]);
                    bl = true;
                }
            }
        }
    }

    @Override
    public final boolean isFlat() {
        return this.flat;
    }

    @Override
    public float[] flatten(boolean bl) {
        if (!bl && this.flat) {
            return this.data;
        }
        float[] fArray = new float[this.number];
        if (this.flat) {
            System.arraycopy(this.data, 0, fArray, 0, this.number);
        } else {
            int n = -1;
            for (int i = 0; i < this.dim2; ++i) {
                int n2 = this.stride2 * i + this.offset;
                for (int j = 0; j < this.dim1; ++j) {
                    int n3 = this.stride1 * j + n2;
                    fArray[++n] = this.data[n3];
                }
            }
        }
        return fArray;
    }

    @Override
    public float[] getData() {
        return this.flat ? this.data : null;
    }

    @Override
    public Float1D slice(int n) {
        return new StriddenFloat1D(this.data, this.offset + this.stride2 * n, this.stride1, this.dim1);
    }

    @Override
    public Float1D slice(int n, int n2) {
        int n3;
        int n4;
        int n5;
        if (n2 < 0) {
            n2 += 2;
        }
        if (n2 == 0) {
            n5 = this.offset + this.stride1 * n;
            n4 = this.stride2;
            n3 = this.dim2;
        } else if (n2 == 1) {
            n5 = this.offset + this.stride2 * n;
            n4 = this.stride1;
            n3 = this.dim1;
        } else {
            throw new IndexOutOfBoundsException("Dimension index out of bounds");
        }
        return new StriddenFloat1D(this.data, n5, n4, n3);
    }

    @Override
    public Float2D view(Range range, Range range2) {
        CompiledRange compiledRange = new CompiledRange(range, this.dim1, this.offset, this.stride1);
        CompiledRange compiledRange2 = new CompiledRange(range2, this.dim2, 0, this.stride2);
        if (compiledRange.doesNothing() && compiledRange2.doesNothing()) {
            return this;
        }
        return new StriddenFloat2D(this.data, compiledRange.getOffset() + compiledRange2.getOffset(), compiledRange.getStride(), compiledRange2.getStride(), compiledRange.getNumber(), compiledRange2.getNumber());
    }

    @Override
    public Float2D view(int[] nArray, int[] nArray2) {
        int[] nArray3 = Helper.select(this.offset, this.stride1, this.dim1, nArray);
        int[] nArray4 = Helper.select(0, this.stride2, this.dim2, nArray2);
        return new SelectedFloat2D(this.data, nArray3, nArray4);
    }

    @Override
    public Float1D as1D() {
        return new FlatFloat1D(this.flatten(), this.number);
    }
}

