/*
 * Decompiled with CFR 0.152.
 */
package mitiv.cost;

import mitiv.base.mapping.DifferentiableMapping;
import mitiv.cost.DifferentiableCostFunction;
import mitiv.cost.GaussianLikelihood;
import mitiv.cost.WeightedData;
import mitiv.linalg.Vector;
import mitiv.linalg.shaped.DoubleShapedVector;
import mitiv.linalg.shaped.FloatShapedVector;

public class DifferentiableGaussianLikelihood
extends GaussianLikelihood
implements DifferentiableCostFunction {
    protected Vector work2 = null;

    public DifferentiableGaussianLikelihood(WeightedData weightedData, DifferentiableMapping differentiableMapping) {
        super(weightedData, differentiableMapping);
    }

    @Override
    public double computeCostAndGradient(double d, Vector vector, Vector vector2, boolean bl) {
        this.dataSpace.check(vector);
        this.dataSpace.check(vector2);
        if (d == 0.0) {
            if (bl) {
                vector2.zero();
            }
            return 0.0;
        }
        this.computeResiduals(vector);
        double d2 = 0.0;
        if (this.ignoreWeights) {
            d2 = this.work1.norm2();
        } else if (this.isSinglePrecision()) {
            float[] fArray = ((FloatShapedVector)this.work1).getData();
            float[] fArray2 = ((FloatShapedVector)this.getWeights()).getData();
            for (int i = 0; i < fArray.length; ++i) {
                float f = fArray[i];
                float f2 = fArray2[i] * f;
                d2 += (double)(f2 * f);
                fArray[i] = f2;
            }
        } else {
            double[] dArray = ((DoubleShapedVector)this.work1).getData();
            double[] dArray2 = ((DoubleShapedVector)this.getWeights()).getData();
            for (int i = 0; i < dArray.length; ++i) {
                double d3 = dArray[i];
                double d4 = dArray2[i] * d3;
                d2 += d4 * d3;
                dArray[i] = d4;
            }
        }
        if (bl) {
            ((DifferentiableMapping)this.directModel).applyJacobian(vector2, vector, this.work1);
            vector2.scale(d);
        } else {
            if (this.work2 == null) {
                this.work2 = this.variableSpace.create();
            }
            ((DifferentiableMapping)this.directModel).applyJacobian(this.work2, vector, this.work1);
            vector2.add(d, this.work2);
        }
        return d / 2.0 * d2;
    }
}

