/*
 * Decompiled with CFR 0.152.
 */
package mitiv.deconv;

import mitiv.array.ShapedArray;
import mitiv.base.Shape;
import mitiv.deconv.ConvolutionDouble1D;
import mitiv.deconv.WeightedConvolutionDouble;
import mitiv.linalg.Vector;
import mitiv.linalg.shaped.DoubleShapedVector;
import mitiv.linalg.shaped.ShapedVector;

class WeightedConvolutionDouble1D
extends WeightedConvolutionDouble {
    private final int dim1;
    private final int off1;
    private final int end1;
    private final ConvolutionDouble1D cnvl;

    public WeightedConvolutionDouble1D(ConvolutionDouble1D convolutionDouble1D) {
        super(convolutionDouble1D.getInputSpace(), convolutionDouble1D.getOutputSpace());
        this.cnvl = convolutionDouble1D;
        Shape shape = convolutionDouble1D.workShape;
        Shape shape2 = convolutionDouble1D.getOutputSpace().getShape();
        int[] nArray = convolutionDouble1D.outputOffsets;
        this.dim1 = shape.dimension(0);
        this.off1 = nArray[0];
        this.end1 = this.off1 + shape2.dimension(0);
    }

    @Override
    protected double _cost(double d, Vector vector) {
        this.checkSetup();
        this.cnvl.push((ShapedVector)vector, false);
        this.cnvl.convolve(false);
        double d2 = 0.0;
        double[] dArray = this.cnvl.getWorkArray();
        int n = 0;
        int n2 = 2 * this.off1;
        if (this.wgt == null) {
            for (int i = this.off1; i < this.end1; ++i) {
                double d3 = dArray[n2] - this.dat[n];
                d2 += d3 * d3;
                ++n;
                n2 += 2;
            }
        } else {
            for (int i = this.off1; i < this.end1; ++i) {
                double d4 = this.wgt[n];
                double d5 = dArray[n2] - this.dat[n];
                d2 += d4 * d5 * d5;
                ++n;
                n2 += 2;
            }
        }
        return d * d2 / 2.0;
    }

    @Override
    protected double _cost(double d, Vector vector, Vector vector2, boolean bl) {
        double d2;
        int n;
        this.checkSetup();
        this.cnvl.push((ShapedVector)vector, false);
        this.cnvl.convolve(false);
        boolean bl2 = this.wgt != null;
        double d3 = d;
        double d4 = 0.0;
        double[] dArray = this.cnvl.getWorkArray();
        int n2 = 0;
        int n3 = 0;
        for (n = 0; n < this.off1; ++n) {
            dArray[n3] = 0.0;
            dArray[n3 + 1] = 0.0;
            n3 += 2;
        }
        if (bl2) {
            for (n = this.off1; n < this.end1; ++n) {
                d2 = this.wgt[n2];
                double d5 = dArray[n3] - this.dat[n2];
                double d6 = d2 * d5;
                d4 += d5 * d6;
                dArray[n3] = d3 * d6;
                dArray[n3 + 1] = 0.0;
                ++n2;
                n3 += 2;
            }
        } else {
            for (n = this.off1; n < this.end1; ++n) {
                d2 = dArray[n3] - this.dat[n2];
                d4 += d2 * d2;
                dArray[n3] = d3 * d2;
                dArray[n3 + 1] = 0.0;
                ++n2;
                n3 += 2;
            }
        }
        for (n = this.end1; n < this.dim1; ++n) {
            dArray[n3] = 0.0;
            dArray[n3 + 1] = 0.0;
            n3 += 2;
        }
        double[] dArray2 = ((DoubleShapedVector)vector2).getData();
        this.cnvl.convolve(true);
        if (bl) {
            n2 = 0;
            n3 = 0;
            while (n2 < dArray2.length) {
                dArray2[n2] = dArray[n3];
                ++n2;
                n3 += 2;
            }
        } else {
            n2 = 0;
            n3 = 0;
            while (n2 < dArray2.length) {
                int n4 = n2++;
                dArray2[n4] = dArray2[n4] + dArray[n3];
                n3 += 2;
            }
        }
        return d * d4 / 2.0;
    }

    @Override
    public void setPSF(ShapedArray shapedArray, int[] nArray, boolean bl) {
        this.cnvl.setPSF(shapedArray, nArray, bl);
    }

    @Override
    public void setPSF(ShapedVector shapedVector) {
        this.cnvl.setPSF(shapedVector);
    }
}

