/*
 * Decompiled with CFR 0.152.
 */
package mitiv.jobs;

import mitiv.array.ShapedArray;
import mitiv.base.Shape;
import mitiv.cost.EdgePreservingDeconvolution;
import mitiv.optim.OptimTask;
import mitiv.utils.TiPiHook;

public class DeconvolutionJob {
    public EdgePreservingDeconvolution solver = new EdgePreservingDeconvolution();
    protected TiPiHook iterHook;
    protected TiPiHook finalHook;
    protected boolean run = true;

    public DeconvolutionJob(ShapedArray shapedArray, ShapedArray shapedArray2, ShapedArray shapedArray3, Shape shape, double d, double d2, double[] dArray, boolean bl, boolean bl2, int n, TiPiHook tiPiHook, TiPiHook tiPiHook2) {
        this.solver.setForceSinglePrecision(bl2);
        this.solver.setRelativeTolerance(0.0);
        this.solver.setUseNewCode(false);
        this.solver.setObjectShape(shape);
        this.solver.setPSF(shapedArray2);
        this.solver.setData(shapedArray);
        this.solver.setWeights(shapedArray3);
        this.solver.setEdgeThreshold(d2);
        this.solver.setRegularizationLevel(d);
        this.solver.setScale(dArray);
        this.solver.setSaveBest(true);
        this.solver.setLowerBound(bl ? 0.0 : Double.NEGATIVE_INFINITY);
        this.solver.setUpperBound(Double.POSITIVE_INFINITY);
        this.solver.setMaximumIterations(n);
        this.solver.setMaximumEvaluations(2 * n);
        this.iterHook = tiPiHook;
        this.finalHook = tiPiHook2;
    }

    public ShapedArray deconv(ShapedArray shapedArray) {
        int n = 0;
        this.run = true;
        this.solver.setInitialSolution(shapedArray);
        OptimTask optimTask = this.solver.start();
        while (this.run) {
            optimTask = this.solver.getTask();
            if (optimTask == OptimTask.ERROR) {
                System.err.format("Error: %s\n", this.solver.getReason());
                break;
            }
            if (optimTask == OptimTask.NEW_X || optimTask == OptimTask.FINAL_X) {
                if (this.iterHook != null) {
                    this.iterHook.run(this, n++);
                }
                if (optimTask == OptimTask.FINAL_X) break;
            }
            if (optimTask == OptimTask.WARNING) break;
            this.solver.iterate();
        }
        shapedArray = this.solver.getBestSolution().asShapedArray();
        this.finalHook.run(this, n);
        return shapedArray;
    }

    public void abort() {
        this.run = false;
    }

    public void updatePsf(ShapedArray shapedArray) {
        this.solver.setPSF(shapedArray);
    }

    public boolean isRunning() {
        return this.run;
    }
}

