/*
 * Decompiled with CFR 0.152.
 */
package mitiv.linalg.shaped;

import mitiv.exception.IllegalTypeException;
import mitiv.exception.NotImplementedException;
import mitiv.linalg.LinearOperator;
import mitiv.linalg.Vector;
import mitiv.linalg.shaped.DoubleShapedVector;
import mitiv.linalg.shaped.FloatShapedVector;
import mitiv.linalg.shaped.FloatShapedVectorSpace;
import mitiv.linalg.shaped.ShapedVector;
import mitiv.linalg.shaped.ShapedVectorSpace;

public class DenseOperator
extends LinearOperator {
    private final Object data;
    private final boolean single;

    public DenseOperator(ShapedVector shapedVector, int n) {
        super(DenseOperator.splitSpace(shapedVector, n, true), DenseOperator.splitSpace(shapedVector, n, false));
        if (shapedVector.getType() == 4) {
            this.single = true;
            this.data = ((FloatShapedVector)shapedVector).getData();
        } else {
            this.single = false;
            this.data = ((DoubleShapedVector)shapedVector).getData();
        }
    }

    @Override
    protected void _apply(Vector vector, Vector vector2, int n) throws NotImplementedException {
        block14: {
            double[] dArray;
            double[] dArray2;
            int n2;
            int n3;
            block15: {
                int n4;
                block13: {
                    if (n != DIRECT && n != ADJOINT) {
                        throw new NotImplementedException("Only direct and adjoint operators are implemented");
                    }
                    n3 = this.getOutputSpace().getNumber();
                    n2 = this.getInputSpace().getNumber();
                    if (!this.single) break block13;
                    float[] fArray = (float[])this.data;
                    float[] fArray2 = ((FloatShapedVector)vector2).getData();
                    float[] fArray3 = ((FloatShapedVector)vector).getData();
                    if (n == DIRECT) {
                        int n5;
                        for (n5 = 0; n5 < n3; ++n5) {
                            fArray3[n5] = 0.0f;
                        }
                        for (n5 = 0; n5 < n2; ++n5) {
                            float f = fArray2[n5];
                            int n6 = n3 * n5;
                            for (int i = 0; i < n3; ++i) {
                                int n7 = i;
                                fArray3[n7] = fArray3[n7] + fArray[i + n6] * f;
                            }
                        }
                    } else {
                        for (int i = 0; i < n2; ++i) {
                            float f = 0.0f;
                            int n8 = n3 * i;
                            for (int j = 0; j < n3; ++j) {
                                f += fArray[j + n8] * fArray2[j];
                            }
                            fArray3[i] = f;
                        }
                    }
                    break block14;
                }
                dArray2 = (double[])this.data;
                dArray = ((DoubleShapedVector)vector2).getData();
                double[] dArray3 = ((DoubleShapedVector)vector).getData();
                if (n != DIRECT) break block15;
                for (n4 = 0; n4 < n3; ++n4) {
                    dArray3[n4] = 0.0;
                }
                for (n4 = 0; n4 < n2; ++n4) {
                    double d = dArray[n4];
                    int n9 = n3 * n4;
                    for (int i = 0; i < n3; ++i) {
                        int n10 = i;
                        dArray3[n10] = dArray3[n10] + dArray2[i + n9] * d;
                    }
                }
                break block14;
            }
            if (n != ADJOINT) break block14;
            for (int i = 0; i < n2; ++i) {
                double d = 0.0;
                int n11 = n3 * i;
                for (int j = 0; j < n3; ++j) {
                    d += dArray2[j + n11] * dArray[j];
                }
                dArray3[i] = d;
            }
        }
    }

    private static ShapedVectorSpace splitSpace(ShapedVector shapedVector, int n, boolean bl) {
        int[] nArray;
        int n2 = shapedVector.getType();
        int n3 = shapedVector.getRank();
        if (n < 1 || n >= n3) {
            throw new IndexOutOfBoundsException("Output rank is out of bounds");
        }
        if (bl) {
            nArray = new int[n3 - n];
            for (int i = 0; i < n3 - n; ++i) {
                nArray[i] = shapedVector.getDimension(n + i);
            }
        } else {
            nArray = new int[n];
            for (int i = 0; i < n; ++i) {
                nArray[i] = shapedVector.getDimension(i);
            }
        }
        if (n2 == 4) {
            return new FloatShapedVectorSpace(nArray);
        }
        if (n2 == 4) {
            return new FloatShapedVectorSpace(nArray);
        }
        throw new IllegalTypeException("Only generic floating-point types are supported");
    }
}

