/*
 * Decompiled with CFR 0.152.
 */
package mitiv.optim;

import mitiv.linalg.Vector;
import mitiv.linalg.shaped.DoubleShapedVector;
import mitiv.linalg.shaped.DoubleShapedVectorSpace;
import mitiv.optim.SimpleBoxedSet;

public class DoubleBoxedSet
extends SimpleBoxedSet {
    private double[] lo = null;
    private double[] up = null;
    private int bound = 0;

    public DoubleBoxedSet(DoubleShapedVectorSpace doubleShapedVectorSpace) {
        super(doubleShapedVectorSpace);
    }

    private double[] getData(Vector vector) {
        this.space.check(vector);
        return ((DoubleShapedVector)vector).getData();
    }

    @Override
    public void setLowerBound(double d) {
        if (d > Double.NEGATIVE_INFINITY) {
            this.lo = new double[]{d};
            this.bound = this.bound / 3 * 3 + 1;
        } else {
            this.lo = null;
            this.bound = this.bound / 3 * 3;
        }
    }

    @Override
    public void setLowerBound(Vector vector) {
        if (vector != null) {
            this.lo = this.getData(vector);
            this.bound = this.bound / 3 * 3 + 2;
        } else {
            this.lo = null;
            this.bound = this.bound / 3 * 3;
        }
    }

    @Override
    public void setUpperBound(double d) {
        if (d < Double.POSITIVE_INFINITY) {
            this.up = new double[]{d};
            this.bound = this.bound % 3 + 3;
        } else {
            this.up = null;
            this.bound %= 3;
        }
    }

    @Override
    public void setUpperBound(Vector vector) {
        if (vector != null) {
            this.up = this.getData(vector);
            this.bound = this.bound % 3 + 6;
        } else {
            this.up = null;
            this.bound %= 3;
        }
    }

    @Override
    public final void projectVariables(Vector vector, Vector vector2) {
        double[] dArray = this.getData(vector);
        double[] dArray2 = this.getData(vector2);
        int n = dArray2.length;
        switch (this.bound) {
            case 0: {
                if (dArray == dArray2) break;
                System.arraycopy(dArray, 0, dArray2, 0, n);
                break;
            }
            case 1: {
                double d = this.lo[0];
                for (int i = 0; i < n; ++i) {
                    double d2 = dArray2[i];
                    if (d2 < d) {
                        d2 = d;
                    }
                    dArray[i] = d2;
                }
                break;
            }
            case 2: {
                for (int i = 0; i < n; ++i) {
                    double d = dArray2[i];
                    double d3 = this.lo[i];
                    if (d < d3) {
                        d = d3;
                    }
                    dArray[i] = d;
                }
                break;
            }
            case 3: {
                double d = this.up[0];
                for (int i = 0; i < n; ++i) {
                    double d4 = dArray2[i];
                    if (d4 > d) {
                        d4 = d;
                    }
                    dArray[i] = d4;
                }
                break;
            }
            case 4: {
                double d = this.lo[0];
                double d5 = this.up[0];
                for (int i = 0; i < n; ++i) {
                    double d6 = dArray2[i];
                    if (d6 < d) {
                        d6 = d;
                    }
                    if (d6 > d5) {
                        d6 = d5;
                    }
                    dArray[i] = d6;
                }
                break;
            }
            case 5: {
                double d = this.up[0];
                for (int i = 0; i < n; ++i) {
                    double d7 = dArray2[i];
                    double d8 = this.lo[i];
                    if (d7 < d8) {
                        d7 = d8;
                    }
                    if (d7 > d) {
                        d7 = d;
                    }
                    dArray[i] = d7;
                }
                break;
            }
            case 6: {
                for (int i = 0; i < n; ++i) {
                    double d = dArray2[i];
                    double d9 = this.up[i];
                    if (d > d9) {
                        d = d9;
                    }
                    dArray[i] = d;
                }
                break;
            }
            case 7: {
                double d = this.lo[0];
                for (int i = 0; i < n; ++i) {
                    double d10 = dArray2[i];
                    double d11 = this.up[i];
                    if (d10 < d) {
                        d10 = d;
                    }
                    if (d10 > d11) {
                        d10 = d11;
                    }
                    dArray[i] = d10;
                }
                break;
            }
            case 8: {
                for (int i = 0; i < n; ++i) {
                    double d = this.lo[i];
                    double d12 = dArray2[i];
                    double d13 = this.up[i];
                    if (d12 < d) {
                        d12 = d;
                    }
                    if (d12 > d13) {
                        d12 = d13;
                    }
                    dArray[i] = d12;
                }
                break;
            }
        }
    }

    @Override
    public void projectDirection(Vector vector, Vector vector2, Vector vector3, int n) {
        double[] dArray = this.getData(vector);
        double[] dArray2 = this.getData(vector2);
        double[] dArray3 = this.getData(vector3);
        int n2 = dArray2.length;
        switch (this.bound) {
            case 0: {
                if (dArray == dArray3) break;
                System.arraycopy(dArray, 0, dArray3, 0, n2);
                break;
            }
            case 1: {
                double d = this.lo[0];
                if (n > 0) {
                    for (int i = 0; i < n2; ++i) {
                        dArray[i] = dArray3[i] >= 0.0 || dArray2[i] > d ? dArray3[i] : 0.0;
                    }
                } else {
                    for (int i = 0; i < n2; ++i) {
                        dArray[i] = dArray3[i] <= 0.0 || dArray2[i] > d ? dArray3[i] : 0.0;
                    }
                }
                break;
            }
            case 2: {
                if (n > 0) {
                    for (int i = 0; i < n2; ++i) {
                        dArray[i] = dArray3[i] >= 0.0 || dArray2[i] > this.lo[i] ? dArray3[i] : 0.0;
                    }
                } else {
                    for (int i = 0; i < n2; ++i) {
                        dArray[i] = dArray3[i] <= 0.0 || dArray2[i] > this.lo[i] ? dArray3[i] : 0.0;
                    }
                }
                break;
            }
            case 3: {
                double d = this.up[0];
                if (n > 0) {
                    for (int i = 0; i < n2; ++i) {
                        dArray[i] = dArray3[i] <= 0.0 || dArray2[i] < d ? dArray3[i] : 0.0;
                    }
                } else {
                    for (int i = 0; i < n2; ++i) {
                        dArray[i] = dArray3[i] >= 0.0 || dArray2[i] < d ? dArray3[i] : 0.0;
                    }
                }
                break;
            }
            case 4: {
                double d = this.lo[0];
                double d2 = this.up[0];
                if (n > 0) {
                    for (int i = 0; i < n2; ++i) {
                        dArray[i] = dArray3[i] < 0.0 ? (dArray2[i] > d ? dArray3[i] : 0.0) : (dArray3[i] > 0.0 ? (dArray2[i] < d2 ? dArray3[i] : 0.0) : 0.0);
                    }
                } else {
                    for (int i = 0; i < n2; ++i) {
                        dArray[i] = dArray3[i] > 0.0 ? (dArray2[i] > d ? dArray3[i] : 0.0) : (dArray3[i] < 0.0 ? (dArray2[i] < d2 ? dArray3[i] : 0.0) : 0.0);
                    }
                }
                break;
            }
            case 5: {
                double d = this.up[0];
                if (n > 0) {
                    for (int i = 0; i < n2; ++i) {
                        dArray[i] = dArray3[i] < 0.0 ? (dArray2[i] > this.lo[i] ? dArray3[i] : 0.0) : (dArray3[i] > 0.0 ? (dArray2[i] < d ? dArray3[i] : 0.0) : 0.0);
                    }
                } else {
                    for (int i = 0; i < n2; ++i) {
                        dArray[i] = dArray3[i] > 0.0 ? (dArray2[i] > this.lo[i] ? dArray3[i] : 0.0) : (dArray3[i] < 0.0 ? (dArray2[i] < d ? dArray3[i] : 0.0) : 0.0);
                    }
                }
                break;
            }
            case 6: {
                if (n > 0) {
                    for (int i = 0; i < n2; ++i) {
                        dArray[i] = dArray3[i] <= 0.0 || dArray2[i] < this.up[i] ? dArray3[i] : 0.0;
                    }
                } else {
                    for (int i = 0; i < n2; ++i) {
                        dArray[i] = dArray3[i] >= 0.0 || dArray2[i] < this.up[i] ? dArray3[i] : 0.0;
                    }
                }
                break;
            }
            case 7: {
                double d = this.lo[0];
                if (n > 0) {
                    for (int i = 0; i < n2; ++i) {
                        dArray[i] = dArray3[i] < 0.0 ? (dArray2[i] > d ? dArray3[i] : 0.0) : (dArray3[i] > 0.0 ? (dArray2[i] < this.up[i] ? dArray3[i] : 0.0) : 0.0);
                    }
                } else {
                    for (int i = 0; i < n2; ++i) {
                        dArray[i] = dArray3[i] > 0.0 ? (dArray2[i] > d ? dArray3[i] : 0.0) : (dArray3[i] < 0.0 ? (dArray2[i] < this.up[i] ? dArray3[i] : 0.0) : 0.0);
                    }
                }
                break;
            }
            case 8: {
                if (n > 0) {
                    for (int i = 0; i < n2; ++i) {
                        dArray[i] = dArray3[i] < 0.0 ? (dArray2[i] > this.lo[i] ? dArray3[i] : 0.0) : (dArray3[i] > 0.0 ? (dArray2[i] < this.up[i] ? dArray3[i] : 0.0) : 0.0);
                    }
                } else {
                    for (int i = 0; i < n2; ++i) {
                        dArray[i] = dArray3[i] > 0.0 ? (dArray2[i] > this.lo[i] ? dArray3[i] : 0.0) : (dArray3[i] < 0.0 ? (dArray2[i] < this.up[i] ? dArray3[i] : 0.0) : 0.0);
                    }
                }
                break;
            }
        }
    }

    @Override
    public void findFreeVariables(Vector vector, Vector vector2, Vector vector3, int n) {
        double[] dArray = this.getData(vector);
        double[] dArray2 = this.getData(vector2);
        double[] dArray3 = this.getData(vector3);
        int n2 = dArray2.length;
        switch (this.bound) {
            case 0: {
                for (int i = 0; i < n2; ++i) {
                    dArray[i] = 1.0;
                }
                break;
            }
            case 1: {
                double d = this.lo[0];
                if (n > 0) {
                    for (int i = 0; i < n2; ++i) {
                        dArray[i] = dArray3[i] < 0.0 ? (double)(dArray2[i] > d ? 1 : 0) : (double)(dArray3[i] > 0.0 ? 1 : 0);
                    }
                } else {
                    for (int i = 0; i < n2; ++i) {
                        dArray[i] = dArray3[i] > 0.0 ? (double)(dArray2[i] > d ? 1 : 0) : (double)(dArray3[i] < 0.0 ? 1 : 0);
                    }
                }
                break;
            }
            case 2: {
                if (n > 0) {
                    for (int i = 0; i < n2; ++i) {
                        dArray[i] = dArray3[i] < 0.0 ? (double)(dArray2[i] > this.lo[i] ? 1 : 0) : (double)(dArray3[i] > 0.0 ? 1 : 0);
                    }
                } else {
                    for (int i = 0; i < n2; ++i) {
                        dArray[i] = dArray3[i] > 0.0 ? (double)(dArray2[i] > this.lo[i] ? 1 : 0) : (double)(dArray3[i] < 0.0 ? 1 : 0);
                    }
                }
                break;
            }
            case 3: {
                double d = this.up[0];
                if (n > 0) {
                    for (int i = 0; i < n2; ++i) {
                        dArray[i] = dArray3[i] < 0.0 ? 1.0 : (double)(dArray3[i] > 0.0 ? dArray2[i] < d : false);
                    }
                    break;
                }
                for (int i = 0; i < n2; ++i) {
                    dArray[i] = dArray3[i] > 0.0 ? 1.0 : (double)(dArray3[i] < 0.0 ? dArray2[i] < d : false);
                }
                break;
            }
            case 4: {
                double d = this.lo[0];
                double d2 = this.up[0];
                if (n > 0) {
                    for (int i = 0; i < n2; ++i) {
                        dArray[i] = dArray3[i] < 0.0 ? (double)(dArray2[i] > d ? 1 : 0) : (double)(dArray3[i] > 0.0 ? dArray2[i] < d2 : false);
                    }
                    break;
                }
                for (int i = 0; i < n2; ++i) {
                    dArray[i] = dArray3[i] > 0.0 ? (double)(dArray2[i] > d ? 1 : 0) : (double)(dArray3[i] < 0.0 ? dArray2[i] < d2 : false);
                }
                break;
            }
            case 5: {
                double d = this.up[0];
                if (n > 0) {
                    for (int i = 0; i < n2; ++i) {
                        dArray[i] = dArray3[i] < 0.0 ? (double)(dArray2[i] > this.lo[i] ? 1 : 0) : (double)(dArray3[i] > 0.0 ? dArray2[i] < d : false);
                    }
                    break;
                }
                for (int i = 0; i < n2; ++i) {
                    dArray[i] = dArray3[i] > 0.0 ? (double)(dArray2[i] > this.lo[i] ? 1 : 0) : (double)(dArray3[i] < 0.0 ? dArray2[i] < d : false);
                }
                break;
            }
            case 6: {
                if (n > 0) {
                    for (int i = 0; i < n2; ++i) {
                        dArray[i] = dArray3[i] < 0.0 ? 1.0 : (double)(dArray3[i] > 0.0 ? dArray2[i] < this.up[i] : false);
                    }
                    break;
                }
                for (int i = 0; i < n2; ++i) {
                    dArray[i] = dArray3[i] > 0.0 ? 1.0 : (double)(dArray3[i] < 0.0 ? dArray2[i] < this.up[i] : false);
                }
                break;
            }
            case 7: {
                double d = this.lo[0];
                if (n > 0) {
                    for (int i = 0; i < n2; ++i) {
                        dArray[i] = dArray3[i] < 0.0 ? (double)(dArray2[i] > d ? 1 : 0) : (double)(dArray3[i] > 0.0 ? dArray2[i] < this.up[i] : false);
                    }
                    break;
                }
                for (int i = 0; i < n2; ++i) {
                    dArray[i] = dArray3[i] > 0.0 ? (double)(dArray2[i] > d ? 1 : 0) : (double)(dArray3[i] < 0.0 ? dArray2[i] < this.up[i] : false);
                }
                break;
            }
            case 8: {
                if (n > 0) {
                    for (int i = 0; i < n2; ++i) {
                        dArray[i] = dArray3[i] < 0.0 ? (double)(dArray2[i] > this.lo[i] ? 1 : 0) : (double)(dArray3[i] > 0.0 ? dArray2[i] < this.up[i] : false);
                    }
                    break;
                }
                for (int i = 0; i < n2; ++i) {
                    dArray[i] = dArray3[i] > 0.0 ? (double)(dArray2[i] > this.lo[i] ? 1 : 0) : (double)(dArray3[i] < 0.0 ? dArray2[i] < this.up[i] : false);
                }
                break;
            }
        }
    }

    @Override
    public double[] findStepLimits(Vector vector, Vector vector2, int n) {
        double[] dArray = this.getData(vector);
        double[] dArray2 = this.getData(vector2);
        int n2 = dArray.length;
        double d = Double.POSITIVE_INFINITY;
        double d2 = Double.POSITIVE_INFINITY;
        double d3 = Double.POSITIVE_INFINITY;
        switch (this.bound) {
            case 1: {
                d = 0.0;
                double d4 = this.lo[0];
                if (n > 0) {
                    for (int i = 0; i < n2; ++i) {
                        double d5 = dArray2[i];
                        if (d5 < 0.0) {
                            double d6 = (d4 - dArray[i]) / d5;
                            if (d6 < d3) {
                                d3 = d6;
                            }
                            if (d6 < d2 && d6 > 0.0) {
                                d2 = d6;
                            }
                            if (!(d6 > d)) continue;
                            d = d6;
                            continue;
                        }
                        if (!(d5 > 0.0)) continue;
                        d = Double.POSITIVE_INFINITY;
                    }
                } else {
                    for (int i = 0; i < n2; ++i) {
                        double d7 = dArray2[i];
                        if (d7 > 0.0) {
                            double d8 = (dArray[i] - d4) / d7;
                            if (d8 < d3) {
                                d3 = d8;
                            }
                            if (d8 < d2 && d8 > 0.0) {
                                d2 = d8;
                            }
                            if (!(d8 > d)) continue;
                            d = d8;
                            continue;
                        }
                        if (!(d7 < 0.0)) continue;
                        d = Double.POSITIVE_INFINITY;
                    }
                }
                break;
            }
            case 2: {
                d = 0.0;
                if (n > 0) {
                    for (int i = 0; i < n2; ++i) {
                        double d9 = dArray2[i];
                        if (d9 < 0.0) {
                            double d10 = (this.lo[i] - dArray[i]) / d9;
                            if (d10 < d3) {
                                d3 = d10;
                            }
                            if (d10 < d2 && d10 > 0.0) {
                                d2 = d10;
                            }
                            if (!(d10 > d)) continue;
                            d = d10;
                            continue;
                        }
                        if (!(d9 > 0.0)) continue;
                        d = Double.POSITIVE_INFINITY;
                    }
                } else {
                    for (int i = 0; i < n2; ++i) {
                        double d11 = dArray2[i];
                        if (d11 > 0.0) {
                            double d12 = (dArray[i] - this.lo[i]) / d11;
                            if (d12 < d3) {
                                d3 = d12;
                            }
                            if (d12 < d2 && d12 > 0.0) {
                                d2 = d12;
                            }
                            if (!(d12 > d)) continue;
                            d = d12;
                            continue;
                        }
                        if (!(d11 < 0.0)) continue;
                        d = Double.POSITIVE_INFINITY;
                    }
                }
                break;
            }
            case 3: {
                d = 0.0;
                double d13 = this.up[0];
                if (n > 0) {
                    for (int i = 0; i < n2; ++i) {
                        double d14 = dArray2[i];
                        if (d14 > 0.0) {
                            double d15 = (d13 - dArray[i]) / d14;
                            if (d15 < d3) {
                                d3 = d15;
                            }
                            if (d15 < d2 && d15 > 0.0) {
                                d2 = d15;
                            }
                            if (!(d15 > d)) continue;
                            d = d15;
                            continue;
                        }
                        if (!(d14 < 0.0)) continue;
                        d = Double.POSITIVE_INFINITY;
                    }
                } else {
                    for (int i = 0; i < n2; ++i) {
                        double d16 = dArray2[i];
                        if (d16 < 0.0) {
                            double d17 = (dArray[i] - d13) / d16;
                            if (d17 < d3) {
                                d3 = d17;
                            }
                            if (d17 < d2 && d17 > 0.0) {
                                d2 = d17;
                            }
                            if (!(d17 > d)) continue;
                            d = d17;
                            continue;
                        }
                        if (!(d16 > 0.0)) continue;
                        d = Double.POSITIVE_INFINITY;
                    }
                }
                break;
            }
            case 4: {
                d = 0.0;
                double d18 = this.lo[0];
                double d19 = this.up[0];
                if (n > 0) {
                    for (int i = 0; i < n2; ++i) {
                        double d20;
                        double d21 = dArray2[i];
                        if (d21 > 0.0) {
                            d20 = (d19 - dArray[i]) / d21;
                        } else {
                            if (!(d21 < 0.0)) continue;
                            d20 = (d18 - dArray[i]) / d21;
                        }
                        if (d20 < d3) {
                            d3 = d20;
                        }
                        if (d20 < d2 && d20 > 0.0) {
                            d2 = d20;
                        }
                        if (!(d20 > d)) continue;
                        d = d20;
                    }
                } else {
                    for (int i = 0; i < n2; ++i) {
                        double d22;
                        double d23 = dArray2[i];
                        if (d23 < 0.0) {
                            d22 = (dArray[i] - d19) / d23;
                        } else {
                            if (!(d23 > 0.0)) continue;
                            d22 = (dArray[i] - d18) / d23;
                        }
                        if (d22 < d3) {
                            d3 = d22;
                        }
                        if (d22 < d2 && d22 > 0.0) {
                            d2 = d22;
                        }
                        if (!(d22 > d)) continue;
                        d = d22;
                    }
                }
                break;
            }
            case 5: {
                d = 0.0;
                double d24 = this.up[0];
                if (n > 0) {
                    for (int i = 0; i < n2; ++i) {
                        double d25;
                        double d26 = dArray2[i];
                        if (d26 > 0.0) {
                            d25 = (d24 - dArray[i]) / d26;
                        } else {
                            if (!(d26 < 0.0)) continue;
                            d25 = (this.lo[i] - dArray[i]) / d26;
                        }
                        if (d25 < d3) {
                            d3 = d25;
                        }
                        if (d25 < d2 && d25 > 0.0) {
                            d2 = d25;
                        }
                        if (!(d25 > d)) continue;
                        d = d25;
                    }
                } else {
                    for (int i = 0; i < n2; ++i) {
                        double d27;
                        double d28 = dArray2[i];
                        if (d28 < 0.0) {
                            d27 = (dArray[i] - d24) / d28;
                        } else {
                            if (!(d28 > 0.0)) continue;
                            d27 = (dArray[i] - this.lo[i]) / d28;
                        }
                        if (d27 < d3) {
                            d3 = d27;
                        }
                        if (d27 < d2 && d27 > 0.0) {
                            d2 = d27;
                        }
                        if (!(d27 > d)) continue;
                        d = d27;
                    }
                }
                break;
            }
            case 6: {
                d = 0.0;
                if (n > 0) {
                    for (int i = 0; i < n2; ++i) {
                        double d29 = dArray2[i];
                        if (d29 > 0.0) {
                            double d30 = (this.up[i] - dArray[i]) / d29;
                            if (d30 < d3) {
                                d3 = d30;
                            }
                            if (d30 < d2 && d30 > 0.0) {
                                d2 = d30;
                            }
                            if (!(d30 > d)) continue;
                            d = d30;
                            continue;
                        }
                        if (!(d29 < 0.0)) continue;
                        d = Double.POSITIVE_INFINITY;
                    }
                } else {
                    for (int i = 0; i < n2; ++i) {
                        double d31 = dArray2[i];
                        if (d31 < 0.0) {
                            double d32 = (dArray[i] - this.up[i]) / d31;
                            if (d32 < d3) {
                                d3 = d32;
                            }
                            if (d32 < d2 && d32 > 0.0) {
                                d2 = d32;
                            }
                            if (!(d32 > d)) continue;
                            d = d32;
                            continue;
                        }
                        if (!(d31 > 0.0)) continue;
                        d = Double.POSITIVE_INFINITY;
                    }
                }
                break;
            }
            case 7: {
                d = 0.0;
                double d33 = this.lo[0];
                if (n > 0) {
                    for (int i = 0; i < n2; ++i) {
                        double d34;
                        double d35 = dArray2[i];
                        if (d35 > 0.0) {
                            d34 = (this.up[i] - dArray[i]) / d35;
                        } else {
                            if (!(d35 < 0.0)) continue;
                            d34 = (d33 - dArray[i]) / d35;
                        }
                        if (d34 < d3) {
                            d3 = d34;
                        }
                        if (d34 < d2 && d34 > 0.0) {
                            d2 = d34;
                        }
                        if (!(d34 > d)) continue;
                        d = d34;
                    }
                } else {
                    for (int i = 0; i < n2; ++i) {
                        double d36;
                        double d37 = dArray2[i];
                        if (d37 < 0.0) {
                            d36 = (dArray[i] - this.up[i]) / d37;
                        } else {
                            if (!(d37 > 0.0)) continue;
                            d36 = (dArray[i] - d33) / d37;
                        }
                        if (d36 < d3) {
                            d3 = d36;
                        }
                        if (d36 < d2 && d36 > 0.0) {
                            d2 = d36;
                        }
                        if (!(d36 > d)) continue;
                        d = d36;
                    }
                }
                break;
            }
            case 8: {
                d = 0.0;
                if (n > 0) {
                    for (int i = 0; i < n2; ++i) {
                        double d38;
                        double d39 = dArray2[i];
                        if (d39 > 0.0) {
                            d38 = (this.up[i] - dArray[i]) / d39;
                        } else {
                            if (!(d39 < 0.0)) continue;
                            d38 = (this.lo[i] - dArray[i]) / d39;
                        }
                        if (d38 < d3) {
                            d3 = d38;
                        }
                        if (d38 < d2 && d38 > 0.0) {
                            d2 = d38;
                        }
                        if (!(d38 > d)) continue;
                        d = d38;
                    }
                } else {
                    for (int i = 0; i < n2; ++i) {
                        double d40;
                        double d41 = dArray2[i];
                        if (d41 < 0.0) {
                            d40 = (dArray[i] - this.up[i]) / d41;
                        } else {
                            if (!(d41 > 0.0)) continue;
                            d40 = (dArray[i] - this.lo[i]) / d41;
                        }
                        if (d40 < d3) {
                            d3 = d40;
                        }
                        if (d40 < d2 && d40 > 0.0) {
                            d2 = d40;
                        }
                        if (!(d40 > d)) continue;
                        d = d40;
                    }
                }
                break;
            }
        }
        return new double[]{d3, d2, d};
    }
}

