/*
 * Decompiled with CFR 0.152.
 */
package mitiv.optim;

import mitiv.linalg.LinearEndomorphism;
import mitiv.linalg.Vector;
import mitiv.linalg.VectorSpace;
import mitiv.optim.BoundProjector;
import mitiv.optim.LBFGSOperator;
import mitiv.optim.LineSearch;
import mitiv.optim.LineSearchTask;
import mitiv.optim.OptimStatus;
import mitiv.optim.OptimTask;
import mitiv.optim.QuasiNewton;

public class VMLMB
extends QuasiNewton {
    private LBFGSOperator H = null;
    protected double pnorm;
    private final boolean saveMemory = true;
    protected Vector x0 = null;
    protected double f0 = 0.0;
    protected Vector g0 = null;
    protected Vector tmp = null;
    protected Vector p = null;
    protected double alpha;
    protected double dg0 = 0.0;
    protected double gnorm = 0.0;
    protected double g0norm = 0.0;
    protected final BoundProjector projector;

    public VMLMB(VectorSpace vectorSpace, BoundProjector boundProjector, int n, LineSearch lineSearch) {
        this(new LBFGSOperator(vectorSpace, n), boundProjector, lineSearch);
    }

    public VMLMB(LinearEndomorphism linearEndomorphism, BoundProjector boundProjector, int n, LineSearch lineSearch) {
        this(new LBFGSOperator(linearEndomorphism, n), boundProjector, lineSearch);
    }

    private VMLMB(LBFGSOperator lBFGSOperator, BoundProjector boundProjector, LineSearch lineSearch) {
        super(lBFGSOperator.getSpace(), lineSearch);
        this.H = lBFGSOperator;
        this.projector = boundProjector;
        this.p = lBFGSOperator.getSpace().create();
        this.getClass();
        this.lnsrch = lineSearch;
    }

    @Override
    public OptimTask start() {
        this.evaluations = 0;
        this.iterations = 0;
        this.restarts = 0;
        return this.begin();
    }

    @Override
    public OptimTask restart() {
        ++this.restarts;
        return this.begin();
    }

    private OptimTask begin() {
        this.H.reset();
        return this.success(OptimTask.COMPUTE_FG);
    }

    @Override
    public OptimTask iterate(Vector vector, double d, Vector vector2) {
        switch (this.getTask()) {
            case COMPUTE_FG: {
                double d2;
                if (this.projector != null) {
                    this.projector.projectDirection(vector, vector2, true, vector2);
                }
                ++this.evaluations;
                if (this.evaluations > 1) {
                    LineSearchTask lineSearchTask = this.lnsrch.iterate(d, -this.p.dot(vector2));
                    if (lineSearchTask == LineSearchTask.SEARCH) {
                        return this.nextStep(vector);
                    }
                    if (lineSearchTask != LineSearchTask.CONVERGENCE) {
                        OptimStatus optimStatus = this.lnsrch.getStatus();
                        if (lineSearchTask != LineSearchTask.WARNING || optimStatus != OptimStatus.ROUNDING_ERRORS_PREVENT_PROGRESS) {
                            return this.failure(optimStatus);
                        }
                    }
                    ++this.iterations;
                }
                this.gnorm = vector2.norm2();
                if (this.evaluations == 1) {
                    this.ginit = this.gnorm;
                }
                return this.success(this.gnorm <= (d2 = this.getGradientThreshold(this.ginit)) ? OptimTask.FINAL_X : OptimTask.NEW_X);
            }
            case NEW_X: {
                if (this.evaluations > 1) {
                    this.H.update(vector, this.x0, vector2, this.g0);
                }
            }
            case FINAL_X: {
                double d3;
                double d4;
                while (true) {
                    this.H.apply(this.p, vector2);
                    this.pnorm = this.p.norm2();
                    d4 = this.p.dot(vector2);
                    if (d4 >= this.epsilon * this.pnorm * this.gnorm) break;
                    if (this.H.mp < 1) {
                        return this.failure(OptimStatus.BAD_PRECONDITIONER);
                    }
                    this.H.reset();
                    ++this.restarts;
                }
                this.dg0 = -d4;
                this.x0 = this.H.s(0);
                this.g0 = this.H.y(0);
                if (this.H.mp == this.H.m) {
                    --this.H.mp;
                }
                this.x0.copy(vector);
                this.g0.copy(vector2);
                this.g0norm = this.gnorm;
                this.f0 = d;
                this.alpha = this.H.mp >= 1 || this.H.rule == 0 ? 1.0 : this.initialStep(this.x0, this.p);
                vector.combine(1.0, this.x0, -this.alpha, this.p);
                if (this.projector == null) {
                    d4 = this.stpmin * this.alpha;
                    d3 = this.stpmax * this.alpha;
                } else {
                    if (this.tmp == null) {
                        this.tmp = vector.getOwner().create();
                    }
                    while (true) {
                        this.projector.projectVariables(vector, vector);
                        this.tmp.combine(1.0, this.x0, -1.0, vector);
                        this.dg0 = -this.tmp.dot(this.g0);
                        if (this.dg0 < 0.0) break;
                        if (this.dg0 == 0.0 && this.H.mp < 1) {
                            return this.success(OptimTask.FINAL_X);
                        }
                        if (this.H.mp >= 1) {
                            this.H.reset();
                            ++this.restarts;
                            this.H.apply(this.p, vector2);
                            this.pnorm = this.p.norm2();
                            this.alpha = this.initialStep(this.x0, this.p);
                        } else {
                            this.alpha *= 0.5;
                        }
                        vector.combine(1.0, this.x0, -this.alpha, this.p);
                    }
                    this.p.copy(this.tmp);
                    this.alpha = 1.0;
                    d4 = this.stpmin;
                    d3 = 1.0;
                }
                LineSearchTask lineSearchTask = this.lnsrch.start(this.f0, this.dg0, this.alpha, d4, d3);
                if (lineSearchTask != LineSearchTask.SEARCH) {
                    return this.failure(this.lnsrch.getStatus());
                }
                return this.success(OptimTask.COMPUTE_FG);
            }
        }
        return this.getTask();
    }

    protected double initialStep(Vector vector, Vector vector2) {
        double d;
        double d2 = vector2.norm2();
        if (0.0 < this.delta && this.delta < 1.0 && (d = vector.norm2()) > 0.0) {
            return d / d2 * this.delta;
        }
        return 1.0 / d2;
    }

    private OptimTask nextStep(Vector vector) {
        this.alpha = this.lnsrch.getStep();
        vector.combine(1.0, this.x0, -this.alpha, this.p);
        if (this.projector != null) {
            this.projector.projectVariables(vector, vector);
        }
        return this.success(OptimTask.COMPUTE_FG);
    }
}

