/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.buffer.tint;

import cern.colt.PersistentObject;
import cern.colt.buffer.tint.IntBufferConsumer;
import cern.colt.list.tint.IntArrayList;

public class IntBuffer
extends PersistentObject
implements IntBufferConsumer {
    private static final long serialVersionUID = 1L;
    protected IntBufferConsumer target;
    protected int[] elements;
    protected IntArrayList list;
    protected int capacity;
    protected int size;

    public IntBuffer(IntBufferConsumer target, int capacity) {
        this.target = target;
        this.capacity = capacity;
        this.elements = new int[capacity];
        this.list = new IntArrayList(this.elements);
        this.size = 0;
    }

    public void add(int element) {
        if (this.size == this.capacity) {
            this.flush();
        }
        this.elements[this.size++] = element;
    }

    @Override
    public void addAllOf(IntArrayList list) {
        int listSize = list.size();
        if (this.size + listSize >= this.capacity) {
            this.flush();
        }
        this.target.addAllOf(list);
    }

    public void clear() {
        this.size = 0;
    }

    public void flush() {
        if (this.size > 0) {
            this.list.setSize(this.size);
            this.target.addAllOf(this.list);
            this.size = 0;
        }
    }
}

