/*
 * Decompiled with CFR 0.152.
 */
package mcib3d.geom;

import java.util.ArrayList;
import mcib3d.geom.Object3DVoxels;
import mcib3d.geom.Point3D;
import mcib3d.geom.Voxel3D;

public class Object3DPoint
extends Object3DVoxels {
    public Object3DPoint(int value, Point3D point) {
        this.init(value, point.getX(), point.getY(), point.getZ());
    }

    public Object3DPoint(int value, double x, double y, double z) {
        this.init(value, x, y, z);
    }

    private void init(int label, double x, double y, double z) {
        this.voxels = new ArrayList(1);
        this.voxels.add(new Voxel3D(x, y, z, 0.0));
        this.contours = this.voxels;
        this.value = label;
        this.resXY = 1.0;
        this.resZ = 1.0;
        this.units = "pix";
        this.cx = x;
        this.cy = y;
        this.cz = z;
        this.bx = this.cx;
        this.by = this.cy;
        this.bz = this.cz;
        this.s200 = Double.NaN;
        this.s110 = Double.NaN;
        this.s101 = Double.NaN;
        this.s020 = Double.NaN;
        this.s011 = Double.NaN;
        this.s002 = Double.NaN;
        this.eigen = null;
        this.distcentermin = Double.NaN;
        this.distcentermax = Double.NaN;
        this.distcentermean = Double.NaN;
        this.distcentersigma = Double.NaN;
        this.feret = Double.NaN;
        this.feret1 = null;
        this.feret2 = null;
        this.integratedDensity = Double.NaN;
        this.pixmax = Double.NaN;
        this.pixmin = Double.NaN;
        this.sigma = Double.NaN;
        this.volume = 1;
        this.areaNbVoxels = -1.0;
        this.areaContactUnit = -1.0;
        this.xmin = (int)this.cx;
        this.xmax = (int)(this.cx + 0.5);
        this.ymin = (int)this.cy;
        this.ymax = (int)(this.cy + 0.5);
        this.zmin = (int)this.cz;
        this.zmax = (int)(this.cz + 0.5);
    }
}

